/*****************************************************************************
* Fichero:          wlandecrypter.c
* Fecha:            23-03-2006  
* Autor:             Nilp0inteR (nilp0inter2k6@gmail.com)
*
* Contribuciones posteriores:
*
* - 15-12-2007 dudux  (dudux@elhacker.net)
* - Insertados nuevos routers en la base de datos.
* - 22-12-2007  thefkboss (foro.elhacker.net)
* - Observacion en los routers Zyxel 650HW/660HW 
* - 12-10-2009 fanta (jackepc@gmail.com)
* - Insertado nuevo router. Amiga version. Argumentos.
*
* Descripcion: Generador de diccionario de claves por defecto para los 
* router de Telefonica.
*
* Este programa es software libre; puedes redistribuirlo y/o modificarlo
* bajo los terminos de la Licencia Publica General GNU (GPL) publicada
* por la Free Software Foundation; en su version numero 2, o (bajo tu 
* criterio) la ultima version. Mira http://www.fsf.org/copyleft/gpl.txt.
* 
* Este programa se distribuye SIN GARANTIA de ningun tipo.
*
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

  /////////////////////////////////////////////////////////////////////////////
 // Numero de modelos de routers en la base de datos //
/////////////////////////////////////////////////////////////////////////////

#define MAXROUTER 10
#define MAXINDEX 1
#define VERSION 0
#define SUBVERSION 6

  ///////////////////////////////////////////////////////////////////
 // Tipo de dato Router, con toda la informacion //
///////////////////////////////////////////////////////////////////

typedef struct Router
{
    char bssid[9];
    char init[MAXINDEX][8];
    char notas[30];
} tRouter;

  ///////////////////////////////
 // Variables globales //
//////////////////////////////

char hex[16]="0123456789ABCDEF";


  ////////////////////
 // Funciones //
////////////////////

void initRouters(tRouter routers[MAXROUTER]);
void datosRouters(tRouter routers[MAXROUTER]);
void muestraAyuda();
int buscaBssid(tRouter routers[MAXROUTER], char *bssid);
void imprimeClaves(FILE *fichero, tRouter routers[MAXROUTER], int bssidId, char *keyEnd);

  ////////////////
 // El main //
///////////////

int main(int argc, char *argv[])
{
    int bssidId, i;
    int validHex=0;
    char endKey[2];
    tRouter routers[MAXROUTER];
    FILE *fichero;
  
  /////////////////////////////////////////////
 // Para mostrar ayuda y version //
/////////////////////////////////////////////


    if(argv[1])
   {
   	 if(argv[1][0] =='-' && argv[1][1] =='v' )
  	 {
 	  printf("version %i.%i\n", VERSION, SUBVERSION);
	 return 0;
   	 }
   	 if(argv[1][0] =='-' && argv[1][1] =='h' )
  	 {
 	  printf("\nwlandecrypter [MAC ROUTER] [ESSID]\n\n-h\t Muestra esta ayuda\n");
 	  printf("-v\t Muestra la version\n\n");
	 return 0;
   	 }

    }



   if(argc<3 || argc>4)
    {
      muestraAyuda();
      return 1;
  }



    if(strlen(argv[1])!=17)
    {
        fprintf(stderr," [-] Longitud de BSSID invalida\n");
        return 1;
    }
        
    initRouters(routers);
    datosRouters(routers);


    bssidId=buscaBssid(routers, argv[1]);

    if(bssidId==-1)
    {
        fprintf(stderr, " [-] BSSID no encontrado\n");
        return 1;
    }
    else
    {
        fprintf(stderr, " [+] BSSID: %s\n" 
                " [+] Modelo: %s\n", argv[1], routers[bssidId].notas);

        for(i=0;i<strlen(argv[2]);i++)
            argv[2][i]=toupper(argv[2][i]);

        if(strlen(argv[2])<7 || strlen(argv[2])>9 || strncmp("WLAN_", argv[2], 5) != 0 )
        {
            fprintf(stderr, " [-] ESSID: %s invalido!!\n", argv[2]);
            return 1;
        }
        else
        {
            for(i=0;i<strlen(hex);i++)
            {
                if(argv[2][5]==hex[i])
                {
                    validHex++;
                    break;
                }
            }
            for(i=0;i<strlen(hex);i++)
            {
                if(argv[2][6]==hex[i])
                {
                    validHex++;
                    break;
                }
            }

            if(validHex!=2)
            {
                fprintf(stderr, " [-] ESSID: %s invalido!!\n", argv[2]);
                return 1;
            }
            else
            {
                endKey[0]=argv[2][5];
                endKey[1]=argv[2][6];

                fprintf(stderr," [+] ESSID: %s\n", argv[2]);
                
                if(argc>3) // Fichero
                {
                    
                    fprintf(stderr," [+] Fichero de claves: %s\n", argv[3]);
                    fichero=fopen(argv[3], "a+");
                    if(fichero!=NULL)
                    {
                        imprimeClaves(fichero,routers,bssidId,endKey);
                        fclose(fichero);
                        fprintf(stderr, " [+] Fichero guardado\n");
                    }
                    else
                    {
                        fprintf(stderr," [-] Error al abrir el fichero\n");
                        return 1;
                    }
                }
                else
                {
                    fprintf(stderr," [+] Seleccionada salida estandar\n");
                    imprimeClaves(stdout,routers,bssidId,endKey);
                }
            }
        }

    }
        
    return 0;
}   

  //////////////////////////////////////////
 // Vacia la estructura routers //
/////////////////////////////////////////

void initRouters(tRouter routers[MAXROUTER])
{
    int i,j;
    for(j=0;j<MAXROUTER;j++)
    {
        strcpy(routers[j].bssid,"");
        for(i=0;i<5;i++)
            strcpy(routers[j].init[i],"");
        strcpy(routers[j].notas,"");
    }
}

  //////////////////////////////////////////////////////////////////////
 // Introduce los datos de los modelos conocidos //
/////////////////////////////////////////////////////////////////////

void datosRouters(tRouter routers[MAXROUTER])
{

    // Z-com
    strcpy(routers[0].bssid,"00:60:B3\0");
    strcpy(routers[0].init[0],"Z001349\0");
    strcpy(routers[0].notas,"Z-com\0");

    // Xavvy
    strcpy(routers[1].bssid,"00:01:38\0");
    strcpy(routers[1].init[0],"X000138\0");
    strcpy(routers[1].notas,"Xavi 7768r\0");

    // Comtrend
    strcpy(routers[2].bssid,"00:03:C9\0");
    strcpy(routers[2].init[0],"C0030DA\0");
    strcpy(routers[2].notas,"Comtrend 535\0");

    
    // Zyxel : Gracias a thefkboss de foro.elhacker.net por esta observacion
    strcpy(routers[3].bssid,"00:A0:C5\0"); 
    strcpy(routers[3].init[0],"Z001349\0");
    strcpy(routers[3].notas,"Zyxel 650HW/660HW\0");

    // Comtrend 
    strcpy(routers[4].bssid,"00:16:38\0");
    strcpy(routers[4].init[0],"C0030DA\0");
    strcpy(routers[4].notas,"Comtrend 536+\0");

    // P-660HW-D1
    strcpy(routers[5].bssid,"00:13:49\0");
    strcpy(routers[5].init[0],"Z001349\0");
    strcpy(routers[5].notas,"P-660HW-D1\0");

    //  ZyGate Communications
    strcpy(routers[6].bssid,"00:02:CF\0");
    strcpy(routers[6].init[0],"Z0002CF\0");
    strcpy(routers[6].notas,"ZyGate\0");

    // Comtrend  nuevos 2007 
    strcpy(routers[7].bssid,"00:1A:2B\0");
    strcpy(routers[7].init[0],"C0030DA\0");
    strcpy(routers[7].notas,"Comtrend_DSL\0");      

    // pianista
    strcpy(routers[8].bssid,"00:19:CB\0");   
    strcpy(routers[8].init[0],"Z0002CF\0");
    strcpy(routers[8].notas,"Zyxel_660hw\0");

    // hrodgar ZyGate Communications
    strcpy(routers[9].bssid,"00:19:15\0");
    strcpy(routers[9].init[0],"C0030DA\0");
    strcpy(routers[9].notas,"Zygate\0");

}

  ////////////////////////////////////////////////
 // Muestra la ayuda del programa //
///////////////////////////////////////////////

void muestraAyuda()
{
    fprintf(stderr, "Argumentos requeridos. Use -h para obtener ayuda.\n");
}

//
// Busca el bssid en la estructura y devuelve el identificador o
//  -1 si no existe
//
int buscaBssid(tRouter routers[MAXROUTER], char *bssid)
{
    int i;
    
    for(i=0;i<strlen(bssid);i++)
        bssid[i]=toupper(bssid[i]);

    for(i=0;i<MAXROUTER;i++)
    {
        if(strncmp ( routers[i].bssid, bssid, 8 ) == 0)
            return i;
    }
    
    return -1;
}

  //////////////////////////////////////////////////
 // Imprime las claves en un fichero //
/////////////////////////////////////////////////

void imprimeClaves(FILE *fichero, tRouter routers[MAXROUTER], int bssidId, char *keyEnd)
{
    int i,j,k,l,index=0;
    
    while(index<MAXINDEX && strcmp(routers[bssidId].init[index], ""))
    {
            for(i=0;i<16;i++)
                    for(j=0;j<16;j++)
                            for(k=0;k<16;k++)
                                    for(l=0;l<16;l++)
                                    {
                        fprintf(fichero, "%s%c%c%c%c%c%c\n",routers[bssidId].init[index],hex[i],hex[j],hex[k],hex[l],keyEnd[0],keyEnd[1]);
                                    }
        index++;
    }

}

