;               T

	incdir	asm:
	include	BIncs.i

Demo=	0

SSpace=	8			* Spline key step
WrapCam=	1
WrapObj=	1
Observer=	0
Mouse=	0
Stretch=	1
Morph=	1
REnvi=	1			* (moving textures)
Exaggerate=	0			* (angles)
Rotate=	1			* (rotate objects)

BPP=	32
BPPoly=	4*2+6
PMul=	123-10
MinDist=	20
Double=	0
ZClip=	1

ObjLimit=	2
KeyLimit=	20
TextLimit=	2

	rsreset
FNC_NPoints	rs	1
FNC_NPolys	rs	1
FNC_Points	rs.l	1
FNC_Polys	rs.l	1
FNC_Pseudos	rs.l	1
FNC_Normals	rs.l	1
	rsreset
VecX	rs.l	1
VecY	rs.l	1
VecZ	rs	1
VecPseudoX	rs	1
VecPseudoY	rs	1
VecPX	rs	1
VecPY	rs	1
VecZDelta	rs	1
	rsreset
ConP1	rs	1
ConP2	rs	1
ConP3	rs	1
ConTN	rs	1
ConSize	rs.b	0

Width=	256
	if Double=0
Height=	256
Opt=	0
	else
Height=	128
Opt=	1
	endif
PlSiz=	(Width/8)*Height
BufferSize=	Width*Height*2


	Section	LWCode,Code
start	push	all
	lea	$dff000,a2
	move.l	4.w,a6
	if demo=1
	move.l	a0,vbrptr
	move	d0,EndPos
	move	d1,EndRow
	move.l	d2,PatPos
	move.l	d3,RowPos
	move	d4,Mode
	move.l	d5,E8Com
	move.l	4.w,a6
	lea	super(pc),a5
	call	supervisor
	endif
	if demo=0
	call	forbid
	call	disable
	lea	super(pc),a5
	call	supervisor
	lea	grname(pc),a1
	moveq	#0,d0
	call	openlibrary
	move.l	d0,a6
	beq	endprg
	move.l	d0,gfxbase
	move.l	actiview(a6),oldview
	call	waitblit
	call	ownblitter
	sub.l	a1,a1
	call	loadview
	call	waittof
	call	waittof
	call	waitblit
	endif
	move	#$8000,d0
	move	dmaconr(a2),olddma
	or	d0,olddma
	move	intenar(a2),oldintena
	or	d0,oldintena
	move	#$187f,intena(a2)
	move	#$187f,intreq(a2)
	if demo=0
	not	d0
	move	d0,dmacon(a2)
	endif
	bsr	prog
	move	#$7fff,d0
	move	#$187f,intena(a2)
	move	#$187f,intreq(a2)
	if demo=0
	move	d0,dmacon(a2)
	move.l	gfxbase,a6
	move.l	startlist(a6),cop1lch(a2)
	move	d0,copjmp1(a2)
	endif
	move	olddma,dmacon(a2)
	move	oldintena,intena(a2)
	if demo=0
	move.l	oldview,a1
	call	loadview
	call	waittof
	call	waittof
	call	disownblitter
	endif
	tst.l	d7
	bne.b	QuitPrg
endprg	move.l	4.w,a6
	if demo=0
	call	enable
	call	permit
	endif
	pull	all
	moveq	#0,d0
	rts
quitprg	move.l	4.w,a6
	if demo=0
	call	enable
	call	permit
	endif
	pull	all
	moveq	#-1,d0
	rts
	include	Credits.i

Super	movec	vbr,d0
	nop
	move.l	d0,VBRPtr
	rte

NewVBI	move	#$0020,intreq+custom
	addq	#1,Framet
	push	d0-d1

	if Mouse=1
	move	joy0dat+custom,d0
	and.l	#$ffff,d0
	move.l	d0,d1
	and.l	#$ff00,d0
	lsr.l	#8,d0
	mulu	#4096,d0
	lsr.l	#8,d0
	move.l	d0,XAngle
	and.l	#$ff,d1
	mulu	#4096,d1
	lsr.l	#8,d1
	move.l	d1,YAngle
	endif

;	add.l	#$000,XAngle
;	add.l	#$000,YAngle
;	add.l	#$005,ZAngle
	and.l	#$fff,XAngle
	and.l	#$fff,YAngle
	and.l	#$fff,ZAngle

	move.l	LastFrame,d0
	lsl.l	#8,d0
;	add.l	#$0050*3,CurFrame
	add.l	#$bd,curframe

	tst.l	CurFrame
	bpl.b	NSW2
	add.l	d0,CurFrame
NSW2	cmp.l	CurFrame,d0
	bhi.b	NSW
	sub.l	d0,CurFrame
NSW	
	pull	d0-d1

	rte

Prog	push	all
	bsr	InitScene
	bmi	Quit

	lea	Buffers,a0
	move.l	#BufferSize,d0
	bsr	BigClear
	lea	CBuf,a0
	move.l	#Width*Height,d0
	bsr	BigClear
	lea	$dff000,a2

	move.l	#Buffers,d0
	move.l	d0,PL1Adr
	add.l	#Width*Height,d0
	move.l	d0,PL2Adr
	bsr	SetScr
	bsr	Switch
	waitr3	$13500
	move.l	VBRPtr,a0
	move.l	$6c(a0),OldVBI
	move.l	#NewVBI,$6c(a0)
	move	#$c020,intena(a2)
	move.l	#CopperList,cop1lch(a2)
	move	d0,copjmp1(a2)
	move	#$83c0,dmacon(a2)
FWait
;	waitr3	$13700
	clr	Framet
	btst	#2,$16(a2)
	bne.b	NFWait
	move	#$0020,intena(a2)
Pause	btst	#2,$16(a2)
	beq.b	Pause
	move	#$8020,intena(a2)
	bra.b	FWait
NFWait
	bsr	Switch

	lea	CBuf,a0
	move.l	#Width*Height,d0
	bsr	BigClear
	lea	$dff000,a2

	bsr	MakeKeyFrame

	if Observer=0
	move.l	XAngle,d0		* pitch
	move.l	YAngle,d1		* heading
	move.l	ZAngle,d2		* bank
	neg.l	d0
	else
	if Mouse=0
	clr.l	d0
	clr.l	d1
	clr.l	d2
	else
	move.l	XAngle,d0		* pitch
	move.l	YAngle,d1		* heading
	move.l	ZAngle,d2		* bank
	endif
	endif
	lea	Matrice,a0
	lea	Sines,a1
	lea	IsoSinus(pc),a3
	bsr	CalcMatrice2
	bsr	CalculateVector
	bsr	ConstructPolygons
	tst	ConstructedPolys
	beq	BlankScreen
	bsr	HideHiddenPolygons
	tst	VisiblePolys
	beq	BlankScreen
	bsr	Sort
	bsr	DrawPolygons
BlankScreen	bsr	Chunky2Planar

	moveq	#0,d0
	move	Framet,d0
	move.l	4(a2),d1
	and.l	#$1ff00,d1
	ror.l	#8,d0
	or.l	d1,d0
	move.l	d0,Test

	btst	#6,$bfe001
	bne	FWait
	bwait
	move	#$01c0,dmacon(a2)
	move	#$0020,intena(a2)
	move.l	VBRPtr,a0
	move.l	OldVBI,$6c(a0)
Quit	pull	all
	rts


CalcV1	macro
	moveq	#-(\2)*1,d5
	muls	d4,d5
	add.l	#\1,d5
	move.l	(a0,d5.l),d0
	moveq	#(\2)*0,d5
	muls	d4,d5
	add.l	#\1,d5
	move.l	(a0,d5.l),d1
	moveq	#(\2)*1,d5
	muls	d4,d5
	add.l	#\1,d5
	move.l	(a0,d5.l),d2
	moveq	#(\2)*2,d5
	muls	d4,d5
	add.l	#\1,d5
	move.l	(a0,d5.l),d3
	move.l	a1,a2
	muls	(a2)+,d0
	muls	(a2)+,d1
	muls	(a2)+,d2
	muls	(a2)+,d3
	add.l	d1,d0
	add.l	d2,d0
	add.l	d3,d0
	add.l	d0,d0
	swap	d0
	ext.l	d0
	endm

	cnop	0,16
MakeKeyFrame
	lea	CameraKeys,a0
	add.l	CamSeqSize,a0
	lea	Spline,a1
	move.l	CurFrame,d0
	divu	#SSpace*256,d0
	move.l	d0,d1
	swap	d1
	and.l	#$ffff,d0
	and.l	#$ffff,d1
	mulu	#CamKeySize-4,d0
	add.l	d0,a0
	moveq	#10,d2
	lsl.l	d2,d1
	divu	#SSpace*256,d1
	lea	(a1,d1*8),a1
	moveq	#1,d4
	CalcV1	0,CamKeySize-4
	move	d0,CamX
	CalcV1	4,CamKeySize-4
	move	d0,CamY
	CalcV1	8,CamKeySize-4
	move	d0,CamZ

	if Mouse=0
	CalcV1	12,CamKeySize-4		* pitch
	and.l	#$fff,d0
	move.l	d0,XAngle
	CalcV1	16,CamKeySize-4		* heading
	and.l	#$fff,d0
	move.l	d0,YAngle
	CalcV1	20,CamKeySize-4		* bank
	and.l	#$fff,d0
	move.l	d0,ZAngle
	endif

	lea	ObjectKeys,a0
	add.l	ObjSeqSize,a0
	lea	Spline,a1
	move.l	CurFrame,d0
	divu	#SSpace*256,d0
	move.l	d0,d1
	swap	d1
	and.l	#$ffff,d0
	and.l	#$ffff,d1
	mulu	#ObjKeySize-4,d0
	mulu	NObjects+2,d0
	add.l	d0,a0
	moveq	#10,d2
	lsl.l	d2,d1
	divu	#SSpace*256,d1
	lea	(a1,d1*8),a1
	lea	CurKeyFrame,a3
	lea	ObjList,a6

	move.l	NObjects,d7
	subq	#1,d7
ObjectKeyLoop
	tst.l	(a6)
	bne.b	CalcForObj1
	add	#9*4,a3
	bra	NextObjKey
CalcForObj1	pushr	a0
	move.l	NObjects,d4
	CalcV1	0,ObjKeySize-4
	move.l	d0,(a3)+
	CalcV1	4,ObjKeySize-4
	move.l	d0,(a3)+
	CalcV1	8,ObjKeySize-4
	move.l	d0,(a3)+
	CalcV1	12,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	CalcV1	16,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	CalcV1	20,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	if Stretch=1
	CalcV1	24,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	CalcV1	28,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	CalcV1	32,ObjKeySize-4
	and.l	#$fff,d0
	move.l	d0,(a3)+
	else
	move.l	#256,(a3)+
	move.l	#256,(a3)+
	move.l	#256,(a3)+
	endif
	pullr	a0
NextObjKey	add.l	#ObjKeySize-4,a0
	add	#12,a6
	dbf	d7,ObjectKeyLoop

	lea	ObjList,a0
	lea	ObjList2,a1
	move.l	NObjects,d7
	subq.l	#1,d7
MakeObjList2	rept	3
	move.l	(a0)+,(a1)+
	endr
	dbf	d7,MakeObjList2

	IF Morph=1
	lea	MorphKeys,a0
	lea	ObjList,a1
	lea	VecDataMorph,a2
	lea	ObjList2,a3
	move.l	NObjects,d7
	subq.l	#1,d7
MorphKeyLoop1	move.l	(a0)+,d6
	beq	MorphNextObject

	tst.l	(a1)
	bne	SkipMorphObj
	addq.l	#4,a0
	mulu	#8,d6
	add.l	d6,a0
	bra	MorphNextObject
SkipMorphObj
	subq.l	#1,d6

	move.l	4(a1),d4		* n points
	move.l	8(a1),a4		* points

	move.l	(a0)+,d0		* target object
	mulu	#12,d0
	lea	ObjList,a5
	move.l	4(a5,d0),d5		* n points 2
	move.l	8(a5,d0),a5		* points 2

	cmp.l	d4,d5
	bhs.b	Bigger1
	move.l	d5,d4
Bigger1	subq.l	#1,d4

	move.l	CurFrame,d2
	lsr.l	#8,d2
MorphKeyLoop2	move.l	(a0),d0
	move.l	4(a0),d1
	cmp.l	d2,d0
	bhi.b	NextMorphKey
	tst	d6
	beq.b	ConstantMorph
	cmp.l	8(a0),d2
	bhs.b	NextMorphKey
	move.l	8+4(a0),d3
	bra.b	VaryingMorph
ConstantMorph	move.l	d1,d3
VaryingMorph
	move.l	a2,8(a3)	* morph data ptr to ObjList2

;	move.l	d2,d5
	move.l	CurFrame,d5	* more accuracy
	lsl.l	#8,d0
	sub.l	d0,d5
	lsr.l	#8,d0
	sub.l	d0,d5		* cur-k1

	sub.l	d1,d3		* m2-m1
	muls	d5,d3		* (cur-k1)*(m2-m1)
	move.l	8(a0),d5
	sub.l	d0,d5		* k2-k1
	divs.l	d5,d3		* (cur-k1)*(m2-m1)/(k2-k1)
	asr.l	#8,d3

	add.l	d3,d1

	pushr	a2
MorphKeyLoop3
	move	(a5)+,d0
	move	(a5)+,d2
	move	(a5)+,d3
	addq.l	#6,a5
	sub	(a4),d0
	sub	2(a4),d2
	sub	4(a4),d3
	muls	d1,d0
	muls	d1,d2
	muls	d1,d3
	asr.l	#8,d0
	asr.l	#8,d2
	asr.l	#8,d3
	add	(a4)+,d0
	add	(a4)+,d2
	add	(a4)+,d3
	move	d0,(a2)+
	move	d2,(a2)+
	move	d3,(a2)+
	move.l	(a4)+,(a2)+
	move	(a4)+,(a2)+

	dbf	d4,MorphKeyLoop3
	pullr	a2

	addq	#1,d6
	lsl	#3,d6
	add	d6,a0
	bra.b	MorphNextObject

NextMorphKey	addq.l	#8,a0
	dbf	d6,MorphKeyLoop2

MorphNextObject
	move.l	4(a1),d0
	mulu	#12,d0			* x,y,z,px,py,pz
	add.l	d0,a2
	add	#12,a1
	add	#12,a3
	dbf	d7,MorphKeyLoop1
	endif

	lea	$dff000,a2
	rts


	cnop	0,16
CalcMatrice	incbin	Virtual/XYZMatrice.bin
	cnop	0,16
CalcMatrice2	incbin	Virtual/MatriceCode2_2.bin


	rsreset
m_xx	rs	1
m_xy	rs	1
m_xz	rs	1
m_yx	rs	1
m_yy	rs	1
m_yz	rs	1
m_zx	rs	1
m_zy	rs	1
m_zz	rs	1

SafeShift=	7		* FOUR CAUSES PROBLEMS !!!

matrix	macro
	move	\1(a1),\3
	muls	\2(a2),\3
	divs.l	#32767*(2^SafeShift),\3
	endm

	cnop	0,16
CalculateVector
	lea	VecData,a0
	lea	VecData2,a6

	lea	ObjList2,a1
	lea	CurKeyFrame,a2
	move.l	NObjects,d7
	subq	#1,d7
CalculateLoop1
	tst.l	(a1)
	bne	SkipObjectRot
	move.l	4(a1),d0
	mulu	#BPP,d0
	add.l	d0,a6
	bra	NextObjectRot
SkipObjectRot
	push	d7/a1-a2
	movem.l	(a2)+,d0-d5

;	sub.l	#1000,d2

	if Observer=0
	sub	CamX,d0
	sub	CamY,d1
	sub	CamZ,d2
	else
	sub.l	#0,d0
	sub.l	#0,d1
	sub.l	#-2000,d2
	endif
	move	d0,AddX
	move	d1,AddY
	move	d2,AddZ

	push	all
	if Rotate=1
	move.l	d3,d0
	move.l	d4,d1
	move.l	d5,d2
	else
	clr.l	d0
	clr.l	d1
	clr.l	d2
	endif
	if Exaggerate=1
	lsl.l	#3,d0
	lsl.l	#3,d1
	lsl.l	#3,d2
	endif
	lea	Matrice2,a0
	lea	IsoSinus(pc),a1
	bsr	CalcMatrice

	if Stretch=1
	move.l	a2,a4
	move.l	a4,a5
	endif
	lea	Matrice,a1
	lea	Matrice2,a2
	lea	Matrice3,a3

	matrix	m_xx,m_xx,d0
	matrix	m_xy,m_yx,d1
	matrix	m_xz,m_zx,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_xx,m_xy,d0
	matrix	m_xy,m_yy,d1
	matrix	m_xz,m_zy,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_xx,m_xz,d0
	matrix	m_xy,m_yz,d1
	matrix	m_xz,m_zz,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	move	0(a1),d0
	muls	AddX,d0
	move	2(a1),d1
	muls	AddY,d1
	move	4(a1),d2
	muls	AddZ,d2
	add.l	d1,d0
	add.l	d2,d0
	asr.l	#SafeShift,d0
	move.l	d0,(a3)+
	if REnvi=0
	move	0(a1),(a3)+		* pseudo
	move	2(a1),(a3)+
	move	4(a1),(a3)+
	else
	move	0(a2),(a3)+
	move	2(a2),(a3)+
	move	4(a2),(a3)+
	endif

	if Stretch=1
	move.l	a4,a5
	endif
	matrix	m_yx,m_xx,d0
	matrix	m_yy,m_yx,d1
	matrix	m_yz,m_zx,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_yx,m_xy,d0
	matrix	m_yy,m_yy,d1
	matrix	m_yz,m_zy,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_yx,m_xz,d0
	matrix	m_yy,m_yz,d1
	matrix	m_yz,m_zz,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	move	6(a1),d0
	muls	AddX,d0
	move	8(a1),d1
	muls	AddY,d1
	move	10(a1),d2
	muls	AddZ,d2
	add.l	d1,d0
	add.l	d2,d0
	asr.l	#SafeShift,d0
	move.l	d0,(a3)+
	if REnvi=0
	move	6(a1),(a3)+		* pseudo
	move	8(a1),(a3)+
	move	10(a1),(a3)+
	else
	move	6(a2),(a3)+
	move	8(a2),(a3)+
	move	10(a2),(a3)+
	endif

	if Stretch=1
	move.l	a4,a5
	endif
	matrix	m_zx,m_xx,d0
	matrix	m_zy,m_yx,d1
	matrix	m_zz,m_zx,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_zx,m_xy,d0
	matrix	m_zy,m_yy,d1
	matrix	m_zz,m_zy,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	matrix	m_zx,m_xz,d0
	matrix	m_zy,m_yz,d1
	matrix	m_zz,m_zz,d2
	add.l	d2,d0
	add.l	d1,d0
	if Stretch=1
	move.l	(a5)+,d1
	muls.l	d1,d0
	asr.l	#8,d0
	endif
	move	d0,(a3)+
	move	12(a1),d0
	muls	AddX,d0
	move	14(a1),d1
	muls	AddY,d1
	move	16(a1),d2
	muls	AddZ,d2
	add.l	d1,d0
	add.l	d2,d0
	asr.l	#SafeShift,d0
	move.l	d0,(a3)+

;	if REnvi=0
;	move	12(a1),(a3)+		* pseudo
;	move	14(a1),(a3)+
;	move	16(a1),(a3)+
;	else
;	move	12(a2),(a3)+
;	move	14(a2),(a3)+
;	move	16(a2),(a3)+
;	endif

	pull	all

	move.l	8(a1),a0
	move.l	4(a1),d7
	subq.l	#1,d7
CalculateLoop2
	lea	Matrice3,a1
	movem	(a0),d0-d5
	muls	(a1)+,d0
	muls	(a1)+,d1
	muls	(a1)+,d2
	add.l	d1,d0
	add.l	d2,d0
	add.l	(a1)+,d0
	muls	(a1)+,d3
	muls	(a1)+,d4
	muls	(a1)+,d5
	move.l	d0,a2
	move.l	a2,(a6)+		* x
	add.l	d4,d3
	add.l	d5,d3
	add.l	d3,d3
	swap	d3
	move.l	d3,a3

	movem	(a0),d0-d5
	muls	(a1)+,d0
	muls	(a1)+,d1
	muls	(a1)+,d2
	add.l	d1,d0
	add.l	d2,d0
	add.l	(a1)+,d0
;	neg.l	d0			* LW NEG
	move.l	d0,a4
	muls	(a1)+,d3
	muls	(a1)+,d4
	muls	(a1)+,d5
	move.l	a4,(a6)+		* y
	add.l	d4,d3
	add.l	d5,d3
	add.l	d3,d3
	swap	d3
	move.l	d3,a5

	movem	(a0)+,d0-d2
	addq.l	#6,a0			* skip pseudos
	muls	(a1)+,d0
	muls	(a1)+,d1
	muls	(a1)+,d2
	add.l	d1,d0
	add.l	d2,d0
	add.l	(a1)+,d0
;	moveq	#15-SafeShift,d1
;	asr.l	d1,d0
	asr.l	#15-SafeShift,d0

	move	d0,(a6)+		* z
	add	#128,a3
	move	a3,(a6)+		* psx
	add	#128,a5
	move	a5,(a6)+		* psy

	add	#MinDist,d0
	ble.b	NoProj1
	move.l	a2,d2
	move.l	a4,d3
	if SafeShift<>7
	asr.l	#7-SafeShift,d2
	endif
	if Double=0
	if SafeShift<>7
	asr.l	#7-SafeShift,d3
	endif
	else
	asr.l	#7-SafeShift+1,d3
	endif
	divs	d0,d2
	divs	d0,d3
	add	#Width/2,d2
	move	d2,(a6)			* px
	neg	d3
	add	#Height/2,d3
	move	d3,2(a6)		* py
NoProj1
	add	#BPP-14,a6
	dbf	d7,CalculateLoop2
	pull	d7/a1-a2

NextObjectRot	add	#12,a1
	add	#ObjKeySize-4,a2
	dbf	d7,CalculateLoop1

	lea	$dff000,a2
	rts


CheckArea	macro
	move.l	\1(a1,\2*8),d4
	bpl.b	NotVecNeg\@
	neg.l	d4
NotVecNeg\@	cmp.l	d4,d5
	bhs.b	DontPoly\@
	addq.l	#2,a3
	bra	NextPolygon
DontPoly\@
	endm


	cnop	0,16
ConstructPolygons
	lea	VecData2,a1
	lea	VecCon2,a2

	move.l	AllPoints,d6
	mulu	#BPP/8,d6

	clr	ConstructedPolys

	lea	ConstList,a6
	move.l	NObjects,d7
	subq.l	#1,d7
ConstructLoop2
	tst.l	(a6)
	beq	NextObjectConst
	pushr	d7
	move.l	4(a6),d7		* npolys
	move.l	8(a6),a0
	subq.l	#1,d7
ConstructLoop
	move.l	a0,a3
	moveq	#0,d0
	move	(a3)+,d1
	move	(a3)+,d2
	move	(a3)+,d3

	tst	VecZ(a1,d1*8)
	bgt.b	P1Pos
	moveq	#1,d0
P1Pos	tst	VecZ(a1,d2*8)
	bgt.b	P2Pos
	or.b	#2,d0
P2Pos	tst	VecZ(a1,d3*8)
	bgt.b	P3Pos
	or.b	#4,d0
P3Pos
	if	ZClip=1
	cmp	#7,d0
	beq.b	NextPolygon
	tst	d0
	bne.b	ClipPolygon
	else
	tst	d0
	bne.b	NextPolygon
	endif

	move	VecZ(a1,d1*8),d4
	add	VecZ(a1,d2*8),d4
	add	VecZ(a1,d3*8),d4
	move	d4,(a2)+
	move	#3,(a2)+
	move	d1,(a2)+
	move	d2,(a2)+
	move	d3,(a2)+
	move	(a3)+,(a2)+
	addq.l	#BPPoly-12,a2
	addq	#1,ConstructedPolys
NextPolygon	addq.l	#ConSize,a0
	dbf	d7,ConstructLoop
	pullr	d7
NextObjectConst
	add	#12,a6
	dbf	d7,ConstructLoop2
	lea	$dff000,a2
	rts

ClipPolygon				* Optimize !!!!!!!!!!!!!!!!!!!
	move.l	#(MinDist+1)*(2^(7-SafeShift))*1000,d5
	CheckArea	VecX,d1
	CheckArea	VecY,d1
	CheckArea	VecX,d2
	CheckArea	VecY,d2
	CheckArea	VecX,d3
	CheckArea	VecY,d3

	cmp	#1,d0
	beq	ClipCase1
	cmp	#2,d0
	beq	ClipCase2
	cmp	#3,d0
	beq	ClipCase3
	cmp	#4,d0
	beq	ClipCase4
	cmp	#5,d0
	beq	ClipCase5
	cmp	#6,d0
	beq	ClipCase6
	bra	NextPolygon

ClipM	macro
	move	\1,d0
	move	\2,d1
	bsr	Point
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	endm

ClipM2	macro
	move	\1(a0),d0
	move	\2(a0),d1
	bsr	Point
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	endm

ZDist	macro
	move	VecZ(a1,\1*8),d4
	add	VecZ(a1,\2*8),d4
	addq	#1,d4
	move	d4,(a2)+
	endm

ZDist2	macro
	move	VecZ(a1,\1*8),d4
	addq	#2,d4
	move	d4,(a2)+
	endm

ClipEMac	macro
	move	(a3)+,(a2)+
	addq.l	#BPPoly-12,a2
	addq	#1,ConstructedPolys
	endm

ClipCase1	ZDist	d2,d3
	moveq	#3,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	move	d3,BPPoly(a2)		* p3_2 -->
	move	d2,(a2)+		* p2 -->
	move	ConP3(a0),d0
	move	ConP1(a0),d1
	bsr	Point
	move	d6,BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	ConP2(a0),d0
	move	ConP1(a0),d1
	bsr	Point
	move	ConP2(a0),BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	(a3)+,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	add	#BPPoly*2-12,a2
	addq	#2,ConstructedPolys
	bra	NextPolygon
ClipCase2	ZDist	d1,d3
	moveq	#3,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	move	d1,BPPoly(a2)		* p1_2 -->
	move	d3,(a2)+		* p3 -->
	move	ConP1(a0),d0
	move	ConP2(a0),d1
	bsr	Point
	move	d6,BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	ConP3(a0),d0
	move	ConP2(a0),d1
	bsr	Point
	move	ConP3(a0),BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	(a3)+,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	add	#BPPoly*2-12,a2
	addq	#2,ConstructedPolys
	bra	NextPolygon
ClipCase4	ZDist	d1,d2
	moveq	#3,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	move	d2,BPPoly(a2)		* p2_2 -->
	move	d1,(a2)+		* p1 -->
	move	ConP2(a0),d0
	move	ConP3(a0),d1
	bsr	Point
	move	d6,BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	ConP1(a0),d0
	move	ConP3(a0),d1
	bsr	Point
	move	ConP1(a0),BPPoly(a2)
	move	d6,(a2)+
	addq.l	#BPP/8,d6
	move	(a3)+,d4
	move	d4,BPPoly(a2)
	move	d4,(a2)+
	add	#BPPoly*2-12,a2
	addq	#2,ConstructedPolys
	bra	NextPolygon
ClipCase3	ZDist2	d3			* p3 z
	move	#3,(a2)+
	move	d3,(a2)+		* p3 -->
	ClipM	d3,d1			* p3,p1
	ClipM2	ConP3,ConP2
	ClipEMac
	bra	NextPolygon
ClipCase5	ZDist2	d2			* p2 z
	move	#3,(a2)+
	move	d2,(a2)+		* p2 -->
	ClipM	d2,d3
	ClipM2	ConP2,ConP1
	ClipEMac
	bra	NextPolygon
ClipCase6	ZDist2	d1			* p1 z
	move	#3,(a2)+
	move	d1,(a2)+		* p1 -->
	ClipM	d1,d2
	ClipM2	ConP1,ConP3
	ClipEMac
	bra	NextPolygon



CalcPos	macro
	move.l	\1(a1,d0*8),d4
	move.l	\1(a1,d1*8),d5
	sub.l	d4,d5
	muls.l	d2,d7:d5
	divs.l	d3,d7:d5
	add.l	d5,d4
	move.l	d4,\1(a1,d6*8)
	endm

CalcPs2	macro
	move	\1(a1,d0*8),d4
	move	\1(a1,d1*8),d5
	sub	d4,d5
	muls	d2,d5
	divs	d3,d5
	add	d5,d4
	move	d4,\1(a1,d6*8)
	endm

Point
					*** OPTIMIZE !!!
	pushr	d7
			**** 64 BIT OPERATIONS COULD BE REMOVED !!!
	move	VecZ(a1,d0*8),d2
	move	VecZ(a1,d1*8),d3
	neg	d3
	add	d2,d3
	ext.l	d2
	ext.l	d3

;	move	d2,VecZDelta(a1,d6*8)	* remove !!!!!!!!!!!!!!!!!!
;	move	d3,VecZDelta+2(a1,d6*8)
	CalcPos	VecX

	if SafeShift<>7
	asr.l	#7-SafeShift,d4
	endif
	if	MinDist<>0
	divs	#MinDist+1,d4
	endif
	add	#Width/2,d4
	move	d4,VecPX(a1,d6*8)
	CalcPos	VecY
	if Double=0
	if SafeShift<>7
	asr.l	#7-SafeShift,d4
	endif
	else
	asr.l	#7-SafeShift+1,d4
	endif
	if	MinDist<>0
	divs	#MinDist+1,d4
	endif
	neg	d4
	add	#Height/2,d4
	move	d4,VecPY(a1,d6*8)
	move	#1,VecZ(a1,d6*8)	* could be taked off
	CalcPs2	VecPseudoX
	CalcPs2	VecPseudoY

	pullr	d7			* OPTIMIZE !!!!!!!!
	rts


	cnop	0,16
HideHiddenPolygons
	clr	VisiblePolys
	lea	VecCon2,a0
	lea	VecData2,a1
	move.l	a0,a2
	move.l	#BPPoly,a5
	sub.l	a6,a6
;	move.l	AllPolys2,d7
	move	ConstructedPolys,d7
	ext.l	d7
	subq.l	#1,d7
	bmi.b	KeinePolys
HideLoop1
	move	4(a0),d4
	move	6(a0),d5
	move	8(a0),d6

	move.l	VecPX(a1,d4*8),d0
	move.l	d0,d1
	swap	d0
	move.l	VecPX(a1,d5*8),d2
	move.l	VecPX(a1,d6*8),d3
	move.l	d3,d4
	swap	d3

	sub	d2,d1
	sub	d2,d4
	swap	d2
	sub	d2,d0
	sub	d2,d3

	muls	d0,d4
	muls	d3,d1
	sub.l	d4,d1
	bmi.b	NextPoly
	move.l	(a0)+,(a2)+
	move.l	(a0)+,(a2)+
	move.l	(a0)+,(a2)+
	move	(a0)+,(a2)+
	addq.l	#1,a6
	sub.l	a5,a0
NextPoly	add.l	a5,a0
	dbf	d7,HideLoop1
KeinePolys	move	a6,VisiblePolys
	lea	$dff000,a2
	rts


	cnop	0,16
Sort
	lea	RadixTable,a0
	move.l	#256*4*2,d0
	bsr	BigClear

	move	VisiblePolys,d7

	lea	VecCon2,a0
	lea	RadixTable,a1
	moveq	#0,d0
	moveq	#BPPoly,d1
	moveq	#4,d2
	move	d7,d6
	lsr	#1,d6
	bcc.b	SkipCount1
	move.b	1(a0),d0
	add.l	d2,(a1,d0*4)
	add.l	d1,a0
SkipCount1	subq	#1,d6
	bmi.b	SkipCount2
CountTypes	rept	2
	move.b	1(a0),d0
	add.l	d2,(a1,d0*4)
	add.l	d1,a0
	endr
	dbf	d6,CountTypes
SkipCount2
	lea	RadixTable,a0
	lea	RadixPointers,a1
	lea	RadixData1,a2
	moveq	#256/8-1,d6
RadixSizing	rept	8
	move.l	a2,(a1)+
	add.l	(a0)+,a2
	endr
	dbf	d6,RadixSizing

	moveq	#0,d0
	moveq	#BPPoly,d1
	lea	VecCon2,a0
	lea	RadixPointers,a1
	move	d7,d6
	lsr	#1,d6
	bcc.b	SkipRadix1
	move.b	1(a0),d0
	move.l	(a1,d0*4),a2
	move.l	a0,(a2)+
	move.l	a2,(a1,d0*4)
	add.l	d1,a0
SkipRadix1	subq	#1,d6
	bmi.b	SkipRadix2
RadixSortLoop1	rept	2
	move.b	1(a0),d0
	move.l	(a1,d0*4),a2
	move.l	a0,(a2)+
	move.l	a2,(a1,d0*4)
	add.l	d1,a0
	endr
	dbf	d6,RadixSortLoop1
SkipRadix2

	moveq	#0,d0
	moveq	#4,d1
	lea	RadixData1,a0
	lea	RadixTable2,a1
	move	d7,d6
	lsr	#1,d6
	bcc.b	SkipCount3
	move.l	(a0)+,a2
	move.b	(a2),d0
	add.l	d1,(a1,d0*4)
SkipCount3	subq	#1,d6
	bmi.b	SkipCount4
CountTypes2	rept	2
	move.l	(a0)+,a2
	move.b	(a2),d0
	add.l	d1,(a1,d0*4)
	endr
	dbf	d6,CountTypes2
SkipCount4
	lea	RadixTable2,a0
	lea	RadixPointers,a1
	lea	RadixData2,a2
	moveq	#256/8-1,d6
RadixSizing2	rept	8
	move.l	a2,(a1)+
	add.l	(a0)+,a2
	endr
	dbf	d6,RadixSizing2

	moveq	#0,d0
	lea	RadixData1,a0
	lea	RadixPointers,a1
	move	d7,d6
	lsr	#1,d6
	bcc.b	SkipRadix3
	move.l	(a0)+,a2
	move.b	(a2),d0
	move.l	(a1,d0*4),a3
	move.l	a2,(a3)+
	move.l	a3,(a1,d0*4)
SkipRadix3	subq	#1,d6
	bmi.b	SkipRadix4
RadixSortLoop2	rept	2
	move.l	(a0)+,a2
	move.b	(a2),d0
	move.l	(a1,d0*4),a3
	move.l	a2,(a3)+
	move.l	a3,(a1,d0*4)
	endr
	dbf	d6,RadixSortLoop2
SkipRadix4	lea	$dff000,a2
	rts


	cnop	0,16
cx1	equ	-48
cy1	equ	-46
tx1	equ	-44
ty1	equ	-42
cx2	equ	-40
cy2	equ	-38
tx2	equ	-36
ty2	equ	-34
cx3	equ	-32
cy3	equ	-30
tx3	equ	-28
ty3	equ	-26

dy3	equ	-24
dy1	equ	-20
dy2	equ	-16

dxneg	equ	-12

txadd	equ	-8
tyadd	equ	-4

DrawPolygons	link	a6,#-48

	lea	RadixData2,a0
	moveq	#0,d7
	move	VisiblePolys,d7
	move.l	d7,d0
	lea	(a0,d0.l*4),a0
	subq	#1,d7
	bra	PolyLoop
	cnop	0,16
PolyLoop	move.l	-(a0),a2
	pushr	d7
	pushr	a0

	lea	VecData2,a0
	addq.l	#4,a2
	move.l	(a2)+,d0
	move	(a2)+,d1

	moveq	#0,d2
	move	(a2)+,d2
	swap	d2
	lea	Textures,a2
	add.l	d2,a2
	move.l	a2,Texture

	move.l	VecPX(a0,d0*8),d2
	move.l	VecPseudoX(a0,d0*8),d3
	move.l	VecPX(a0,d1*8),d4
	move.l	VecPseudoX(a0,d1*8),d5
	swap	d0
	move.l	VecPseudoX(a0,d0*8),d1
	move.l	VecPX(a0,d0*8),d0

	cmp	d2,d0
	blt.b	y1smaller
	exg	d0,d2
	exg	d1,d3
y1smaller	cmp	d4,d0
	blt.b	y1smaller2
	exg	d0,d4
	exg	d1,d5
y1smaller2	cmp	d4,d2
	blt.b	y2smaller
	exg	d2,d4
	exg	d3,d5
y2smaller
	sub.l	a4,a4

	cmp	d0,d2		* NUMBER 3 *
	bne.b	notsame2
	addq.l	#1,a4
	move.l	d0,d6
	move.l	d2,d7
	swap	d6
	swap	d7
	cmp	d6,d7
	bge.b	notsame1	;bhs = bcc => bge
	exg	d0,d2
	exg	d1,d3
	bra.b	notsame1
notsame2
	cmp	d2,d4		* NUMBER 4 *
	bne.b	notsame1
	addq.l	#2,a4
	move.l	d2,d6
	move.l	d4,d7
	swap	d6
	swap	d7
	cmp	d6,d7
	blt.b	notsame1	;blo = bcs => blt
	exg	d2,d4
	exg	d3,d5
notsame1
	lea	cx1(a6),a0
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d2,(a0)+
	move.l	d3,(a0)+
	move.l	d4,(a0)+
	move.l	d5,(a0)+

	cmp	#Height-1,d0
	bgt	NextPoly2
	tst	d4
	ble	NextPoly2

	swap	d0
	swap	d2
	swap	d4
	sub.l	a5,a5
	move	#Width-1,d6
	cmp	d6,d0
	bls.b	NoClip1
	addq.l	#1,a5
NoClip1	cmp	d6,d2
	bls.b	NoClip2
	addq.l	#1,a5
NoClip2	cmp	d6,d4
	bls.b	NoClip3
	cmp	#2,a5
	beq	NextPoly2
	addq.l	#1,a5
NoClip3
	swap	d0
	swap	d2
	swap	d4

	sub	d0,d4
	beq	NextPoly2
	move.l	d4,(a0)+		;dy3
	move.l	d4,d6

	sub	d0,d2
	move.l	d2,(a0)+		;dy1
	sub	d2,d4
	move.l	d4,(a0)+		;dy2

	move.l	d2,d3			;dy1
	move.l	d6,d4			;dy3

	move	cx3(a6),d7
	move	cx1(a6),d0
	sub	d0,d7
	ext.l	d7
	lsl.l	#8,d7
	divs	d4,d7
	muls	d3,d7
	asr.l	#8,d7
	add	d0,d7
	swap	d2		;DX=Leveimmn scanlinen leveys
	sub	d2,d7		;DX=(cx3-cx1)*256/dy3*dy2/256+cx1-cx2
	bne.b	notzero1
	clr.l	(a0)+		;dxneg
	clr.l	(a0)+		;txadd
	clr.l	(a0)		;tyadd
	bra.b	adders
notzero1
	ext.l	d7
	move.l	d7,(a0)+	;dxneg

	move.l	d1,d2		;jotain m tss oon laskenu ...
	move.l	d5,d6
	sub	d1,d5
	swap	d2
	swap	d6
	sub	d2,d6
	ext.l	d5
	ext.l	d6
	lsl.l	#8,d5
	lsl.l	#8,d6
	divs	d4,d5
	divs	d4,d6
	muls	d3,d5
	muls	d3,d6

	asr.l	#8,d6		;TX adder
	add	d2,d6
	sub	tx2(a6),d6
	ext.l	d6
	lsl.l	#8,d6
	divs	d7,d6
	ext.l	d6
	ror.l	#8,d6
	move.l	d6,(a0)+	;txadd

	asr.l	#8,d5		;TY Adder
	add	d1,d5
	sub	ty2(a6),d5
	ext.l	d5
	lsl.l	#8,d5
	divs	d7,d5
	ext.l	d5
	move.l	d5,(a0)		;tyadd
	move.b	txadd(a6),(a0)	;tyadd
adders

	lea	LBuf,a0
	move.l	a4,d0
	beq	NormPoly

	cmp	#1,d0
	bne	Number4

	move.l	dy3(a6),d6		* NUMBER 3 *

	move	cx3(a6),d2
	move	cx2(a6),d0
	sub	d0,d2
	ext.l	d2

	swap	d0
	move	cx3(a6),d1
	move	cx1(a6),d0
	sub	d0,d1		;cx1
	ext.l	d1

	tst.l	a5
	beq.b	NoClipN3
	lsl.l	#6,d2
	divs	d6,d2
	swap	d2
	lsl.l	#6,d1
	divs	d6,d1
	move	d1,d2
	lsl.l	#6,d0
	bra.b	ClipN3
NoClipN3	lsl.l	#8,d2
	divs	d6,d2
	swap	d2
	lsl.l	#8,d1
	divs	d6,d1
	move	d1,d2
	lsl.l	#8,d0
ClipN3
	move	tx3(a6),d4
	move	tx1(a6),d3
	sub	d3,d4
	ext.l	d4
	lsl.l	#8,d4
	divs	d6,d4
	swap	d4
	swap	d3

	move	ty3(a6),d1
	move	ty1(a6),d3
	sub	d3,d1
	ext.l	d1
	lsl.l	#8,d1
	divs	d6,d1
	move	d1,d4

	lsl.l	#8,d3

	lsr	#1,d6
	bcc.b	skipl9
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
skipl9	subq	#1,d6
	bmi.b	skipl10
Number3Loop1	rept	2
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
	endr
	dbf	d6,Number3Loop1
skipl10
	bra	MapIt


Number4					* NUMBER 4 *
	move.l	dy3(a6),d6

	move	cx2(a6),d1
	move	cx1(a6),d0
	sub	d0,d1
	ext.l	d1

	move	cx3(a6),d2
	sub	d0,d2
	ext.l	d2
	move	d0,d3
	swap	d0
	move	d3,d0

	tst.l	a5
	beq.b	NoClipN4
	lsl.l	#6,d1
	divs	d6,d1
	swap	d1
	lsl.l	#6,d2
	divs	d6,d2
	move	d2,d1
	lsl.l	#6,d0
	bra.b	ClipN4
NoClipN4
	lsl.l	#8,d1
	divs	d6,d1
	swap	d1
	lsl.l	#8,d2
	divs	d6,d2
	move	d2,d1
	lsl.l	#8,d0
ClipN4
	move	tx3(a6),d3
	move	tx1(a6),d2
	sub	d2,d3
	ext.l	d3
	lsl.l	#8,d3
	divs	d6,d3
	swap	d3
	swap	d2

	move	ty3(a6),d4
	move	ty1(a6),d2
	sub	d2,d4
	ext.l	d4
	lsl.l	#8,d4
	divs	d6,d4
	move	d4,d3

	lsl.l	#8,d2

	lsr	#1,d6
	bcc.b	skipl11
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d2,(a0)+
	add.l	d3,d2
skipl11	subq	#1,d6
	bmi.b	skipl12
number4loop1	rept	2
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d2,(a0)+
	add.l	d3,d2
	endr
	dbf	d6,number4loop1
skipl12
	bra	MapIt


NormPoly
	tst.l	dxneg(a6)
	bmi	Number2

	move.l	dy1(a6),d6	* NUMBER 1 (LONG RIGHT) *

	move	cx3(a6),d1
	move	cx1(a6),d0
	sub	d0,d1
	ext.l	d1

	move	cx2(a6),d2
	sub	d0,d2		;d0=cx1
	ext.l	d2
	move	d0,d3
	swap	d0
	move	d3,d0

	tst.l	a5
	beq.b	NoClipN1
	lsl.l	#6,d1
	divs	dy3+2(a6),d1
	swap	d1
	lsl.l	#6,d2
	divs	d6,d2
	move	d2,d1
	lsl.l	#6,d0
	bra.b	ClipN1

NoClipN1	lsl.l	#8,d1
	divs	dy3+2(a6),d1
	swap	d1
	lsl.l	#8,d2
	divs	d6,d2
	move	d2,d1
	lsl.l	#8,d0
ClipN1
	move	tx2(a6),d4
	move	tx1(a6),d3
	sub	d3,d4
	ext.l	d4
	lsl.l	#8,d4
	divs	d6,d4
	swap	d4
	swap	d3

	move	ty2(a6),d2
	move	ty1(a6),d3
	sub	d3,d2
	ext.l	d2
	lsl.l	#8,d2
	divs	d6,d2
	move	d2,d4

	lsl.l	#8,d3

	lsr	#1,d6
	bcc.b	skipl1
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d3,(a0)+
	add.l	d4,d3
skipl1	subq	#1,d6
	bmi.b	skipl2
Number1loop	rept	2
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d3,(a0)+
	add.l	d4,d3
	endr
	dbf	d6,Number1loop
skipl2
	move.l	dy2(a6),d6

	move	cx3(a6),d2
	move	cx2(a6),d0
	sub	d0,d2

	tst.l	a5
	beq.b	NoClipN1_2
	lsl	#6,d0
	ext.l	d2
	lsl.l	#6,d2
	bra.b	ClipN1_2
NoClipN1_2	lsl	#8,d0
	ext.l	d2
	lsl.l	#8,d2
ClipN1_2
	divs	d6,d2
	move	d2,d1

	swap	d3
	move	tx3(a6),d2
	move	tx2(a6),d3
	sub	d3,d2
	lsl	#8,d3
	swap	d3
	ext.l	d2
	lsl.l	#8,d2
	divs	d6,d2
	swap	d4
	move	d2,d4
	swap	d4

	move	ty3(a6),d2
	move	ty2(a6),d3
	sub	d3,d2
	lsl	#8,d3
	ext.l	d2
	lsl.l	#8,d2
	divs	d6,d2
	move	d2,d4

	lsr	#1,d6
	bcc.b	skipl3
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d3,(a0)+
	add.l	d4,d3
skipl3	subq	#1,d6
	bmi.b	skipl4
Number1loop2	rept	2
	move.l	d0,(a0)+
	add.l	d1,d0
	move.l	d3,(a0)+
	add.l	d4,d3
	endr
	dbf	d6,Number1loop2
skipl4
	bra	MapIt


Number2				* NUMBER 2 (LONG LEFT) *
	move.l	dy1(a6),d5
	move.l	dy3(a6),d6

	move	cx2(a6),d2
	move	cx1(a6),d0
	sub	d0,d2
	ext.l	d2

	move	cx3(a6),d1
	sub	d0,d1		;cx1
	ext.l	d1

	move	d0,d3
	swap	d0
	move	d3,d0

	tst.l	a5
	beq.b	NoClipN2
	lsl.l	#6,d2
	divs	d5,d2
	swap	d2
	lsl.l	#6,d1
	divs	d6,d1
	move	d1,d2
	lsl.l	#6,d0
	bra.b	ClipN2

NoClipN2	lsl.l	#8,d2
	divs	d5,d2
	swap	d2
	lsl.l	#8,d1
	divs	d6,d1
	move	d1,d2
	lsl.l	#8,d0
ClipN2
	move	tx3(a6),d4
	move	tx1(a6),d3
	sub	d3,d4
	ext.l	d4
	lsl.l	#8,d4
	divs	d6,d4
	swap	d4
	swap	d3

	move	ty3(a6),d1
	move	ty1(a6),d3
	sub	d3,d1
	ext.l	d1
	lsl.l	#8,d1
	divs	d6,d1
	move	d1,d4

	lsl.l	#8,d3

	lsr	#1,d5
	bcc.b	skipl6
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
skipl6	subq	#1,d5
	bmi.b	skipl5
Number2Loop1	rept	2
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
	endr
	dbf	d5,Number2Loop1
skipl5
	move.l	dy2(a6),d6

	swap	d0
	swap	d2
	move	cx3(a6),d1
	move	cx2(a6),d0
	sub	d0,d1
	ext.l	d1

	tst.l	a5
	beq.b	NoClipN2_2
	lsl.l	#6,d1
	divs	d6,d1
	move	d1,d2
	lsl	#6,d0
	bra.b	ClipN2_2
NoClipN2_2	lsl.l	#8,d1
	divs	d6,d1
	move	d1,d2
	lsl	#8,d0
ClipN2_2	swap	d0
	swap	d2

	lsr	#1,d6
	bcc.b	skipl7
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
skipl7	subq	#1,d6
	bmi.b	skipl8
Number2Loop2	rept	2
	move.l	d0,(a0)+
	add.l	d2,d0
	move.l	d3,(a0)+
	add.l	d4,d3
	endr
	dbf	d6,Number2Loop2
skipl8
	bra.b	MapIt

	cnop	0,16
MapIt
	lea	CBuf,a0
	lea	LBuf,a1
	move.l	Texture,a2
	move.l	dy3(a6),d7

	move	cy1(a6),d0
	bpl.b	LineMulu
	add	d0,d7
	lsl	#3,d0
	ext.l	d0
	sub.l	d0,a1
	bra.b	SkipLineMulu

LineMulu	if Width=256
	ext.l	d0
	lsl.l	#8,d0
	else
	mulu	#Width,d0
	endif
	add.l	d0,a0
SkipLineMulu
	move.l	txadd(a6),d4
	move.l	tyadd(a6),d5
	move.l	#Width,a4
	move	cy3(a6),d0
	cmp	#Height,d0
	bls.b	NoYClip
	sub	#Height,d0
	sub	d0,d7
NoYClip	subq	#1,d7
	moveq	#0,d6

	tst.l	a5
	bne.b	Clipper

	move.l	#$ff00ff00,a5
LineLoop	move.l	a5,d0
	and.l	(a1)+,d0
	lsr.l	#8,d0
	move.l	(a1)+,d1

	move.l	d0,d2
	swap	d2
	sub	d0,d2
	ble.b	NextLine
	lea	(a0,d0),a3

	move.l	d1,d0
	swap	d0
	lsr	#8,d0

	subq	#1,d2
LineLoop2	move	d1,d6
	move.b	d0,d6
	move.b	(a2,d6.l),(a3)+
	add.l	d5,d1
	addx.l	d4,d0
	dbf	d2,LineLoop2

NextLine	add.l	a4,a0
	dbf	d7,LineLoop

NextPoly2
	pullr	a0
	pullr	d7
	dbf	d7,PolyLoop
	lea	$dff000,a2
	unlk	a6
	rts

	cnop	0,16
Clipper	move.l	#$ffc0ffc0,a5
LineLoop_Clip	move.l	a5,d0
	and.l	(a1)+,d0
	lsr.l	#6,d0
	move.l	(a1)+,d1

	move.l	d0,d2
	swap	d2
	btst	#9,d2
	bne.b	NextLine_Clip

	btst	#9,d0
	beq.b	NLeftClip

	move	#$400-1,d6
	sub	d0,d6
	moveq	#0,d0
	bra.b	LeftClip2
NLeftClip
	btst	#8,d0
	bne.b	NextLine_Clip

	btst	#8,d2
	beq.b	LeftClip
	move	d2,d6
	sub	#$100,d6
	sub	d6,d2
LeftClip	moveq	#0,d6
LeftClip2	sub	d0,d2
	ble.b	NextLine_Clip
	lea	(a0,d0),a3

	move.l	d1,d3
	swap	d3
	lsr	#8,d3

	tst	d6
	beq.b	NoClipping
	bmi.b	NextLine_Clip
ClipLoop1	add.l	d5,d1
	addx.l	d4,d3
	dbf	d6,ClipLoop1
NoClipping
	subq	#1,d2
	bmi.b	NextLine2
LineLoop2_Clip	move	d1,d6
	move.b	d3,d6
	move.b	(a2,d6.l),(a3)+
	add.l	d5,d1
	addx.l	d4,d3
	dbf	d2,LineLoop2_Clip
NextLine2
;	moveq	#0,d6

NextLine_Clip	add.l	a4,a0
	dbf	d7,LineLoop_Clip
	bra	NextPoly2
PolyLoopE





makeeven	macro
	move.l	d0,-(a7)
	move.l	\1,d0
	and.l	#-2,d0
	addq.l	#2,d0
	move.l	d0,\1
	move.l	(a7)+,d0
	endm

InitScene	push	all

	clr.l	NFrames
	clr.l	NTextures
	clr.l	NObjects
	clr.l	AllPoints
	clr.l	AllPolys

	lea	Scene,a0		* object infos
	lea	Objs,a2
	cmp.l	#'OBJS',(a0)+
	bne	NoScene
ObjectLoop	tst.l	(a0)
	beq	EndObjectLoop
	add	(a0)+,a0
	makeeven	a0
	lea	4(a0),a1

	push	all
	move.l	a1,Obj
	bsr	CalcPseudoNormals
	pull	all

	moveq	#0,d0
	moveq	#0,d1
	move	FNC_NPoints(a1),d0
	move	FNC_NPolys(a1),d1
	move.l	a1,a3
	move.l	a1,a4
	move.l	a1,a5
	add.l	FNC_Points(a1),a3
	add.l	FNC_Polys(a1),a4
	add.l	FNC_Pseudos(a1),a5
	addq.l	#2,a3			* skip max
	addq.l	#4,a4			* skip mul und corn
	addq.l	#2,a5			* skip mul

	addq.l	#4,a2			* space for script
	move.l	d0,(a2)+		* npoints
	move.l	d1,(a2)+		* npolys
	move.l	a3,(a2)+		* points
	move.l	a4,(a2)+		* polys
	move.l	a5,(a2)+		* pseudos
	add.l	d0,AllPoints
	add.l	d1,AllPolys

	add.l	(a0)+,a0
	makeeven	a0
	addq.l	#1,NObjects
	bra	ObjectLoop
EndObjectLoop
	tst.l	(a0)+
	bne	NoScene

	tst.l	AllPoints
	beq	NoScene
	tst.l	AllPolys
	beq	NoScene
	tst.l	NObjects
	beq	NoScene

	clr.l	PhongBit
	clr.l	PhongNum
	moveq	#0,d6			* text num
	lea	Textures,a2		* grab textures
	lea	TextNums,a3
	cmp.l	#'TEXT',(a0)+
	bne	NoScene
GTextureLoop
	cmp.l	#TextLimit,NTextures
	bhs	EGTextureLoop
	tst.l	(a0)
	beq	EGTextureLoop
	cmp.l	#'*BMP',2(a0)
	bne.b	NotBMP
	add	(a0)+,a0
	makeeven	a0
	tst.l	PhongBit
	beq.b	MakePhong
	move.l	PhongNum,(a3)+
	bra	NextTexture2

MakePhong	bsr	MakePhongTexture
	add.l	#$10000,a2
	move.l	d6,PhongNum
	st	PhongBit
	bra	NextTexture

NotBMP	add	(a0)+,a0
	makeeven	a0

	lea	4(a0),a1
	pushr	a0
	move.l	(a0)+,d0
	lea	TBuf,a1
	mblockf	a0,a1,d0
	pullr	a0
	move.l	a1,IffAdr
	move.l	a2,TextAdr
	bsr	ReadTexture
	add.l	#$10000,a2
	add.l	(a0)+,a0
	makeeven	a0
NextTexture	move.l	d6,(a3)+
	addq.l	#1,d6
	addq.l	#1,NTextures
NextTexture2	bra	GTextureLoop
EGTextureLoop
	tst.l	(a0)+
	bne	NoScene

	tst.l	NTextures
	beq	NoScene


	cmp.l	#'FRME',(a0)+
	bne	NoScene
	lea	FirstFrame,a1
	move.l	(a0)+,d0
	move.l	d0,(a1)+
	move.l	(a0)+,d1
	move.l	d1,(a1)+
	move.l	(a0)+,(a1)+
	tst.l	(a0)+
	bne	NoScene
	sub.l	d0,d1
	beq	NoScene
	move.l	d1,NFrames


	cmp.l	#'MOVE',(a0)+
	bne	NoScene
	lea	Script,a1
	lea	Objs,a2
	lea	ObjList2,a6
	move.l	NObjects,d7
	subq.l	#1,d7
MovementLoop
	move.l	a1,(a2)+		* --> objs script ptr
	add.l	#5*4,a2

	move.l	#1,(a6)
	move.l	(a0)+,d0
	bne.b	ShowObject
	clr.l	(a6)
* no more keys in scene, but we'll fake one !
	move.l	#1,(a1)+		* wenigstens eins !
	rept	3*3
	clr.l	(a1)+
	endr
	bra.b	NextObjectMove
ShowObject	move.l	(a0)+,d6
	move.l	d6,(a1)+
	subq.l	#1,d6
	bmi	NoScene			* atleast one key !

	move.l	a0,a3
	moveq	#2-1,d5
MovementLoop3	move.l	a3,a0
	move.l	d6,d4
MovementLoop2	move.l	(a0)+,(a1)+		* frame n
	move.l	(a0)+,(a1)+		* x pos
	move.l	(a0)+,(a1)+		* y pos
	move.l	(a0)+,(a1)+		* z pos

	move.l	4(a0),(a1)+		* x angle	pitch
	move.l	0(a0),(a1)+		* y angle	heading
	addq.l	#8,a0
	move.l	(a0)+,(a1)+		* z angle	bank

	move.l	(a0)+,(a1)+		* x stretch
	move.l	(a0)+,(a1)+		* y stretch
	move.l	(a0)+,(a1)+		* z stretch
	dbf	d4,MovementLoop2
	dbf	d5,MovementLoop3
NextObjectMove
	addq.l	#4,a6
	dbf	d7,MovementLoop
	tst.l	(a0)+
	bne	NoScene


	cmp.l	#'CAMR',(a0)+
	bne	NoScene
	lea	Camr,a1
	move.l	(a0)+,d7
	move.l	d7,(a1)+
	subq.l	#1,d7
	move.l	a0,a2
	moveq	#2-1,d6
CameraLoop2	move.l	a2,a0
	move.l	d7,d5
CameraLoop	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+		* x pos
	move.l	(a0)+,(a1)+		* y pos
	move.l	(a0)+,(a1)+		* z pos
	move.l	4(a0),(a1)+		* pitch
	move.l	0(a0),(a1)+		* heading
	addq.l	#8,a0
	move.l	(a0)+,(a1)+		* bank
	dbf	d5,CameraLoop
	dbf	d6,CameraLoop2
	tst.l	(a0)+
	bne	NoScene


	cmp.l	#'MORP',(a0)+
	bne	NoScene
	move.l	NObjects,d7
	subq.l	#1,d7
	lea	MorphKeys,a1
MorphLoop1	move.l	(a0)+,d0		* n keys
	move.l	d0,(a1)+
	tst.l	d0
	beq	NextMorph
	move.l	(a0)+,(a1)+		* target object
	subq.l	#1,d0
MorphLoop2	move.l	(a0)+,(a1)+		* framenumber
	move.l	(a0)+,(a1)+		* percentage
	dbf	d0,MorphLoop2
NextMorph	dbf	d7,MorphLoop1
	tst.l	(a0)+
	bne	NoScene


	clr	CurPoints
	lea	Objs,a0
	lea	VecData,a1
	lea	VecCon,a2
	lea	TextNums,a5
	move.l	NObjects,d7
	subq.l	#1,d7
	move.l	#0,d5
VecDataLoop1
	move.l	4(a0),d0		* n points
	move.l	12(a0),a4		* points
	move.l	20(a0),a3		* pseudos
	subq.l	#1,d0
VecDataLoop2	
	move	(a4)+,(a1)+		* x,y,z
	move	(a4)+,(a1)+
	move	(a4)+,(a1)+
	add	d5,-2(a1)		**********

	move	(a3)+,d2		* px,py,pz
	move	(a3)+,d3
	move	(a3)+,d4
	muls	#PMul,d2
	muls	#PMul,d3
	muls	#PMul,d4
	asr.l	#8,d2
	asr.l	#8,d3
	asr.l	#8,d4
	move	d2,(a1)+
	move	d3,(a1)+
	move	d4,(a1)+
	dbf	d0,VecDataLoop2

	move.l	8(a0),d0		* n polys
	subq.l	#1,d0
	move.l	16(a0),a3		* polys
	move	CurPoints,d1
	move.l	(a5)+,d6
VecConLoop1
	move	(a3)+,d2		* p1,p2,p3
	move	(a3)+,d3
	move	(a3)+,d4
	add	d1,d2
	add	d1,d3
	add	d1,d4
	mulu	#BPP/8,d2
	mulu	#BPP/8,d3
	mulu	#BPP/8,d4
	move	d2,(a2)+
	move	d3,(a2)+
	move	d4,(a2)+
;	move	#1,(a2)+
	move	d6,(a2)+		* text num
	dbf	d0,VecConLoop1

;	add	#300,d5
	move.l	4(a0),d0		* n points
	add	d0,CurPoints

	add.l	#6*4,a0
	dbf	d7,VecDataLoop1


	lea	Objs,a1
	lea	VecData,a2
	lea	ObjList,a3
	lea	ObjList2,a4
	lea	ConstList,a5
	lea	VecCon,a6
	move.l	NObjects,d7
	subq.l	#1,d7
VecDataSetLoop1
	move.l	(a4),(a3)+
	move.l	(a4)+,(a5)+
	move.l	4(a1),d0
	move.l	d0,(a3)+
	move.l	a2,(a3)+
	mulu.l	#12,d0			* x,y,z,px,py,pz
	add.l	d0,a2
	move.l	8(a1),d0
	move.l	d0,(a5)+
	move.l	a6,(a5)+
	mulu.l	#8,d0			* 1,2,3,tnumb
	add.l	d0,a6
	add.l	#6*4,a1
	dbf	d7,VecDataSetLoop1


	lea	CameraKeys,a0		* Make All Splinekeys !
	lea	ObjectKeys,a1	
	move.l	#1*256,CurFrame
MoreFrames	push	a0-a1
	move.l	a0,CamPtr
	move.l	a1,KeyPtr
	bsr	KeyFramer
	pull	a0-a1
	add.l	#CamKeySize-4,a0
	move.l	NObjects,d0
	mulu	#ObjKeySize-4,d0
	add.l	d0,a1
	add.l	#SSpace*256,CurFrame
	move.l	CurFrame,d0
	lsr.l	#8,d0
	cmp.l	LastFrame,d0
	blo.b	MoreFrames
	move.l	LastFrame,d0
	lsl.l	#8,d0
	subq.l	#1,d0
	move.l	d0,CurFrame
	push	a0-a1
	move.l	a0,CamPtr
	move.l	a1,KeyPtr
	bsr	KeyFramer
	pull	a0-a1
	add.l	#CamKeySize-4,a0
	move.l	NObjects,d0
	mulu	#ObjKeySize-4,d0
	add.l	d0,a1

	lea	CameraKeys,a2
	lea	ObjectKeys,a3
	sub.l	a2,a0
	sub.l	a3,a1
	move.l	a0,d2
	move.l	a1,d3
	move.l	d2,CamSeqSize
	move.l	d3,ObjSeqSize
	add.l	CamSeqSize,a2
	add.l	ObjSeqSize,a3
	moveq	#2-1,d7
TripleKeys	lea	CameraKeys,a0
	move.l	CamSeqSize,d2
	mblockf	a0,a2,d2
	lea	ObjectKeys,a0
	move.l	ObjSeqSize,d3
	mblockf	a0,a3,d3
	add.l	CamSeqSize,a2
	add.l	ObjSeqSize,a3
	dbf	d7,TripleKeys


	if WrapCam=1
	lea	CameraKeys,a0
	move.l	CamSeqSize,d1
	add.l	d1,a0
	move.l	a0,a1
	sub	#CamKeySize-4,a1
	moveq	#6-1,d7
CamWrapL1	move.l	(a0)+,(a1)+
	dbf	d7,CamWrapL1

	lea	CameraKeys,a0
	add.l	d1,a0
	move.l	a0,a1
	add.l	d1,a1
	moveq	#2-1,d7
CamWrapL2	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	sub	#CamKeySize-4,a0
	dbf	d7,CamWrapL2
	endif

	if WrapObj=1
	lea	ObjectKeys,a0
	move.l	ObjSeqSize,d1
	add.l	d1,a0
	move.l	a0,a1
	moveq	#ObjKeySize-4,d0
	mulu.l	NObjects,d0
	sub.l	d0,a1
	moveq	#9,d7
	mulu.l	NObjects,d7
	subq	#1,d7
ObjWrapL1	move.l	(a0)+,(a1)+
	dbf	d7,ObjWrapL1
	lea	ObjectKeys,a0
	add.l	d1,a0
	move.l	a0,a1
	add.l	d1,a1
	moveq	#2-1,d7
ObjWrapL2	moveq	#9,d6
	mulu.l	NObjects,d6
	subq.l	#1,d6
ObjWrapL3	move.l	(a0)+,(a1)+
	dbf	d6,ObjWrapL3
	moveq	#ObjKeySize-4,d0
	mulu.l	NObjects,d0
	sub.l	d0,a0
	dbf	d7,ObjWrapL2
	endif



	clr.l	CurFrame


	pull	all
	moveq	#0,d0
	rts
NoScene	pull	all
	moveq	#-1,d0
	rts


CalcVal	macro
	move.l	\1(a0),d2
	move.l	\1(a1),d3
	sub.l	d2,d3
	muls	d0,d3
	asr.l	#8,d3
	add.l	d3,d2
	endm
CalcVl2	macro
	move.l	\1(a1),d2
	move.l	\1(a2),d3
	sub.l	d2,d3
	muls	d0,d3
	asr.l	#8,d3
	add.l	d3,d2
	endm

	cnop	0,16
KeyFramer
	lea	Camr,a0
	move.l	CurFrame,d0
	lsr.l	#8,d0
	move.l	(a0)+,d7
	subq	#1,d7
	moveq	#CamKeySize,d1
	move.l	CamPtr,a3
KeyFramerLoop1
	move.l	CamKeySize(a0),d2
	tst.l	d7
	beq.b	SameFrame
	cmp.l	(a0),d2
	beq	SameFrame
	cmp.l	(a0),d0
	blo	NextKey
	cmp.l	CamKeySize(a0),d0
	bhs	NextKey
SameFrame
	move.l	a0,a1
	tst.l	d7
	beq.b	NoKeyAdd2
	add	#CamKeySize,a1
NoKeyAdd2	move.l	FrameNumber(a0),d2
	move.l	FrameNumber(a1),d3
	sub.l	d2,d0
	sub.l	d2,d3
	lsl.l	#8,d0
	tst.l	d3
	bne.b	Happening
	moveq	#0,d0
	moveq	#1,d3
Happening	divu.l	d3,d0

	CalcVal	OXPos
	move.l	d2,(a3)+
	CalcVal	OYPos
	move.l	d2,(a3)+
	CalcVal	OZPos
	move.l	d2,(a3)+

	CalcVal	OXAngle
	move.l	d2,(a3)+
	CalcVal	OYAngle
	move.l	d2,(a3)+
	CalcVal	OZAngle
	move.l	d2,(a3)+

	bra.b	CameraDone

NextKey	add.l	d1,a0
	dbf	d7,KeyFramerLoop1
CameraDone

	lea	Objs,a0
	move.l	KeyPtr,a3
	move.l	CurFrame,d0
	lsr.l	#8,d0
	moveq	#ObjKeySize,d1
	move.l	NObjects,d7
	subq	#1,d7
KeyFramerLoop2
	move.l	(a0),a1
	move.l	(a1)+,d6
	subq	#1,d6
KeyFramerLoop3
	move.l	ObjKeySize(a1),d2
	tst.l	d6
	beq.b	SameFrame2
	cmp.l	(a1),d2
	beq.b	SameFrame2
	cmp.l	(a1),d0
	blo	NextKey2
	cmp.l	ObjKeySize(a1),d0
	bhs	NextKey2
SameFrame2
	pushr	d0
	move.l	a1,a2
	tst.l	d6
	beq.b	NoKeyAdd
	add	#ObjKeySize,a2
NoKeyAdd	move.l	FrameNumber(a1),d2
	move.l	FrameNumber(a2),d3
	sub.l	d2,d0
	sub.l	d2,d3
	lsl.l	#8,d0
	tst.l	d3
	bne.b	Happening2
	moveq	#0,d0
	moveq	#1,d3
Happening2	divu.l	d3,d0

	CalcVl2	OXPos
	move.l	d2,(a3)+
	CalcVl2	OYPos
	move.l	d2,(a3)+
	CalcVl2	OZPos
	move.l	d2,(a3)+

	CalcVl2	OXAngle
	move.l	d2,(a3)+
	CalcVl2	OYAngle
	move.l	d2,(a3)+
	CalcVl2	OZAngle
	move.l	d2,(a3)+

	CalcVl2	OXStretch
	move.l	d2,(a3)+
	CalcVl2	OYStretch
	move.l	d2,(a3)+
	CalcVl2	OZStretch
	move.l	d2,(a3)+

	pullr	d0
	bra.b	NextObjectKey

NextKey2	add.l	d1,a1
	dbf	d6,KeyFramerLoop3

NextObjectKey	add	#6*4,a0
	dbf	d7,KeyFramerLoop2

	lea	$dff000,a2
	rts


CalcPseudoNormals
	move.l	Obj,a6
	move.l	a6,a0
	add.l	FNC_Points(a6),a0
	move.l	#$100,d1
	move	(a0)+,d0
	bpl.b	NoLNeg
	neg	d0
NoLNeg	cmp	#$200,d0
	bls.b	NoPseudoShr
	and.l	#$ffff,d0
	lsl.l	#8,d0
	divu.l	#$200,d0
	move.l	d0,d1
NoPseudoShr	move.l	d1,PseudoDiv
	move.l	a6,a1
	add.l	FNC_Polys(a6),a1
	addq.l	#4,a1
	lea	Normals,a3
	move	FNC_NPolys(a6),d7
	subq	#1,d7
FaceNormLoop	move	(a1)+,d0
	move	(a1)+,d3
	move	(a1)+,d6
	mulu	#6,d0
	mulu	#6,d3
	mulu	#6,d6
	move	(a0,d3.l),d1
	move	2(a0,d3.l),d2
	move	4(a0,d3.l),d3
	move	(a0,d6.l),d4
	move	2(a0,d6.l),d5
	move	4(a0,d6.l),d6
	ext.l	d1
	ext.l	d2
	ext.l	d3
	ext.l	d4
	ext.l	d5
	ext.l	d6
	lsl.l	#8,d1
	lsl.l	#8,d2
	lsl.l	#8,d3
	lsl.l	#8,d4
	lsl.l	#8,d5
	lsl.l	#8,d6
	divs.l	PseudoDiv,d1
	divs.l	PseudoDiv,d2
	divs.l	PseudoDiv,d3
	divs.l	PseudoDiv,d4
	divs.l	PseudoDiv,d5
	divs.l	PseudoDiv,d6

	move.l	d7,a2
	move	(a0,d0.l),d7
	ext.l	d7
	lsl.l	#8,d7
	divs.l	PseudoDiv,d7
	sub.l	d7,d1
	sub.l	d7,d4
	move	2(a0,d0.l),d7
	ext.l	d7
	lsl.l	#8,d7
	divs.l	PseudoDiv,d7
	sub.l	d7,d2
	sub.l	d7,d5
	move	4(a0,d0.l),d7
	ext.l	d7
	lsl.l	#8,d7
	divs.l	PseudoDiv,d7
	sub.l	d7,d3
	sub.l	d7,d6
	move.l	a2,d7
				;ax=d1,ay=d2,az=d3
				;bx=d4,by=d5,bz=d6

	move.l	d2,d0		;Xn Vector
	muls.l	d6,d0		;Ay*Bz
	move.l	d0,a4
	move.l	d3,d0		;Az*By
	muls.l	d5,d0
	sub.l	d0,a4		;Ay*Bz-Az*By

	move.l	d3,d0		;Yn Vector
	muls.l	d4,d0		;Az*Bx
	move.l	d0,a5
	move.l	d1,d0
	muls.l	d6,d0		;Ax*Bz
	sub.l	d0,a5

	move.l	d1,d0		;Zn Vector
	muls.l	d5,d0		;Ax*By
	move.l	d0,a6
	move.l	d2,d0		;Ay*Bx
	muls.l	d4,d0
	sub.l	d0,a6

	move.l	a4,d0		;sqrt(NX^2+NY^2+NZ^2)
	move.l	a5,d1
	move.l	a6,d2

	muls.l	d0,d0
	muls.l	d1,d1
	muls.l	d2,d2
	add.l	d1,d0
	add.l	d2,d0
	tst.l	d0
	bne.b	notzero
	moveq	#1,d0
notzero	pushr	a0
	bsr	Sqrt
	pullr	a0

	move.l	a4,d4
	move.l	a5,d5
	move.l	a6,d6
	ext.l	d4
	ext.l	d5
	ext.l	d6
	muls.l	#256,d4
	muls.l	#256,d5
	muls.l	#256,d6

	divs.l	d0,d4
	divs.l	d0,d5
	divs.l	d0,d6

	move	d4,(a3)+
	move	d5,(a3)+
	move	d6,(a3)+

	dbf	d7,FaceNormLoop

	push	all
	lea	VecData2,a0
	move.l	#VecData2E-VecData2,d0
	bsr	BigClear
	pull	all

	move.l	Obj,a6
	lea	Normals,a0
	move.l	a6,a1
	add.l	FNC_Polys(a1),a1
	addq.l	#4,a1
	lea	VecData2,a2
	move	FNC_NPolys(a6),d7
	subq	#1,d7
PseudoLoop1	movem	(a0)+,d0-d2
	moveq	#3-1,d6
PseudoLoop2	moveq	#0,d3
	move	(a1)+,d3
	mulu	#14,d3
	lea	(a2,d3.l),a3
	addq	#1,(a3)+
	add.l	d0,(a3)+
	add.l	d1,(a3)+
	add.l	d2,(a3)+
	dbf	d6,PseudoLoop2
	dbf	d7,PseudoLoop1

	lea	VecData2,a0
	move.l	Obj,a6
	move.l	a6,a1
	add.l	FNC_Pseudos(a6),a1
	addq.l	#2,a1
	move	FNC_NPoints(a6),d7
	subq	#1,d7
PseudoLoop3
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move	(a0)+,d0
	movem.l	(a0)+,d1-d3
	tst	d0
	beq.b	SkipPseudo
	ext.l	d0
	divs.l	d0,d1
	divs.l	d0,d2
	divs.l	d0,d3
SkipPseudo	move	d1,(a1)+
	move	d2,(a1)+
	move	d3,(a1)+
	dbf	d7,PseudoLoop3
	rts

Sqrt	incbin	misc2/SqrtNoStack2.bin
	rts

MakePhongTexture
	push	all
	move.l	a2,a0
	moveq	#0,d1
MPT1	moveq	#0,d0
MPT2	move	d0,d2
	move	d1,d3
	sub	#128,d2
	sub	#128,d3
	muls	d2,d2
	muls	d3,d3
	add.l	d3,d2
	push	a0/d0-d2
	move.l	d2,d0
	bsr	Sqrt
	mulu	#220,d0
	divu	#100,d0
	move	#255,d3
	sub	d0,d3
	pull	a0/d0-d2
	move.b	d3,(a0)+
	addq	#1,d0
	cmp	#256,d0
	bne.b	MPT2
	addq	#1,d1
	cmp	#256,d1
	bne.b	MPT1
	pull	all
	rts


ReadTexture	push	all
;	lea	Iff,a0
	move.l	IffAdr,a0

	cmp.l	#'FORM',(a0)+
	bne	Couldnt2
	move.l	a0,a1
	add.l	(a1)+,a1
	addq.l	#4,a0
	cmp.l	#'ILBM',(a0)+
	bne	Couldnt2
	move.l	a0,IffP

	move.l	IffP,a0
NextHunk	cmp.l	a0,a1
	bls	Couldnt2
	cmp.l	#'BMHD',(a0)+
	beq.b	FoundBMHD
	add.l	(a0)+,a0
	bra.b	NextHunk
FoundBMHD	addq.l	#4,a0

	cmp.l	#$01000100,(a0)
	bne	Couldnt2
	cmp.b	#8,8(a0)
	bne	Couldnt2
	move.b	10(a0),Compr

	move.l	IffP,a0
NextHunk2	cmp.l	a0,a1
	bls	Couldnt2
	cmp.l	#'CMAP',(a0)+
	beq.b	FoundCMAP
	add.l	(a0)+,a0
	bra.b	NextHunk2
FoundCMAP	addq.l	#4,a0
	lea	Pal,a2
	move	#256-1,d7
PalLoop	clr.b	(a2)+
	move	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	dbf	d7,PalLoop
	push	all
	lea	Pal,a0
	lea	CopPal+6,a1
	move	#256*2-1,d7
	bsr	PutColors
	pull	all

	move.l	IffP,a0
NextHunk3	cmp.l	a0,a1
	bls	Couldnt2
	cmp.l	#'BODY',(a0)+
	beq.b	FoundBODY
	add.l	(a0)+,a0
	bra.b	NextHunk3
FoundBODY	addq.l	#4,a0

	tst.b	Compr
	bne	Compressed
	move.l	#$10000,d0
	lea	CBuf,a2
	mblockf	a0,a2,d0
	bra	Done
Compressed
	lea	CBuf,a1
	move.l	a1,a3
	add.l	#$10000,a3
DeCodeLoop1	move.b	(a0)+,d0
	ext	d0
	bpl.b	NotNeg1
	neg	d0
	move.b	(a0)+,d1
DeCodeLoop2	move.b	d1,(a1)+
	dbf	d0,DeCodeLoop2
	cmp.l	a1,a3
	bhi.b	DeCodeLoop1
	bra.b	Done
NotNeg1	move.b	(a0)+,(a1)+
	dbf	d0,NotNeg1
	cmp.l	a1,a3
	bhi.b	DeCodeLoop1
Done
	lea	CBuf,a2		* interleaved --> non interleaved
	move.l	IffAdr,a1
	moveq	#8-1,d7
RastC2	move.l	a2,a0
	move	#256-1,d6
RastC1	rept	8
	move.l	(a0)+,(a1)+
	endr
	add.l	#32*7,a0
	dbf	d6,RastC1
	add.l	#32,a2
	dbf	d7,RastC2

	move.l	IffAdr,a0
	add.l	#$8000,a0
;	lea	Iff+$8000,a0
	move.l	TextAdr,a1
;	lea	Texture,a1
	move.l	a1,a2
	add.l	#$10000,a2
	bra	DoneConv
	cnop	0,4
DoneConv
	move.b	-$2000(a0),d1
	lsl	#8,d1
	move.b	-$4000(a0),d1
	lsl.l	#8,d1
	move.b	-$6000(a0),d1
	lsl.l	#8,d1
	move.b	-$8000(a0),d1
	move.b	$6000(a0),d0
	lsl	#8,d0
	move.b	$4000(a0),d0
	lsl.l	#8,d0
	move.b	$2000(a0),d0
	lsl.l	#8,d0
	move.b	(a0)+,d0

	move.l	d0,a4
	move.l	d1,a5

	moveq	#0,d2
	move.l	d2,d3
	move.l	d2,d4
	move.l	d2,d5
	move.l	d2,d6
	move.l	d2,d7
	rept	4
	add.l	d0,d0
	roxl.b	#1,d2
	add.l	d0,d0
	roxl.b	#1,d3
	add.l	d0,d0
	roxl.b	#1,d4
	add.l	d0,d0
	roxl.b	#1,d5
	add.l	d0,d0
	roxl.b	#1,d6
	add.l	d0,d0
	roxl.b	#1,d7
	lsl.l	#2,d0
	endr
	rept	4
	add.l	d1,d1
	roxl.b	#1,d2
	add.l	d1,d1
	roxl.b	#1,d3
	add.l	d1,d1
	roxl.b	#1,d4
	add.l	d1,d1
	roxl.b	#1,d5
	add.l	d1,d1
	roxl.b	#1,d6
	add.l	d1,d1
	roxl.b	#1,d7
	lsl.l	#2,d1
	endr
	move.b	d2,(a1)+
	move.b	d3,(a1)+
	move.b	d4,(a1)+
	move.b	d5,(a1)+
	move.b	d6,(a1)+
	move.b	d7,(a1)+

	move.l	a4,d0
	move.l	a5,d1
	moveq	#0,d2
	move.l	d2,d3

	rept	4
	lsl.l	#6,d0
	add.l	d0,d0
	roxl.b	#1,d2
	add.l	d0,d0
	roxl.b	#1,d3
	endr
	rept	4
	lsl.l	#6,d1
	add.l	d1,d1
	roxl.b	#1,d2
	add.l	d1,d1
	roxl.b	#1,d3
	endr
	move.b	d2,(a1)+
	move.b	d3,(a1)+

	cmp.l	a1,a2
	bhi	DoneConv
Couldnt2
	pull	all
	moveq	#0,d0
	rts

PutColors	moveq	#0,d0
	moveq	#0,d1
	move.l	#$f0f0f,d5
	move	#$fff,d6
ccl	move.l	(a0,d0*4),d2
	tst	d1
	bne.b	aw
	lsr.l	#4,d2
aw	and.l	d5,d2
	moveq	#0,d3
	move.b	d2,d3
	lsr.l	#8,d2
	ror	#4,d3
	move.b	d2,d3
	lsr.l	#8,d2
	ror	#4,d3
	move.b	d2,d3
	rol	#8,d3
	and	d6,d3
	move	d3,(a1)
	addq	#1,d0
	addq	#4,a1
	cmp	#$0106,-2(a1)
	bne.b	ccla
	move	(a1),d3
	and	#$0200,d3
	tst	d3
	beq.b	paska2
	sub	#32,d0
paska2	eor	#1,d1
	addq.l	#4,a1
ccla	dbf	d7,ccl
	rts


BigClear	move.l	a0,a6
	add.l	d0,a6
	move.l	d0,d7
	divu	#52*4,d7
	move	d7,d1
	mulu	#52*4,d1
	sub.l	d1,d0
	subq	#1,d7
	push	d0
	moveq	#0,d0
	move.l	d0,d1
	move.l	d0,d2
	move.l	d0,d3
	move.l	d0,d4
	move.l	d0,d5
	move.l	d0,d6
	move.l	d0,a0
	move.l	d0,a1
	move.l	d0,a2
	move.l	d0,a3
	move.l	d0,a4
	move.l	d0,a5
bssclear	movem.l	d0-d6/a0-a5,-(a6)
	movem.l	d0-d6/a0-a5,-(a6)
	movem.l	d0-d6/a0-a5,-(a6)
	movem.l	d0-d6/a0-a5,-(a6)
	dbf	d7,bssclear
	pull	d0
	move	d0,d1
	lsr	#2,d0
	beq.b	nolwclear
	subq	#1,d0
lwcloop	move.l	d2,-(a6)
	dbf	d0,lwcloop
nolwclear	and	#3,d1
	beq.b	nobytclear
	subq	#1,d1
bytcloop	move.b	d2,-(a6)
	dbf	d1,bytcloop
nobytclear	rts

	cnop	0,4
Chunky2Planar	lea	CBuf,a0
	move.l	Planeadr,a1
	include	chunkytests/CTestChunky.i

SetScr	move.l	PL1Adr,d0
	lea	XPL,a0
	bsr	SetScrs
	move.l	PL2Adr,d0
	lea	YPL,a0
	bsr	SetScrs
	lea	BlkSprite,a0
	move.l	a0,d0
	lea	Spr0H,a0
	moveq	#8-1,d7
SetSprb	swap	d0
	move	d0,(a0)
	addq	#4,a0
	swap	d0
	move	d0,(a0)
	addq	#4,a0
	dbf	d7,SetSprb
	rts
SetScrs	moveq	#8-1,d1
ScrL	swap	d0
	move	d0,(a0)+
	swap	d0
	move	d0,(a0)+
	add.l	#PlSiz,d0
	dbf	d1,ScrL
	rts

Switch	addq	#1,Frame
	btst	#0,Frame+1
	bne.b	F2
	move.l	PL2Adr,Planeadr
	lea	XPL,a0
	bra.b	SetBpls
F2	move.l	PL1Adr,Planeadr
	lea	YPL,a0
SetBpls	move	(a0)+,Bpl1H
	move	(a0)+,Bpl1L
	move	(a0)+,Bpl2H
	move	(a0)+,Bpl2L
	move	(a0)+,Bpl3H
	move	(a0)+,Bpl3L
	move	(a0)+,Bpl4H
	move	(a0)+,Bpl4L
	move	(a0)+,Bpl5H
	move	(a0)+,Bpl5L
	move	(a0)+,Bpl6H
	move	(a0)+,Bpl6L
	move	(a0)+,Bpl7H
	move	(a0)+,Bpl7L
	move	(a0)+,Bpl8H
	move	(a0)+,Bpl8L
	rts

grname	dc.b	'graphics.library',0,0
IsoSinus	incbin	Sines/4096x32767Sinus.bin
Spline	incbin	MiscFiles/1024x32767BSpline.bin

Scene
	incdir	lw:scenes/
;	incbin	oma4.scnshd
;	incbin	oma5_2.scnshd
;	incbin	oma7.scnshd
;	incbin	oma8.scnshd
;	incbin	testi5.scnshd
;	incbin	rinkula.scnshd
;	incbin	spincube.scnshd

;	incbin	mysticmorph.scnshd
;	incbin	turpa5_4.scnshd
;	incbin	oma6.scnshd
;	incbin	room1.scnshd
;	incbin	room2.scnshd
;	incbin	through2.scnshd
;	incbin	through3.scnshd
;	incbin	paska3.scnshd
;	incbin	trash:paska2.scnshd
;	incbin	duckgroup1.scnshd


;	incbin	asm:hate3/flare1/flarescene2.scnshd
	incbin	asm:Hate3/flare1/flarescene4.scnshd

SceneE

	Section LWData,data
GFXBase	dc.l	0
VBRPtr	dc.l	0
OldVBI	dc.l	0
OldView	dc.l	0
OldDMA	dc	0
OldIntena	dc	0
Planeadr	dc.l	0
PL1Adr	dc.l	0
PL2Adr	dc.l	0
Frame	dc	0
Framet	dc	0
XAngle	dc.l	0
YAngle	dc.l	0
ZAngle	dc.l	0
Test	dc.l	0
XPL	blk.l	8,0
YPL	blk.l	8,0

IffAdr	dc.l	0		* texture reader
IffP	dc.l	0
Compr	dc.l	0
TextAdr	dc.l	0

PseudoDiv	dc.l	0

NObjects	dc.l	0
NTextures	dc.l	0
NFrames	dc.l	0
AllPoints	dc.l	0
AllPolys	dc.l	0

;AllPolys2	dc.l	0

FirstFrame	dc.l	0
LastFrame	dc.l	0
FrameStep	dc.l	0

CurPoints	dc.l	0
CurFrame	dc.l	0

CamX	dc.l	0
CamY	dc.l	0
CamZ	dc.l	0
AddX	dc.l	0
AddY	dc.l	0
AddZ	dc.l	0

CamPtr	dc.l	0
KeyPtr	dc.l	0
CamSeqSize	dc.l	0
ObjSeqSize	dc.l	0

Obj	dc.l	0
VisiblePolys	dc.l	0
Texture	dc.l	0
ConstructedPolys	dc.l	0

PhongBit	dc.l	0
PhongNum	dc.l	0


Fade	dc	256
EndBit	dc	0
EndPos	dc	0
EndRow	dc	0
PatPos	dc.l	0
RowPos	dc.l	0
Mode	dc	0
E8Com	dc.l	0
StroboBit	dc	0
FadeSpeed	dc	0

	section	LWBSS,bss
CBuf	ds.b	256^2
Textures	ds.b	256^2*TextLimit
Pal	ds.l	256
TBuf	ds.b	256^2+16384
Matrice	ds.l	8
Matrice2	ds.l	8
Matrice3	ds.l	32
Sines	ds.l	8

Objs	ds.l	6*ObjLimit	* scene datas
	* script,npoints,npolys,points,polys,pseudos
ObjList	ds.l	3*ObjLimit
ObjList2	ds.l	3*ObjLimit
	* showobject,npoints,points
ConstList	ds.l	3*ObjLimit
	* showobject,npolys,connect

	cnop	0,16
VecData	ds.b	100000
VecDataMorph	ds.b	100000
VecData2	ds.b	100000
VecData2E
VecCon	ds.b	100000
VecCon2	ds.b	100000
Normals	ds.b	100000

	rsreset
FrameNumber	rs.l	1
OXPos	rs.l	1
OYPos	rs.l	1
OZPos	rs.l	1
OXAngle	rs.l	1	* pitch
OYAngle	rs.l	1	* heading
OZAngle	rs.l	1	* bank
CamKeySize	rs.l	0
OXStretch	rs.l	1
OYStretch	rs.l	1
OZStretch	rs.l	1
ObjKeySize	rs.l	0

Script	ds.b	ObjLimit*(ObjKeySize*KeyLimit*2+4)
Camr	ds.b	KeyLimit*CamKeySize*2+4
MorphKeys	ds.b	ObjLimit*(KeyLimit*8+8)
CurKeyFrame	ds.b	ObjLimit*(ObjKeySize-4)

CameraKeys	ds.b	(CamKeySize-4)*600*3
ObjectKeys	ds.b	ObjLimit*(ObjKeySize-4)*600*3
TextNums	ds.l	ObjLimit

	cnop	0,16
RadixTable	ds.l	256
RadixTable2	ds.l	256
RadixPointers	ds.l	256
RadixPointers2	ds.l	256
	cnop	0,16
RadixData1	ds.l	10000
	cnop	0,16
RadixData2	ds.l	10000
	cnop	0,16
LBuf	ds.b	8*2000


	Section	LWCopperList,Data_C
CopperList	dc	fmode,3
	dc	diwstrt,$2aa1,diwstop,$2aa1
	dc	ddfstrt,$0038,ddfstop,$00b0
	dc	bplcon0,$0211,bplcon1,$8800,bplcon2,0
	dc	bplcon3,0,bplcon4,$0011
	dc	bpl1mod,-8,bpl2mod,-8
	dc	bpl1pth
Bpl1H	dc	0,bpl1ptl
Bpl1L	dc	0,bpl2pth
Bpl2H	dc	0,bpl2ptl
Bpl2L	dc	0,bpl3pth
Bpl3H	dc	0,bpl3ptl
Bpl3L	dc	0,bpl4pth
Bpl4H	dc	0,bpl4ptl
Bpl4L	dc	0,bpl5pth
Bpl5H	dc	0,bpl5ptl
Bpl5L	dc	0,bpl6pth
Bpl6H	dc	0,bpl6ptl
Bpl6L	dc	0,bpl7pth
Bpl7H	dc	0,bpl7ptl
Bpl7L	dc	0,bpl8pth
Bpl8H	dc	0,bpl8ptl
Bpl8L	dc	0,spr0pth
Spr0H	dc	0,spr0ptl
Spr0L	dc	0,spr1pth
Spr1H	dc	0,spr1ptl
Spr1L	dc	0,spr2pth
Spr2H	dc	0,spr2ptl
Spr2L	dc	0,spr3pth
Spr3H	dc	0,spr3ptl
Spr3L	dc	0,spr4pth
Spr4H	dc	0,spr4ptl
Spr4L	dc	0,spr5pth
Spr5H	dc	0,spr5ptl
Spr5L	dc	0,spr6pth
Spr6H	dc	0,spr6ptl
Spr6L	dc	0,spr7pth
Spr7H	dc	0,spr7ptl
Spr7L	dc	0
CopPal	incbin	graphics:colors/256x8BlackToWhite.cop
	dc.l	$01060020
	if	Double=1
rast set $2a
	rept	128
	if rast=0
	dc.l	$ffd9fffe
	endif
	dc.b	rast,1,-1,-2
	dc	bpl1mod,-8-Width/8,bpl2mod,-8-Width/8
rast set (rast+1)&$ff
	if rast=0
	dc.l	$ffd9fffe
	endif
	dc.b	rast,1,-1,-2
	dc	bpl1mod,-8,bpl2mod,-8
rast set (rast+1)&$ff
	endr
	endif
	dc.l	-2
BlkSprite	dc.l	0

	Section	LWBufferit,BSS_C
Buffers	ds.b	BufferSize

end
