/* 
 * File:   CMUI_Application.h
 * Author: Piotr Hoppe
 *
 * Created on 25 listopada 2015, 20:11
 */

#ifndef CMUI_APPLICATION_H
#define	CMUI_APPLICATION_H

#include <libraries/muiplus/CMUI_Notify.h>
#include <rexx/storage.h>

/***************************************************************************
**                    CMUI_Application class definition                     
***************************************************************************/

class CMUI_Application : public CMUI_Notify
{
public:
	CMUI_Application (void);
	CMUI_Application (struct TagItem *tags);
	CMUI_Application (Tag tag1, ...);
	CMUI_Application (Object * obj);

	CMUI_Application & operator = (Object * obj);

	void AddWindow (Object *window);	
	void RemoveWindow (Object *window);
	BOOL Active (void) const;
	void SetActive (BOOL value);
	STRPTR Author (void) const;
	STRPTR Base (void) const;
	CxObj * Broker (void) const;
	struct Hook * BrokerHook (void) const;
	void SetBrokerHook (struct Hook * value);
	struct MsgPort * BrokerPort (void) const;
	LONG BrokerPri (void) const;
	struct MUI_Command * Commands (void) const;
	void SetCommands (struct MUI_Command * value);
	STRPTR Copyright (void) const;
	STRPTR Description (void) const;
	struct DiskObject * DiskObject (void) const;
	void SetDiskObject (struct DiskObject * value);
	BOOL DoubleStart (void) const;
	void SetDropObject (Object * value);
	BOOL ForceQuit (void) const;
	STRPTR HelpFile (void) const;
	void SetHelpFile (STRPTR value);
	BOOL Iconified (void) const;
	void SetIconified (BOOL value);
	IPTR MenuAction (void) const;
	IPTR MenuHelp (void) const;
	struct Hook * RexxHook (void) const;
	void SetRexxHook (struct Hook * value);
	struct RxMsg * RexxMsg (void) const;
	void SetRexxString (STRPTR value);
	void SetSleep (BOOL value);
	STRPTR Title (void) const;
	STRPTR Version (void) const;
	struct List * WindowList (void) const;
	IPTR AboutMUI (Object * refwindow);
	IPTR AddInputHandler (struct MUI_InputHandlerNode * ihnode);
	IPTR CheckRefresh (void);
	IPTR InputBuffered (void);
	IPTR Load (STRPTR name);
	IPTR NewInput (LONGBITS * signal);
	IPTR OpenConfigWindow (IPTR flags);
	IPTR PushMethod (StartVarArgs sva, Object * dest, LONG count, ...);
	IPTR RemInputHandler (struct MUI_InputHandlerNode * ihnode);
	IPTR ReturnID (IPTR retid);
	IPTR Save (STRPTR name);
	IPTR SetConfigItem (IPTR item, APTR data);
	IPTR ShowHelp (Object * window, char * name, char * node, LONG line);
#ifdef MUI_OBSOLETE
	struct NewMenu * Menu (void) const;
	IPTR GetMenuCheck (IPTR MenuID);
	IPTR GetMenuState (IPTR MenuID);
	IPTR Input (LONGBITS * signal);
	IPTR SetMenuCheck (IPTR MenuID, LONG stat);
	IPTR SetMenuState (IPTR MenuID, LONG stat);
#endif /* MUI_OBSOLETE */
};
#endif	/* CMUI_APPLICATION_H */

