/* 
 * File:   CMUI_Area.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 28 listopada 2015, 23:43
 */

#include "CMUI_Area.h"

void CMUI_Area::SetBackground(LONG value) {
    SetAttr(MUIA_Background, (IPTR) value);
}

LONG CMUI_Area::BottomEdge(void) const {
    return (LONG) MGetAttr(MUIA_BottomEdge);
}

Object * CMUI_Area::ContextMenu(void) const {
    return (Object *) MGetAttr(MUIA_ContextMenu);
}

void CMUI_Area::SetContextMenu(Object * value) {
    SetAttr(MUIA_ContextMenu, (IPTR) value);
}

Object * CMUI_Area::ContextMenuTrigger(void) const {
    return (Object *) MGetAttr(MUIA_ContextMenuTrigger);
}

char CMUI_Area::ControlChar(void) const {
    return (char) MGetAttr(MUIA_ControlChar);
}

void CMUI_Area::SetControlChar(char value) {
    SetAttr(MUIA_ControlChar, (IPTR) value);
}

LONG CMUI_Area::CycleChain(void) const {
    return (LONG) MGetAttr(MUIA_CycleChain);
}

void CMUI_Area::SetCycleChain(LONG value) {
    SetAttr(MUIA_CycleChain, (IPTR) value);
}

BOOL CMUI_Area::Disabled(void) const {
    return (BOOL) MGetAttr(MUIA_Disabled);
}

void CMUI_Area::SetDisabled(BOOL value) {
    SetAttr(MUIA_Disabled, (IPTR) value);
}

BOOL CMUI_Area::Draggable(void) const {
    return (BOOL) MGetAttr(MUIA_Draggable);
}

void CMUI_Area::SetDraggable(BOOL value) {
    SetAttr(MUIA_Draggable, (IPTR) value);
}

BOOL CMUI_Area::Dropable(void) const {
    return (BOOL) MGetAttr(MUIA_Dropable);
}

void CMUI_Area::SetDropable(BOOL value) {
    SetAttr(MUIA_Dropable, (IPTR) value);
}

void CMUI_Area::SetFillArea(BOOL value) {
    SetAttr(MUIA_FillArea, (IPTR) value);
}

struct TextFont * CMUI_Area::Font(void) const {
    return (struct TextFont *) MGetAttr(MUIA_Font);
}

LONG CMUI_Area::Height(void) const {
    return (LONG) MGetAttr(MUIA_Height);
}

LONG CMUI_Area::HorizDisappear(void) const {
    return (LONG) MGetAttr(MUIA_HorizDisappear);
}

void CMUI_Area::SetHorizDisappear(LONG value) {
    SetAttr(MUIA_HorizDisappear, (IPTR) value);
}

WORD CMUI_Area::HorizWeight(void) const {
    return (WORD) MGetAttr(MUIA_HorizWeight);
}

void CMUI_Area::SetHorizWeight(WORD value) {
    SetAttr(MUIA_HorizWeight, (IPTR) value);
}

LONG CMUI_Area::InnerBottom(void) const {
    return (LONG) MGetAttr(MUIA_InnerBottom);
}

LONG CMUI_Area::InnerLeft(void) const {
    return (LONG) MGetAttr(MUIA_InnerLeft);
}

LONG CMUI_Area::InnerRight(void) const {
    return (LONG) MGetAttr(MUIA_InnerRight);
}

LONG CMUI_Area::InnerTop(void) const {
    return (LONG) MGetAttr(MUIA_InnerTop);
}

LONG CMUI_Area::LeftEdge(void) const {
    return (LONG) MGetAttr(MUIA_LeftEdge);
}

BOOL CMUI_Area::Pressed(void) const {
    return (BOOL) MGetAttr(MUIA_Pressed);
}

LONG CMUI_Area::RightEdge(void) const {
    return (LONG) MGetAttr(MUIA_RightEdge);
}

BOOL CMUI_Area::Selected(void) const {
    return (BOOL) MGetAttr(MUIA_Selected);
}

void CMUI_Area::SetSelected(BOOL value) {
    SetAttr(MUIA_Selected, (IPTR) value);
}

STRPTR CMUI_Area::ShortHelp(void) const {
    return (STRPTR) MGetAttr(MUIA_ShortHelp);
}

void CMUI_Area::SetShortHelp(STRPTR value) {
    SetAttr(MUIA_ShortHelp, (IPTR) value);
}

BOOL CMUI_Area::ShowMe(void) const {
    return (BOOL) MGetAttr(MUIA_ShowMe);
}

void CMUI_Area::SetShowMe(BOOL value) {
    SetAttr(MUIA_ShowMe, (IPTR) value);
}

LONG CMUI_Area::Timer(void) const {
    return (LONG) MGetAttr(MUIA_Timer);
}

LONG CMUI_Area::TopEdge(void) const {
    return (LONG) MGetAttr(MUIA_TopEdge);
}

LONG CMUI_Area::VertDisappear(void) const {
    return (LONG) MGetAttr(MUIA_VertDisappear);
}

void CMUI_Area::SetVertDisappear(LONG value) {
    SetAttr(MUIA_VertDisappear, (IPTR) value);
}

WORD CMUI_Area::VertWeight(void) const {
    return (WORD) MGetAttr(MUIA_VertWeight);
}

void CMUI_Area::SetVertWeight(WORD value) {
    SetAttr(MUIA_VertWeight, (IPTR) value);
}

LONG CMUI_Area::Width(void) const {
    return (LONG) MGetAttr(MUIA_Width);
}

struct Window * CMUI_Area::Window(void) const {
    return (struct Window *) MGetAttr(MUIA_Window);
}

Object * CMUI_Area::MWindowObject(void) const {
    return (Object *) MGetAttr(MUIA_WindowObject);
}

IPTR CMUI_Area::AskMinMax(struct MUI_MinMax * MinMaxInfo) {
    return MDoMethod(MUIM_AskMinMax, MinMaxInfo);
}

IPTR CMUI_Area::Cleanup(void) {
    return MDoMethod(MUIM_Cleanup);
}

IPTR CMUI_Area::ContextMenuBuild(LONG mx, LONG my) {
    return MDoMethod(MUIM_ContextMenuBuild, mx, my);
}

IPTR CMUI_Area::ContextMenuChoice(Object * item) {
    return MDoMethod(MUIM_ContextMenuChoice, item);
}

IPTR CMUI_Area::CreateBubble(LONG x, LONG y, char * txt, IPTR flags) {
    return MDoMethod(MUIM_CreateBubble, x, y, txt, flags);
}

IPTR CMUI_Area::CreateShortHelp(LONG mx, LONG my) {
    return MDoMethod(MUIM_CreateShortHelp, mx, my);
}

IPTR CMUI_Area::DeleteBubble(APTR bubble) {
    return MDoMethod(MUIM_DeleteBubble, bubble);
}

IPTR CMUI_Area::DeleteShortHelp(STRPTR help) {
    return MDoMethod(MUIM_DeleteShortHelp, help);
}

IPTR CMUI_Area::DragBegin(Object * obj) {
    return MDoMethod(MUIM_DragBegin, obj);
}

IPTR CMUI_Area::DragDrop(Object * obj, LONG x, LONG y) {
    return MDoMethod(MUIM_DragDrop, obj, x, y);
}

IPTR CMUI_Area::DragFinish(Object * obj) {
    return MDoMethod(MUIM_DragFinish, obj);
}

IPTR CMUI_Area::DragQuery(Object * obj) {
    return MDoMethod(MUIM_DragQuery, obj);
}

IPTR CMUI_Area::DragReport(Object * obj, LONG x, LONG y, LONG update) {
    return MDoMethod(MUIM_DragReport, obj, x, y, update);
}

IPTR CMUI_Area::Draw(IPTR flags) {
    return MDoMethod(MUIM_Draw, flags);
}

IPTR CMUI_Area::DrawBackground(LONG left, LONG top, LONG width, LONG height, LONG xoffset, LONG yoffset, LONG flags) {
    return MDoMethod(MUIM_DrawBackground, left, top, width, height, xoffset, yoffset, flags);
}

IPTR CMUI_Area::HandleEvent(struct IntuiMessage * imsg, LONG muikey) {
    return MDoMethod(MUIM_HandleEvent, imsg, muikey);
}

IPTR CMUI_Area::HandleInput(struct IntuiMessage * imsg, LONG muikey) {
    return MDoMethod(MUIM_HandleInput, imsg, muikey);
}

IPTR CMUI_Area::Hide(void) {
    return MDoMethod(MUIM_Hide);
}

IPTR CMUI_Area::Setup(struct MUI_RenderInfo * RenderInfo) {
    return MDoMethod(MUIM_Setup, RenderInfo);
}

IPTR CMUI_Area::Show(void) {
    return MDoMethod(MUIM_Show);
}

CMUI_Area::CMUI_Area()
: CMUI_Notify() {
}
