/* 
 * File:   CMUI_Bitmap.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 17:58
 */

#include "CMUI_Bitmap.h"

CMUI_Bitmap::CMUI_Bitmap()
: CMUI_Area() {
}

CMUI_Bitmap::CMUI_Bitmap(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Bitmap, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Bitmap object\n");
#endif
}

CMUI_Bitmap::CMUI_Bitmap(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Bitmap, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Bitmap object\n");
#endif
}

CMUI_Bitmap::CMUI_Bitmap(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Bitmap & CMUI_Bitmap::operator=(Object * obj) {
    object = obj;
    return *this;
}

struct BitMap * CMUI_Bitmap::Bitmap(void) const {
    return (struct BitMap *) MGetAttr(MUIA_Bitmap_Bitmap);
}

void CMUI_Bitmap::SetBitmap(struct BitMap * value) {
    SetAttr(MUIA_Bitmap_Bitmap, (IPTR) value);
}

LONG CMUI_Bitmap::Height(void) const {
    return (LONG) MGetAttr(MUIA_Bitmap_Height);
}

void CMUI_Bitmap::SetHeight(LONG value) {
    SetAttr(MUIA_Bitmap_Height, (IPTR) value);
}

UBYTE * CMUI_Bitmap::MappingTable(void) const {
    return (UBYTE *) MGetAttr(MUIA_Bitmap_MappingTable);
}

void CMUI_Bitmap::SetMappingTable(UBYTE * value) {
    SetAttr(MUIA_Bitmap_MappingTable, (IPTR) value);
}

LONG CMUI_Bitmap::Precision(void) const {
    return (LONG) MGetAttr(MUIA_Bitmap_Precision);
}

void CMUI_Bitmap::SetPrecision(LONG value) {
    SetAttr(MUIA_Bitmap_Precision, (IPTR) value);
}

struct BitMap * CMUI_Bitmap::RemappedBitmap(void) const {
    return (struct BitMap *) MGetAttr(MUIA_Bitmap_RemappedBitmap);
}

IPTR * CMUI_Bitmap::SourceColors(void) const {
    return (IPTR *) MGetAttr(MUIA_Bitmap_SourceColors);
}

void CMUI_Bitmap::SetSourceColors(IPTR * value) {
    SetAttr(MUIA_Bitmap_SourceColors, (IPTR) value);
}

LONG CMUI_Bitmap::Transparent(void) const {
    return (LONG) MGetAttr(MUIA_Bitmap_Transparent);
}

void CMUI_Bitmap::SetTransparent(LONG value) {
    SetAttr(MUIA_Bitmap_Transparent, (IPTR) value);
}

LONG CMUI_Bitmap::Width(void) const {
    return (LONG) MGetAttr(MUIA_Bitmap_Width);
}

void CMUI_Bitmap::SetWidth(LONG value) {
    SetAttr(MUIA_Bitmap_Width, (IPTR) value);
}

