/* 
 * File:   CMUI_Bodychunk.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 18:06
 */

#include "CMUI_Bodychunk.h"

CMUI_Bodychunk::CMUI_Bodychunk()
: CMUI_Bitmap() {
}

CMUI_Bodychunk::CMUI_Bodychunk(TagItem* tags)
: CMUI_Bitmap() {
    object = MUI_NewObjectA(MUIC_Bodychunk, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Bodychunk object\n");
#endif
}

CMUI_Bodychunk::CMUI_Bodychunk(Tag tag1, ...)
: CMUI_Bitmap() {
    object = MUI_NewObjectA(MUIC_Bodychunk, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Bodychunk object\n");
#endif
}

CMUI_Bodychunk::CMUI_Bodychunk(Object* obj)
: CMUI_Bitmap() {
    object = obj;
}

CMUI_Bodychunk & CMUI_Bodychunk::operator=(Object * obj) {
    object = obj;
    return *this;
}

UBYTE * CMUI_Bodychunk::Body(void) const {
    return (UBYTE *) MGetAttr(MUIA_Bodychunk_Body);
}

void CMUI_Bodychunk::SetBody(UBYTE * value) {
    SetAttr(MUIA_Bodychunk_Body, (IPTR) value);
}

UBYTE CMUI_Bodychunk::Compression(void) const {
    return (UBYTE) MGetAttr(MUIA_Bodychunk_Compression);
}

void CMUI_Bodychunk::SetCompression(UBYTE value) {
    SetAttr(MUIA_Bodychunk_Compression, (IPTR) value);
}

LONG CMUI_Bodychunk::Depth(void) const {
    return (LONG) MGetAttr(MUIA_Bodychunk_Depth);
}

void CMUI_Bodychunk::SetDepth(LONG value) {
    SetAttr(MUIA_Bodychunk_Depth, (IPTR) value);
}

UBYTE CMUI_Bodychunk::Masking(void) const {
    return (UBYTE) MGetAttr(MUIA_Bodychunk_Masking);
}

void CMUI_Bodychunk::SetMasking(UBYTE value) {
    SetAttr(MUIA_Bodychunk_Masking, (IPTR) value);
}
