/* 
 * File:   CMUI_Cycle.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:04
 */

#include "CMUI_Cycle.h"

CMUI_Cycle::CMUI_Cycle()
: CMUI_Group() {
}

CMUI_Cycle::CMUI_Cycle(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Cycle, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Cycle object\n");
#endif
}

CMUI_Cycle::CMUI_Cycle(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Cycle, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Cycle object\n");
#endif
}

CMUI_Cycle::CMUI_Cycle(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Cycle::CMUI_Cycle(STRPTR label, STRPTR* entries)
: CMUI_Group() {
    object = MUI_MakeObject(MUIO_Cycle, label, entries);
}

CMUI_Cycle& CMUI_Cycle::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Cycle::Active(void) const {
    return (LONG) MGetAttr(MUIA_Cycle_Active);
}

void CMUI_Cycle::SetActive(LONG value) {
    SetAttr(MUIA_Cycle_Active, (IPTR) value);
}
