/* 
 * File:   CMUI_Dataspace.h
 * Author: Piotr Hoppe
 *
 * Created on 3 grudnia 2015, 22:50
 */

#ifndef CMUI_DATASPACE_H
#define	CMUI_DATASPACE_H

#include "CMUI_Semaphore.h"

/***************************************************************************
 **                     CMUI_Dataspace class definition                      
 ***************************************************************************/

class CMUI_Dataspace : public CMUI_Semaphore {
public:
    CMUI_Dataspace(void);
    CMUI_Dataspace(struct TagItem *tags);
    CMUI_Dataspace(Tag tag1, ...);
    CMUI_Dataspace(Object * obj);
    CMUI_Dataspace & operator=(Object * obj);

    IPTR Add(APTR data, LONG len, IPTR id);
    IPTR Clear(void);
    IPTR Find(IPTR id);
    IPTR Merge(Object * dataspace);
    IPTR ReadIFF(struct IFFHandle * handle);
    IPTR Remove(IPTR id);
    IPTR WriteIFF(struct IFFHandle * handle, IPTR type, IPTR id);
};


#endif	/* CMUI_DATASPACE_H */

