/* 
 * File:   CMUI_Gauge.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 20:58
 */

#include "CMUI_Gauge.h"

CMUI_Gauge::CMUI_Gauge()
: CMUI_Area() {
}

CMUI_Gauge::CMUI_Gauge(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Gauge, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Gauge object\n");
#endif
}

CMUI_Gauge::CMUI_Gauge(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Gauge, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Gauge object\n");
#endif
}

CMUI_Gauge::CMUI_Gauge(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Gauge& CMUI_Gauge::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Gauge::Current(void) const {
    return (LONG) MGetAttr(MUIA_Gauge_Current);
}

void CMUI_Gauge::SetCurrent(LONG value) {
    SetAttr(MUIA_Gauge_Current, (IPTR) value);
}

BOOL CMUI_Gauge::Divide(void) const {
    return (BOOL) MGetAttr(MUIA_Gauge_Divide);
}

void CMUI_Gauge::SetDivide(BOOL value) {
    SetAttr(MUIA_Gauge_Divide, (IPTR) value);
}

STRPTR CMUI_Gauge::InfoText(void) const {
    return (STRPTR) MGetAttr(MUIA_Gauge_InfoText);
}

void CMUI_Gauge::SetInfoText(STRPTR value) {
    SetAttr(MUIA_Gauge_InfoText, (IPTR) value);
}

LONG CMUI_Gauge::Max(void) const {
    return (LONG) MGetAttr(MUIA_Gauge_Max);
}

void CMUI_Gauge::SetMax(LONG value) {
    SetAttr(MUIA_Gauge_Max, (IPTR) value);
}
