/* 
 * File:   CMUI_Menu.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 19:34
 */

#include "CMUI_Menu.h"

CMUI_Menu::CMUI_Menu()
: CMUI_Family() {
}

CMUI_Menu::CMUI_Menu(TagItem* tags)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menu, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menu object\n");
#endif
}

CMUI_Menu::CMUI_Menu(Tag tag1, ...)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menu, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menu object\n");
#endif
}

CMUI_Menu::CMUI_Menu(Object* obj)
: CMUI_Family() {
    object = obj;
}

CMUI_Menu& CMUI_Menu::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Menu::Enabled(void) const {
    return (BOOL) MGetAttr(MUIA_Menu_Enabled);
}

void CMUI_Menu::SetEnabled(BOOL value) {
    SetAttr(MUIA_Menu_Enabled, (IPTR) value);
}

STRPTR CMUI_Menu::Title(void) const {
    return (STRPTR) MGetAttr(MUIA_Menu_Title);
}

void CMUI_Menu::SetTitle(STRPTR value) {
    SetAttr(MUIA_Menu_Title, (IPTR) value);
}
