/* 
 * File:   CMUI_Menustrip.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 18:02
 */

#include "CMUI_Menustrip.h"

CMUI_Menustrip::CMUI_Menustrip()
: CMUI_Family() {
}

CMUI_Menustrip::CMUI_Menustrip(TagItem* tags)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menustrip, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menustrip object\n");
#endif
}

CMUI_Menustrip::CMUI_Menustrip(Tag tag1, ...)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menustrip, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menustrip object\n");
#endif
}

CMUI_Menustrip::CMUI_Menustrip(Object* obj)
: CMUI_Family() {
    object = obj;
}

CMUI_Menustrip::CMUI_Menustrip(NewMenu* nm, IPTR flags)
: CMUI_Family() {
    object = MUI_MakeObject(MUIO_MenustripNM, nm, flags);
}

CMUI_Menustrip& CMUI_Menustrip::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Menustrip::Enabled(void) const {
    return (BOOL) MGetAttr(MUIA_Menustrip_Enabled);
}

void CMUI_Menustrip::SetEnabled(BOOL value) {
    SetAttr(MUIA_Menustrip_Enabled, (IPTR) value);
}
