/* 
 * File:   CMUI_Numeric.h
 * Author: Piotr Hoppe
 *
 * Created on 30 listopada 2015, 21:37
 */

#ifndef CMUI_NUMERIC_H
#define	CMUI_NUMERIC_H

#include "CMUI_Area.h"

/***************************************************************************
 **                      CMUI_Numeric class definition                       
 ***************************************************************************/

class CMUI_Numeric : public CMUI_Area {
public:
    operator int();
    CMUI_Numeric & operator=(const int value);
    CMUI_Numeric operator++();
    CMUI_Numeric operator++(int dummy);
    CMUI_Numeric & operator+=(LONG value);
    CMUI_Numeric operator--();
    CMUI_Numeric operator--(int dummy);
    CMUI_Numeric & operator-=(LONG value);


    BOOL CheckAllSizes(void) const;
    void SetCheckAllSizes(BOOL value);
    LONG Default(void) const;
    void SetDefault(LONG value);
    STRPTR Format(void) const;
    void SetFormat(STRPTR value);
    LONG Max(void) const;
    void SetMax(LONG value);
    LONG Min(void) const;
    void SetMin(LONG value);
    BOOL Reverse(void) const;
    void SetReverse(BOOL value);
    BOOL RevLeftRight(void) const;
    void SetRevLeftRight(BOOL value);
    BOOL RevUpDown(void) const;
    void SetRevUpDown(BOOL value);
    LONG Value(void) const;
    void SetValue(LONG value);
    IPTR Decrease(LONG amount);
    IPTR Increase(LONG amount);
    IPTR ScaleToValue(LONG scalemin, LONG scalemax, LONG scale);
    IPTR SetDefault(void);
    IPTR Stringify(LONG value);
    IPTR ValueToScale(LONG scalemin, LONG scalemax);
protected:

    CMUI_Numeric(void);

};

#endif	/* CMUI_NUMERIC_H */

