/* 
 * File:   CMUI_Popasl.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:29
 */

#include "CMUI_Popasl.h"

CMUI_Popasl::CMUI_Popasl()
: CMUI_Popstring() {
}

CMUI_Popasl::CMUI_Popasl(TagItem* tags)
: CMUI_Popstring() {
    object = MUI_NewObjectA(MUIC_Popasl, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popasl object\n");
#endif
}

CMUI_Popasl::CMUI_Popasl(Tag tag1, ...)
: CMUI_Popstring() {
    object = MUI_NewObjectA(MUIC_Popasl, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popasl object\n");
#endif
}

CMUI_Popasl::CMUI_Popasl(Object* obj)
: CMUI_Popstring() {
    object = obj;
}

CMUI_Popasl& CMUI_Popasl::operator=(Object* obj) {
    object = obj;
    return *this;
}

 BOOL CMUI_Popasl::Active (void) const
{
	 return (BOOL)MGetAttr (MUIA_Popasl_Active);
}

 struct Hook * CMUI_Popasl::StartHook (void) const
{
	 return (struct Hook *)MGetAttr (MUIA_Popasl_StartHook);
}

 void CMUI_Popasl::SetStartHook (struct Hook * value)
{
	 SetAttr (MUIA_Popasl_StartHook, (IPTR)value);
}

 struct Hook * CMUI_Popasl::StopHook (void) const
{
	 return (struct Hook *)MGetAttr (MUIA_Popasl_StopHook);
}

 void CMUI_Popasl::SetStopHook (struct Hook * value)
{
	 SetAttr (MUIA_Popasl_StopHook, (IPTR)value);
}

 IPTR CMUI_Popasl::Type (void) const
{
	 return (IPTR)MGetAttr (MUIA_Popasl_Type);
}
