/* 
 * File:   CMUI_Semaphore.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:43
 */

#include "CMUI_Semaphore.h"

CMUI_Semaphore::CMUI_Semaphore()
: CMUI_Object() {
}

CMUI_Semaphore::CMUI_Semaphore(TagItem* tags)
: CMUI_Object() {
    object = MUI_NewObjectA(MUIC_Semaphore, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Semaphore object\n");
#endif
}

CMUI_Semaphore::CMUI_Semaphore(Tag tag1, ...)
: CMUI_Object() {
    object = MUI_NewObjectA(MUIC_Semaphore, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Semaphore object\n");
#endif
}

CMUI_Semaphore::CMUI_Semaphore(Object* obj)
: CMUI_Object() {
    object = obj;
}

CMUI_Semaphore& CMUI_Semaphore::operator=(Object* obj) {
    object = obj;
    return *this;
}

IPTR CMUI_Semaphore::Attempt(void) {
    return MDoMethod(MUIM_Semaphore_Attempt);
}

IPTR CMUI_Semaphore::AttemptShared(void) {
    return MDoMethod(MUIM_Semaphore_AttemptShared);
}

IPTR CMUI_Semaphore::Obtain(void) {
    return MDoMethod(MUIM_Semaphore_Obtain);
}

IPTR CMUI_Semaphore::ObtainShared(void) {
    return MDoMethod(MUIM_Semaphore_ObtainShared);
}

IPTR CMUI_Semaphore::Release(void) {
    return MDoMethod(MUIM_Semaphore_Release);
}
