/* 
 * File:   CMUI_Slider.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 21:27
 */

#include "CMUI_Slider.h"

CMUI_Slider::CMUI_Slider()
: CMUI_Numeric() {
}

CMUI_Slider::CMUI_Slider(TagItem* tags)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Slider, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Slider object\n");
#endif
}

CMUI_Slider::CMUI_Slider(Tag tag1, ...)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Slider, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Slider object\n");
#endif
}

CMUI_Slider::CMUI_Slider(Object* obj)
: CMUI_Numeric() {
    object = obj;
}

CMUI_Slider::CMUI_Slider(STRPTR label, LONG min, LONG max)
: CMUI_Numeric() {
    object = MUI_MakeObject(MUIO_Slider, label, min, max);
}

CMUI_Slider& CMUI_Slider::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Slider::Horiz(void) const {
    return (BOOL) MGetAttr(MUIA_Slider_Horiz);
}

void CMUI_Slider::SetHoriz(BOOL value) {
    SetAttr(MUIA_Slider_Horiz, (IPTR) value);
}
