/* 
 * File:   CMUI_Virtgroup.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 20:57
 */

#include "CMUI_Virtgroup.h"

CMUI_Virtgroup::CMUI_Virtgroup()
: CMUI_Group() {
}

CMUI_Virtgroup::CMUI_Virtgroup(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Virtgroup, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Virtgroup object\n");
#endif
}

CMUI_Virtgroup::CMUI_Virtgroup(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Virtgroup, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Virtgroup object\n");
#endif
}

CMUI_Virtgroup::CMUI_Virtgroup(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Virtgroup& CMUI_Virtgroup::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Virtgroup::Height(void) const {
    return (LONG) MGetAttr(MUIA_Virtgroup_Height);
}

LONG CMUI_Virtgroup::Left(void) const {
    return (LONG) MGetAttr(MUIA_Virtgroup_Left);
}

void CMUI_Virtgroup::SetLeft(LONG value) {
    SetAttr(MUIA_Virtgroup_Left, (IPTR) value);
}

LONG CMUI_Virtgroup::Top(void) const {
    return (LONG) MGetAttr(MUIA_Virtgroup_Top);
}

void CMUI_Virtgroup::SetTop(LONG value) {
    SetAttr(MUIA_Virtgroup_Top, (IPTR) value);
}

LONG CMUI_Virtgroup::Width(void) const {
    return (LONG) MGetAttr(MUIA_Virtgroup_Width);
}
