
/* 
 * File:   CTMUI_List.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 20 grudnia 2015, 21:32
 */

#include "CTMUI_List.h"

template<class Type>
CTMUI_List<Type>::CTMUI_List()
: CMUI_Area() {
    object = NULL;
}

template<class Type>
CTMUI_List<Type>::CTMUI_List(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_List, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CTMUI_List object\n");
#endif
}

template<class Type>
CTMUI_List<Type>::CTMUI_List(Object* obj)
: CMUI_Area() {
    object = obj;
}

template<class Type>
CTMUI_List<Type>& CTMUI_List<Type>::operator=(Object* obj) {
    object = obj;
    return *this;
}
// By overloading the [] operator you can treat lists like arrays

template<class Type>
Type& CTMUI_List<Type>::operator[](LONG pos) {
    Type *entry;
    MDoMethod(MUIM_List_GetEntry, pos, &entry);

#ifdef MUIPP_DEBUG
    if (entry == NULL)
        _MUIPPError("Index into CTMUI_List is out of range:\n"
        "Index = %ld, List length = %ld\n", pos, (LONG) Entries());
#endif
    return *entry;
}

// This method is a convienient alternative to the Entries attribute

template <typename Type> LONG CTMUI_List<Type>::Length(void) const {
    return (LONG) MGetAttr(MUIA_List_Entries);
}

// This method can be used to retrieve the number of selected entries
// in a list

template <typename Type> IPTR CTMUI_List<Type>::NumSelected(void) {
    IPTR numSelected;
    MDoMethod(MUIM_List_Select, MUIV_List_Select_All, MUIV_List_Select_Ask, &numSelected);
    return numSelected;
}

// These methods can be used as shortcuts for inserting objects into lists

template <typename Type> void CTMUI_List<Type>::InsertTop(Type *entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Top);
}

template <typename Type> void CTMUI_List<Type>::InsertTop(Type &entry) {
    MDoMethod(MUIM_List_InsertSingle, &entry, MUIV_List_Insert_Top);
}

template <typename Type> void CTMUI_List<Type>::InsertBottom(Type *entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Bottom);
}

template <typename Type> void CTMUI_List<Type>::InsertBottom(Type &entry) {
    MDoMethod(MUIM_List_InsertSingle, &entry, MUIV_List_Insert_Bottom);
}

template <typename Type> void CTMUI_List<Type>::InsertSorted(Type *entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Sorted);
}

template <typename Type> void CTMUI_List<Type>::InsertSorted(Type &entry) {
    MDoMethod(MUIM_List_InsertSingle, &entry, MUIV_List_Insert_Sorted);
}

template <typename Type> void CTMUI_List<Type>::InsertActive(Type *entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Active);
}

template <typename Type> void CTMUI_List<Type>::InsertActive(Type &entry) {
    MDoMethod(MUIM_List_InsertSingle, &entry, MUIV_List_Insert_Active);
}

template <typename Type> void CTMUI_List<Type>::InsertSingle(Type &entry, LONG pos) {
    MDoMethod(MUIM_List_InsertSingle, &entry, pos);
}

template <typename Type> LONG CTMUI_List<Type>::Active(void) const {
    return (LONG) MGetAttr(MUIA_List_Active);
}

template <typename Type> void CTMUI_List<Type>::SetActive(LONG value) {
    SetAttr(MUIA_List_Active, (IPTR) value);
}

template <typename Type> BOOL CTMUI_List<Type>::AutoVisible(void) const {
    return (BOOL) MGetAttr(MUIA_List_AutoVisible);
}

template <typename Type> void CTMUI_List<Type>::SetAutoVisible(BOOL value) {
    SetAttr(MUIA_List_AutoVisible, (IPTR) value);
}

template <typename Type> void CTMUI_List<Type>::SetCompareHook(struct Hook * value) {
    SetAttr(MUIA_List_CompareHook, (IPTR) value);
}

template <typename Type> void CTMUI_List<Type>::SetConstructHook(struct Hook * value) {
    SetAttr(MUIA_List_ConstructHook, (IPTR) value);
}

template <typename Type> void CTMUI_List<Type>::SetDestructHook(struct Hook * value) {
    SetAttr(MUIA_List_DestructHook, (IPTR) value);
}

template <typename Type> void CTMUI_List<Type>::SetDisplayHook(struct Hook * value) {
    SetAttr(MUIA_List_DisplayHook, (IPTR) value);
}

template <typename Type> BOOL CTMUI_List<Type>::DragSortable(void) const {
    return (BOOL) MGetAttr(MUIA_List_DragSortable);
}

template <typename Type> void CTMUI_List<Type>::SetDragSortable(BOOL value) {
    SetAttr(MUIA_List_DragSortable, (IPTR) value);
}

template <typename Type> LONG CTMUI_List<Type>::DropMark(void) const {
    return (LONG) MGetAttr(MUIA_List_DropMark);
}

template <typename Type> LONG CTMUI_List<Type>::Entries(void) const {
    return (LONG) MGetAttr(MUIA_List_Entries);
}

template <typename Type> LONG CTMUI_List<Type>::First(void) const {
    return (LONG) MGetAttr(MUIA_List_First);
}

template <typename Type> STRPTR CTMUI_List<Type>::Format(void) const {
    return (STRPTR) MGetAttr(MUIA_List_Format);
}

template <typename Type> void CTMUI_List<Type>::SetFormat(STRPTR value) {
    SetAttr(MUIA_List_Format, (IPTR) value);
}

template <typename Type> LONG CTMUI_List<Type>::InsertPosition(void) const {
    return (LONG) MGetAttr(MUIA_List_InsertPosition);
}

template <typename Type> void CTMUI_List<Type>::SetMultiTestHook(struct Hook * value) {
    SetAttr(MUIA_List_MultiTestHook, (IPTR) value);
}

template <typename Type> void CTMUI_List<Type>::SetQuiet(BOOL value) {
    SetAttr(MUIA_List_Quiet, (IPTR) value);
}

template <typename Type> BOOL CTMUI_List<Type>::ShowDropMarks(void) const {
    return (BOOL) MGetAttr(MUIA_List_ShowDropMarks);
}

template <typename Type> void CTMUI_List<Type>::SetShowDropMarks(BOOL value) {
    SetAttr(MUIA_List_ShowDropMarks, (IPTR) value);
}

template <typename Type> char * CTMUI_List<Type>::Title(void) const {
    return (char *) MGetAttr(MUIA_List_Title);
}

template <typename Type> void CTMUI_List<Type>::SetTitle(char * value) {
    SetAttr(MUIA_List_Title, (IPTR) value);
}

template <typename Type> LONG CTMUI_List<Type>::Visible(void) const {
    return (LONG) MGetAttr(MUIA_List_Visible);
}

template <typename Type> IPTR CTMUI_List<Type>::Clear(void) {
    return MDoMethod(MUIM_List_Clear);
}

template <typename Type> IPTR CTMUI_List<Type>::CreateImage(Object * obj, IPTR flags) {
    return MDoMethod(MUIM_List_CreateImage, obj, flags);
}

template <typename Type> IPTR CTMUI_List<Type>::DeleteImage(APTR listimg) {
    return MDoMethod(MUIM_List_DeleteImage, listimg);
}

template <typename Type> IPTR CTMUI_List<Type>::Exchange(LONG pos1, LONG pos2) {
    return MDoMethod(MUIM_List_Exchange, pos1, pos2);
}

template <typename Type> IPTR CTMUI_List<Type>::GetEntry(LONG pos, Type ** entry) {
    return MDoMethod(MUIM_List_GetEntry, pos, entry);
}

template <typename Type> IPTR CTMUI_List<Type>::Insert(Type ** entries, LONG count, LONG pos) {
    return MDoMethod(MUIM_List_Insert, entries, count, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::InsertSingle(Type * entry, LONG pos) {
    return MDoMethod(MUIM_List_InsertSingle, entry, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::Jump(LONG pos) {
    return MDoMethod(MUIM_List_Jump, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::Move(LONG from, LONG to) {
    return MDoMethod(MUIM_List_Move, from, to);
}

template <typename Type> IPTR CTMUI_List<Type>::NextSelected(LONG * pos) {
    return MDoMethod(MUIM_List_NextSelected, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::Redraw(LONG pos) {
    return MDoMethod(MUIM_List_Redraw, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::Remove(LONG pos) {
    return MDoMethod(MUIM_List_Remove, pos);
}

template <typename Type> IPTR CTMUI_List<Type>::Select(LONG pos, LONG seltype, LONG * state) {
    return MDoMethod(MUIM_List_Select, pos, seltype, state);
}

template <typename Type> IPTR CTMUI_List<Type>::Sort(void) {
    return MDoMethod(MUIM_List_Sort);
}

template <typename Type> IPTR CTMUI_List<Type>::TestPos(LONG x, LONG y, struct MUI_List_TestPos_Result * res) {
    return MDoMethod(MUIM_List_TestPos, x, y, res);
}
