
/* 
 * File:   CTMUI_Listview.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 20 grudnia 2015, 21:38
 */

#include "CTMUI_Listview.h"

template<class Type>
CTMUI_Listview<Type>::CTMUI_Listview()
: CTMUI_List<Type> () {
    this->object = NULL;
}

template<class Type>
CTMUI_Listview<Type>::CTMUI_Listview(Tag tag1, ...)
: CTMUI_List<Type> () {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CTMUI_Listview", (struct TagItem *) &tag1, MUIA_Listview_List, "MUIA_Listview_List", TAG_DONE);
#endif
    this->object = MUI_NewObjectA(MUIC_Listview, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (this->object == NULL)
        _MUIPPWarning("Could not create a CTMUI_Listview object\n");
#endif
}

template<class Type>
CTMUI_Listview<Type>::CTMUI_Listview(Object* obj)
: CTMUI_List<Type> () {
    this->object = obj;
}

template<class Type>
CTMUI_Listview<Type>& CTMUI_Listview<Type>::operator=(Object* obj) {
    this->object = obj;
    return *this;
}

template <typename Type> LONG CTMUI_Listview<Type>::ActivePage(void) const {
    return (LONG) this->MGetAttr(MUIA_Group_ActivePage);
}

template <typename Type> void CTMUI_Listview<Type>::SetActivePage(LONG value) {
    this->SetAttr(MUIA_Group_ActivePage, (IPTR) value);
}

template <typename Type> struct List * CTMUI_Listview<Type>::ChildList(void) const {
    return (struct List *) this->MGetAttr(MUIA_Group_ChildList);
}

template <typename Type> void CTMUI_Listview<Type>::SetColumns(LONG value) {
    this->SetAttr(MUIA_Group_Columns, (IPTR) value);
}

template <typename Type> LONG CTMUI_Listview<Type>::HorizSpacing(void) const {
    return (LONG) this->MGetAttr(MUIA_Group_HorizSpacing);
}

template <typename Type> void CTMUI_Listview<Type>::SetHorizSpacing(LONG value) {
    this->SetAttr(MUIA_Group_HorizSpacing, (IPTR) value);
}

template <typename Type> void CTMUI_Listview<Type>::SetRows(LONG value) {
    this->SetAttr(MUIA_Group_Rows, (IPTR) value);
}

template <typename Type> void CTMUI_Listview<Type>::SetSpacing(LONG value) {
    this->SetAttr(MUIA_Group_Spacing, (IPTR) value);
}

template <typename Type> LONG CTMUI_Listview<Type>::VertSpacing(void) const {
    return (LONG) this->MGetAttr(MUIA_Group_VertSpacing);
}

template <typename Type> void CTMUI_Listview<Type>::SetVertSpacing(LONG value) {
    this->SetAttr(MUIA_Group_VertSpacing, (IPTR) value);
}

template <typename Type> IPTR CTMUI_Listview<Type>::ExitChange(void) {
    return this->MDoMethod(MUIM_Group_ExitChange);
}

template <typename Type> IPTR CTMUI_Listview<Type>::InitChange(void) {
    return this->MDoMethod(MUIM_Group_InitChange);
}

template <typename Type> IPTR CTMUI_Listview<Type>::Sort(StartVarArgs sva, Object * obj, ...) {
    sva.methodID = MUIM_Group_Sort;
    return this->MDoMethodA((Msg) & sva);
}

template <typename Type> LONG CTMUI_Listview<Type>::ClickColumn(void) const {
    return (LONG) this->MGetAttr(MUIA_Listview_ClickColumn);
}

template <typename Type> LONG CTMUI_Listview<Type>::DefClickColumn(void) const {
    return (LONG) this->MGetAttr(MUIA_Listview_DefClickColumn);
}

template <typename Type> void CTMUI_Listview<Type>::SetDefClickColumn(LONG value) {
    this->SetAttr(MUIA_Listview_DefClickColumn, (IPTR) value);
}

template <typename Type> BOOL CTMUI_Listview<Type>::MDoubleClick(void) const {
    return (BOOL) this->MGetAttr(MUIA_Listview_DoubleClick);
}

template <typename Type> LONG CTMUI_Listview<Type>::DragType(void) const {
    return (LONG) this->MGetAttr(MUIA_Listview_DragType);
}

template <typename Type> void CTMUI_Listview<Type>::SetDragType(LONG value) {
    this->SetAttr(MUIA_Listview_DragType, (IPTR) value);
}

template <typename Type> Object * CTMUI_Listview<Type>::List(void) const {
    return (Object *) this->MGetAttr(MUIA_Listview_List);
}

template <typename Type> BOOL CTMUI_Listview<Type>::SelectChange(void) const {
    return (BOOL) this->MGetAttr(MUIA_Listview_SelectChange);
}
