
/* 
 * File:   CMUI_NList.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 13 grudnia 2015, 20:23
 */

#include "CMUI_NList.h"

CMUI_NList::CMUI_NList()
: CMUI_Area() {
}

CMUI_NList::CMUI_NList(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_NList, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_NList object\n");
#endif
}

CMUI_NList::CMUI_NList(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_NList, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_NList object\n");
#endif
}

CMUI_NList::CMUI_NList(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_NList& CMUI_NList::operator=(Object* obj) {
    object = obj;
    return *this;
}

// By overloading the [] operator you can treat lists like arrays

APTR CMUI_NList::operator[](LONG pos) {
    APTR entry;
    MDoMethod(MUIM_NList_GetEntry, pos, &entry);
    return entry;
}

// This method is a convienient alternative to the Entries attribute

LONG CMUI_NList::Length(void) const {
    return (LONG) MGetAttr(MUIA_NList_Entries);
}

// This method can be used to retrieve the number of selected entries
// in a list

IPTR CMUI_NList::NumSelected(void) {
    IPTR numSelected;
    MDoMethod(MUIM_NList_Select, MUIV_NList_Select_All, MUIV_NList_Select_Ask, &numSelected);
    return numSelected;
}

// These methods can be used as shortcuts for inserting objects into lists

void CMUI_NList::AddHead(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Top);
}

void CMUI_NList::AddTail(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Bottom);
}

void CMUI_NList::InsertTop(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Top);
}

void CMUI_NList::InsertBottom(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Bottom);
}

void CMUI_NList::InsertSorted(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Sorted);
}

void CMUI_NList::InsertActive(APTR entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Active);
}

LONG CMUI_NList::Active(void) const {
    return (LONG) MGetAttr(MUIA_NList_Active);
}

void CMUI_NList::SetActive(LONG value) {
    SetAttr(MUIA_NList_Active, (IPTR) value);
}

void CMUI_NList::SetAutoCopyToClip(BOOL value) {
    SetAttr(MUIA_NList_AutoCopyToClip, (IPTR) value);
}

BOOL CMUI_NList::AutoVisible(void) const {
    return (BOOL) MGetAttr(MUIA_NList_AutoVisible);
}

void CMUI_NList::SetAutoVisible(BOOL value) {
    SetAttr(MUIA_NList_AutoVisible, (IPTR) value);
}

LONG CMUI_NList::ClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_NList_ClickColumn);
}

void CMUI_NList::SetCompareHook(struct Hook * value) {
    SetAttr(MUIA_NList_CompareHook, (IPTR) value);
}

void CMUI_NList::SetConstructHook(struct Hook * value) {
    SetAttr(MUIA_NList_ConstructHook, (IPTR) value);
}

void CMUI_NList::SetCopyColumnToClipHook(struct Hook * value) {
    SetAttr(MUIA_NList_CopyColumnToClipHook, (IPTR) value);
}

void CMUI_NList::SetCopyEntryToClipHook(struct Hook * value) {
    SetAttr(MUIA_NList_CopyEntryToClipHook, (IPTR) value);
}

void CMUI_NList::SetDefaultObjectOnClick(BOOL value) {
    SetAttr(MUIA_NList_DefaultObjectOnClick, (IPTR) value);
}

LONG CMUI_NList::DefClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_NList_DefClickColumn);
}

void CMUI_NList::SetDefClickColumn(LONG value) {
    SetAttr(MUIA_NList_DefClickColumn, (IPTR) value);
}

void CMUI_NList::SetDestructHook(struct Hook * value) {
    SetAttr(MUIA_NList_DestructHook, (IPTR) value);
}

void CMUI_NList::SetDisplayHook(struct Hook * value) {
    SetAttr(MUIA_NList_DisplayHook, (IPTR) value);
}

void CMUI_NList::SetDisplayRecall(BOOL value) {
    SetAttr(MUIA_NList_DisplayRecall, (IPTR) value);
}

BOOL CMUI_NList::MDoubleClick(void) const {
    return (BOOL) MGetAttr(MUIA_NList_DoubleClick);
}

BOOL CMUI_NList::DragSortable(void) const {
    return (BOOL) MGetAttr(MUIA_NList_DragSortable);
}

void CMUI_NList::SetDragSortable(BOOL value) {
    SetAttr(MUIA_NList_DragSortable, (IPTR) value);
}

LONG CMUI_NList::DragType(void) const {
    return (LONG) MGetAttr(MUIA_NList_DragType);
}

void CMUI_NList::SetDragType(LONG value) {
    SetAttr(MUIA_NList_DragType, (IPTR) value);
}

LONG CMUI_NList::DropMark(void) const {
    return (LONG) MGetAttr(MUIA_List_DropMark);
}

LONG CMUI_NList::Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Entries);
}

BOOL CMUI_NList::EntryValueDependent(void) const {
    return (BOOL) MGetAttr(MUIA_NList_EntryValueDependent);
}

void CMUI_NList::SetEntryValueDependent(BOOL value) {
    SetAttr(MUIA_NList_EntryValueDependent, (IPTR) value);
}

LONG CMUI_NList::First(void) const {
    return (LONG) MGetAttr(MUIA_NList_First);
}

void CMUI_NList::SetFirst(LONG value) {
    SetAttr(MUIA_NList_First, (IPTR) value);
}

STRPTR CMUI_NList::Format(void) const {
    return (STRPTR) MGetAttr(MUIA_NList_Format);
}

void CMUI_NList::SetFormat(STRPTR value) {
    SetAttr(MUIA_NList_Format, (IPTR) value);
}

LONG CMUI_NList::HorizDeltaFactor(void) const {
    return (LONG) MGetAttr(MUIA_NList_HorizDeltaFactor);
}

LONG CMUI_NList::Horiz_Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_Entries);
}

LONG CMUI_NList::Horiz_First(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_First);
}

void CMUI_NList::SetHoriz_First(LONG value) {
    SetAttr(MUIA_NList_Horiz_First, (IPTR) value);
}

LONG CMUI_NList::Horiz_Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_Visible);
}

BOOL CMUI_NList::Input(void) const {
    return (BOOL) MGetAttr(MUIA_NList_Input);
}

void CMUI_NList::SetInput(BOOL value) {
    SetAttr(MUIA_NList_Input, (IPTR) value);
}

LONG CMUI_NList::InsertPosition(void) const {
    return (LONG) MGetAttr(MUIA_NList_InsertPosition);
}

void CMUI_NList::SetKeepActive(Object * value) {
    SetAttr(MUIA_NList_KeepActive, (IPTR) value);
}

void CMUI_NList::SetMakeActive(Object * value) {
    SetAttr(MUIA_NList_MakeActive, (IPTR) value);
}

void CMUI_NList::SetMinLineHeight(LONG value) {
    SetAttr(MUIA_NList_MinLineHeight, (IPTR) value);
}

BOOL CMUI_NList::MultiClick(void) const {
    return (BOOL) MGetAttr(MUIA_NList_MultiClick);
}

void CMUI_NList::SetMultiTestHook(struct Hook * value) {
    SetAttr(MUIA_NList_MultiTestHook, (IPTR) value);
}

APTR CMUI_NList::PrivateData(void) const {
    return (APTR) MGetAttr(MUIA_NList_PrivateData);
}

void CMUI_NList::SetPrivateData(APTR value) {
    SetAttr(MUIA_NList_PrivateData, (IPTR) value);
}

LONG CMUI_NList::Prop_Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_Entries);
}

LONG CMUI_NList::Prop_First(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_First);
}

void CMUI_NList::SetProp_First(LONG value) {
    SetAttr(MUIA_NList_Prop_First, (IPTR) value);
}

LONG CMUI_NList::Prop_Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_Visible);
}

void CMUI_NList::SetQuiet(BOOL value) {
    SetAttr(MUIA_NList_Quiet, (IPTR) value);
}

BOOL CMUI_NList::ShowDropMarks(void) const {
    return (BOOL) MGetAttr(MUIA_NList_ShowDropMarks);
}

void CMUI_NList::SetShowDropMarks(BOOL value) {
    SetAttr(MUIA_NList_ShowDropMarks, (IPTR) value);
}

char * CMUI_NList::SkipChars(void) const {
    return (char *) MGetAttr(MUIA_NList_SkipChars);
}

void CMUI_NList::SetSkipChars(char * value) {
    SetAttr(MUIA_NList_SkipChars, (IPTR) value);
}

IPTR CMUI_NList::TabSize(void) const {
    return (IPTR) MGetAttr(MUIA_NList_TabSize);
}

void CMUI_NList::SetTabSize(IPTR value) {
    SetAttr(MUIA_NList_TabSize, (IPTR) value);
}

char * CMUI_NList::Title(void) const {
    return (char *) MGetAttr(MUIA_NList_Title);
}

void CMUI_NList::SetTitle(char * value) {
    SetAttr(MUIA_NList_Title, (IPTR) value);
}

BOOL CMUI_NList::TitleSeparator(void) const {
    return (BOOL) MGetAttr(MUIA_NList_TitleSeparator);
}

void CMUI_NList::SetTitleSeparator(BOOL value) {
    SetAttr(MUIA_NList_TitleSeparator, (IPTR) value);
}

void CMUI_NList::SetTypeSelect(LONG value) {
    SetAttr(MUIA_NList_TypeSelect, (IPTR) value);
}

LONG CMUI_NList::VertDeltaFactor(void) const {
    return (LONG) MGetAttr(MUIA_NList_VertDeltaFactor);
}

LONG CMUI_NList::Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Visible);
}

LONG CMUI_NList::TitleBackground(void) const {
    return (LONG) MGetAttr(MUIA_NList_TitleBackground);
}

void CMUI_NList::SetTitleBackground(LONG value) {
    SetAttr(MUIA_NList_TitleBackground, (IPTR) value);
}

LONG CMUI_NList::TitlePen(void) const {
    return (LONG) MGetAttr(MUIA_NList_TitlePen);
}

void CMUI_NList::SetTitlePen(LONG value) {
    SetAttr(MUIA_NList_TitlePen, (IPTR) value);
}

IPTR CMUI_NList::Clear(void) {
    return MDoMethod(MUIM_NList_Clear);
}

IPTR CMUI_NList::CopyToClip(LONG pos, IPTR clipnum) {
    return MDoMethod(MUIM_NList_CopyToClip, pos, clipnum);
}

IPTR CMUI_NList::CreateImage(Object * imgobj, IPTR flags) {
    return MDoMethod(MUIM_NList_CreateImage, imgobj, flags);
}

IPTR CMUI_NList::DeleteImage(APTR listimg) {
    return MDoMethod(MUIM_NList_DeleteImage, listimg);
}

IPTR CMUI_NList::Exchange(LONG pos1, LONG pos2) {
    return MDoMethod(MUIM_NList_Exchange, pos1, pos2);
}

IPTR CMUI_NList::GetEntry(LONG pos, APTR * entry) {
    return MDoMethod(MUIM_NList_GetEntry, pos, entry);
}

IPTR CMUI_NList::GetEntryInfo(struct MUI_NList_GetEntryInfo * res) {
    return MDoMethod(MUIM_NList_GetEntryInfo, res);
}

IPTR CMUI_NList::Insert(APTR * entries, LONG count, LONG pos) {
    return MDoMethod(MUIM_NList_Insert, entries, count, pos);
}

IPTR CMUI_NList::InsertSingle(APTR entry, LONG pos) {
    return MDoMethod(MUIM_NList_InsertSingle, entry, pos);
}

IPTR CMUI_NList::InsertSingleWrap(void) {
    return MDoMethod(MUIM_NList_InsertSingleWrap);
}

IPTR CMUI_NList::InsertWrap(APTR * entries) {
    return MDoMethod(MUIM_NList_InsertWrap, entries);
}

IPTR CMUI_NList::Jump(LONG pos) {
    return MDoMethod(MUIM_NList_Jump, pos);
}

IPTR CMUI_NList::Move(LONG from, LONG to) {
    return MDoMethod(MUIM_NList_Move, from, to);
}

IPTR CMUI_NList::NextSelected(LONG * pos) {
    return MDoMethod(MUIM_NList_NextSelected, pos);
}

IPTR CMUI_NList::Redraw(LONG pos) {
    return MDoMethod(MUIM_NList_Redraw, pos);
}

IPTR CMUI_NList::Remove(LONG pos) {
    return MDoMethod(MUIM_NList_Remove, pos);
}

IPTR CMUI_NList::ReplaceSingle(LONG pos, LONG seltype, LONG * state) {
    return MDoMethod(MUIM_NList_ReplaceSingle, pos, seltype, state);
}

IPTR CMUI_NList::Sort(void) {
    return MDoMethod(MUIM_NList_Sort);
}

IPTR CMUI_NList::TestPos(LONG x, LONG y, struct MUI_NList_TestPos_Result * res) {
    return MDoMethod(MUIM_NList_TestPos, x, y, res);
}

IPTR CMUI_NList::UseImage(Object * obj, IPTR imgnum, IPTR flags) {
    return MDoMethod(MUIM_NList_UseImage, obj, imgnum, flags);
}

