
/* 
 * File:   CMUI_NList.h
 * Author: Piotr Hoppe
 *
 * Created on 13 grudnia 2015, 20:23
 */

#ifndef CMUI_NLIST_H
#define CMUI_NLIST_H

#include <libraries/mui.hpp>
#include <mui/NList_mcc.h>

/***************************************************************************
 **                       CMUI_NList class definition                        
 ***************************************************************************/

class CMUI_NList : public CMUI_Area {
public:
    CMUI_NList(void);
    CMUI_NList(struct TagItem *tags);
    CMUI_NList(Tag tag1, ...);
    CMUI_NList(Object * obj);
    CMUI_NList & operator=(Object * obj);
    APTR operator[](LONG pos);
    LONG Length(void) const;
    IPTR NumSelected(void);

    void AddHead(APTR entry);
    void AddTail(APTR entry);
    void InsertTop(APTR entry);
    void InsertBottom(APTR entry);
    void InsertSorted(APTR entry);
    void InsertActive(APTR entry);
    LONG Active(void) const;
    void SetActive(LONG value);
    void SetAutoCopyToClip(BOOL value);
    BOOL AutoVisible(void) const;
    void SetAutoVisible(BOOL value);
    LONG ClickColumn(void) const;
    void SetCompareHook(struct Hook * value);
    void SetConstructHook(struct Hook * value);
    void SetCopyColumnToClipHook(struct Hook * value);
    void SetCopyEntryToClipHook(struct Hook * value);
    void SetDefaultObjectOnClick(BOOL value);
    LONG DefClickColumn(void) const;
    void SetDefClickColumn(LONG value);
    void SetDestructHook(struct Hook * value);
    void SetDisplayHook(struct Hook * value);
    void SetDisplayRecall(BOOL value);
    BOOL MDoubleClick(void) const;
    BOOL DragSortable(void) const;
    void SetDragSortable(BOOL value);
    LONG DragType(void) const;
    void SetDragType(LONG value);
    LONG DropMark(void) const;
    LONG Entries(void) const;
    BOOL EntryValueDependent(void) const;
    void SetEntryValueDependent(BOOL value);
    LONG First(void) const;
    void SetFirst(LONG value);
    STRPTR Format(void) const;
    void SetFormat(STRPTR value);
    LONG HorizDeltaFactor(void) const;
    LONG Horiz_Entries(void) const;
    LONG Horiz_First(void) const;
    void SetHoriz_First(LONG value);
    LONG Horiz_Visible(void) const;
    BOOL Input(void) const;
    void SetInput(BOOL value);
    LONG InsertPosition(void) const;
    void SetKeepActive(Object * value);
    void SetMakeActive(Object * value);
    void SetMinLineHeight(LONG value);
    BOOL MultiClick(void) const;
    void SetMultiTestHook(struct Hook * value);
    APTR PrivateData(void) const;
    void SetPrivateData(APTR value);
    LONG Prop_Entries(void) const;
    LONG Prop_First(void) const;
    void SetProp_First(LONG value);
    LONG Prop_Visible(void) const;
    void SetQuiet(BOOL value);
    BOOL ShowDropMarks(void) const;
    void SetShowDropMarks(BOOL value);
    char * SkipChars(void) const;
    void SetSkipChars(char * value);
    IPTR TabSize(void) const;
    void SetTabSize(IPTR value);
    char * Title(void) const;
    void SetTitle(char * value);
    BOOL TitleSeparator(void) const;
    void SetTitleSeparator(BOOL value);
    void SetTypeSelect(LONG value);
    LONG VertDeltaFactor(void) const;
    LONG Visible(void) const;
    LONG TitleBackground(void) const;
    void SetTitleBackground(LONG value);
    LONG TitlePen(void) const;
    void SetTitlePen(LONG value);
    IPTR Clear(void);
    IPTR CopyToClip(LONG pos, IPTR clipnum);
    IPTR CreateImage(Object * imgobj, IPTR flags);
    IPTR DeleteImage(APTR listimg);
    IPTR Exchange(LONG pos1, LONG pos2);
    IPTR GetEntry(LONG pos, APTR * entry);
    IPTR GetEntryInfo(struct MUI_NList_GetEntryInfo * res);
    IPTR Insert(APTR * entries, LONG count, LONG pos);
    IPTR InsertSingle(APTR entry, LONG pos);
    IPTR InsertSingleWrap(void);
    IPTR InsertWrap(APTR * entries);
    IPTR Jump(LONG pos);
    IPTR Move(LONG from, LONG to);
    IPTR NextSelected(LONG * pos);
    IPTR Redraw(LONG pos);
    IPTR Remove(LONG pos);
    IPTR ReplaceSingle(LONG pos, LONG seltype, LONG * state);
    IPTR Sort(void);
    IPTR TestPos(LONG x, LONG y, struct MUI_NList_TestPos_Result * res);
    IPTR UseImage(Object * obj, IPTR imgnum, IPTR flags);
};


#endif /* CMUI_NLIST_H */

