#ifndef GENERIC_STRINGS_H
#define GENERIC_STRINGS_H

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifdef CATCOMP_ARRAY
#undef CATCOMP_NUMBERS
#undef CATCOMP_STRINGS
#define CATCOMP_NUMBERS
#define CATCOMP_STRINGS
#endif

#ifdef CATCOMP_BLOCK
#undef CATCOMP_STRINGS
#define CATCOMP_STRINGS
#endif

#ifdef CATCOMP_NUMBERS

#define MSG_MENU_PROJECT 0
#define MSG_MENU_NEW 1
#define MSG_KEY_NEW 2
#define MSG_MENU_OPEN 3
#define MSG_KEY_OPEN 4
#define MSG_MENU_SAVE1 5
#define MSG_KEY_SAVE 6
#define MSG_MENU_SAVEAS 7
#define MSG_KEY_SAVEAS 8
#define MSG_MENU_PRINT 9
#define MSG_KEY_PRINT 10
#define MSG_MENU_PRINTAS 11
#define MSG_MENU_HIDE 12
#define MSG_MENU_REVEAL 13
#define MSG_MENU_CLOSE 14
#define MSG_MENU_ABOUT 15
#define MSG_KEY_ABOUT 16
#define MSG_MENU_EXIT 17
#define MSG_MENU_QUIT 18
#define MSG_KEY_QUIT 19
#define MSG_MENU_EDIT 20
#define MSG_MENU_CUT 21
#define MSG_KEY_CUT 22
#define MSG_MENU_COPY 23
#define MSG_KEY_COPY 24
#define MSG_MENU_PASTE 25
#define MSG_KEY_PASTE 26
#define MSG_MENU_ERASE 27
#define MSG_KEY_ERASE 28
#define MSG_MENU_UNDO 29
#define MSG_KEY_UNDO 30
#define MSG_MENU_REDO 31
#define MSG_MENU_MACROS 32
#define MSG_MENU_STARTLEARNING 33
#define MSG_MENU_STOPLEARNING 34
#define MSG_MENU_ASSIGNMACRO 35
#define MSG_MENU_LOAD 36
#define MSG_MENU_SAVE2 37
#define MSG_MENU_SETTINGS 38
#define MSG_MENU_CREATEICONS 39
#define MSG_KEY_CREATEICONS 40
#define MSG_MENU_LOADSETTINGS 41
#define MSG_MENU_SAVESETTINGS 42
#define MSG_MENU_SAVESETTINGSAS 43
#define MSG_MENU_USER 44
#define MSG_MENU_HELP 45
#define MSG_MENU_ICONIFY 46
#define MSG_MENU_MANUAL 47
#define MSG_KEY_MANUAL 48
#define MSG_MENU_POINTER 49
#define MSG_MENU_REVERT 50
#define MSG_KEY_REVERT 51
#define MSG_MENU_TITLEBAR 52
#define MSG_MENU_TOOLS 53
#define MSG_MENU_VIEW 54
#define MSG_CANTLOCK_NAMED 55
#define MSG_CANTLOCK_DEFAULT 56

#endif

#ifdef CATCOMP_STRINGS

#define MSG_MENU_PROJECT_STR "Project"
#define MSG_MENU_NEW_STR "New"
#define MSG_KEY_NEW_STR "N"
#define MSG_MENU_OPEN_STR "Open..."
#define MSG_KEY_OPEN_STR "O"
#define MSG_MENU_SAVE1_STR "Save"
#define MSG_KEY_SAVE_STR "S"
#define MSG_MENU_SAVEAS_STR "Save As..."
#define MSG_KEY_SAVEAS_STR "A"
#define MSG_MENU_PRINT_STR "Print"
#define MSG_KEY_PRINT_STR "P"
#define MSG_MENU_PRINTAS_STR "Print As..."
#define MSG_MENU_HIDE_STR "Hide"
#define MSG_MENU_REVEAL_STR "Reveal..."
#define MSG_MENU_CLOSE_STR "Close"
#define MSG_MENU_ABOUT_STR "About..."
#define MSG_KEY_ABOUT_STR "?"
#define MSG_MENU_EXIT_STR "Exit"
#define MSG_MENU_QUIT_STR "Quit..."
#define MSG_KEY_QUIT_STR "Q"
#define MSG_MENU_EDIT_STR "Edit"
#define MSG_MENU_CUT_STR "Cut"
#define MSG_KEY_CUT_STR "X"
#define MSG_MENU_COPY_STR "Copy"
#define MSG_KEY_COPY_STR "C"
#define MSG_MENU_PASTE_STR "Paste"
#define MSG_KEY_PASTE_STR "V"
#define MSG_MENU_ERASE_STR "Erase"
#define MSG_KEY_ERASE_STR "E"
#define MSG_MENU_UNDO_STR "Undo"
#define MSG_KEY_UNDO_STR "Z"
#define MSG_MENU_REDO_STR "Redo"
#define MSG_MENU_MACROS_STR "Macros"
#define MSG_MENU_STARTLEARNING_STR "Start Learning"
#define MSG_MENU_STOPLEARNING_STR "Stop Learning"
#define MSG_MENU_ASSIGNMACRO_STR "Assign Macro..."
#define MSG_MENU_LOAD_STR "Load..."
#define MSG_MENU_SAVE2_STR "Save..."
#define MSG_MENU_SETTINGS_STR "Settings"
#define MSG_MENU_CREATEICONS_STR "Create Icons?"
#define MSG_KEY_CREATEICONS_STR "I"
#define MSG_MENU_LOADSETTINGS_STR "Load Settings..."
#define MSG_MENU_SAVESETTINGS_STR "Save Settings"
#define MSG_MENU_SAVESETTINGSAS_STR "Save Settings As..."
#define MSG_MENU_USER_STR "User"
#define MSG_MENU_HELP_STR "Help"
#define MSG_MENU_ICONIFY_STR "Iconify"
#define MSG_MENU_MANUAL_STR "Manual..."
#define MSG_KEY_MANUAL_STR "M"
#define MSG_MENU_POINTER_STR "Pointer?"
#define MSG_MENU_REVERT_STR "Revert"
#define MSG_KEY_REVERT_STR "R"
#define MSG_MENU_TITLEBAR_STR "Titlebar?"
#define MSG_MENU_TOOLS_STR "Tools"
#define MSG_MENU_VIEW_STR "View"
#define MSG_CANTLOCK_NAMED_STR "Can't lock public screen \"%s\"!"
#define MSG_CANTLOCK_DEFAULT_STR "Can't lock default public screen!"

#endif

#ifdef CATCOMP_ARRAY

struct CatCompArrayType
{
    LONG   cca_ID;
    STRPTR cca_Str;
};

static const struct CatCompArrayType CatCompArray[] =
{
    {MSG_MENU_PROJECT,(STRPTR)MSG_MENU_PROJECT_STR},
    {MSG_MENU_NEW,(STRPTR)MSG_MENU_NEW_STR},
    {MSG_KEY_NEW,(STRPTR)MSG_KEY_NEW_STR},
    {MSG_MENU_OPEN,(STRPTR)MSG_MENU_OPEN_STR},
    {MSG_KEY_OPEN,(STRPTR)MSG_KEY_OPEN_STR},
    {MSG_MENU_SAVE1,(STRPTR)MSG_MENU_SAVE1_STR},
    {MSG_KEY_SAVE,(STRPTR)MSG_KEY_SAVE_STR},
    {MSG_MENU_SAVEAS,(STRPTR)MSG_MENU_SAVEAS_STR},
    {MSG_KEY_SAVEAS,(STRPTR)MSG_KEY_SAVEAS_STR},
    {MSG_MENU_PRINT,(STRPTR)MSG_MENU_PRINT_STR},
    {MSG_KEY_PRINT,(STRPTR)MSG_KEY_PRINT_STR},
    {MSG_MENU_PRINTAS,(STRPTR)MSG_MENU_PRINTAS_STR},
    {MSG_MENU_HIDE,(STRPTR)MSG_MENU_HIDE_STR},
    {MSG_MENU_REVEAL,(STRPTR)MSG_MENU_REVEAL_STR},
    {MSG_MENU_CLOSE,(STRPTR)MSG_MENU_CLOSE_STR},
    {MSG_MENU_ABOUT,(STRPTR)MSG_MENU_ABOUT_STR},
    {MSG_KEY_ABOUT,(STRPTR)MSG_KEY_ABOUT_STR},
    {MSG_MENU_EXIT,(STRPTR)MSG_MENU_EXIT_STR},
    {MSG_MENU_QUIT,(STRPTR)MSG_MENU_QUIT_STR},
    {MSG_KEY_QUIT,(STRPTR)MSG_KEY_QUIT_STR},
    {MSG_MENU_EDIT,(STRPTR)MSG_MENU_EDIT_STR},
    {MSG_MENU_CUT,(STRPTR)MSG_MENU_CUT_STR},
    {MSG_KEY_CUT,(STRPTR)MSG_KEY_CUT_STR},
    {MSG_MENU_COPY,(STRPTR)MSG_MENU_COPY_STR},
    {MSG_KEY_COPY,(STRPTR)MSG_KEY_COPY_STR},
    {MSG_MENU_PASTE,(STRPTR)MSG_MENU_PASTE_STR},
    {MSG_KEY_PASTE,(STRPTR)MSG_KEY_PASTE_STR},
    {MSG_MENU_ERASE,(STRPTR)MSG_MENU_ERASE_STR},
    {MSG_KEY_ERASE,(STRPTR)MSG_KEY_ERASE_STR},
    {MSG_MENU_UNDO,(STRPTR)MSG_MENU_UNDO_STR},
    {MSG_KEY_UNDO,(STRPTR)MSG_KEY_UNDO_STR},
    {MSG_MENU_REDO,(STRPTR)MSG_MENU_REDO_STR},
    {MSG_MENU_MACROS,(STRPTR)MSG_MENU_MACROS_STR},
    {MSG_MENU_STARTLEARNING,(STRPTR)MSG_MENU_STARTLEARNING_STR},
    {MSG_MENU_STOPLEARNING,(STRPTR)MSG_MENU_STOPLEARNING_STR},
    {MSG_MENU_ASSIGNMACRO,(STRPTR)MSG_MENU_ASSIGNMACRO_STR},
    {MSG_MENU_LOAD,(STRPTR)MSG_MENU_LOAD_STR},
    {MSG_MENU_SAVE2,(STRPTR)MSG_MENU_SAVE2_STR},
    {MSG_MENU_SETTINGS,(STRPTR)MSG_MENU_SETTINGS_STR},
    {MSG_MENU_CREATEICONS,(STRPTR)MSG_MENU_CREATEICONS_STR},
    {MSG_KEY_CREATEICONS,(STRPTR)MSG_KEY_CREATEICONS_STR},
    {MSG_MENU_LOADSETTINGS,(STRPTR)MSG_MENU_LOADSETTINGS_STR},
    {MSG_MENU_SAVESETTINGS,(STRPTR)MSG_MENU_SAVESETTINGS_STR},
    {MSG_MENU_SAVESETTINGSAS,(STRPTR)MSG_MENU_SAVESETTINGSAS_STR},
    {MSG_MENU_USER,(STRPTR)MSG_MENU_USER_STR},
    {MSG_MENU_HELP,(STRPTR)MSG_MENU_HELP_STR},
    {MSG_MENU_ICONIFY,(STRPTR)MSG_MENU_ICONIFY_STR},
    {MSG_MENU_MANUAL,(STRPTR)MSG_MENU_MANUAL_STR},
    {MSG_KEY_MANUAL,(STRPTR)MSG_KEY_MANUAL_STR},
    {MSG_MENU_POINTER,(STRPTR)MSG_MENU_POINTER_STR},
    {MSG_MENU_REVERT,(STRPTR)MSG_MENU_REVERT_STR},
    {MSG_KEY_REVERT,(STRPTR)MSG_KEY_REVERT_STR},
    {MSG_MENU_TITLEBAR,(STRPTR)MSG_MENU_TITLEBAR_STR},
    {MSG_MENU_TOOLS,(STRPTR)MSG_MENU_TOOLS_STR},
    {MSG_MENU_VIEW,(STRPTR)MSG_MENU_VIEW_STR},
    {MSG_CANTLOCK_NAMED,(STRPTR)MSG_CANTLOCK_NAMED_STR},
    {MSG_CANTLOCK_DEFAULT,(STRPTR)MSG_CANTLOCK_DEFAULT_STR},
};

#endif

#endif
