;
;   MEGABALL              by Ed Mackey
;      BOARD EDITOR          PO Box 475
;         v4.0              Wayne, PA 19087

;  Here is the source code, assembled with Assempro by Abacus.

;  DATA requires CHIP RAM.

VERSION = 4     ;Version byte in save file header.
MAXBANK = 60    ;Was 24.

GadSpc = Gadget1 - Gadget0

;EDSGADGET = 8         ;uncomment this for BoardEd.main_bds

       Include 'includes:IncludeMe'
       Include 'includes:intuition.offsets'
       Include 'includes:graphics.offsets'
       Include 'includes:diskfont.offsets'
       Include 'includes:icon.offsets'
       Include 'includes:dos.offsets'
       Include 'includes:iff.offsets'
       Include 'includes:exec/types.i'
       Include 'includes:MemVars'
       Include 'includes:libraries/reqbase.i'

; Some v39 gfx calls:

_LVOLoadRGB32          = -$372
_LVOAllocBitMap        = -$396
_LVOFreeBitMap         = -$39C
_LVOAllocSpriteDataA   = -$3FC
_LVOGetExtSpriteA      = -$3A2
_LVOFreeSpriteData     = -$408

; datatypes.library calls:

_LVONewDTObjectA       = -$30
_LVODisposeDTObject    = -$36
_LVOGetDTAttrsA        = -$42
_LVODoDTMethodA        = -$5A

; asl.library calls:

_LVOAllocAslRequest    = -$30
_LVOFreeAslRequest     = -$36
_LVOAslRequest         = -$3C

; intuition.library calls:

_LVOLockPubScreen      = -$1FE
_LVOUnLockPubScreen    = -$204

       ILABEL 'Includes:Amiga.L'

BoardEdAGA:
       bra.s   NoDebug
YesDebug:
       move    #1,Debug
NoDebug:
; a0 = args, d0 = arg len.
       move.l  a0,SaveArgs
       move.l  d0,ArgLen

       INIT_AMIGA   ;Run me from WB!

       bsr     run
       move.l  ExecBase,a6

       EXIT_AMIGA

SELECTUP   = $E8
SELECTDOWN = $68
MENUUP     = $E9
MENUDOWN   = $69

Whole_Thing = 50 * 20 * 21  ;21k

run:
       tst.l   PR_CLI(a4)   ;a4 was inited to our task ptr by INIT_AMIGA
       beq     YesWB
       cmp.l   #1,ArgLen
       bhi     Arg
       move.l  PR_CLI(a4),a0
       add.l   a0,a0
       add.l   a0,a0
       move.l  16(a0),d0
       lsl.l   #2,d0
       move.l  d0,SaveArgs
Arg:   moveq   #0,d0
YesWB: move.l  d0,WBMsg     ;d0 has WBMsg (unless from CLI), again I_A
       bsr     openint      ;open intuition.library
       beq     IntKicked    ;uh-oh.  Where's intuition?!?!
       bsr     opengfx
       beq     GfxKicked
       bsr     opendos
       beq     DosKicked
       move.l  #-1,OldDir
       tst     Debug
       beq     NoDB
       move.l  #DebugProgName,SaveArgs
       move.l  #DebugCurDirName,d1
       moveq   #-2,d2    ;ACCESS_READ
       move.l  dosbase,a6
       jsr     _LVOLock(a6)
       move.l  d0,d1
       bne     DB1
       clr     Debug
NoDB:  tst.l   WBMsg
       beq     NoWB
       clr.l   SaveArgs
       move.l  WBMsg,a0
       move.l  36(a0),a0    ;sm_ArgList
       cmp.l   #0,a0
       beq     NoWB
       move.l  (a0),d1
       move.l  4(a0),SaveArgs
       move.l  dosbase,a6
DB1:   jsr     _LVOCurrentDir(a6)
       move.l  d0,OldDir
NoWB:  
       bsr     opendiskfont
       beq     DiskFontKicked
       move.l  fontbase,a6      ;look for font
       lea     TextAttr,a0
       jsr     _LVOOpenDiskFont(a6)
       move.l  d0,Font
       tst.l   d0
       beq     dfk1
       move.l  #TextAttr,ScreenTextAttr
dfk1:  bsr     closediskfont
DiskFontKicked:
       bsr     openicon
       bsr     closeicon
       clr.l   DataTypesBase
       clr.l   iffbase
       bsr     opendatatypes
       beq     DataTypesKickedM
       bsr     openiff
       beq     IffKicked
       lea     Board1,a2
       bsr     CopyBoards
       tst     d0
       beq     BoardsKickedM
       tst     OS20
       beq     NoZap
       clr.l   Zap_If_20
NoZap: 

       lea     GfxNameNonAGAList,a2  ;Non-AGA gfx list.
       tst     v39
       beq     TryToLoadGfx    ;Was OldGfx
       lea     GfxNameList,a2
TryToLoadGfx:                  ;MegaBall Graphics Loader
       move.l  (a2)+,d1
       tst.l   d1
       beq     GfxKickedM      ;Out of MegaBall.Gfx.#? files
       move.l  #MODE_OLD,d2
       move.l  dosbase,a6
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       beq     TryToLoadGfx
       move.l  d0,d1
       move.l  #FakeRast,d2

HDRSIZ = 84

       moveq.l #HDRSIZ+8,d3
       jsr     _LVORead(a6)    ;Peek at this file
       cmp.l   #HDRSIZ+8,d0
       beq     ttlg1
ttlgX: move.l  d7,d1
       move.l  dosbase,a6
       jsr     _LVOClose(a6)
       bra     TryToLoadGfx
ttlg1: lea     FakeRast,a0
       cmp.l   #'MBG4',(a0)+      ;First longword = 'MBG4'
       bne     ttlgX
       addq.l  #2,a0              ;Next word = End exploder (ignored by BoardEd).
       move.w  (a0)+,Depth        ;Next word = Depth.
       move.w  (a0)+,FitchSubCol  ;Next word = color to inverse-blink
       move.w  (a0)+,FitchCol     ;Next word = color to blink
       moveq   #17,d0
       lea     Converter,a1       ; Next 72 bytes are Converter bytes.
h2c:   move.l  (a0)+,(a1)+
       dbra    d0,h2c
       cmp.l   #'FORM',(a0)+      ;Start of IFF
       bne     ttlgX
       move.l  (a0)+,d6           ;D6 = length of IFF - 8.
       bsr     scropen            ;Can we handle this Depth?
       beq     ttlgX
       bsr     allocbitmap        ;OK!  We got one, let's GO!
       beq     bitmap2kickedM
       move.l  d0,bit2map

       move.l  d6,d0
       addq.l  #8,d0           ;Add FORM+len to length.
       move.l  ExecBase,a6
       moveq   #0,d1
       jsr     _LVOAllocMem(a6)   ;Get mem for file
       move.l  d0,d5
       beq     ReadKickedM
       move.l  d0,a0
       move.l  #'FORM',(a0)+
       move.l  d6,(a0)+
       move.l  dosbase,a6
       move.l  d7,d1           ;d7 has filehandle
       move.l  a0,d2           ;d5 has memory (a0 has mem+8).
       move.l  d6,d3           ;d6 has length
       jsr     _LVORead(a6)
       move.l  d6,d1
       addq.l  #8,d6           ;Add FORM+len to length.
       cmp.l   d0,d1
       bne     ReadKickedMM    ;File read kicked, free d5/d6 and close d7!
       bsr     CloseD7

       tst     v39
       beq     OldGfx
       move.l  #MBgfxTempName,d1
       move.l  #MODE_NEW,d2
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       beq     RamKickedM      ;FreeD5D6.
       move.l  d0,d1
       move.l  d5,d2           ;First IFF
       move.l  d6,d3           ;Length.
       jsr     _LVOWrite(a6)
       move.l  d0,d4
       move.l  d7,d1
       jsr     _LVOClose(a6)
       cmp.l   d3,d4
       bne     RamKickedM
       move.l  bit2map,a5
       bsr     GetDTgfx
       bra     DTgfxOK

;  inputs: a5 = bitmap
; returns: d7 = DTobj
GetDTgfx:
       moveq   #0,d7
       move.l  DataTypesBase,a6
       move.l  #MBgfxTempName,d0
       lea     DTtags,a0
       jsr     _LVONewDTObjectA(a6)
       move.l  d0,d7
       beq     DTObjKickedM    ;Object kicked, pop.l, dispose d7!
       move.l  d7,a0
       suba.l  a1,a1
       suba.l  a2,a2
       lea     gpl,a3          ;Layout the object on our process.
       jsr     _LVODoDTMethodA(a6)
       tst.l   d0
       beq     DTObjKickedM    ;no mem?
;       move.l  d7,a0
;       suba.l  a1,a1
;       suba.l  a2,a2
;       lea     dtf,a3          ;Request a FrameInfo.
;       jsr     _LVODoDTMethodA(a6)
;       tst.l   d0
;       beq     DTObjKickedM
       move.l  d7,a0
       lea     DTGAtags,a2
       jsr     _LVOGetDTAttrsA(a6)
       cmp.l   #3,d0           ;number of attributes gotten.
       bne     DTObjKickedM
       tst.l   newbm
       beq     DTBitmapKickedM
       tst.l   CRegs
       beq     DTColsKickedM
       movem.l d5-d7,-(sp)
       move.l  gfxbase,a6
       move.l  newbm,a0
       moveq   #0,d0
       moveq   #0,d1
       move.l  a5,a1   ;Dest bitmap was passed in as a5.
       moveq   #0,d2
       moveq   #0,d3
       move.l  #320,d4
       move.l  #200,d5
       move    #$c0,d6
       move    #$ff,d7
       suba.l  a2,a2
       jsr     _LVOBltBitMap(a6)  ;Copy the gfx page
       movem.l (sp)+,d5-d7
       rts

DTgfxOK:
       bsr     FreeD5D6
       moveq   #0,d1
       move    Depth,d1
       moveq   #1,d0
       lsl.l   d1,d0
       clr.l   numcolors       ;clear # colors and initial color.
       move.w  d0,numcolors    ;write # colors.
       subq.l  #1,d0
       lea     ctable32,a0
       move.l  CRegs,a1
       lea     ctable,a2
       move.l  #28,d3
ColorMake:
       move.l  (a1)+,d2        ;R
       move.l  d2,(a0)+
       lsr.l   d3,d2
       move.l  d2,d1           ;d1 builds 4-bit color
       move.l  (a1)+,d2        ;G
       move.l  d2,(a0)+
       lsr.l   d3,d2
       lsl     #4,d1
       or      d2,d1
       move.l  (a1)+,d2        ;B
       move.l  d2,(a0)+
       lsr.l   d3,d2
       lsl     #4,d1
       or      d2,d1
       move    d1,(a2)+
       dbra    d0,ColorMake
       clr.l   (a0)+           ;Put end-of-colors mark.

       bsr     DisposeD7
       bsr     DeleteTemp
       bra     GfxOK

OldGfx:
       move.l  d5,a1
       move.l  bit2map,a0
       bsr     pic2plane      ;Sets ErrPtr if there's a problem.
       beq     PicKickedM
       bsr     FreeD5D6

GfxOK: bsr     ColorOn
       bsr     closedatatypes
       bsr     closeiff
       lea     NeedFix,a0
       move.l  #24,d0
NF1:   move    #$0101,(a0)+
       dbra    d0,NF1
       clr.b   NeedFix
       clr     DelFlip
       move    #1,CurWork
       move    #1,CurRow
       clr     ModePut
       lea     Board1,a0
       add.l   #20,a0
       move.l  a0,CPtr_
       move    #16,CX
       move    #14,CY
       lea     Gads50,a0
       move.l  #49,d1
       move.l  #15,d2
       move.l  #13,d3
NxtGad:move.l  a0,d0
       add.l   #44,d0
       tst     d1
       bne     SkpG
       moveq.l #0,d0
SkpG:  move.l  d0,(a0)+   ;Gadget -> NextGadget
       move    d2,(a0)+   ;LeftEdge
       move    d3,(a0)+   ;TopEdge
       add     #43,d2
       cmp     #278,d2
       blt     NNR     ;No Next Row
       move    #15,d2
       add     #23,d3
NNR:   lea     GadExamp+8,a1
       moveq.l #8,d4
FinG:  move.l  (a1)+,(a0)+
       dbra    d4,FinG
       dbra    d1,NxtGad
       bsr     wind2open
       beq     Wind2Kicked
       move.l  window2hd,a0
       move.l  50(a0),a0
       move.l  a0,Rast2
       move.l  #5,d4
       move.l  #22,d5
       move.l  #NumList,d6
       move.l  gfxbase,a6
       move.l  Rast2,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
Num1:  move.l  d4,d0
       move.l  d5,d1
       move.l  Rast2,a1
       jsr     _LVOMove(a6)
       move.l  d6,a0
       moveq.l #1,d0
       move.l  Rast2,a1
       jsr     _LVOText(a6)
       addq.l  #1,d6
       btst    #0,d6
       bne     Num2
       add     #7,d5
Num2:  addq    #8,d5
       cmp     #198,d5
       blt     Num1
       move.l  window2hd,a0
       move.l  86(a0),a0
       moveq.l #0,d0
       moveq.l #1,d1
       move.b  15(a0),d0
       lsl.l   d0,d1
       move.l  d1,Signals
       bsr     windopen      ;open my windows
       beq     WindKicked
       move.l  windowhd,a0
       move.l  86(a0),a0
       moveq.l #0,d0
       moveq.l #1,d1
       move.b  15(a0),d0
       lsl.l   d0,d1
       or.l    d1,Signals
       move.l  ExecBase,a6
       sub.l   a1,a1
       jsr     _LVOFindTask(a6)
       move.l  d0,a0
       move.l  d0,MyTsk
       move.l  184(a0),OldWindowPtr
       move.l  windowhd,184(a0)       ;Install new DOS requestors!
       clr.l   aslbase
       clr.l   AslFR
       clr.l   reqbase
       lea     AslAllocTags,a0
       move.l  windowhd,4(a0)
       bsr     openasl
       tst.l   AslFR
       bne     GotAsl
       bsr     openreq      ;open the req.library!
GotAsl:clr     Drawing
       clr     Changes
       clr     BigChg
       move.l  intbase,a6
       move.l  Rast2,a0
       lea     GetText,a1
       move.l  #102,d0
       move.l  #181,d1
       jsr     _LVOPrintIText(a6)
       move.l  gfxbase,a6
       move.l  windowhd,a4
       move.l  50(a4),a4
       move.l  a4,Rast
       bsr     DrawChoosers
       move.l  a4,a1
       moveq   #5,d0             ;Color of bounding dots!
       jsr     _LVOSetAPen(a6)
       move    #1,Selected
       move.l  #9,d4
       move.l  #14,d5
       moveq.l #0,d6
       moveq.l #0,d7
BdrDrw:xor     #1,d7
       tst     d7
       beq     DD
       move    d4,d0
       move    d5,d1
       move.l  a4,a1
       jsr     _LVOWritePixel(a6)
DD:    tst     d6
       bne     BD2
       addq    #1,d4
       cmp     #310,d4
       blt     BdrDrw
       addq    #1,d6
       bra     BdrDrw
BD2:   cmp     #1,d6
       bne     BD3
       addq    #1,d5
       cmp     #155,d5
       blt     BdrDrw
       addq    #1,d6
       bra     BdrDrw
BD3:   cmp     #2,d6
       bne     BD4
       subq    #1,d4
       cmp     #9,d4
       bgt     BdrDrw
       addq    #1,d6
       bra     BdrDrw
BD4:   subq    #1,d5
       cmp     #15,d5
       bgt     BdrDrw
       move.l  #118,d0
       move.l  #166,d1
       move.l  Rast,a1
       jsr     _LVOMove(a6)
       moveq.l #1,d0
       move.l  Rast,a1
       jsr     _LVOSetAPen(a6)
       move.l  Rast,a1
       lea     Using,a0
       move.l  #end_Using-Using,d0
       jsr     _LVOText(a6)
       lea     MyName,a1
       lea     MyNameHere,a2
       move.l  #21,d0
FixName:
       move.b  #$aa,d1
       sub.b   (a1)+,d1
       move.b  d1,(a2)+
       dbra    d0,FixName
       move.l  intbase,a6
       move.l  windowhd,a0
       lea     b5text,a1
       lea     0,a2
       lea     r5text,a3
       clr.l   d0
       clr.l   d1
       move.l  #320,d2
       move.l  #116,d3
       jsr     _LVOAutoRequest(a6)
       lea     ReDrwBuf,a0
       move.l  #99,d0
KRDB:  move.l  #-1,(a0)+     ;Kill the redraw buffer
       dbra    d0,KRDB
ClrBoard:
       clr     Changes
       lea     Board,a0
       move.l  #104,d0   ;420/4 = 105
ClBd:  clr.l   (a0)+
       dbra    d0,ClBd
ReDrwBrd:
       lea     Board+20,a4
       lea     ReDrwBuf,a5
       moveq.l #1,d5
       moveq.l #0,d4
NxtBlk:moveq.l #0,d0
       move.b  (a4)+,d0
       cmp.b   (a5)+,d0
       beq     SkipMe
       move.b  d0,-1(a5)
;       move.l  intbase,a6
;       mulu    #ImgSpc,d0
;       lea     Img0,a1
;       add.l   d0,a1
       move.l  d0,a1
       move.l  d4,d0
       move.l  d5,d1
       mulu    #15,d0
       mulu    #7,d1
       add.l   #10,d0
       addq.l  #8,d1
       move.l  Rast,a0
;       jsr     _LVODrawImage(a6)
       bsr     DrawBlock
SkipMe:addq    #1,d4
       cmp     #20,d4
       blt     NxtBlk
       moveq.l #0,d4
       addq    #1,d5
       cmp     #21,d5
       blt     NxtBlk
SelNew:;move.l  intbase,a6
       suba.l  a1,a1
       move    Selected,a1
;       mulu    #ImgSpc,d0
;       lea     Img0,a1
;       add.l   d0,a1
       move.l  #168,d0
       move.l  #160,d1
       move.l  Rast,a0
;       jsr     _LVODrawImage(a6)
       bsr     DrawBlock
loop:
       bsr     ColorFitch
       tst     CurWork
       bne     DrSome
;       move.l  ExecBase,a6
       move.l  gfxbase,a6
;       move.l  Signals,d0
       jsr     _LVOWaitTOF(a6)
DSR:   moveq.l #0,d7
loop2:
       move.l  window2hd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)
       tst.l   d0
       bne     ReadMsg
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;read in the gadget message.
       tst.l   d0
       bne     ReadMsg
       cmp     #0,d7
       beq     loop
       cmp     #2,d7
       beq     SelNew
       cmp     #3,d7
       beq     ClearAll
       cmp     #4,d7
       beq     IntoEditor
       cmp     #5,d7
       beq     OutSource
       cmp     #6,d7
       beq     InBoards
       cmp     #7,d7
       beq     OutBoards
       cmp     #8,d7
       beq     AllUp
       cmp     #9,d7
       beq     AllDn
       cmp     #10,d7
       beq     AllLf
       cmp     #11,d7
       beq     AllRt
       cmp     #12,d7
       beq     UndoAll
ende:
       bsr     AskMeAll
       beq     loop
       bsr     closeasl
       bsr     closereq
       move.l  MyTsk,a0
       move.l  OldWindowPtr,184(a0)  ;replace old DOS requestors.
       bsr     windclose
WindKicked:
       bsr     wind2close
Wind2Kicked:
       move.l  bit2map,a0
       bsr     freebitmap
bitmap2kicked:
       bsr     scrclose    ;clean up this stuff.
ScrKicked:                 ;BoardsKickedM joins us here.
DataTypesKicked:
IffKicked:
       bsr     closedatatypes   ;These two check for NULL bases.
       bsr     closeiff
       tst.l   Font
       beq     FontKicked
       move.l  gfxbase,a6
       move.l  Font,a1
       jsr     _LVOCloseFont(a6)
FontKicked:
       cmp.l   #-1,OldDir
       beq     NoChB
       move.l  dosbase,a6
       move.l  OldDir,d1
       jsr     _LVOCurrentDir(a6)
       tst     Debug
       beq     NoChB
       move.l  d0,d1
       jsr     _LVOUnLock(a6)
NoChB:
       bsr     closedos
DosKicked:
       bsr     closegfx
GfxKicked:
       tst.l   ErrPtr
       beq     NoErrs
       move.l  intbase,a6
       suba.l  a5,a5   ;a5 = pubscreen handle
       tst     OS20
       beq     NAjEr   ;No Adjust Error window.
       suba.l  a0,a0
       jsr     _LVOLockPubScreen(a6)
       move.l  d0,a5
       tst.l   d0
       beq     NAjEr
       lea     Errwindowdef,a0
       move.l  a5,$1e(a0)      ;NewWindow -> Screen
       move.w  #2,$2e(a0)      ;#PUBLICSCREEN, NewWindow -> Type
       moveq   #0,d0
       move.b  $23(a5),d0      ;Screen -> WBorTop
       move.l  $28(a5),a1      ;Screen -> Font
       add     4(a1),d0        ;TextAttr -> ta_YSize
       addq    #1,d0
       move.w  d0,6(a0)        ;NewWindow -> Height
NAjEr: lea     Errwindowdef,a0
       jsr     _LVOopenwindow(a6)   ;make my Error window.
       move.l  d0,windowhd
       tst.l   d0
       beq     NoEW
       move.l  ExecBase,a6
       move.l  windowhd,a0
       move.l  86(a0),a0
       jsr     _LVOWaitPort(a6)  ;wait for the close gadget.
       move.l  intbase,a6
       move.l  windowhd,a0
       jsr     _LVOCloseWindow(a6)
NoEW:  cmp.l   #0,a5
       beq     NoErrs
       suba.l  a0,a0
       move.l  a5,a1
       jsr     _LVOUnlockPubScreen(a6)
NoErrs:bsr     closeint
IntKicked:
       rts   ;that's all folks!
BoardsKickedM:
       move.l  #no_boards,ErrPtr
       bra     ScrKicked
DataTypesKickedM:
       move.l  #no_datatypes,ErrPtr
       bra     DataTypesKicked
CloseD7:
       move.l  dosbase,a6
       move.l  d7,d1
       jsr     _LVOClose(a6)
       rts
FreeD5D6:
       move.l  ExecBase,a6
       move.l  d5,a1
       move.l  d6,d0
       jsr     _LVOFreeMem(a6)
       rts
bitmap2kickedM:
       bsr     CloseD7
       move.l  #no_bitmap,ErrPtr
       bra     bitmap2kicked
ReadKickedMM:
       bsr     FreeD5D6
ReadKickedM:
       bsr     CloseD7
       move.l  #no_gfx,ErrPtr
       bra     Wind2Kicked
DisposeD7:
       move.l  DataTypesBase,a6
       move.l  d7,a0
       jsr     _LVODisposeDTObject(a6)
       rts
DeleteTemp:
       move.l  dosbase,a6
       move.l  #MBgfxTempName,d1
       jsr     _LVODeleteFile(a6)
       rts
RamKickedM:
       bsr     FreeD5D6
       move.l  #no_ram,ErrPtr
       bra     Wind2Kicked
PicKickedM:
       bsr     FreeD5D6
       bra     Wind2Kicked
DTObjKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_gfx,ErrPtr
       bra     Wind2Kicked
DTColsKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_cols,ErrPtr
       bra     Wind2Kicked
DTBitmapKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_DTbm,ErrPtr
       bra     Wind2Kicked
GfxKickedM:
       move.l  #no_gfx,ErrPtr
       bra     ScrKicked
ReadMsg:
       move.l  d0,a5
       move.l  a5,-(sp)
       move.l  20(a5),d0
       and.l   #$200,d0
       cmp.l   #0,d0
       beq     NotClose
       moveq.l #1,d7
       bra     Reply
NotClose:
       move.l  20(a5),d0
       cmp.l   #$8,d0
       bne     NotMB
       cmp.w   #MENUDOWN,24(a5)
       bne     NotDw2
       move    #2,Drawing
       clr     DrawWith
       bra     DrMe
NotDw2:cmp.w   #MENUUP,24(a5)
       bne     NotDw1
       clr     Drawing
       bra     Reply
NotDw1:cmp.w   #SELECTDOWN,24(a5)
       bne     NotDw
       move    #2,Drawing
       move    Selected,DrawWith
       bra     DrMe
NotDw: cmp.w   #SELECTUP,24(a5)
       bne     Reply
       clr     Drawing
       bra     Reply
NotMB:
       tst     Drawing
       beq     NotMM
       move.l  20(a5),d0
       cmp.l   #$10,d0
       bne     NotMM
DrMe:  moveq.l #0,d4
       moveq.l #0,d5
       move    32(a5),d4
       move    34(a5),d5
       cmp     #14,d5
       ble     Reply
       cmp     #155,d5
       bge     Reply
       cmp     #9,d4
       ble     Reply
       cmp     #310,d4
       bge     Reply
       cmp     #2,Drawing
       bne     NoCTU
       bsr     CopyToUndo
NoCTU: move    #1,Drawing
       subq    #8,d5
       sub     #10,d4
       divu    #7,d5
       divu    #15,d4
       move    d4,-(sp)
       move    d5,-(sp)
       moveq.l #0,d6
       move    #19,d0
       move    #21,d1
       sub     d4,d0
       sub     d5,d1
       move    FlgVer,d3
       and     #$80,d3
       tst     d3
       beq     NoVer
       addq    #1,d6
       move    d4,-(sp)
       move    d1,-(sp)
NoVer: move    FlgPol,d3
       and     #$80,d3
       tst     d3
       beq     NoPol
       addq    #1,d6
       move    d0,-(sp)
       move    d1,-(sp)
NoPol: move    FlgHor,d3
       and     #$80,d3
       tst     d3
       beq     NoHor
       addq    #1,d6
       move    d0,-(sp)
       move    d5,-(sp)
NoHor: move    FlgDia,d3
       and     #$80,d3
       tst     d3
       beq     Sym1
       move.l  d6,d0
       move.l  sp,a0       ;My very own copy of the stack pointer!
Dia1:  move    #20,d1
       sub     (a0)+,d1
       move    d1,-(sp)
       move    #20,d1
       sub     (a0)+,d1
       move    d1,-(sp)
       addq    #1,d6
       dbra    d0,Dia1
Sym1:  move    (sp)+,d5
       move    (sp)+,d4
       move.l  #20,d0
       and.l   #$ffff,d4
       and.l   #$ffff,d5
       mulu    d5,d0
       add     d4,d0
       lea     Board,a0
       move    DrawWith,d1
       cmp.b   (a0,d0.w),d1
       beq     NxtSym
       lea     ReDrwBuf-20,a1
       move.b  d1,(a0,d0.w)
       move.b  d1,(a1,d0.w)
       move    #1,Changes
;       move.l  intbase,a6
       move    d1,a1
;       mulu    #ImgSpc,d0
;       lea     Img0,a1
;       add.l   d0,a1
       move.l  #10,d0
       moveq.l #8,d1
       mulu    #15,d4
       mulu    #7,d5
       add.l   d4,d0
       add.l   d5,d1
       move.l  Rast,a0
;       jsr     _LVODrawImage(a6)
       bsr     DrawBlock
NxtSym:dbra    d6,Sym1
NotMM:
       cmp.l   #$20,20(a5)
       bne     NotGadDwn
       move.l  28(a5),d0
       cmp.l   #gadget0,d0
       blo     Reply
       cmp.l   #gadget11,d0
       bhi     Reply
       moveq.l #2,d7
       sub.l   #gadget0,d0
       divu    #GadSpc,d0
       add     BankSel,d0
       move    d0,Selected
       bra     Reply
NotGadDwn:
       cmp.l   #$40,20(a5)
       bne     Reply
       move.l  28(a5),d0
       cmp.l   #GadClear,d0
       bne     NGD1
       moveq.l #3,d7
       bra     Reply
NGD1:  cmp.l   #GadUp,d0
       bne     NotUp
       move.l  #8,d7
       bra     Reply
NotUp: cmp.l   #GadDn,d0
       bne     NotDn
       move.l  #9,d7
       bra     Reply
NotDn: cmp.l   #GadLf,d0
       bne     NotLf
       move.l  #10,d7
       bra     Reply
NotLf: cmp.l   #GadRt,d0
       bne     NotRt
       move.l  #11,d7
       bra     Reply
NotRt: cmp.l   #GadInc,d0
       bne     NotInc
       add     #12,BankSel
       cmp     #MAXBANK,BankSel
       ble     ni1
       clr     BankSel
       bra     ni1
NotInc:cmp.l   #GadDec,d0
       bne     NotDec
       sub     #12,BankSel
       tst     BankSel
       bge     ni1
       move    #MAXBANK,BankSel
ni1:   bsr     DrawChoosers
       bra     Reply
NotDec:cmp.l   #GadUnd,d0
       bne     NotUnd
       move.l  #12,d7
       bra     Reply
NotUnd:cmp.l   #GadGet,d0
       bne     NGD2
       clr     ModePut
       bsr     CallWind2
       move.l  intbase,a6
       move.l  Rast2,a0
       lea     GetText,a1
       move.l  #102,d0
       move.l  #181,d1
       jsr     _LVOPrintIText(a6)
       bra     Reply
NGD2:  cmp.l   #GadCnc,d0
       bne     NGD3
       clr     ModePut
       bsr     CallWind1
       move.l  intbase,a6
       move.l  Rast2,a0
       lea     GetText,a1
       move.l  #102,d0
       move.l  #181,d1
       jsr     _LVOPrintIText(a6)
       bra     Reply
NGD3:  cmp.l   #Gads50,d0
       blo     NGD4
       cmp.l   #End_Gads50,d0
       bhs     NGD4
       sub.l   #Gads50,d0
       divu    #44,d0
       moveq.l #4,d7
       move    d0,LastBoard
       bra     Reply
NGD4:  cmp.l   #GadPut,d0
       bne     NGD5
       move    #1,ModePut
       bsr     CallWind2
       move.l  intbase,a6
       move.l  Rast2,a0
       lea     PutText,a1
       move.l  #102,d0
       move.l  #181,d1
       jsr     _LVOPrintIText(a6)
       bra     Reply
NGD5:
       cmp.l   #GadSrc,d0
       bne     NGD6
       moveq.l #5,d7
       bra     Reply
NGD6:
       cmp.l   #GadLod,d0
       bne     NGD7
       moveq.l #6,d7
       bra     Reply
NGD7:
       cmp.l   #GadSav,d0
       bne     Reply
       moveq.l #7,d7
Reply:
       and     #1,Drawing
       move.l  (sp)+,a5
       move.l  a5,a1
       move.l  ExecBase,a6
       jsr     _LVOReplyMsg(a6)
       bra     Loop2
ClearAll:
       bsr     AskMeFirst
       beq     loop
       bsr     CopyToUndo
       bra     ClrBoard
UndoAll:
       lea     Board+20,a0
       lea     UndoBoard+20,a1
       move.l  #99,d1     ;400/4 - 1
UA1:   move.l  (a0),d0
       move.l  (a1),(a0)+
       move.l  d0,(a1)+
       dbra    d1,UA1
       bra     ReDrwBrd
CopyToUndo:
       movem.l d1/a0/a1,-(sp)
       lea     Board+20,a0
       lea     UndoBoard+20,a1
       move.l  #99,d1
UA2:   move.l  (a0)+,(a1)+
       dbra    d1,UA2
       movem.l (sp)+,d1/a0/a1
       rts
AllUp:
       lea     Board+20,a0
       move.l  a0,a1
       lea     MemBlkBuf,a2
       move.l  #4,d1
AU1:   move.l  (a1)+,(a2)+
       dbra    d1,AU1
       move.l  #94,d1      ;(400-20)/4 - 1 = 94
AU2:   move.l  (a1)+,(a0)+
       dbra    d1,AU2
       lea     MemBlkBuf,a2
       moveq.l #4,d1
AU3:   move.l  (a2)+,(a0)+
       dbra    d1,AU3
       bra     ReDrwBrd
AllDn:
       lea     Board+420,a0
       move.l  a0,a1
       lea     MemBlkBuf+20,a2
       move.l  #4,d1
AD1:   move.l  -(a1),-(a2)
       dbra    d1,AD1
       move.l  #94,d1      ;(400-20)/4 - 1 = 94
AD2:   move.l  -(a1),-(a0)
       dbra    d1,AD2
       lea     MemBlkBuf+20,a2
       moveq.l #4,d1
AD3:   move.l  -(a2),-(a0)
       dbra    d1,AD3
       bra     ReDrwBrd
AllLf:
       lea     Board+20,a0
       move.l  #19,d1
       move.l  a0,a1
       addq.l  #1,a1
AL3:   move.l  #18,d2
       move.b  (a0),d3
AL2:   move.b  (a1)+,(a0)+
       dbra    d2,AL2
       addq.l  #1,a1
       move.b  d3,(a0)+
       dbra    d1,AL3
       bra     ReDrwBrd
AllRt:
       lea     Board+420,a0
       move.l  #19,d1
       move.l  a0,a1
       subq.l  #1,a1
AR3:   move.l  #18,d2
       move.b  -1(a0),d3
AR2:   move.b  -(a1),-(a0)
       dbra    d2,AR2
       subq.l  #1,a1
       move.b  d3,-(a0)
       dbra    d1,AR3
       bra     ReDrwBrd

InAslBoards:
       move.l  windowhd,a0
       lea     AslLoading,a1
       move.l  #-1,a2
       move.l  intbase,a6
       jsr     _LVOSetWindowTitles(a6)
       move.l  AslFR,a0
       lea     AslReqTags,a1
       clr.l   12(a1)      ;DoSaveMode = FALSE
       move.l  aslbase,a6
       jsr     _LVOAslRequest(a6)
       tst     d0
       beq     AslDonLod

       lea     strpuffer2,a0
       move.l  AslFR,a1
       move.l  8(a1),a1    ;fr_Drawer
       cmp.l   #0,a1
       beq     IAB1
       tst.b   (a1)
       beq     IAB1
IAB2:  move.b  (a1)+,(a0)+
       bne     IAB2
       subq.l  #1,a0
       cmp.b   #':',-1(a0)
       beq     IAB1
       cmp.b   #'/',-1(a0)
       beq     IAB1
       move.b  #'/',(a0)+
IAB1:  move.l  AslFR,a1
       move.l  4(a1),a1    ;fr_File
       cmp.l   #0,a1
       beq     IAB3
       tst.b   (a1)
       beq     IAB3
IAB4:  move.b  (a1)+,(a0)+
       bne     IAB4
IAB3:  clr.b   (a0)
       bra     AslLod
AslNFdErr:
       lea     AslReqTags,a1
       move.l  #f_FNF,4(a1)
       bra     InAslBoards
AslVerErr:
       lea     AslReqTags,a1
       move.l  #f_VER,4(a1)
       bra     InAslBoards
AslLodErr:
       lea     AslReqTags,a1
       move.l  #f_NBD,4(a1)
       bra     InAslBoards
AslDonLod:
       move.l  windowhd,a0
       lea     windname,a1
       move.l  #-1,a2
       move.l  intbase,a6
       jsr     _LVOSetWindowTitles(a6)
       bra     loop
InBoards:
       move    changes,-(sp)
       clr     changes
       bsr     AskMeAll
       move    (sp)+,changes
       tst     d3
       beq     loop
       lea     AslReqTags,a1
       move.l  #wind3nameL,4(a1)
       tst.l   AslFR
       bne     InAslBoards
       move.l  #wind3nameL,W3N
       tst.l   reqbase
       bne     RKik1
       move.l  #gascLod,GoP
RKik1: bsr     wind3open
       beq     loop
       tst.l   reqbase
       bne     LSreqLoop
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #ReqText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)   ;You need V1+ of req.library!!
LSreqLoop:
       tst.l   reqbase
       beq     LSloop
       move.l  f_Flags,d0
       lea     FileRequestor,a0
       add.l   #FRQLOADINGM,d0
       move.l  d0,frq_Flags(a0)
       move.l  #wind3nameL,frq_Title(a0)
       move.l  reqbase,a6
       jsr     _LVOFileRequester(a6)
       tst     d0
       beq     LodOps
       bra     LSreqG
LSloop:
       move.l  window3hd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)
       tst.l   d0
       bne     LSReadMsg
       move.l  window3hd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOWaitPort(a6)
       bra     LSloop
LSReadMsg:
       move.l  d0,a1
       move.l  20(a1),d2
       move.l  28(a1),d3
       jsr     _LVOReplyMsg(a6)
       cmp.l   #$40,d2
       bne     LSloop
       cmp.l   #GadOps,d3
       beq     LodOps
       cmp.l   #GadGo,d3
       bne     LSloop
       tst.l   reqbase
       bne     LSreqLoop
LSreqG:tst.b   strpuffer2
       beq     LSreqLoop
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #LodText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
AslLod:move.l  dosbase,a6
       move.l  #MODE_OLD,d2
       move.l  #strpuffer2,d1
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       tst.l   d7
       beq     NFdErr
       move.l  d7,d1
       move.l  #LodSavHdr,d2
       move.l  #21012,d3
       jsr     _LVORead(a6)
       move.l  d0,d6
       move.l  d7,d1
       jsr     _LVOClose(a6)
       move.l  LodSavHdr,d0
       clr.b   d0    ;Clear JUST the low byte.
       cmp.l   #'BDS'<<8,d0
       bne     NoV
       subq.l  #4,d6
       cmp.b   #VERSION,LodSavHdr+3
       ble     Vok
       bra     VerErr
NoV:   lea     LodSavHdr+21008,a0
       lea     4(a0),a1
       move.l  #5251,d0   ;21008 / 4 - 1
NoVb:  move.l  -(a0),-(a1)
       dbra    d0,NoVb
Vok:   lea     Board1,a2
       bsr     DecodeBoards
       tst     d0
       beq     LodErr
       bra     INBc

CopyBoards:    ;Send boards to (a2)+
       movem.l d0/a2,-(sp)
       move.l  #(Whole_Thing/4)-1,d0
CpBds1:clr.l   (a2)+
       dbra    d0,CpBds1
       movem.l (sp)+,d0/a2
       rts

;       movem.l d1-a6,-(sp)
;       lea     CompressedBoards,a0
;       lea     Chk2,a1
;       move.l  #(CompBoardSiz-1),d0
;       lsr     #2,d0
;CpBds1:move.l  (a0)+,(a1)+
;       dbra    d0,CpBds1
;       move.l  #CompBoardSiz,d6
;       bsr     DecodeBoards
;       movem.l (sp)+,d1-a6
;       rts

;a2 = dest
;d6 = size
DecodeBoards:
       cmp.l   #20,d6
       ble     DecErr
       subq.l  #8,d6
       lsr.l   #2,d6
       move.l  d6,d3
       lea     chk1,a3
;       move.l  #5250,d3
       move.l  chk2,d5      ;d5 = chk2
Mov1:  sub.l   (a3)+,d5
       dbra    d3,Mov1
       tst.l   d5           ;d5 = MyKey (of saved file) XOR $ad6c72e5
       beq     DecErr
       cmp.l   #$ad6c72e5,d5
       beq     DecErr
;       move.l  #5250,d3
       move.l  d6,d3
       lea     chk1,a3
Mov2:  xor.l   d5,(a3)+
       dbra    d3,Mov2
       moveq.l #0,d4
;       move.l  #5249,d3
       move.l  d6,d3
       subq.l  #1,d3
       lea     LodSavBuf,a3
Mov3:  add.l   (a3)+,d4
       dbra    d3,Mov3
       cmp.l   chk1,d4
       bne     DecErr
       move.l  #20999,d3
       lea     LodSavBuf,a3
       moveq.l #0,d0
INB1:  tst.b   d0
       blt     INBa
       tst.b   d0
       bgt     INBb
       move.b  (a3)+,d0
       bra     INB1
INBa:  add.b   #1,d0
       beq     INBaa
       move.b  (a3),(a2)+
       dbra    d3,INBa
       moveq   #1,d0
       rts
INBb:  subq    #1,d0
INBaa: move.b  (a3)+,(a2)+
       dbra    d3,INB1
       moveq   #1,d0
       rts
DecErr:moveq   #0,d0
       rts

INBc:  lea     NeedFix,a1
       move.l  #24,d3
INB2:  move.w  #$0101,(a1)+
       dbra    d3,INB2
       clr     BigChg
       tst.l   AslFR
       bne     INB2b
       bsr     wind3close
INB2b: move.l  intbase,a6
       move.l  #GadCnc,a0
       move.l  window2hd,a1
       move.l  #0,a2
       jsr     _LVORefreshGadgets(a6)
       move    #-1,CurWork
       tst.l   AslFR
       bne     AslDonLod
       bra     loop
LodOps:
       bsr     wind3close
       bra     loop
LodErr:
       tst.l   AslFR
       bne     AslLodErr
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #CorText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
       bra     LSloop
NFdErr:
       tst.l   AslFR
       bne     AslNFdErr
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #NFdText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
       bra     LSloop
VerErr:
       tst.l   AslFR
       bne     AslVerErr
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #VerText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
       bra     LSloop

OutAslBoards:
       move.l  windowhd,a0
       lea     AslSaving,a1
       move.l  #-1,a2
       move.l  intbase,a6
       jsr     _LVOSetWindowTitles(a6)
       move.l  AslFR,a0
       lea     AslReqTags,a1
       move.l  #-1,12(a1)    ;DoSaveMode = TRUE
       move.l  aslbase,a6
       jsr     _LVOAslRequest(a6)
       tst     d0
       beq     AslDonSav

       lea     strpuffer2,a0
       move.l  AslFR,a1
       move.l  8(a1),a1    ;fr_Drawer
       cmp.l   #0,a1
       beq     OAB1
       tst.b   (a1)
       beq     OAB1
OAB2:  move.b  (a1)+,(a0)+
       bne     OAB2
       subq.l  #1,a0
       cmp.b   #':',-1(a0)
       beq     OAB1
       cmp.b   #'/',-1(a0)
       beq     OAB1
       move.b  #'/',(a0)+
OAB1:  move.l  AslFR,a1
       move.l  4(a1),a1    ;fr_File
       cmp.l   #0,a1
       beq     OAB3
       tst.b   (a1)
       beq     OAB3
OAB4:  move.b  (a1)+,(a0)+
       bne     OAB4
OAB3:  clr.b   (a0)
       bra     AslSav
AslSavErr:
       lea     AslReqTags,a1
       move.l  #f_SER,4(a1)
       bra     OutAslBoards
AslDonSav:
       move.l  windowhd,a0
       lea     windname,a1
       move.l  #-1,a2
       move.l  intbase,a6
       jsr     _LVOSetWindowTitles(a6)
       bra     loop
OutBoards:
       tst     Changes
       beq     NoDave
       move.l  intbase,a6
       move.l  windowhd,a0
       moveq.l #0,d0
       jsr     _LVOReportMouse(a6)
       move.l  windowhd,a0
       lea     b4text,a1
       lea     0,a2
       tst     BigChg
       beq     Goof
       lea     l4text,a2
Goof:  lea     r4text,a3
       clr.l   d0
       clr.l   d1
       move.l  #320,d2
       move.l  #68,d3
       jsr     _LVOAutoRequest(a6)
       move    d0,d3
       move.l  windowhd,a0
       move.l  #-1,d0
       jsr     _LVOReportMouse(a6)
       tst     d3
       beq     loop
NoDave:lea     AslReqTags,a1
       move.l  #wind3nameS,4(a1)
       tst.l   AslFR
       bne     OutAslBoards
       move.l  #wind3nameS,W3N
       tst.l   reqbase
       bne     RKik2
       move.l  #gascSav,GoP
RKik2: bsr     wind3open
       beq     loop
       tst.l   reqbase
       bne     SSreqLoop
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #ReqText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)   ;You need V1+ of req.library!!
SSreqLoop:
       tst.l   reqbase
       beq     SSloop
       move.l  f_Flags,d0
       lea     FileRequestor,a0
       add.l   #FRQSAVINGM,d0
       move.l  d0,frq_Flags(a0)
       move.l  #wind3nameS,frq_Title(a0)
       move.l  reqbase,a6
       jsr     _LVOFileRequester(a6)
       tst     d0
       beq     SavOps
       bra     SSreqG
SSloop:
       move.l  window3hd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)
       tst.l   d0
       bne     SSReadMsg
       move.l  window3hd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOWaitPort(a6)
       bra     SSloop
SSReadMsg:
       move.l  d0,a1
       move.l  20(a1),d2
       move.l  28(a1),d3
       jsr     _LVOReplyMsg(a6)
       cmp.l   #$40,d2
       bne     SSloop
       cmp.l   #GadOps,d3
       beq     SavOps
       cmp.l   #GadGo,d3
       bne     SSloop
       tst.l   reqbase
       bne     SSreqLoop
SSreqG:tst.b   strpuffer2
       beq     SSreqLoop
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #SavText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
AslSav:lea     Board1,a2    ;a2 = cptr_
       lea     LodSavBuf,a3 ;a3 = wptr
       moveq.l #0,d0        ;d0 = temp
       moveq.l #0,d2        ;d2 = Mode
       moveq.l #0,d3        ;d3 = Last
Cmpr1: move.l  a3,a4        ;a4 = addr
       addq.l  #1,a3
       moveq.l #0,d2
       move.b  (a2),d3
       addq    #1,d3
Cmpr2: move.b  (a2),d0
       cmp.b   d0,d3
       bne     Cmpr3
       cmp.b   1(a2),d3
       beq     Cmpr5
Cmpr3: move    d0,d3
       move.b  d0,(a3)+
       addq.l  #1,a2
       addq    #1,d2
       cmp.b   #127,d2
       beq     Cmpr4
       cmp.l   #end_allBoards,a2
       blt     Cmpr2
Cmpr4: move.b  d2,(a4)
       cmp.l   #end_AllBoards,a2
       beq     CmprE
       bra     Cmpr1
Cmpr5: sub.b   #1,d2
       move.b  d2,(a4)
       move.l  a3,a4
       subq.l  #1,a4
       move.b  #-1,d2
       move.b  d3,(a3)+
Cmpr6: cmp.b   (a2),d3
       bne     Cmpr4
       sub.b   #1,d2
       addq.l  #1,a2
       cmp.b   #-127,d2
       beq     Cmpr4
       cmp.l   #end_allboards,a2
       blt     Cmpr6
       bra     Cmpr4
CmprE: move.l  a3,d3
       lea     LodSavBuf,a3
       move.l  MyKey,d2
       xor.l   #$ad6c72e5,d2    ;d2 = key
       sub.l   #LodSavBuf,d3
       or.b    #3,d3
       addq.l  #1,d3
       move.l  d3,a4
       addq.l  #8,a4
       lsr.l   #2,d3
       subq    #1,d3
;       move.l  #5249,d3
       moveq.l #0,d4        ;d4 = chk1
       moveq.l #0,d5        ;d5 = chk2
Mov4:  move.l  (a3),d0
       add.l   d0,d4
       xor.l   d2,d0
       add.l   d0,d5
       move.l  d0,(a3)+
       dbra    d3,Mov4
       xor.l   d2,d4
       add.l   d4,d5
       move.l  d4,chk1
       add.l   d2,d5
       move.l  d5,chk2
       move.l  dosbase,a6
       move.l  #MODE_NEW,d2
       move.l  #strpuffer2,d1
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       tst.l   d7
       beq     SavErr
       move.l  d7,d1
 IFND EDSGADGET
       move.l  #LodSavHdr,d2
       move.l  #(('BDS'<<8)+VERSION),LodSavHdr
       addq.l  #4,a4   ;Size of LodSavHdr
 ELSE
       move.l  #Chk2,d2
 ENDIF
       move.l  a4,d3
       jsr     _LVOWrite(a6)
       move.l  d0,d6
       move.l  d7,d1
       jsr     _LVOClose(a6)
       cmp.l   a4,d6
       bne     SavErr
       clr     BigChg
SavOps:tst.l   AslFR
       bne     AslDonSav
       bsr     wind3close
       bra     loop
SavErr:
       tst.l   AslFR
       bne     AslSavErr
       move.l  intbase,a6
       move.l  window3hd,a0
       move.l  50(a0),a0    ;RastPort
       move.l  #SerText,a1
       move.l  #4,d0
       move.l  #100,d1
       jsr     _LVOPrintIText(a6)
       bra     SSloop
OutSource:
       move.l  dosbase,a6
       move.l  #SrcName,d1
       move.l  #MODE_NEW,d2
       jsr     _LVOOpen(a6)
       tst     d0
       beq     loop
       move.l  d0,d5
       lea     Board,a2
       lea     SrcBuf,a3
       move.l  #20,d6
OS1:   lea     DCBuf,a4
       move.l  #14,d7
OSX:   move.b  (a4)+,(a3)+  ;Note there is NO OS2!!!!!!!
       dbra    d7,OSX
       move.l  #19,d7
OS3:   moveq.l #0,d0
       move.b  (a2)+,d0
       add     #'0',d0
       cmp.b   #'0'+10,d0
       bne     OS4
       move.b  #'x',d0
OS4:   cmp.b   #'0'+11,d0
       bne     OS5
       move.b  #'i',d0
OS5:   move.b  d0,(a3)+
       move.b  #',',(a3)+
       dbra    d7,OS3
       move.b  #10,-1(a3)
       dbra    d6,OS1
       move.l  d5,d1
       move.l  #SrcBuf,d2
       move.l  a3,d3
       sub.l   d2,d3
       jsr     _LVOWrite(a6)
       move.l  d5,d1
       jsr     _LVOClose(a6)
       bra     loop
IntoEditor:
       tst     ModePut
       bne     OutofEditor
       bsr     CallWind1
       bsr     AskMeFirst
       beq     loop
       bsr     CopyToUndo
       moveq.l #0,d0
       move    LastBoard,d0
       mulu    #420,d0
       lea     Board1,a0
       add.l   d0,a0
       move.l  #104,d1
       lea     Board,a1
IE1:   move.l  (a0)+,(a1)+
       dbra    d1,IE1
       clr     Changes
       bra     ReDrwBrd
OutofEditor:
       move    LastBoard,d0
       mulu    #420,d0
       lea     Board1,a0
       add.l   d0,a0
       move    #104,d0
       moveq   #2,d3
OE4:   tst.l   (a0)+
       bne     OE5
       dbra    d0,OE4
       bra     OE6
OE5:   move.l  intbase,a6
       move.l  windowhd,a0
       moveq.l #0,d0
       jsr     _LVOReportMouse(a6)
       move.l  windowhd,a0
       lea     b3text,a1
       lea     l3text,a2
       lea     r3text,a3
       clr.l   d0
       clr.l   d1
       move.l  #320,d2
       move.l  #68,d3
       jsr     _LVOAutoRequest(a6)
       move    d0,d3
       move.l  windowhd,a0
       move.l  #-1,d0
       jsr     _LVOReportMouse(a6)
OE6:   move    d3,-(sp)
       move.l  intbase,a6
       move.l  Rast2,a0
       lea     GetText,a1
       move.l  #102,d0
       move.l  #181,d1
       jsr     _LVOPrintIText(a6)
       move    (sp),d3  ;don't move the SP!
       tst     d3
       bne     NCCP1    ;Well I sure don't know what it stands for!
       bsr     CallWind1
NCCP1: move    (sp)+,d3       ;0 = swap, 1 = overwrite, 2 = blank!
       moveq.l #0,d0
       move    LastBoard,d0
       lea     NeedFix,a0
       move.b  #1,(a0,d0)
       move    #1,BigChg
       clr     ModePut
       tst     CurWork
       bne     NRfCW
       move    #-1,CurWork
NRfCW: mulu    #420,d0
       lea     Board1,a0
       add.l   d0,a0
       move.l  #104,d1
       lea     Board,a1
       lea     UndoBoard,a2
       tst     d3        ;1 = Overwrite, 0 = Swap, 2 = blank!
       beq     OE2
       cmp     #2,d3
       beq     OE3
OE1:   move.l  (a0),(a2)+    ;Overwrite: save to undo,
       move.l  (a1)+,(a0)+   ;then copy to set.
       dbra    d1,OE1
       clr     Changes
       move    #1,DelFlip
       bra     loop
OE2:   move.l  (a1),d0       ;Swap: No change to undo,
       move.l  (a0),(a1)+    ;so they can PUT both the Editor Board
       move.l  d0,(a0)+      ;and the Undo Buffer.
       dbra    d1,OE2
       move    #1,Changes
;       bsr     CopyToUndo    ;Undo used to do diddley.
       bra     ReDrwBrd
OE3:   move.l  (a1)+,(a0)+   ;Blank: just copy to set.
       dbra    d1,OE3
       clr     Changes
       move    #1,DelFlip
       bra     loop
DrSome:
       cmp     #-1,CurWork
       beq     TstFF
       moveq.l #0,d0
       move.l  CPtr_,a2
       move.l  gfxbase,a6
       lea     Converter,a3
       move    CX,d3
       move    d3,d5
       add     #40,d5
       move    CY,d4
       move.l  Rast2,a4
DS1:   move.b  (a2)+,d0
       move.b  (a3,d0),d0
       move.l  a4,a1
       jsr     _LVOSetAPen(a6)
       move    d3,d0
       move    d4,d1
       move.l  a4,a1
       jsr     _LVOWritePixel(a6)
       addq    #1,d3
       move    d3,d0
       move    d4,d1
       move.l  a4,a1
       jsr     _LVOWritePixel(a6)
       addq    #1,d3
       cmp     d5,d3
       blt     DS1
       add     #1,CY
       move.l  a2,CPtr_
       add     #1,CurRow
       cmp     #21,CurRow
       blt     DSR
       tst     DelFlip
       beq     TstFF
       bsr     CallWind1
       clr     DelFlip
TstFF: moveq.l #0,d2       ;Test For Fix
       move.l  #49,d1
       lea     NeedFix,a1
       add.l   #50,a1
DS2:   tst.b   -(a1)
       beq     DS3
       move    d1,d2
       addq    #1,d2
DS3:   dbra    d1,DS2
       move    d2,CurWork
       tst     d2
       beq     DSR
       subq    #1,d2
       clr.b   (a1,d2)
       lea     Board1,a0
       move    #1,CurRow
       move.l  d2,d1
       mulu    #420,d1
       add.l   d1,a0
       add.l   #20,a0
       move.l  a0,CPtr_
       mulu    #44,d2
       lea     Gads50+4,a0
       add.l   d2,a0
       move    (a0)+,CX
       move    (a0)+,CY
       add     #1,CX
       add     #1,CY
       bra     DSR

;d0,d1 = dest x,y.  a0 = Rast, a1 = block #
DrawBlock:
       movem.l d0-a5,-(sp)
       move.l  gfxbase,a6
       move.l  d0,d2           ;d2/d3 = dest xy
       move.l  d1,d3
       move    a1,d4
       ext.w   d4
       ext.l   d4
       lea     BlockCoords,a1
       lsl.l   #2,d4
       moveq   #0,d0
       moveq   #0,d1
       move    (a1,d4.w),d0    ;d0/d1 = source xy
       move    2(a1,d4.w),d1
       moveq.l #15,d4          ;d4/d5 = size xy
       moveq.l #7,d5
       move.l  #$c0,d6         ;d6 = minterm
       move.l  a0,a1           ;a1 = dest RastPort
       move.l  bit2map,a0      ;a0 = source bitmap
       jsr     _LVOBltBitMapRastPort(a6)
       movem.l (sp)+,d0-a5
       move.l  intbase,a6      ;compatability
       rts

DrawChoosers:
       movem.l d0-a6,-(sp)
       lea     Choosers,a2
       moveq   #11,d2
       move    BankSel,d3
drc1:  move    (a2)+,d0
       move    (a2)+,d1
       move.l  Rast,a0
       move    d3,a1
       bsr     DrawBlock
       addq    #1,d3
       dbra    d2,drc1
       movem.l (sp)+,d0-a6
       rts

openint:
       move.l  ExecBase,a6
       lea     intname,a1
       move.l  #0,d0
       jsr     _LVOopenlibrary(a6)  ;open intuition.library
       move.l  d0,intbase
       tst.l   d0
       rts
closeint:
       move.l  ExecBase,a6
       move.l  intbase,a1
       jsr     _LVOcloselibrary(a6) ;close intuition.library
       rts
opendatatypes:
       moveq   #1,d0
       tst     v39
       beq     odt1
       move.l  ExecBase,a6
       lea     datatypesname,a1
       moveq.l #39,d0
       jsr     _LVOopenlibrary(a6)  ;open datatypes.library
       move.l  d0,DataTypesBase
odt1:  tst.l   d0
       rts
closedatatypes:
       tst     DataTypesBase
       beq     _rts
       move.l  ExecBase,a6
       move.l  DataTypesBase,a1
       jsr     _LVOcloselibrary(a6) ;close datatypes.library
       clr.l   DataTypesBase
       rts
openiff:
       moveq   #1,d0
       tst     v39
       bne     odt1
       move.l  ExecBase,a6
       lea     iffname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open iff.library
       move.l  d0,iffbase
       tst.l   d0
       bne     _rts
       move.l  #no_iff,ErrPtr
       tst.l   d0
       rts
closeiff:
       tst.l   iffbase
       beq     _rts
       move.l  ExecBase,a6
       move.l  iffbase,a1
       jsr     _LVOcloselibrary(a6) ;close iff.library
       clr.l   iffbase
       rts
openreq:
       move.l  ExecBase,a6
       lea     reqname,a1
       move.l  #ReqVersion,d0
       jsr     _LVOopenlibrary(a6)  ;open req.library
       move.l  d0,reqbase
       tst.l   d0
       beq     _rts
       clr.l   Gpth
       lea     FileRequestor,a0
       move.l  #gascPath,frq_Title(a0)
       move.l  #f_Dir,frq_Dir(a0)
       move.l  #f_File,frq_File(a0)
       move.w  #6,frq_WindowLeftEdge(a0)
       move.w  #15,frq_WindowTopEdge(a0)
       move.w  #9,frq_dirnamescolor(a0)
       move.w  #17,frq_devicenamescolor(a0)
       move.w  #21,frq_gadgettextcolor(a0)
       move.w  #26,frq_stringnamecolor(a0)
       move.w  #4,frq_boxbordercolor(a0)
       move.l  #strpuffer2,frq_PathName(a0)
       move.l  #FRQCACHINGM+FRQCACHEPURGEM+FRQNODRAGM+FRQABSOLUTEXYM,f_Flags
       lea     frq_ExtendedSelect+4+WILDLENGTH+2(a0),a0
       lea     f_Show,a1
orq1:  move.b  (a1)+,(a0)+
       bne     orq1
       rts
closereq:
       move.l  reqbase,a6
       cmp.l   #0,a6
       beq     _rts
       lea     FileRequestor,a0
       jsr     _LVOPurgefiles(a6)
       move.l  a6,a1
       move.l  ExecBase,a6
       jsr     _LVOcloselibrary(a6) ;close req.library
       rts
openasl:
       moveq   #0,d0
       tst     OS20
       beq     NoAsl
       move.l  ExecBase,a6
       lea     aslname,a1
       moveq.l #36,d0
       jsr     _LVOOpenLibrary(a6)  ;open asl.library
NoAsl: move.l  d0,aslbase
       tst.l   d0
       beq     _rts
       move.l  d0,a6
       moveq   #0,d0           ;ASL_FileRequest
       lea     AslAllocTags,a0
       jsr     _LVOAllocAslRequest(a6)
       move.l  d0,AslFR
       tst.l   d0
       rts
closeasl:
       move.l  aslbase,a6
       cmp.l   #0,a6
       beq     _rts
       move.l  AslFR,a0
       cmp.l   #0,a0
       beq     NoAFR
       jsr     _LVOFreeAslRequest(a6)
NoAFR: move.l  a6,a1
       move.l  ExecBase,a6
       jsr     _LVOcloselibrary(a6) ;close asl.library
       rts
opengfx:
       move    #1,v39
       move.l  ExecBase,a6
       lea     gfxname,a1
       move.l  #39,d0
       jsr     _LVOopenlibrary(a6)  ;open graphics.library >= v39
       move.l  d0,gfxbase
       tst.l   d0
       bne     ok39
       clr     v39
       lea     gfxname,a1
       move.l  #0,d0
       jsr     _LVOopenlibrary(a6)  ;open graphics.library < v39
       move.l  d0,gfxbase
ok39:  tst.l   d0
       rts
closegfx:
       move.l  ExecBase,a6
       move.l  gfxbase,a1
       jsr     _LVOcloselibrary(a6) ;close graphics.library
       rts
opendos:
       move    #1,OS20
       move.l  ExecBase,a6
       lea     dosname,a1
       move.l  #36,d0
       jsr     _LVOopenlibrary(a6)  ;open dos.library >= v36
       move.l  d0,dosbase
       tst.l   d0
       bne     ok20
       clr     OS20
       lea     dosname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open dos.library < v36
       move.l  d0,dosbase
ok20:  tst.l   d0
       rts
closedos:
       move.l  ExecBase,a6
       move.l  dosbase,a1
       jsr     _LVOcloselibrary(a6) ;close dos.library
       rts

; inputs: a0 = string, d0 = default.  Output: d0.
GetBool:
       lea     TexBuf,a1
       moveq   #0,d1
GB1:   move.b  (a0)+,d1
       cmp.b   #'a',d1
       blt     GB2
       cmp.b   #'z',d1
       bgt     GB2
       sub.b   #'a'-'A',d1
GB2:   move.b  d1,(a1)+
       bne     GB1
       moveq   #3,d1
GB3:   clr.b   (a1)+
       dbra    d1,GB3
       move.l  TexBuf,d1
       cmp.l   #'ON'<<16,d1
       beq.s   GB_on
       cmp.l   #'OFF'<<8,d1
       beq.s   GB_off
       cmp.l   #'YES'<<8,d1
       beq.s   GB_on
       cmp.l   #'NO'<<16,d1
       beq.s   GB_off
       cmp.l   #'1'<<24,d1
       beq.s   GB_on
       cmp.l   #'0'<<24,d1
       beq.s   GB_off
       rts
GB_on: moveq   #1,d0
       rts
GB_off:moveq   #0,d0
       rts

openicon:
       clr.l   iconbase
       clr.l   MyDiskObj
       clr.l   MyToolTypes
       tst.l   SaveArgs
       beq     _rts
       move.l  ExecBase,a6
       lea     iconname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open icon.library
       move.l  d0,iconbase
       tst.l   d0
       beq     _rts
       move.l  SaveArgs,a0
       tst.l   WBMsg
       bne     oi1
       tst     Debug
       bne     oi1
       lea     TexBuf,a1
       moveq   #0,d0
       cmp.l   #1,ArgLen
       bls.s   Arg2
       move.l  ArgLen,d0
       bra.s   Arg3
Arg2:  move.b  (a0)+,d0
Arg3:  subq.l  #1,d0
oi2:   cmp.b   #' ',(a0)
       bls     oi3
       move.b  (a0)+,(a1)+
       dbra    d0,oi2
oi3:   clr.b   (a1)
       lea     TexBuf,a0
oi1:   move.l  iconbase,a6
       jsr     _LVOGetDiskObject(a6)
       tst.l   d0
       beq     _rts
       move.l  d0,MyDiskObj
       move.l  d0,a0
       move.l  $36(a0),d2
       tst.l   d2
       beq     _rts
       move.l  d2,MyToolTypes
       move.l  d2,a0
       lea     Tool_ModeID,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     _rts
       move.l  d0,a0
       moveq   #0,d0
       moveq   #0,d1
oi11b: move.b  (a0)+,d1
       cmp.b   #'0',d1
       blt     oi11f
       cmp.b   #'9',d1
       bgt     oi11c
       sub.b   #'0',d1
oi11c: cmp.b   #'A',d1
       blt     oi11d
       cmp.b   #'F',d1
       bgt     oi11d
       sub.b   #'A'-10,d1
oi11d: cmp.b   #'a',d1
       blt     oi11e
       cmp.b   #'f',d1
       bgt     oi11e
       sub.b   #'a'-10,d1
oi11e: cmp.b   #15,d1
       bgt     oi11f
       lsl.l   #4,d0
       or.b    d1,d0
       bra     oi11b
oi11f: move.l  #$80000032,MId   ;SA_DisplayID
       move.l  d0,MId+4
       rts
closeicon:
       tst.l   iconbase
       beq     _rts
       tst.l   MyDiskObj
       beq     ci1
       move.l  MyDiskObj,a0
       move.l  iconbase,a6
       jsr     _LVOFreeDiskObject(a6)
ci1:   move.l  ExecBase,a6
       move.l  iconbase,a1
       jsr     _LVOcloselibrary(a6) ;close icon.library
       clr.l   iconbase
       rts
opendiskfont:
       move.l  ExecBase,a6
       lea     DiskFontName,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open diskfont.library
       move.l  d0,fontbase
       tst.l   d0
       rts
closediskfont:
       move.l  ExecBase,a6
       move.l  fontbase,a1
       jsr     _LVOcloselibrary(a6) ;close diskfont.library
       rts
allocbitmap:                ;handle returned in d0.
       tst     v39
       beq     abmOld
       move.l  gfxbase,a6
       move.l  #320,d0
       move.l  #200,d1
       moveq.l #0,d2
       move    Depth,d2
       move.l  #5,d3        ;Flags, 5 = BMF_INTERLEAVED|BMF_CLEAR
       move.l  screenhd,a0
       add.l   #84,a0
       move.l  4(a0),a0     ;Friend bitmap.
       jsr     _LVOAllocBitMap(a6)
       tst.l   d0
       rts
abmOld:move.l  ExecBase,a6
       move.l  #40,d0
       move.l  #MEMF_CLEAR,d1
       jsr     _LVOAllocMem(a6)
       tst.l   d0
       beq     _rts
       moveq   #0,d2
       move    Depth,d2
       move.l  d0,a2
       move.l  d0,a3
       move.w  #40,(a3)+   ;BytesPerRow
       move.w  #200,(a3)+  ;Rows
       clr.b   (a3)+       ;Flags
       move.b  d2,(a3)+    ;Depth
       addq.l  #2,a3       ;Pad
       subq    #1,d2
       move.l  gfxbase,a6
abmo1: move.l  #320,d0
       move.l  #200,d1
       jsr     _LVOAllocRaster(a6)
       move.l  a2,a0
       tst.l   d0
       beq     freebitmap
       move.l  d0,(a3)+
       dbra    d2,abmo1
       move.l  a2,d0
       tst.l   d0
       rts
freebitmap:                 ;put handle in a0.
       move.l  gfxbase,a6
       tst     v39
       beq     fbmOld
       jsr     _LVOFreeBitMap(a6)
       rts
fbmOld:move.l  a0,a2
       lea     8(a2),a3
       moveq   #0,d2
       move    Depth,d2
       subq    #1,d2
fbmo1: tst.l   (a3)+
       beq.s   fbmo2
       move.l  -4(a3),a0
       move.l  #320,d0
       move.l  #200,d1
       jsr     _LVOFreeRaster(a6)
fbmo2: dbra    d2,fbmo1
       move.l  a2,a1
       move.l  #40,d0
       move.l  ExecBase,a6
       jsr     _LVOFreeMem(a6)
       moveq   #0,d0
       rts
pic2plane:                   ;IFF ptr must be in a1!
       movem.l a0/a1,-(sp)   ;dest bitmap must be in a0!
       move.l  iffbase,a6
       lea     ctable,a0
       jsr     _LVOGetColorTab(a6)
       tst.l   d0
       bne     dop2p
       addq.l  #8,sp         ;don't need pichd/bitmap
       move.l  #no_color,ErrPtr
       bra     IffError
dop2p: movem.l (sp)+,a0/a1
       jsr     _LVODecodePic(a6)
       tst.l   d0
       bne     _rts
       move.l  #no_decode,ErrPtr   ;Fall into IFFerror.
IFFerror:
       move.l  iffbase,a6
       jsr     _LVOIffError(a6)    ;Fall into sorrybud.
sorrybud:
       moveq.l #0,d1
       tst.l   d1
       rts
scropen:
       move.l  intbase,a6
       lea     screen_defs,a0
       jsr     _LVOopenscreen(a6)   ;make my screen.
       move.l  d0,screenhd
       move.l  d0,screen2hd
       move.l  d0,screen3hd
       move.l  d0,a0
       add.l   #44,a0       ;ViewPort
       move.l  a0,ViewPort
       tst.l   d0
       rts
scrclose:
       move.l  intbase,a6
       move.l  screenhd,a0
       jsr     _LVOclosescreen(a6)  ;close my screen.
       rts
windopen:
       move.l  intbase,a6
       lea     windowdef,a0
       jsr     _LVOopenwindow(a6)   ;make my window.
       move.l  d0,windowhd
       tst.l   d0
_rts:  rts
windclose:
       move.l  intbase,a6
       move.l  windowhd,a0
       jsr     _LVOclosewindow(a6)  ;close it.
       rts
wind2open:
       move.l  intbase,a6
       lea     window2def,a0
       jsr     _LVOopenwindow(a6)   ;make my other window.
       move.l  d0,window2hd
       tst.l   d0
       rts
wind2close:
       move.l  intbase,a6
       move.l  window2hd,a0
       jsr     _LVOclosewindow(a6)  ;close it.
       rts
wind3open:
       move.l  intbase,a6
       lea     window3def,a0
       jsr     _LVOopenwindow(a6)   ;make my other window.
       move.l  d0,window3hd
       tst.l   d0
       rts
wind3close:
       move.l  intbase,a6
       move.l  window3hd,a0
       jsr     _LVOclosewindow(a6)  ;close it.
       rts
CallWind2:
       move.l  window2hd,a2
       bra     CW1
CallWind1:
       move.l  windowhd,a2
CW1:   move.l  intbase,a6
       move.l  a2,a0
       jsr     _LVOWindowToFront(a6)
       move.l  a2,a0
       jsr     _LVOActivateWindow(a6)
       move.l  dosbase,a6
       moveq.l #10,d1
       jsr     _LVODelay(a6)
       rts
AskMeAll:
       move.l  #-1,d4
       bra     AMF
AskMeFirst:
       moveq.l #0,d4
AMF:   move.l  #-1,d3
       move.l  intbase,a6
       move.l  windowhd,a0
       moveq.l #0,d0
       jsr     _LVOReportMouse(a6)
       tst     Changes
       beq     NoAMF
       lea     Board+20,a0
       move.l  #99,d0
       moveq   #0,d1
BlkTst:or.l    (a0)+,d1
       dbra    d0,BlkTst
       tst.l   d1
       beq     NoAMF
       move.l  windowhd,a0
       lea     btext,a1
       lea     ltext,a2
       lea     rtext,a3
       clr.l   d0
       clr.l   d1
       move.l  #320,d2
       move.l  #58,d3
       jsr     _LVOAutoRequest(a6)
       move    d0,d3
NoAMF: and     d3,d4
       tst     d4
       bne     AMM
RtAMM: move.l  windowhd,a0
       move.l  #-1,d0
       jsr     _LVOReportMouse(a6)
       tst     d3        ;1 = yes, 0 = no.  Duh....
       rts
AMM:   tst     BigChg    ;d3 is already -1 here.
       beq     RtAMM
       move.l  windowhd,a0
       lea     b2text,a1
       lea     l2text,a2
       lea     r2text,a3
       clr.l   d0
       clr.l   d1
       move.l  #320,d2
       move.l  #116,d3
       jsr     _LVOAutoRequest(a6)
       move    d0,d3
       bra     RtAMM

ColorFitch:
       move.l  gfxbase,a6
       move.l  ViewPort,a0     ;Sub-color fitch
       moveq   #0,d0
       move    FitchSubCol,d0
       beq     CFnsf   ;ColorFitch: No Sub-Fitch
       moveq.l #0,d1
       moveq.l #$F,d2
       moveq.l #$F,d3
       sub     Fcol,d2
       jsr     _LVOSetRGB4(a6)
       move.l  ViewPort,a0     ;Main color fitch
       moveq   #0,d0
CFnsf: move    FitchCol,d0
       moveq.l #0,d1
       moveq.l #0,d2
       moveq.l #$F,d3
       move    Fcol,d2
       add     Fdir,d2
       move    d2,Fcol
       tst     d2
       bgt     NoFc1m
       move    #1,Fdir
NoFc1m:cmp     #$F,d2
       blt     NoFc2m
       move    #-1,Fdir
NoFc2m:jsr     _LVOSetRGB4(a6)
       rts
ColorOn:
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       tst     v39
       beq     coOld
       lea     numcolors,a1    ;Followed by ctable32
       jsr     _LVOLoadRGB32(a6)
       rts
coOld: move.l  #32,d0
       lea     ctable,a1
       jsr     _LVOLoadRGB4(a6)
       rts
ColorOff:
       move.l  gfxbase,a6
       move.l  #32,d0
       move.l  ViewPort,a0
       lea     ftable,a1
       move.l  a1,a2
       move.l  #31,d2
COff2: clr     (a2)+
       dbra    d2,COff2
       jsr     _LVOLoadRGB4(a6)
       rts

       ;DATA   ;data section in CODE because no CHIP nedded here
screen_defs:
       dc.w    0,0,320,200
Depth:
       dc.w    3
       dc.b    0,1
       dc.w    $2,$100F        ;$100F = NS_EXTENDED|CUSTOMSCREEN
ScreenTextAttr:
       dc.l    TopazAttr,tite1,0,0
       dc.l    ScrTags

; SA_Dummy =   $80000020
ScrTags:
       dc.l    $80000042,-1        ;SA_Interleaved,TRUE
       dc.l    $8000003A,SApens    ;SA_Pens,SApens
MId:   dc.l    1,0                 ;TAG_IGNORE,0  (For SA_DisplayID).
       dc.l    0                   ;TAG_END
SApens:
       dc.w    1,0     ;Detail,block
       dc.w    1       ;Text on bkg
       dc.w    20,22   ;Shine,Shadow
       dc.w    21,18   ;Active window (bar,title)
       dc.w    0,17    ;bkg, hilite text
       dc.w    0,1,1   ;v39 menu bar detail, block, trim
       dc.w    -1      ;End
TopazAttr:
       dc.l    TopazName
       dc.w    8
       dc.b    0,1
TextAttr:
       dc.l    FontName
       dc.w    8
       dc.b    0,0
windowdef:
       dc.w    0,1,320,199
       dc.b    0,1
       dc.l    $278,$1120c,gadget0,0,windname
screenhd: dc.l 0,0
       dc.w    0,0,0,0,15  ;rest of the windowdef
window2def:
       dc.w    0,1,320,199
       dc.b    0,1
       dc.l    $40,$10004,GadCnc,0,wind2name
screen2hd: dc.l 0,0
       dc.w    0,0,0,0,15  ;rest of the windowdef
window3def:
       dc.w    0,1,320,199
       dc.b    0,1
       dc.l    $40,$11000,GadGo,0
W3N:   dc.l    wind3nameL
screen3hd: dc.l 0,0
       dc.w    0,0,0,0,15  ;rest of the windowdef
Errwindowdef:
       dc.w    100,95,440,10
       dc.b    3,2
       dc.l    $200,$100e,0,0
ErrPtr:dc.l    0
       dc.l    0,0
       dc.w    0,0,0,0,1

;       INCLUDE 'Stuff'

MyName:
;              '**********************'
       dc.b    $aa-'E',$aa-'d',$aa-' ',$aa-'M',$aa-'a',$aa-'c',$aa-'k'
       dc.b    $aa-'e',$aa-'y',$aa-'.',$aa    ,$aa    ,$aa    ,$aa
       dc.b    $aa    ,$aa    ,$aa    ,$aa    ,$aa    ,$aa    ,$aa
       dc.b    $aa
MYKEYMAC: MACRO
       IFND    EDSGADGET
       dc.l    $be2112eb                  ;This is the "serial number"
       ELSE
       dc.l    $fe21489a       ;This magic number is the only serial number
                               ;that can make default board sets.
       ENDIF
       ENDM
Converter:
       dc.b    0,21,9,17,13,26,3,0,4,5,6,27         ;non-aga pixels
       dc.b    6,20,21,22,23,3,28,5,29,30,31,4      ;aga pixels
       dc.b    24,20,9,10,11,27,16,10,12,13,15,26   ;aga pixels
       dc.b    0,21,9,17,13,26,3,0,4,5,6,27         ;cd32 pixels
       dc.b    6,20,21,22,23,3,28,5,29,30,31,4      ;cd32 pixels
       dc.b    24,20,9,10,11,27,16,10,12,13,15,26   ;cd32 pixels
;ctable:
;       dc.w    $000,$fff,$bf0,$90f,$f08,$08f,$ff0,$88c
OS20:
       dc.w    0
gadget0:
       dc.l    gadget1
       dc.w    80,180,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    0   ;Gadget ID
       dc.l    0
gadget1:
       dc.l    gadget2
       dc.w    20,160,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    1   ;Gadget ID
       dc.l    0
gadget2:
       dc.l    gadget3
       dc.w    40,160,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    2   ;Gadget ID
       dc.l    0
gadget3:
       dc.l    gadget4
       dc.w    60,160,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    3   ;Gadget ID
       dc.l    0
gadget4:
       dc.l    gadget5
       dc.w    80,160,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    4   ;Gadget ID
       dc.l    0
gadget5:
       dc.l    gadget6
       dc.w    20,180,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    5   ;Gadget ID
       dc.l    0
gadget6:
       dc.l    gadget7
       dc.w    20,170,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    6   ;Gadget ID
       dc.l    0
gadget7:
       dc.l    gadget8
       dc.w    60,180,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    7   ;Gadget ID
       dc.l    0
gadget8:
       dc.l    gadget9
       dc.w    40,170,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    8   ;Gadget ID
       dc.l    0
gadget9:
       dc.l    gadget10
       dc.w    60,170,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    9   ;Gadget ID
       dc.l    0
gadget10:
       dc.l    gadget11
       dc.w    80,170,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    10  ;Gadget ID
       dc.l    0
gadget11:
       dc.l    GadClear
       dc.w    40,180,15,7,5,3,1
       dc.l    0,0,0,0,0
       dc.w    11  ;Gadget ID
       dc.l    0
GadClear:
   IFND     EDSGADGET
       dc.l    GadGet
       dc.w    221      ;Centered X value.
   ELSE
       dc.l    GadSrc
       dc.w    205
   ENDIF
       dc.w    160,31,7,4,1,1
       dc.l    ImgClear,0,0,0,0
       dc.w    12  ;Gadget ID
       dc.l    0
GadSrc:
       dc.l    GadGet
       dc.w    237,160,31,7,4,1,1
       dc.l    ImgSrc,0,0,0,0
       dc.w    17  ;Gadget ID
       dc.l    0
GadGet:
       dc.l    GadPut
       dc.w    205,168,31,7,4,1,1
       dc.l    ImgGet,0,0,0,0
       dc.w    13  ;Gadget ID
       dc.l    0
GadPut:
       dc.l    GadLod
       dc.w    237,168,31,7,4,1,1
       dc.l    ImgPut,0,0,0,0
       dc.w    14  ;Gadget ID
       dc.l    0
GadLod:
       dc.l    GadSav
       dc.w    205,176,31,7,4,1,1
       dc.l    ImgLod,0,0,0,0
       dc.w    15  ;Gadget ID
       dc.l    0
GadSav:
       dc.l    GadVer
       dc.w    237,176,31,7,4,1,1
       dc.l    ImgSav,0,0,0,0
       dc.w    16  ;Gadget ID
       dc.l    0
GadExamp:
       dc.l    0
       dc.w    15,15,42,22,4,1,1          ;Was ...,0,1,1
       dc.l    BlankGrid_Image,0,0,0,0    ;Was GadBrd
       dc.w    1   ;Gadget ID
       dc.l    0
GadCnc:
       dc.l    Gads50
       dc.w    278,182,31,7,4,1,1
       dc.l    ImgCnc,0,0,0,0
       dc.w    18  ;Gadget ID
       dc.l    0
;GadBrd:              ;The old white border with black X.
;       dc.w    0,0
;       dc.b    1,0,1,5
;       dc.l    PtList,EraBrd
;PtList:
;       dc.w    0,0,  41,0,  41,21,  0,21,  0,0
;EraBrd:
;       dc.w    0,0
;       dc.b    0,0,1,4
;       dc.l    EraList,0
;EraList:
;       dc.w    1,1,  40,20,  1,20,  40,1
GadVer:
       dc.l    GadHor
       dc.w    282,172,7,13
FlgVer:dc.w    4,$102,1        ;$80 = Selected
       dc.l    ImgVer,0,0,0,0
       dc.w    19  ;Gadget ID
       dc.l    0
GadHor:
       dc.l    GadPol
       dc.w    290,164,15,7
FlgHor:dc.w    4,$102,1
       dc.l    ImgHor,0,0,0,0
       dc.w    20  ;Gadget ID
       dc.l    0
GadPol:
       dc.l    GadDia
       dc.w    290,172,15,13
FlgPol:dc.w    4,$102,1
       dc.l    ImgPol,0,0,0,0
       dc.w    21  ;Gadget ID
       dc.l    0
GadDia:
       dc.l    GadUp
       dc.w    282,164,7,7
FlgDia:dc.w    4,$102,1
       dc.l    ImgDia,0,0,0,0
       dc.w    22  ;Gadget ID
       dc.l    0
GadUp:
       dc.l    GadDn
       dc.w    128,170,15,7,4,1,1
       dc.l    ImgUp,0,0,0,0
       dc.w    23  ;Gadget ID
       dc.l    0
GadDn:
       dc.l    GadLf
       dc.w    128,186,15,7,4,1,1
       dc.l    ImgDn,0,0,0,0
       dc.w    24  ;Gadget ID
       dc.l    0
GadLf:
       dc.l    GadRt
       dc.w    112,178,15,7,4,1,1
       dc.l    ImgLf,0,0,0,0
       dc.w    25  ;Gadget ID
       dc.l    0
GadRt:
       dc.l    GadUnd
       dc.w    144,178,15,7,4,1,1
       dc.l    ImgRt,0,0,0,0
       dc.w    26  ;Gadget ID
       dc.l    0
GadUnd:
       dc.l    GadInc
       dc.w    221,184,31,7,4,1,1
       dc.l    ImgUnd,0,0,0,0
       dc.w    27  ;Gadget ID
       dc.l    0
GadInc:
       dc.l    GadDec
       dc.w    9,166,7,7
       dc.w    4,1,1
       dc.l    ImgInc,0,0,0,0
       dc.w    28  ;Gadget ID
       dc.l    0
GadDec:
       dc.l    0
       dc.w    9,176,7,7
       dc.w    4,1,1
       dc.l    ImgDec,0,0,0,0
       dc.w    29  ;Gadget ID
       dc.l    0
MyKey:
       MYKEYMAC
ImgCnc:
       dc.w    0,0,31,7,3
       dc.l    BlkCnc
       dc.b    19,0
       dc.l    0
ImgClear:
       dc.w    0,0,31,7,3
       dc.l    BlkClr
       dc.b    19,0
       dc.l    0
ImgUnd:
       dc.w    0,0,31,7,3
       dc.l    BlkUnd
       dc.b    19,0
       dc.l    0
ImgGet:
       dc.w    0,0,31,7,3
       dc.l    BlkGet
       dc.b    19,0
       dc.l    0
ImgPut:
       dc.w    0,0,31,7,3
       dc.l    BlkPut
       dc.b    19,0
       dc.l    0
ImgLod:
       dc.w    0,0,31,7,3
       dc.l    BlkLod
       dc.b    19,0
       dc.l    0
ImgSav:
       dc.w    0,0,31,7,3
       dc.l    BlkSav
       dc.b    19,0
       dc.l    0
ImgSrc:
       dc.w    0,0,31,7,3
       dc.l    BlkSrc
       dc.b    19,0
       dc.l    0
ImgVer:
       dc.w    0,0,7,13,3
       dc.l    BlkVer
       dc.b    19,0
       dc.l    0
ImgHor:
       dc.w    0,0,15,7,3
       dc.l    BlkHor
       dc.b    19,0
       dc.l    0
ImgPol:
       dc.w    0,0,15,13,3
       dc.l    BlkPol
       dc.b    19,0
       dc.l    0
ImgDia:
       dc.w    0,0,7,7,3
       dc.l    BlkDia
       dc.b    19,0
       dc.l    0
ImgInc:
       dc.w    0,0,7,7,3
       dc.l    BlkInc
       dc.b    19,0
       dc.l    0
ImgDec:
       dc.w    0,0,7,7,3
       dc.l    BlkDec
       dc.b    19,0
       dc.l    0
ImgUp:
       dc.w    0,0,15,7,3
       dc.l    BlkUp
       dc.b    19,0
       dc.l    0
ImgDn:
       dc.w    0,0,15,7,3
       dc.l    BlkDn
       dc.b    19,0
       dc.l    0
ImgLf:
       dc.w    0,0,15,7,3
       dc.l    BlkLf
       dc.b    19,0
       dc.l    0
ImgRt:
       dc.w    0,0,15,7,3
       dc.l    BlkRt
       dc.b    19,0
       dc.l    0

BlankGrid_image:
       dc.w    0,0
       dc.w    42,22
       dc.w    1
       dc.l    BlankGrid_data
       dc.b    $01
       dc.b    $00
       dc.l    0

;       INCLUDE 'Boards.Include'
;       blk.b   420,50             ;Safety

btext:                         ;Lose changes to board
       dc.b    17,0,0,0
       dc.w    10,10
       dc.l    0
       dc.l    bodytext,0
ltext:
       dc.b    29,0,0,0
       dc.w    5,3
       dc.l    0,lefttext,0
rtext:
       dc.b    4,0,0,0
       dc.w    5,3
       dc.l    0,righttext,0
b2text:                        ;Didn't save to disk
       dc.b    29,0,0,0
       dc.w    20,20
       dc.l    0
       dc.l    body2text,0
l2text:
       dc.b    29,0,0,0
       dc.w    5,3
       dc.l    0,left2text,0
r2text:
       dc.b    4,0,0,0
       dc.w    5,3
       dc.l    0,right2text,0
b3text:                        ;Overwrite/swap
       dc.b    17,0,0,0
       dc.w    10,10
       dc.l    0
       dc.l    body3text,b3textb
b3textb:
       dc.b    17,0,0,0
       dc.w    10,20
       dc.l    0
       dc.l    body3textb
Zap_If_20:
       dc.l    b3textc  ;Don't do these for a WB2 requester.
b3textc:
       dc.b    13,0,0,0
       dc.w    194,10
       dc.l    0
       dc.l    left3text,b3textd  ;Overwrite
b3textd:
       dc.b    13,0,0,0
       dc.w    34,20
       dc.l    0
       dc.l    right3text,0       ;Swap With
l3text:
       dc.b    29,0,0,0
       dc.w    5,3
       dc.l    0,left3text,0
r3text:
       dc.b    4,0,0,0
       dc.w    5,3
       dc.l    0,right3text,0
b4text:                        ;Big explanation about save not saving the editor
       dc.b    17,0,0,0
       dc.w    10,10
       dc.l    0
       dc.l    body4text,b4textb
b4textb:
       dc.b    17,0,0,0
       dc.w    10,20
       dc.l    0,body4textb,0
l4text:
       dc.b    29,0,0,0
       dc.w    5,3
       dc.l    0,left4text,0
r4text:
       dc.b    4,0,0,0
       dc.w    5,3
       dc.l    0,right4text,0
b5text:                        ;About: for registered users only!
       dc.b    17,0,0,0
       dc.w    10,10
       dc.l    0,body5text,b5textb
b5textb:
       dc.b    17,0,0,0
       dc.w    10,20
       dc.l    0,body5textb,b5textc
b5textc:
       dc.b    17,0,0,0
       dc.w    10,30
       dc.l    0,body5textc,0
r5text:
       dc.b    17,0,0,0
       dc.w    5,3
       dc.l    0,right5text,0
GetText:
       dc.b    21,0,1,0
       dc.w    0,0
       dc.l    0,GetMsg,0
PutText:
       dc.b    29,0,1,0
       dc.w    0,0
       dc.l    0,PutMsg,0
NFdText:
       dc.b    21,0,1,0
       dc.w    0,0
       dc.l    0,NFdMsg,0
VerText:
       dc.b    29,0,1,0
       dc.w    0,0
       dc.l    0,VerMsg,0
CorText:
       dc.b    29,0,1,0
       dc.w    0,0
       dc.l    0,CorMsg,0
ReqText:
       dc.b    17,0,1,0
       dc.w    0,0
       dc.l    0,ReqMsg,0
LodText:
       dc.b    21,0,1,0
       dc.w    0,0
       dc.l    0,LodMsg,0
SavText:
       dc.b    17,0,1,0
       dc.w    0,0
       dc.l    0,SavMsg,0
SerText:
       dc.b    17,0,1,0
       dc.w    0,0
       dc.l    0,SerMsg,0
GadPath:
       dc.l    0    ;35 chars, 280 wide.
       dc.w    10,34,280,10,$0,$2,$4
       dc.l    boarder3,0,gtextP,0,strinfo2
       dc.w    6 ;ID
       dc.l    0
gtextP:
       dc.b    5,0,1,0
       dc.w    0,-15
       dc.l    0,gascPath,0
GadGo:
       dc.l    GadOps
       dc.w    22,49,73,11,$0,$1,$1
       dc.l    boarder,0,gtextGo,0,0
       dc.w    7 ;ID
       dc.l    0
gtextGo:
       dc.b    6,3,1,0
       dc.w    1,2
       dc.l    0
GoP:   dc.l    gascTry,0
GadOps:
Gpth:  dc.l    GadPath
       dc.w    230,49,73,11,$0,$1,$1
       dc.l    boarder,0,gtextOps,0,0
       dc.w    8 ;ID
       dc.l    0
gtextOps:
       dc.b    2,3,1,0
       dc.w    1,2
       dc.l    0
       dc.l    gascCnc,0
boarder:
       dc.w    0,0
       dc.b    4,0,0,8
       dc.l    ptlist2,0
ptlist2:
       dc.w    -1,11, -1,-1,  73,-1,  73,11,  74,-1, 74,11, -2,11,  -2,-1
boarder3:
       dc.w    0,0
       dc.b    4,0,0,8
       dc.l    ptlist3,0
ptlist3:
       dc.w    -2,9, -2,-2,  280,-2,  280,9,  281,-2, 281,9, -3,9,  -3,-2
strinfo2:
       dc.l    strpuffer2,undo
       dc.w    0,100,0,0,0,0,0,0
       dc.l    0,0,0
strpuffer2:
       dc.b    'UnNamed.BDS'
       blk.b   DSIZE+FCHARS+2,0
       align
undo:
       blk.b   120,0
       align
FileRequestor:
       blk.b   frq_SIZEOF,0
       align
BankSel:
       dc.w    0
BlockCoords:   ;Blank one is at 17,34
       dc.w    278,46, 206,11, 222,11, 206,18, 222,18, 206,25
       dc.w    222,25, 278,39, 273,184, 289,177, 289,184, 273,177
; And the AGA blocks:
       dc.w    136,4, 136,11, 136,18, 136,25, 214,39, 214,46
       dc.w    152,4, 152,11, 152,18, 152,25, 230,39, 230,46
       dc.w    168,4, 168,11, 168,18, 168,25, 246,39, 246,46
       dc.w    184,4, 184,11, 184,18, 184,25, 262,39, 262,46
; And the CD32 blocks:
       dc.w    184,50,   8,50, 24,50,  40,50,  56,50, 136,50
       dc.w     72,50, 168,50, 88,50, 104,50, 120,50, 152,50

       dc.w    40,25,  8,4,   8,11,  8,18,  8,25, 40,4
       dc.w    24,4,  40,18, 24,11, 24,18, 24,25, 40,11

       dc.w    88,25, 56,4,  56,11, 56,18, 56,25, 88,4
       dc.w    72,4,  88,18, 72,11, 72,18, 72,25, 88,11
Choosers:
       dc.w    80,180, 20,160, 40,160, 60,160, 80,160, 20,180
       dc.w    20,170, 60,180, 40,170, 60,170, 80,170, 40,180
; ASL_TB = $80080000
AslAllocTags:
       dc.l    $80080002,0         ;ASLFR_Window,0
       dc.l    $80080008,f_File    ;ASLFR_InitialFile,f_File
       dc.l    $80080009,f_Dir     ;ASLFR_InitialDrawer,f_Dir
       dc.l    $8008000A,f_Show    ;ASLFR_InitialPattern,f_Show
       dc.l    $80080003,0         ;ASLFR_InitialLeftEdge,0
       dc.l    $80080004,0         ;ASLFR_InitialTopEdge,0
       dc.l    $80080005,320       ;ASLFR_InitialWidth,320
       dc.l    $80080006,200       ;ASLFR_InitialHeight,200
       dc.l    $8008002e,-1        ;ASLFR_DoPatterns,-1
       dc.l    0                   ;TAG_END
AslReqTags:
       dc.l    $80080001,0         ;ASLFR_Titletext,0
       dc.l    $8008002c,0         ;ASLFR_DoSaveMode,0
       dc.l    0                   ;TAG_END
;DTA_Dummy = $80001000
DTtags:
       dc.l    $80001065,2         ;DTA_SourceType, DTST_FILE
;       dc.l    $80001066,0         ;DTA_Handle, 0
       dc.l    $8000101F,'pict'    ;DTA_GroupID, GID_PICTURE
       dc.l    $800010D3,0         ;PDTA_Remap, 0
       dc.l    0                   ;TAG_END
DTGAtags:
       dc.l    $800010D1,numcolors ;PDTA_NumColors,numcolors
       dc.l    $800010CC,CRegs     ;PDTA_CRegs,CRegs
       dc.l    $800010CA,newbm     ;PDTA_BitMap,newbm
       dc.l    0                   ;TAG_END
CRegs:
       dc.l    0
newbm:
       dc.l    0
;dtf:                   ;struct dtFrameBox
;       dc.l    $601    ;DTM_FRAMEBOX
;       dc.l    0,fri,fri,36   ;sizeof(struct FrameInfo)
;fri:                   ;struct FrameInfo
;       dc.l    0       ;PropertyFlags
;       dc.w    0,0     ;Res x,y
;       dc.b    0,0,0,0 ;RGB bits
;       dc.l    0,0,0   ;Wid,Hig,Dep
;       dc.l    0,0,0   ;Screen, ColorMap, Flags
gpl:                   ;struct gpLayout
       dc.l    $602    ;DTM_PROCLAYOUT
       dc.l    0,1
v39:
       dc.w    0
FitchCol:
       dc.w    24
FitchSubCol:
       dc.w    0
Fcol:
       dc.w    0
Fdir:
       dc.w    1
Debug:
       dc.w    0
;CompressedBoards:
;       IBYTES  'Main.BDS'
;end_CompressedBoards:
;       dc.l    0
;CompBoardSiz = end_CompressedBoards-CompressedBoards
GfxNameList:
       dc.l    picname      ; was newpicname,picname
GfxNameNonAGAList:
       dc.l    pic2name,0
NumList:
       dc.b    '0108152229364350'  ;Left side of "Get which Board?" window.
DCBuf:
       dc.b    '       dc.b    '
f_Dir:
       dc.b    'Boards'
       blk.b   DSIZE+1,0
f_File:
       dc.b    'UnNamed.BDS'
       blk.b   FCHARS+1,0
f_Show:
       dc.b    '#?.BDS',0
bodytext:
       dc.b    'Lose changes to this board?!',0
lefttext:
       dc.b    'Sure.',0
righttext:
       dc.b    'OH NO!!',0
body2text:
       dc.b    "You didn't save to disk!!",0
left2text:
       dc.b    'Who cares?',0
right2text:
       dc.b    'OOPS! hehe.',0
body3text:
       dc.b    'Take editor board, and Overwrite',0
body3textb:
       dc.b    'or Swap with selected board?',0
left3text:
       dc.b    'Overwrite',0
right3text:
       dc.b    'Swap with',0
body4text:
       dc.b    'NOTE: SAVE only saves the 50 boards.',0
body4textb:
       dc.b    'You must first PUT the editor board!',0
left4text:
       dc.b    'I know. Save anyway.',0
right4text:
       dc.b    'Oh. Cancel.',0
body5text:
       dc.b    '     MegaBall Editor v4.0',0
body5textb:
       dc.b    'Intangible Assets Manufacturing ',0
;       dc.b    '** for REGISTERED users only! **',0
;       dc.b    'belongs to '
MyNameHere:
       dc.b    '**********************'
end_MyNameHere:
body5textc:
       dc.b    ' Copyright 1995 by Ed Mackey.',0
right5text:
       dc.b    'OK',0
gascPath:
       dc.b    'Enter path/filename:',0
gascSav:
       dc.b    '> SAVE! <',0
gascLod:
       dc.b    '> LOAD! <',0
gascTry:
       dc.b    'Try again',0
gascCnc:
       dc.b    'Forget it',0
tite1:
       dc.b    'Loading graphics....',0
windname:
       dc.b    'MEGABALL Board Editor by Ed Mackey',0
wind2name:
       dc.b    'Select a board:',0
wind3nameL:
       dc.b    'Filename to LOAD?',0
wind3nameS:
       dc.b    'Filename to SAVE?',0
AslLoading:
       dc.b    ' ... Loading, PLEASE WAIT ... ',0
AslSaving:
       dc.b    ' ... Saving, PLEASE WAIT ... ',0
GetMsg:
       dc.b    'Get which board?',0
PutMsg:
       dc.b    'PUT which board?',0
f_FNF:
       dc.b    'Last try: File not found.',0
f_VER:
       dc.b    'Last try: Needs newer version of MegaBall.',0
f_NBD:
       dc.b    'Last try: Not a board file.',0
f_SER:
       dc.b    'Last try: ERROR, NOT SAVED!',0
CorMsg:
       dc.b    'Not a board file, or file corrupt.',0
NFdMsg:
       dc.b    'File not found -- Try full path?  ',0
VerMsg:
       dc.b    'Needs newer version of MegaBall.  ',0
ReqMsg:
       dc.b    'You need V1+ of req.library!!     ',0
LodMsg:
       dc.b    'Loading...                        ',0
SavMsg:
       dc.b    'Saving...                         ',0
SerMsg:
       dc.b    'WARNING: Disk error!              ',0
SrcName:
       dc.b    'RAM:Board',0
no_boards:
       dc.b    'ERROR: Internal data corrupt!',0
no_datatypes:
       dc.b    "Error: Can't open datatypes.library!",0
no_iff:
       dc.b    "Error: Can't find LIBS:iff.library!",0
no_bitmap:
       dc.b    "Error: Can't allocate bitmap from CHIP mem.",0
no_ram:
       dc.b    "Error: No RAM for graphics!",0
no_gfx:
       dc.b    "Error: Can't load graphics!  No CHIP mem?",0
no_cols:
       dc.b    "Error: Can't access CRegs colors!",0
no_DTbm:
       dc.b    "Error: Can't access DataTypes bitmap!",0
no_decode:
       dc.b    'Error: DecodePic() failed, IFF is invalid.',0
no_color:
       dc.b    'Error: GetColorTab() failed, IFF is invalid.',0
;newpicname:
;       dc.b    'MegaBall.Gfx.CD32',0
picname:
       dc.b    'MegaBall4.Gfx.AGA',0
pic2name:
       dc.b    'MegaBall4.Gfx.non-AGA',0
DebugCurDirName:
       dc.b    'MBL:',0
DebugProgName:
       dc.b    'BoardEd',0
MBgfxTempName:
       dc.b    'RAM:MegaBall.temp.junk',0
Tool_ModeID:
       dc.b    'MODEID',0
FontName:
       dc.b    'MegaBall.font',0
TopazName:
       dc.b    'topaz.font',0
intname:
       dc.b    'intuition.library',0
datatypesname:
       dc.b    'datatypes.library',0
iffname:
       dc.b    'iff.library',0
gfxname:
       dc.b    'graphics.library',0
iconname:
       dc.b    'icon.library',0
dosname:
       dc.b    'dos.library',0
diskfontname:
       dc.b    'diskfont.library',0
reqname:
       dc.b    'req.library',0
aslname:
       dc.b    'asl.library',0
Using:
       dc.b    'Using:'
end_Using:
       align

       DATA    ;This part needs CHIP!
BlkCnc:dc.l    %11111111111111111111111111111110
       dc.l    %10011100100100010111011101000010
       dc.l    %10010001010110010100010001000010
       dc.l    %10010001110101010100011001000010
       dc.l    %10010001010100110100010001000010
       dc.l    %10011101010100010111011101110010
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkClr:dc.l    %11111111111111111111111111111110
       dc.l    %10001110010000111000100011000010
       dc.l    %10001000010000100001010010100010
       dc.l    %10001000010000110001110011000010
       dc.l    %10001000010000100001010010100010
       dc.l    %10001110011100111001010010100010
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkUnd:dc.l    %11111111111111111111111111111110
       dc.l    %10001000101000101111000111000010
       dc.l    %10001000101100101000101000100010
       dc.l    %10001000101010101000101000100010
       dc.l    %10001000101001101000101000100010
       dc.l    %10000111001000101111000111000010
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkGet:dc.l    %11111111111111111111111111111110
       dc.l    %10001110011100111000010001111110
       dc.l    %10001000010000010000110001111110
       dc.l    %10001010011000010001111111111110
       dc.l    %10001010010000010000110001111110
       dc.l    %10001110011100010000010001111110
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkPut:dc.l    %11111111111111111111111111111110
       dc.l    %10001110010100111000001001111110
       dc.l    %10001010010100010000001101111110
       dc.l    %10001110010100010001111111111110
       dc.l    %10001000010100010000001101111110
       dc.l    %10001000011100010000001001111110
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkLod:dc.l    %11111111111111111111111111111110
       dc.l    %10100001000100110000010001111110
       dc.l    %10100010101010101000110000111110
       dc.l    %10100010101110101001111101101110
       dc.l    %10100010101010101000110001111110
       dc.l    %10111001001010110000010001101110
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkSav:dc.l    %11111111111111111111111111111110
       dc.l    %10111001001010111000010001111110
       dc.l    %10100010101010100000011000111110
       dc.l    %10111011101010110001111101101110
       dc.l    %10001010101010100000011001111110
       dc.l    %10111010100100111000010001101110
       dc.l    %11111111111111111111111111111110
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe
BlkSrc:dc.l    %00000000000000000000000000000000
       dc.l    %00111000110000111000010001111100
       dc.l    %00100000101000100000011000111100
       dc.l    %00111000110000100001111101101100
       dc.l    %00001000101000100000011001111100
       dc.l    %00111000101000111000010001101100
       dc.l    %00000000000000000000000000000000
       dc.l    0,0,0,0,0,0,0
       dc.l    $fffffffe,$80000002,$80000002,$80000002
       dc.l    $80000002,$80000002,$fffffffe

BlkVer:dc.w    %0000000000000000
       dc.w    %0001000000000000
       dc.w    %0111110000000000
       dc.w    %0011100000000000
       dc.w    %0001000000000000
       dc.w    %0000000000000000
       dc.w    %0111110000000000
       dc.w    %0000000000000000
       dc.w    %0001000000000000
       dc.w    %0011100000000000
       dc.w    %0111110000000000
       dc.w    %0001000000000000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0,0,0,0,0,0,0
       dc.w    $fe00,$8200,$8200,$8200,$8200,$8200
       dc.w    $8200,$8200,$8200,$8200,$8200,$8200,$fe00
BlkHor:dc.w    %0000000000000000
       dc.w    %0001000100010000
       dc.w    %0001100100110000
       dc.w    %0111110101111100
       dc.w    %0001100100110000
       dc.w    %0001000100010000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002,$fffe
BlkPol:dc.w    %0000000000000000
       dc.w    %0111100000000000
       dc.w    %0110000000000000
       dc.w    %0101000000000000
       dc.w    %0100101110000000
       dc.w    %0000011111000000
       dc.w    %0000011111000000
       dc.w    %0000011111000000
       dc.w    %0000001110100100
       dc.w    %0000000000010100
       dc.w    %0000000000001100
       dc.w    %0000000000111100
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002
       dc.w    $8002,$8002,$8002,$8002,$8002,$8002,$fffe
BlkDia:dc.w    %0000000000000000
       dc.w    %0110010000000000
       dc.w    %0110100000000000
       dc.w    %0001000000000000
       dc.w    %0010110000000000
       dc.w    %0100110000000000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fe00,$8200,$8200,$8200,$8200,$8200,$fe00
BlkInc:dc.w    %1111111000000000
       dc.w    %1001001000000000
       dc.w    %1001001000000000
       dc.w    %1111111000000000
       dc.w    %1001001000000000
       dc.w    %1001001000000000
       dc.w    %1111111000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fe00,$8200,$8200,$8200,$8200,$8200,$fe00
BlkDec:dc.w    %1111111000000000
       dc.w    %1000001000000000
       dc.w    %1000001000000000
       dc.w    %1111111000000000
       dc.w    %1000001000000000
       dc.w    %1000001000000000
       dc.w    %1111111000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fe00,$8200,$8200,$8200,$8200,$8200,$fe00
BlkUp: dc.w    %0000000000000000
       dc.w    %0000000100000000
       dc.w    %0000001110000000
       dc.w    %0000011111000000
       dc.w    %0000111111100000
       dc.w    %0001000100010000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002,$fffe
BlkDn: dc.w    %0000000000000000
       dc.w    %0001000100010000
       dc.w    %0000111111100000
       dc.w    %0000011111000000
       dc.w    %0000001110000000
       dc.w    %0000000100000000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002,$fffe
BlkLf: dc.w    %0000000000000000
       dc.w    %0000001111000000
       dc.w    %0000111100000000
       dc.w    %0011111111111000
       dc.w    %0000111100000000
       dc.w    %0000001111000000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002,$fffe
BlkRt: dc.w    %0000000000000000
       dc.w    %0000011110000000
       dc.w    %0000000111100000
       dc.w    %0011111111111000
       dc.w    %0000000111100000
       dc.w    %0000011110000000
       dc.w    %0000000000000000
       dc.w    0,0,0,0,0,0,0
       dc.w    $fffe,$8002,$8002,$8002,$8002,$8002,$fffe

BlankGrid_data:
       dc.w    $FFFF,$FFFF,$FFC0,$8000,$0000,$0040,$AAAA,$AAAA
       dc.w    $AA40,$9555,$5555,$5540,$AAAA,$AAAA,$AA40,$9555
       dc.w    $5555,$5540,$AAAA,$AAAA,$AA40,$9555,$5555,$5540
       dc.w    $AAAA,$AAAA,$AA40,$9555,$5555,$5540,$AAAA,$AAAA
       dc.w    $AA40,$9555,$5555,$5540,$AAAA,$AAAA,$AA40,$9555
       dc.w    $5555,$5540,$AAAA,$AAAA,$AA40,$9555,$5555,$5540
       dc.w    $AAAA,$AAAA,$AA40,$9555,$5555,$5540,$AAAA,$AAAA
       dc.w    $AA40,$9555,$5555,$5540,$8000,$0000,$0040,$FFFF
       dc.w    $FFFF,$FFC0

       BSS
SaveArgs:
       ds.l    1
ArgLen:
       ds.l    1
windowhd:
       ds.l    1
window2hd:
       ds.l    1
window3hd:
       ds.l    1
WBMsg:
       ds.l    1
intbase:
       ds.l    1
DataTypesBase:
       ds.l    1
iffbase:
       ds.l    1
iconbase:
       ds.l    1
dosbase:
       ds.l    1
reqbase:
       ds.l    1
aslbase:
       ds.l    1
gfxbase:
       ds.l    1
fontbase:
       ds.l    1
MyDiskObj:
       ds.l    1
MyToolTypes:
       ds.l    1
AslFR:
       ds.l    1
bit2map:
       ds.l    1
ViewPort:
       ds.l    1
ctable:
       ds.w    256  ;More than required space, just to be sure!
ftable:
       ds.w    256
numcolors:             ;Keep numcolors and ctable32 together.
       ds.w    2       ;Format:  # colors .w
ctable32:              ;         initial color .w
       ds.l    257*3   ;         RGB values .l
Changes:
       ds.w    1
BigChg:
       ds.w    1
Drawing:
       ds.w    1
Rast:
       ds.l    1
Rast2:
       ds.l    1
Selected:
       ds.w    1
DrawWith:
       ds.w    1
Signals:
       ds.l    1
Font:
       ds.l    1
CurWork:
       ds.w    1
CurRow:
       ds.w    1
CPtr_:
       ds.l    1
CX:
       ds.w    1
CY:
       ds.w    1
f_Flags:
       ds.l    1
DelFlip:
       ds.w    1
LastBoard:
       ds.w    1
MyTsk:
       ds.l    1
OldWindowPtr:
       ds.l    1
OldDir:
       ds.l    1
FakeRast:               ;Not used to fake a rastport in the editor
       ds.b    HDRSIZ
NeedFix:
       ds.b    50
MemBlkBuf:
       ds.b    20
TexBuf:
       ds.b    80
Board:
       ds.b    420
UndoBoard:
       ds.b    420
ReDrwBuf:
       ds.b    400
SrcBuf:
       ds.b    1180
Board1:
       ds.b    Whole_Thing
end_AllBoards:
LodSavHdr:            ;\
       ds.l    1      ; \
Chk2:                 ;  \
       ds.l    1      ;   \Keep
Chk1:                 ;   /Together
       ds.l    1      ;  /
LodSavBuf:            ; /
       ds.b    21000  ;/
Gads50:
       ds.b    44 * 50
end_Gads50:
ModePut:
       ds.w    1
       END
