#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_gfxPrimitives.h>
#include <time.h>

/* Functions */
void update(void); // function for updating the screen
void trake(); // function for checking collision with snake or blocks
int snakes(); // sets the snakes moves
int setblock(void); // sets the apple and the blocks (and add new blocks)
void blocker(); // function for blitting the blocks

/* Variables */
SDL_Surface *screen, *background, *blockpic, *apple, *snakehead, *snakelimb ;
SDL_Rect block; // the apple
SDL_Rect blocks[255]; // the blocks
SDL_Rect snake[255]; // you (the snake)
Uint8 *keys; // varable for input keys
SDL_Event event; // important event for checking window actions
bool done = false, start = false, pause = false;
int direction, points = 0, lng = 4, i, u = 0, count = 0, speed, numberblocks, j = 0, restart, blockadd = 5, wh = 1;

int main (int argc, char** argv)
{
    printf ("This program was created by David Maciejewski.\n");
    printf ("AROS port, sprite graphics and english translation by David Bergantin.\n");
    printf ("Background taken from Ubuntu 10.04 distribution.\n\n");
    hier:
    printf ("Enter game speed (150 = normal):\n");
    scanf ("%d", &speed);
    if (speed < 0)
	speed = 0;
    srand (time(NULL));
    printf ("How many obstacles (blocks) (-1 = none/ max. 200)\n");
    scanf ("%d", &numberblocks);
    if (numberblocks > 200)
    {
        printf ("You have entered more than the maximum. Blocks are now set to 200!\n");
        numberblocks = 200;
    }
    printf ("Do you want to increase the number of blocks during the game? (1 = Yes/ 0 = No)\n");
    scanf ("%d", &blockadd);

    if (SDL_Init (SDL_INIT_VIDEO) == -1)
    {
        printf("Could not initialize SDL:  %s\n", SDL_GetError());
        exit(1);
    }
    atexit(SDL_Quit);

    screen = SDL_SetVideoMode(640, 480, 24, SDL_HWSURFACE);
    if (screen == NULL)
    {
        printf("The video mode could not be set: %s\n", SDL_GetError());
        exit(1);
    }
    SDL_WM_SetCaption("Snake",NULL);

    background = SDL_LoadBMP("bilder/hintergrund.bmp");
    if  (background == NULL)
    {
        printf ("The image could not be loaded: %s\n", SDL_GetError());
        exit(1);
    }

    blockpic = SDL_LoadBMP ("bilder/block.bmp");
    if  (blockpic == NULL)
    {
        printf ("The image could not be loaded: %s\n", SDL_GetError());
        exit(1);
    }

    snakehead = IMG_Load ("bilder/snakehead.png");
    if  (snakehead == NULL)
    {
        printf ("The image could not be loaded: %s\n", SDL_GetError());
        exit(1);
    }

    snakelimb = IMG_Load ("bilder/snakelimb.png");
    if  (snakelimb == NULL)
    {
        printf ("The image could not be loaded: %s\n", SDL_GetError());
        exit(1);
    }

    apple = IMG_Load ("bilder/apple.png");
    if  (apple == NULL)
    {
        printf ("The image could not be loaded: %s\n", SDL_GetError());
        exit(1);
    }

    for (int i = 0; i <= lng; i++)
    {
        snake[i].x = 0;
        snake[i].y = 0;
        snake[i].w = 32;
        snake[i].h = 32;
        SDL_FillRect (screen, &snake[i], SDL_MapRGB (screen->format, 0, 0, 255));
    }

    SDL_SetColorKey (apple, SDL_SRCCOLORKEY, SDL_MapRGB (apple->format, 255, 0, 255));
    SDL_SetColorKey (snakehead, SDL_SRCCOLORKEY, SDL_MapRGB (snakehead->format, 255, 0, 255));
    SDL_SetColorKey (snakelimb, SDL_SRCCOLORKEY, SDL_MapRGB (snakelimb->format, 255, 0, 255));
    j = 0;

    if (numberblocks != -1)
    {
        while (j < numberblocks)
        {
            //while ((blocks[j].x == 0) && (blocks[j].y == 0))
            //while ((blocks[j].x == 32) && (blocks[j].y == 32))
            blocks[j].x = (rand()%19 * 32);
            blocks[j].y = (rand()%15 * 32);
            blocks[j].w = 32;
            blocks[j].h = 32;
            SDL_FillRect (screen, &blocks[j], SDL_MapRGB (screen->format, 120, 120, 120));
            SDL_BlitSurface(blockpic, NULL, screen, &blocks[j]);
            if ((blocks[j].x != 0) && (blocks[j].y != 0))
            {
                if ((blocks[j].x != 32) && (blocks[j].y != 32))
                    j++;
            }
        }
    }

    snakes();
    setblock();
    update();
    printf ("Press D, or Right to start.\n");

    keys = SDL_GetKeyState(NULL);
    while (!done)
    {
        if (keys[SDLK_w] || keys[SDLK_UP])
        {
            if (direction != 2)
            {
                direction = 0;
                start = true;
            }
        }

        if (keys[SDLK_s] || keys[SDLK_DOWN])
        {
            if (direction != 0)
            {
                direction = 2;
                start = true;
            }
        }

        if (keys[SDLK_d] || keys[SDLK_RIGHT])
        {
            if (direction != 3)
            {
                direction = 1;
                start = true;
            }
        }

        if (keys[SDLK_a] || keys[SDLK_LEFT])
        {
            if (direction != 1)
            {
                direction = 3;
                start = true;
            }
        }
        if (keys[SDLK_p])
        {
            if (pause == false)
            {
                pause = true;
                printf ("Game paused! Press P to continue!\n");
            }
            else
                pause = false;
        }

        // **************************************

        if (start == true)
        {
            if (pause == false)
            {
            switch (direction)
            {
                case 0:
                    if ( snake[0].y > 0)
                    {
                        snake[0].y = snake[0].y - 32;
                        trake();
			if (done == true)
			    goto ende;
                        snakes();
                    }
                    else
                    {
                        printf ("You slammed against a wall!\n");
                        printf ("You lost!\n");
                        done = true;
			goto ende;
                    }
                    break;
                case 1:
                    if ((snake[0].x + 32) < screen->w)
                    {
                        snake[0].x = snake[0].x + 32;
                        trake();
                        snakes();
                    }
                    else
                    {
                        printf ("You slammed against a wall!\n");
                        printf ("You lost!\n");
                        done = true;
			goto ende;
                    }
                    break;
                case 2:
                    if ((snake[0].y + 32) < screen->h)
                    {
                        snake[0].y = snake[0].y + 32;
                        trake();
                        snakes();
                    }
                    else
                    {
                        printf ("You slammed against a wall!\n");
                        printf ("You lost!\n");
                        done = true;
			goto ende;
                    }
                    break;
                case 3:
                    if (snake[0].x > 0)
                    {
                        snake[0].x = snake[0].x - 32;
                        trake();
                        snakes();
                    }
                    else
                    {
                        printf ("You slammed against a wall!\n");
                        printf ("You lost!\n");
                        done = true;
			goto ende;

                    }
                    break;
            }
            }
            if ((snake[0].x == block.x) && (snake[0].y == block.y))
            {
                if (lng == 254)
                    ;
                else
                {
                    lng++;
                    points = points + 3;
                    setblock();
                }
            }
            update();
            SDL_Delay(speed);
            count++;
        }


        while (SDL_PollEvent(&event))
        {

            switch(event.type)
            {
                case SDL_QUIT:
                    done = true;
                    break;
                case SDL_KEYDOWN:
                    if (event.key.keysym.sym == SDLK_ESCAPE)
                        done = true;
                    break;
            }
        }
    }
    ende:
    printf ("You scored %d points!\n", points);
    SDL_FreeSurface(background);
    SDL_FreeSurface(blockpic);
    SDL_FreeSurface(apple);
    SDL_Quit();
    printf ("\n");
    printf ("Do you want to play again? (1 = Yes/0 = No)\n");
    scanf ("%d", &restart);
    if (restart == 1)
    {
        u = 0;
        points = 0;
        lng = 4;
        start = false;
        count = 0;
        direction = 5;
        done = false;
	numberblocks = 0;
	j = 0;
	for (j = 0; j <= 255; j++)
	{
	  snake[j].x = -32;
	  snake[j].y = -32;
	}
        goto hier;
    }
    else
        printf ("Program terminated.\n");
    return 0;
}

void blocker()
{
    if (numberblocks != -1)
    {
        while (j < numberblocks)
        {
            blocks[j].w = 32;
            blocks[j].h = 32;
            SDL_FillRect (screen, &blocks[j], SDL_MapRGB (screen->format, 120, 120, 120));
            SDL_BlitSurface(blockpic, NULL, screen, &blocks[j]);
            j++;
        }
    }
}

void update(void)
{
    SDL_FillRect (screen, NULL, SDL_MapRGB (screen ->format, 0, 0, 0));
    SDL_BlitSurface(background, NULL, screen, NULL);
    //SDL_FillRect (screen, &block, SDL_MapRGB (screen->format, 0, 255, 0));
    SDL_BlitSurface (apple, NULL, screen, &block);
    i = 0;

    for (; i <= lng; i++)
    if (i == 1)
        SDL_BlitSurface (snakehead, NULL, screen, &snake[i]);
        // SDL_FillRect (screen, &snake[i], SDL_MapRGB (screen->format, 255, 255, 0));
    else
        SDL_BlitSurface (snakelimb, NULL, screen, &snake[i]);
        // SDL_FillRect (screen, &snake[i], SDL_MapRGB (screen->format, 255, 0, 0));
    j = 0;
    blocker();
#ifndef AROS
    stringColor (screen, 10, 10, "Snake-v1.5 by David Maciejewski", 0xffffffff);
#endif
    SDL_Flip(screen);
}

int setblock(void)
{
    i = 0;
    block.x = (rand()%19 * 32);
    block.y = (rand()%15 * 32);
    block.w = 32;
    block.h = 32;
    if (blockadd == 1)
    {
	for (int c = 0; c <= 150; c = c + 3)
	{
	    if (start == true)
	    {
		if ((points / 3) == c)
		{
		    numberblocks = numberblocks + 1;
		    while (wh == 1)
		    {
			blocks[numberblocks].x = (rand()%19 * 32);
			blocks[numberblocks].y = (rand()%15 * 32);
			if ((blocks[numberblocks].x != 0) && (blocks[numberblocks].y != 0))
			{
			    if ((blocks[numberblocks].x != 32) && (blocks[numberblocks].y != 32))
				wh = 0;
			}
		    }
		    wh = 1;
		}
	    }
	}
    }
    while (i < lng)
    {
        if ((block.x == snake[i].x) && (block.y == snake[i].y))
            setblock();
        else
            ;
        i++;
    }
    i = 0;
    while (i < numberblocks)
    {
        if ((block.x == blocks[i].x) && (block.y == blocks[i].y))
            setblock();
        else
            ;
        i++;
    }
    return 0;
}

int snakes()
{
    int u, i;
    i = lng;
    while (i != 0)
    {
        u = i - 1;
        if (i == 0)
        ;
        else
        {
            snake[i].w = 32;
            snake[i].h = 32;
            snake[i].x = snake[i - 1].x;
            snake[i].y = snake[i - 1].y;
        }
        i--;
    }
    return 0;
}

void trake()
{
    i = 2;
    while (i < lng)
    {
        if (count > 5)
        {
            if ((snake[1].x == snake[i].x) && (snake[1].y == snake[i].y))
            {
                printf ("You have hit yourself!\n");
                printf ("You lost!\n");
                done = true;
            }
        }
        i++;
        j = 0;
        while (j < numberblocks)
        {
            if ((snake[1].x == blocks[j].x) && (snake[1].y == blocks[j].y))
            {
                printf ("You slammed against a block!\n");
                printf ("You lost!\n");
                done = true;
            }
            j++;
        }

    }

}
