/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "msgbox.h"
#include <proto/intuition.h>

void log_displayBox (const char *title, int isError, const char *msg)
{
	if (IntuitionBase) {
		struct EasyStruct easy;
		easy.es_StructSize = sizeof(easy);
		easy.es_Flags = 0;
		easy.es_Title = (CONST_STRPTR)title;
		easy.es_TextFormat = (CONST_STRPTR)"%s";
		easy.es_GadgetFormat = (CONST_STRPTR)"Ok";
		EasyRequest(NULL, &easy, NULL, msg);
	}
}
