		jmp	Start

;GlobalX/Y - pozycja sprita w calej planszy
;LiniaX/Y - x,y pixla w lewym gornym rogu ekranu

RND	=	$bfd600

ScreenWidth	=	384
ScreenHeight	=	256
ScreenDMA	=	320
Depth		=	4
ScrBPR		=	ScreenWidth/8
ScrsNum		=	4
ScrDMA		=	320
ScrNL		=	ScrBPR*Depth
ScrSize		=	ScrNL*ScreenHeight
DDFVAR		=	7

BoxWidth	=	32
BoxHeight	=	32
BoxBPR		=	BoxWidth/8
BoxNL		=	ScrNL*BoxHeight
BoxShowX	=	ScreenWidth/BoxWidth
BoxShowY	=	ScreenHeight/BoxHeight

CaveWidth	=	22*10+2
CaveHeight	=	24*6+2
CaveStartX	=	0
CaveStartY	=	0

BoxBank1Strt	=	0
BoxBank2Strt	=	1
StartBoxBank1	=	BoxBank1Strt*50*512
StartBoxBank2	=	BoxBank2Strt*50*512
StartBoxInfo1	=	BoxBank1Strt*50
StartBoxInfo2	=	BoxBank2Strt*50

AddScrMem	=	[CaveWidth-BoxShowX]*4
CopyReply	=	64
IlSprt		=	35
DrabinaWaitS	=	2
DrabinaWaitL	=	6
JumpSize	=	48

GlobSprtStartX	=	32*4
GlobSprtStartY	=	32*2

MaxIlBob	=	30
MaxIlObject	=	MaxIlBob
BobMemSize	=	12
CursDelay	=	4
MaxIlNab	=	4

BLT_NORMAL	=	%000011001010
BLT_MIRROR1	=	%000011101010
BLT_MIRROR2	=	%000011011010
BLT_WHITE	=	%000011111010

Start:
	bsr.L	Install
	bsr.L	Own_System
	beq.s	Run_Error
	lea	Run_Begin,a6
	move.l	a6,$80
	trap	#0
	bra.s	Run_Quit
Run_Begin:
	move.l	a7,Stos
	lea	CUSTOM,a6
	bsr.s	Program
Halt:
	move.l	Stos,a7
	rte
Run_Quit:
	bsr.L	Disown_System
Run_Error:
	bsr.L	Remove
	rts

;*******************************************************************

Install:
	rts

Remove:
	rts

;*******************************************************************

Program:
	bsr.L	ResetRegisters
	bsr.L	ResetGame
	bsr.L	InstallBox
	bsr.L	InstallSprite
	bsr.L	InstallBob
	bsr.L	ResetBobDraw
	bsr.L	ResetStrzal
	bsr.L	ClrKeyBuf
	bsr.L	SetStartSOFT
	bsr.L	SetVBL
	bsr.L	StartVBL
	bsr.L	SetScreen
	bsr.L	SetDownScreen
	bsr.L	PasteFirst
	bsr.L	Loop_Rainbow2
	bsr.L	ScrMathFirst
	bsr.L	ViewOn
	lea	Txt,a0
	bsr.L	Loop_SetDT
	bsr.L	SetLives
	bsr.L	SetScore
	bsr.L	InitBox
	bsr.L	ResetObject
	bsr.L	InstallSamples
	bsr.L	StartCIA
	bsr.L	Wymus1

	;*** GLOWNA PETLA ***

Loop:
	bsr.L	ShowScreen

	move.w	#$000,$dff180
	;move.w	#$800,$dff180
	btst	#2,$dff016
	bne.s	NoCheck
	move.l	#20,d0
	jsr	Wait
xxx:
	btst	#6,$bfe001
	beq.s	xxx
NoCheck:
	;move.l	#2,d0
	;jsr	Wait

	bsr.L	Joystick
	bsr.L	Loop_BobsClear
	bsr.L	Loop_Scroll
	bsr.L	Loop_ScreenMath
	bsr.L	Loop_Math
	bsr.L	Loop_Object
	bsr.L	Loop_Strzal
	bsr.L	Loop_BobsDraw
	bsr.L	Loop_Work
	bsr.L	Loop_DownFont
	bsr.L	Loop_Lives
	bsr.L	Loop_Score
	bsr.L	Loop_CheckBank
	bsr.L	Loop_CopyLong
	bsr.L	Loop_Sprite
	bsr.L	Loop_JoyOff
	move.w	#$000,$dff180
	bsr.L	Loop_Range
	bsr.L	Loop_RainbowWithWait
	bsr.L	Loop_Fade
	bsr.L	Loop_DownSprite
	bsr.L	Loop_SetSprite
	bsr.L	SubTimer
	bsr.L	WaitBlit

	tst.b	DTQuitGame
	beq.L	Loop
	bsr.L	SamplesOff
	rts

Wymus1:
	move.l	#222*18+11,a0
	adda.l	ObjectPtr,a0
	move.w	#4,d0
W1:
	move.b	#39,(a0)+
	dbf	d0,W1

	move.l	#222*21+6,a0
	adda.l	ObjectPtr,a0
	move.w	#3,d0
W2:
	move.b	#38,(a0)+
	dbf	d0,W2

	move.l	#222*20+6,a0
	adda.l	ObjectPtr,a0
	move.b	#34,(a0)

	move.l	#222*19+10,a0
	adda.l	ObjectPtr,a0
	move.b	#35,(a0)

	move.l	#222*19+7,a0
	adda.l	ObjectPtr,a0
	move.b	#30,(a0)

	move.l	#222*19+8,a0
	adda.l	ObjectPtr,a0
	move.b	#29,(a0)

	move.l	#222*21+10,a0
	adda.l	ObjectPtr,a0
	move.b	#32,(a0)
	move.l	#222*21+11,a0
	adda.l	ObjectPtr,a0
	move.b	#33,(a0)
	move.l	#222*21+12,a0
	adda.l	ObjectPtr,a0
	move.b	#32,(a0)
	move.l	#222*21+13,a0
	adda.l	ObjectPtr,a0
	move.b	#33,(a0)

	move.l	#222*19+6,a0
	adda.l	ObjectPtr,a0
	move.b	#24,(a0)
	move.l	#222*19+9,a0
	adda.l	ObjectPtr,a0
	move.b	#24,(a0)

	move.l	#222*21+7,a0
	adda.l	ObjectPtr,a0
	move.b	#36,(a0)
	rts

;--- wartosci pseudolosowe ---

StartCIA:
	move.b	#0,$bfdf00
	move.b	#255,$bfd600
	move.b	#16,$bfdf00
	move.b	#0,$bfdf00
	move.b	#1,$bfdf00
	rts

;--- Liczniki. ---

SubTimer:
	sub.b	#1,Timer1
	bpl.s	SuTi1
	move.b	#1,Timer1
SuTi1:
	sub.b	#1,Timer2
	bpl.s	SuTi2
	move.b	#2,Timer2
SuTi2:
	sub.b	#1,Timer3
	bpl.s	SuTi3
	move.b	#3,Timer3
SuTi3:
	sub.b	#1,Timer9
	bpl.s	SuTi4
	move.b	#9,Timer9
SuTi4:

	move.w	Wahadlo1,d0
	addq.w	#1,d0
	tst.b	SubAdd1
	beq.s	SuTi5
	subq.w	#2,d0
SuTi5:
	move.w	d0,Wahadlo1
	tst.b	d0
	bne.s	SuTi6
	eor.b	#$ff,SubAdd1
SuTi6:
	cmp.b	#8,d0
	bne.s	SuTi7
	eor.b	#$ff,SubAdd1
SuTi7:
	rts

Timer1:		dc.b	0
Timer2:		dc.b	0
Timer3:		dc.b	0
Timer9:		dc.b	0

Wahadlo1:	dc.w	0
SubAdd1:	dc.b	0
	EVEN

Loop_Work:
	tst.b	WezBobNumS
	beq.s	LoWo1
	clr.w	d1
	move.b	ActWin,d1
	clr.w	d0
	move.b	WezBobNum,d0
	beq.s	LoWo2
	add.b	#44,d0
	cmp.b	#75,d0
	bne.s	LoWo0
	addq.b	#2,d0
LoWo0:
	bsr.l	DrawInBox
	sf	WezBobNumS
	lea	TxtPos,a0
	movea.l	a0,a1
	clr.w	d0
	move.b	WezBobNum,d0
	sub.b	#11,d0
	lsl.w	#2,d0
	move.l	0(a0,d0.w),a0
	add.l	a1,a0
	bsr.L	Loop_SetDT
	bra.s	LoWo1
LoWo2:
	bsr.l	ClrBox
LoWo1:
	rts

;--- Obsluga objektow. ---

;a0.l - lista bobow do rysowania

Loop_Object:
	lea	BobDrawTabBack,a0
	lea	BobDrawTab,a6
	bsr.L	Loop_RemoveObject
	bsr.L	Loop_AddObject
	bsr.L	Loop_ControlObject
	bsr.s	Loop_Collision
	move.w	#-1,4(a6)
	lea	CUSTOM,a6
	rts

;--- Kolizje ze spritem. ---

SPRT_WIDTH	=	26
SPRT_HEIGHT	=	32

Loop_Collision:
	lea	RemoveObject,a4
	lea	ObjectTab,a3
	move.w	GlobalX,d0		;XSprt
	move.w	GlobalY,d1		;YSprt
LoCl1:
	tst.b	(a3)
	bpl.s	LoCl2			;koniec listy
	rts
LoCl2:
	beq.L	LoCl10			;nieaktywny

	;--- Kolizja z nabojem. ---

	tst.b	1(a3)
	beq.s	LoCl3b			;nie badac z nabojem
	tst.b	19(a3)
	beq.s	LoCl3			;brak jakiejkolwiek kolizji
	bpl.s	LoCl3b			;byla ze spritem
	sf	19(a3)			;kolizja odebrana
	sf	d7			;kolizja z nabojem
	bra.s	LoCl_Collision		;skok do procedur kolizji

	;--- Kolizja ze spritem. ---

LoCl3b:
	tst.b	18(a3)			;nie badac ze spritem
	beq.s	LoCl3
	tst.b	19(a3)
	beq.s	LoCl3
	sf	19(a3)
	st	d7			;kolizja ze spritem
LoCl_Collision:
	clr.w	d0
	move.b	(a3),d0
	move.w	d0,d1
	lsl.w	#2,d1
	move.l	0(a4,d1.w),a5
	movem.l	a3/a4,-(sp)
	jsr	(a5)			;(JMP)
	movem.l	(sp)+,a3/a4

LoCl3:
LoCl10:
	lea	ObjectSize(a3),a3
	bra.L	LoCl1

;--- Usuniecie objektow poza ekranem. ---

Loop_RemoveObject:
	lea	ObjectTab,a3
LoRo0:
	tst.b	(a3)
	bpl.s	LoRo1
	rts
LoRo1:
	beq.s	LoRo2
	move.w	10(a3),d1	;XBob
	move.w	12(a3),d2	;YBob
	add.w	#32,d1
	add.w	#32,d2

	sub.w	LiniaX,d1
	bmi.s	LoRo_Usun
	sub.w	LiniaY,d2
	bmi.s	LoRo_Usun
	cmp.w	#13*32,d1
	bhi.s	LoRo_Usun
	cmp.w	#9*32,d2
	bhi.s	LoRo_Usun

	bra.s	LoRo2

LoRo_Usun:
	sf	(a3)
LoRo2:
	lea	ObjectSize(a3),a3
	bra.s	LoRo0

;--- Dodanie objektow. ---

Loop_AddObject:
	lea	InstObject,a4

	cmp.b	#2,CntUp
	bne.s	LoAo1

	;--- GORA ---

	move.l	BoxOffset,a1
	move.l	a1,a2
	adda.l	CavePtr,a1
	adda.l	ObjectPtr,a2
	clr.w	d1
	clr.w	d2
	move.b	CaveX,d1
	move.b	CaveY,d2
	move.w	#11,d3
LoAo11:
	move.b	(a2),d0
	beq.s	LoAo12
	bsr.L	AddObject
LoAo12:
	lea	1(a1),a1
	lea	1(a2),a2
	addq.b	#1,d1
	dbf	d3,LoAo11
	bra.s	LoAo2
LoAo1:
	cmp.b	#2,CntDown
	bne.s	LoAo2

	;--- DOL ---

	move.l	BoxOffset,a1
	adda.l	#CaveWidth*7,a1	;dolna linia
	move.l	a1,a2
	adda.l	CavePtr,a1
	adda.l	ObjectPtr,a2
	clr.w	d1
	clr.w	d2
	move.b	CaveX,d1
	move.b	CaveY,d2
	addq.b	#7,d2		;dolna linia
	move.w	#11,d3
LoAo21:
	move.b	(a2),d0
	beq.s	LoAo22
	bsr.L	AddObject
LoAo22:
	lea	1(a1),a1
	lea	1(a2),a2
	addq.b	#1,d1
	dbf	d3,LoAo21
LoAo2:
	cmp.b	#2,CntLeft
	bne.s	LoAo3

	;--- LEWO ---

	move.l	BoxOffset,a1
	move.l	a1,a2
	adda.l	CavePtr,a1
	adda.l	ObjectPtr,a2
	clr.w	d1
	clr.w	d2
	move.b	CaveX,d1
	move.b	CaveY,d2
	move.w	#7,d3
LoAo31:
	move.b	(a2),d0
	beq.s	LoAo32
	bsr.s	AddObject
LoAo32:
	lea	CaveWidth(a1),a1
	lea	CaveWidth(a2),a2
	addq.b	#1,d2
	dbf	d3,LoAo31
	bra.s	LoAo4
LoAo3:
	cmp.b	#2,CntRight
	bne.s	LoAo4

	;--- PRAWO ---

	move.l	BoxOffset,a1
	lea	11(a1),a1	;na prawo
	move.l	a1,a2
	adda.l	CavePtr,a1
	adda.l	ObjectPtr,a2
	clr.w	d1
	clr.w	d2
	move.b	CaveX,d1
	move.b	CaveY,d2
	add.b	#11,d1		;na prawo
	move.w	#7,d3
LoAo41:
	move.b	(a2),d0
	beq.s	LoAo42
	bsr.s	AddObject
LoAo42:
	lea	CaveWidth(a1),a1
	lea	CaveWidth(a2),a2
	addq.b	#1,d2
	dbf	d3,LoAo41
LoAo4:
	rts

;--- Dodanie objektu wg. numeru. ---

;d0.B - numer objektu
;d1.B - CaveX
;d2.B - CaveY
;d3.W - NC
;a1.L - Adres w tablicy CAVE
;a2.L - Adres w tablicy OBJECT
;a4.L - Install Object Array

;najpierw, czy ten object juz jest

AddObject:
	lea	ObjectTab,a3
AdOb001:
	tst.b	(a3)
	bmi.s	AdOb00
	beq.s	AdOb000
	cmpa.l	6(a3),a1
	beq.s	AdOb_Quit
AdOb000:
	lea	ObjectSize(a3),a3
	bra.s	AdOb001
AdOb00:
	lea	ObjectTab,a3
AdOb0:
	tst.b	(a3)
	bpl.s	AdOb1
AdOb_Quit:
	rts

AdOb1:
	bne.s	AdOb2
AddObject2:
	move.b	d0,(a3)
	move.w	d1,d4
	move.w	d2,d5
	lsl.w	#5,d4
	lsl.w	#5,d5
	move.l	a2,2(a3)
	move.l	a1,6(a3)
	move.w	d4,10(a3)
	move.w	d5,12(a3)
	move.w	d1,20(a3)
	move.w	d2,22(a3)

	clr.w	d7
	move.b	d0,d7
	lsl.w	#2,d7
	move.l	0(a4,d7.w),a5
	jmp	(a5)
AdOb2:
	lea	ObjectSize(a3),a3
	bra.s	AdOb0

;--- Obsluga objektow. ---

Loop_ControlObject:
	lea	ObjectTab,a1
	lea	MoveObject,a2
LoCo1:
	tst.b	(a1)
	bpl.s	LoCo2
	rts
LoCo2:
	beq.L	LoCo3
	clr.w	d0
	move.b	(a1),d0
	move.w	d0,d1
	lsl.w	#2,d1
	move.l	0(a2,d1.w),a3

	sf	d7
	jsr	(a3)			;Procedura MOVE Objektu

	;--- kolizje z nabojem. ---

	tst.b	d7
	beq.L	LoCo3			;nie zostal narysowany
	bpl.L	DrawA0

	tst.b	1(a1)
	beq.s	LoCo3M			;nie sprawdzac z nabojem
	tst.b	19(a1)			;poprzednia kolizja
	bne.L	LoCo3			;nie odebrana

	lea	NabTab,a5		;tablica naboi
	move.w	-8(a6),d2		;XBob
	move.w	2-8(a6),d3		;YBob
	addq.w	#4,d2
	addq.w	#4,d3
	move.w	d2,d4
	move.w	d3,d5
	add.w	14(a1),d2		;XB+WB
	add.w	16(a1),d3		;YB+HB
	moveq	#MaxIlNab-1,d0		;sprawdzic z kazdym nabojem
LoCl_NabLoop:
	tst.w	4(a5)
	bmi.s	LoCl_NoNab		;brak naboja
	movem.w	d4/d5,-(sp)
	sub.w	#16,d4			;XB-WidthNab
	sub.w	#8,d5			;YB-HeightNab
	cmp.w	8(a5),d2		;XS>XB+WB
	blt.s	LoCl_NoNabS
	cmp.w	8(a5),d4		;XS<XB-WS
	bgt.s	LoCl_NoNabS
	cmp.w	10(a5),d3
	blt.s	LoCl_NoNabS
	cmp.w	10(a5),d5
	bgt.s	LoCl_NoNabS

	move.w	#-1,4(a5)		;brak naboja
	sf	6(a5)
	st	19(a1)			;byla kolizja

LoCl_NoNabS:
	movem.w	(sp)+,d4/d5

LoCl_NoNab:
	lea	NABTABS(a5),a5
	dbf	d0,LoCl_NabLoop

LoCo3M:
	;--- ze spritem ---

	tst.b	19(a1)			;byla kolizja z
	bne.s	LoCo3			;nabojem - wyzszy priorytet
	tst.b	18(a1)
	beq.s	LoCo3			;nie badac ze spritem

	move.w	-8(a6),d2		;XBob
	move.w	2-8(a6),d3		;YBob
	move.w	d2,d4
	move.w	d3,d5
	add.w	14(a1),d2		;XB+WB
	add.w	16(a1),d3		;YB+HB
	sub.w	#SPRT_WIDTH,d4		;XB-WS
	sub.w	#SPRT_HEIGHT,d5		;YB-HS
	cmp.w	GlobalX,d2		;XS>XB+WB
	blt.s	LoCo3
	cmp.w	GlobalX,d4		;XS<XB-WS
	bgt.s	LoCo3
	cmp.w	GlobalY,d3
	blt.s	LoCo3
	cmp.w	GlobalY,d5
	bgt.s	LoCo3

	move.b	#1,19(a1)		;byla kolizja
LoCo3:
	lea	ObjectSize(a1),a1
	bra.L	LoCo1

DrawA0:
	tst.b	19(a1)
	bne.s	LoCo3
	tst.b	18(a1)
	beq.s	LoCo3			;nie badac ze spritem

	move.w	-8(a0),d2		;XBob
	move.w	2-8(a0),d3		;YBob
	move.w	d2,d4
	move.w	d3,d5
	add.w	14(a1),d2		;XB+WB
	add.w	16(a1),d3		;YB+HB
	sub.w	#SPRT_WIDTH,d4		;XB-WS
	sub.w	#SPRT_HEIGHT,d5		;YB-HS
	cmp.w	GlobalX,d2		;XS>XB+WB
	blt.s	LoCo3
	cmp.w	GlobalX,d4		;XS<XB-WS
	bgt.s	LoCo3
	cmp.w	GlobalY,d3
	blt.s	LoCo3
	cmp.w	GlobalY,d5
	bgt.s	LoCo3

	move.b	#1,19(a1)
	lea	ObjectSize(a1),a1
	bra.L	LoCo1

;*******************************************************************
;			Procedury Obslugi
;*******************************************************************

	;a0.L - Lista bobow
	;a1.L - struktura
	;d0.W - numer objektu
	;d2.B - czy mozliwosc zmiany w CAVE

	;a2 - NC

Move_CloseDoor:
	move.l	6(a1),a3
	bset	#7,(a3)			;kod muru
	move.l	2(a1),a3
	cmp.b	#1,(a3)			;czy nadal zamkniete
	beq.s	MoCd2
	move.b	#2,(a1)			;zmien na zamkniete
MoCd2:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	#67,4(a0)
	move.w	#BLT_NORMAL,6(a0)
	add.w	#10,(a0)
	sub.w	#6,2(a0)
	lea	8(a0),a0
	rts

Move_OpenDoor:
	move.l	6(a1),a3
	bclr	#7,(a3)			;kod przejscia
	move.l	2(a1),a3
	cmp.b	#2,(a3)			;czy nadal otwarte
	beq.s	MoOd2
	move.b	#1,(a1)			;zmien na zamkniete
MoOd2:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	#68,4(a0)
	move.w	#BLT_NORMAL,6(a0)
	add.w	#10,(a0)
	sub.w	#6,2(a0)
	lea	8(a0),a0
	rts

Move_Diamond1:
	tst.b	Timer2
	bne.s	MoDi1
	add.w	#1,24(a1)
	cmp.w	#14,24(a1)
	bne.s	MoDi1
	move.w	#8,24(a1)
MoDi1:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	24(a1),4(a0)
	move.w	#BLT_NORMAL,6(a0)
	add.w	#16,2(a0)
	bra.L	JumpProc

Move_Diamond2:
	tst.b	Timer2
	bne.s	MoDi2
	sub.w	#1,24(a1)
	cmp.w	#13,24(a1)
	bhi.s	MoDi2
	move.w	#19,24(a1)
MoDi2:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	24(a1),4(a0)
	move.w	#BLT_NORMAL,6(a0)
	add.w	#16,2(a0)
	bra.s	JumpProc

Move_ChmuraGet:
	tst.b	Timer1
	bne.s	MoCh1
	add.w	#1,24(a1)
	cmp.w	#38,24(a1)
	bne.s	MoCh1
	sf	(a1)
	rts
MoCh1:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	24(a1),4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	rts

JumpProc:
	tst.w	26(a1)
	beq.s	MoDi2B
	lea	Jump1,a3
	move.w	26(a1),d1
	cmp.w	#88,d1
	bls.s	MoDi2C
	move.w	#44*2,d1
MoDi2C:
	move.w	0(a3,d1.w),d2
	sub.w	d2,2(a0)
	sub.w	#2,26(a1)
MoDi2B:
	lea	8(a0),a0
	moveq	#1,d7
	rts

;- 6 -
Move_Mina1:
	move.w	30(a1),d1
	addq.w	#1,d1
	tst.b	27(a1)
	beq.s	MoMi0
	subq.w	#2,d1
MoMi0:
	tst.b	d1
	bne.s	MoMi0B
	eor.b	#$ff,27(a1)
	bra.s	MoMi0C
MoMi0B:
	cmp.b	#8,d1
	bne.s	MoMi0C
	eor.b	#$ff,27(a1)
MoMi0C:
	move.w	d1,30(a1)
	add.w	28(a1),d1
	move.w	d1,12(a1)

	move.w	10(a1),d3
	addq.w	#1,d3
	tst.b	26(a1)
	bne.s	MoMi4
	subq.w	#2,d3
MoMi4:
	move.w	d3,10(a1)
	move.w	12(a1),d4
	add.w	#9,d3
	add.w	#9,d4
	bsr.L	JakaKostka
	bne.s	MoMi3
	eor.b	#$ff,26(a1)
MoMi3:
	move.w	24(a1),d1
	tst.b	Timer1
	bne.s	MoMi1
	addq.w	#1,d1
	cmp.w	#46,d1
	bne.s	MoMi2
	subq.w	#2,d1
MoMi2:
	move.w	d1,24(a1)
MoMi1:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	d1,4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6
	st	d7
	rts

;- 6 -
Move_Mina2:
	move.w	30(a1),d1
	addq.w	#1,d1
	tst.b	27(a1)
	beq.s	MoMi0e
	subq.w	#2,d1
MoMi0e:
	tst.b	d1
	bne.s	MoMi0Bb
	eor.b	#$ff,27(a1)
	bra.s	MoMi0Cb
MoMi0Bb:
	cmp.b	#8,d1
	bne.s	MoMi0Cb
	eor.b	#$ff,27(a1)
MoMi0Cb:
	move.w	d1,30(a1)
	add.w	28(a1),d1
	move.w	d1,12(a1)

	move.w	10(a1),d3
	addq.w	#1,d3
	tst.b	26(a1)
	bne.s	MoMi4b
	subq.w	#2,d3
MoMi4b:
	move.w	d3,10(a1)
	move.w	12(a1),d4
	add.w	#9,d3
	add.w	#9,d4
	bsr.L	JakaKostka
	bne.s	MoMi3b
	eor.b	#$ff,26(a1)
MoMi3b:
	move.w	24(a1),d1
	tst.b	Timer1
	bne.s	MoMi1b
	addq.w	#1,d1
	cmp.w	#48,d1
	bne.s	MoMi2b
	subq.w	#2,d1
MoMi2b:
	move.w	d1,24(a1)
MoMi1b:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	d1,4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6
	st	d7
	rts

Move_Wyrzutnia:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	30(a1)
	beq.s	MoWy100
	sf	30(a1)
	move.w	#BLT_WHITE,6(a6)
MoWy100:
	move.w	#43,4(a6)
	cmp.b	#214,28(a1)
	bhi.s	MoWy00
	move.w	#42,4(a6)
MoWy00:
	lea	8(a6),a6
	tst.b	28(a1)
	bne.s	MoWy1
	move.b	#244,28(a1)
	moveq	#9,d0
	bsr.L	FI
MoWy1:
	sub.b	#1,28(a1)
	st	d7
	rts

Move_Rakieta:
	move.w	10(a1),d0
	move.w	12(a1),d1
	tst.b	25(a1)
	beq.s	MoRa1
	cmp.w	GlobalY,d1
	bhi.s	MoRa3
	addq.w	#1,d1
	bra.s	MoRa2
MoRa3:
	sf	25(a1)
	bra.s	MoRa2
MoRa1:
	addq.w	#6,d0
	tst.b	24(a1)
	bne.s	MoRa2
	sub.w	#12,d0
MoRa2:
	move.w	d0,10(a1)
	move.w	d1,12(a1)

	tst.b	Timer2
	bne.s	MoRa10
	add.b	#1,27(a1)
	cmp.b	#40,27(a1)
	bne.s	MoRa10
	move.b	#38,27(a1)
MoRa10:
	move.w	d0,(a6)
	move.w	d1,2(a6)
	move.w	26(a1),d0
	tst.b	24(a1)
	beq.s	MoRa0
	addq.b	#2,d0
MoRa0:
	move.w	d0,4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6

	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoRa00
	exg	a1,a3
	sub.w	#8,12(a3)
	add.w	#4,10(a3)
	bsr.l	Inst_Chmura16
	exg	a3,a1
	sf	d7
	rts
MoRa00:
	st	d7
	rts

;-10-
Move_Chmura16:
	tst.b	Timer1
	bne.s	MoCh2
	add.w	#1,24(a1)
	cmp.w	#55,24(a1)
	bne.s	MoCh2
	sf	(a1)
	rts
MoCh2:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	24(a1),4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	rts

;-11 do 22-
Move_Przedmiot:
	move.w	10(a1),(a0)
	move.w	12(a1),d1
	move.w	24(a1),d2
	beq.s	MoPr1
	lea	Jump2,a4
	sub.w	0(a4,d2.w),d1
	subq.w	#2,d2
	move.w	d2,24(a1)
MoPr1:
	add.w	#16,d1
	move.w	d1,2(a0)
	add.w	#44,d0
	move.w	#BLT_NORMAL,6(a0)

	cmp.b	#75,d0
	bne.s	MoPr0
	addq.b	#2,d0
MoPr0:
	move.w	d0,4(a0)		;num boba
	lea	8(a0),a0
	moveq	#1,d7
	rts

;- 23 -
Move_Chmura32:
	tst.b	Timer1
	bne.s	MoCh2b
	add.w	#1,24(a1)
	cmp.w	#109,24(a1)
	bne.s	MoCh2b
	sf	(a1)
	rts
MoCh2b:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	move.w	24(a1),4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	rts

;- 24 -
Move_Plyta:
	tst.b	Timer1
	bne.s	MoPl1
	add.w	#1,24(a1)
	cmp.w	#104,24(a1)
	bne.s	MoPl1
	move.w	#98,24(a1)
MoPl1:
	add.w	#1,12(a1)
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	tst.b	27(a1)
	beq.s	MoPl2
	move.w	#BLT_WHITE,6(a6)
	sf	27(a1)
	bra.s	MoPl3
MoPl2:
	move.w	#BLT_NORMAL,6(a6)
MoPl3:
	lea	8(a6),a6

	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoPl0
	exg	a1,a3
	bsr.l	Inst_Chmura16
	exg	a3,a1
	sf	d7
	rts
MoPl0:
	st	d7
	rts

; 25
Move_Ball1:
	add.w	#4,10(a1)
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6

	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoBll1
	exg	a1,a3
	sub.w	#8,12(a3)
	sub.w	#4,10(a3)
	bsr.l	Inst_Chmura16
	exg	a3,a1
	rts
MoBll1:
	st	d7
	rts

; 26
Move_Ball2:
	sub.w	#4,10(a1)
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6
	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoBll2
	exg	a1,a3
	sub.w	#8,12(a3)
	sub.w	#4,10(a3)
	bsr.l	Inst_Chmura16
	exg	a3,a1
	rts
MoBll2:
	st	d7
	rts

; 27
Move_Ball3:
	add.w	#2,10(a1)
	add.w	#2,12(a1)
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6
	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoBll3
	exg	a1,a3
	sub.w	#8,12(a3)
	sub.w	#4,10(a3)
	bsr.l	Inst_Chmura16
	exg	a3,a1
	rts
MoBll3:
	st	d7
	rts

; 28
Move_Ball4:
	sub.w	#2,10(a1)
	add.w	#2,12(a1)
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	lea	8(a6),a6
	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoBll4
	exg	a1,a3
	sub.w	#6,10(a3)
	sub.w	#4,12(a3)
	bsr.l	Inst_Chmura16
	exg	a3,a1
	rts
MoBll4:
	st	d7
	rts

;29
Move_OutBall:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	29(a1)
	beq.s	MoOb5
	move.w	#BLT_WHITE,6(a6)
	sf	29(a1)
MoOb5:
	tst.b	Timer3
	bne.s	MoOb1
	add.w	#1,24(a1)
	cmp.w	#75,24(a1)
	bcs.s	MoOb2
	move.w	#73,24(a1)
MoOb2:
	sub.b	#1,26(a1)
	bne.s	MoOb1
	move.b	#20,26(a1)
	moveq	#27,d0
	eor.b	#$ff,27(a1)
	beq.s	MoOb3
	moveq	#28,d0
MoOb3:
	bsr.l	FI
MoOb1:
	lea	8(a6),a6
	st	d7
	rts

;30
Move_Fly:
	move.w	10(a1),d3
	move.w	12(a1),d4

	move.w	GlobalX,d7
	cmp.w	d3,d7
	bcs.s	MoFl3
	bhi.s	MoFl4
	bra.s	MoFl5
MoFl4:
	add.w	#1,d3
	bra.s	MoFl5
MoFl3:
	sub.w	#1,d3
MoFl5:
	move.w	d3,d1
	move.w	d4,d2
	addq.w	#8,d3
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoFl5b
	move.w	10(a1),d3
	move.w	d2,d4
	bra.s	MoFl5c
MoFl5b:
	move.w	d1,d3
	move.w	d2,d4
MoFl5c:
	move.w	GlobalY,d7
	cmp.w	d4,d7
	bcs.s	MoFl3b
	bhi.s	MoFl4b
	bra.s	MoFl5bb
MoFl4b:
	add.w	#1,d4
	bra.s	MoFl5bb
MoFl3b:
	sub.w	#1,d4
MoFl5bb:
	move.w	d3,d1
	move.w	d4,d2
	addq.w	#8,d3
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoFl5b2
	move.w	d1,d3
	move.w	12(a1),d4
	bra.s	MoFl5c2
MoFl5b2:
	move.w	d1,d3
	move.w	d2,d4
MoFl5c2:
	move.w	d3,10(a1)
	move.w	d4,12(a1)

	move.w	d3,(a6)
	move.w	d4,2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	27(a1)
	beq.s	MoFl2
	move.w	#BLT_WHITE,6(a6)
	sf	27(a1)
MoFl2:
	tst.b	Timer2
	bne.s	MoFl1
	add.w	#1,24(a1)
	cmp.w	#73,24(a1)
	bcs.s	MoFl1
	move.w	#69,24(a1)
MoFl1:
	lea	8(a6),a6
	st	d7
	rts

;32
Move_Kolec1:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	add.w	#16,2(a0)
	move.w	#78,4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	moveq	#1,d7
	rts

;33
Move_Kolec2:
	move.w	10(a1),(a0)
	move.w	12(a1),2(a0)
	add.w	#16,2(a0)
	move.w	#79,4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	moveq	#1,d7
	rts

;34
Move_DzialoP:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	27(a1)
	beq.s	MoDzp
	move.w	#BLT_WHITE,6(a6)
	sf	27(a1)
MoDzp:
	lea	8(a6),a6
	st	d7
	tst.b	Timer2
	bne.s	MoDp1
	cmp.w	#94,24(a1)
	beq.s	MoDp1
	add.w	#1,24(a1)
MoDp1:
	sub.b	#1,26(a1)
	bne.s	MoDp2
	move.b	#100,26(a1)
	move.w	#92,24(a1)
	moveq	#25,d0
	bsr.l	FI
MoDp2:
	rts

;35
Move_DzialoL:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	add.w	#18,(a6)
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	27(a1)
	beq.s	MoDzl
	move.w	#BLT_WHITE,6(a6)
	sf	27(a1)
MoDzl:
	lea	8(a6),a6
	st	d7
	tst.b	Timer2
	bne.s	MoDp1b
	cmp.w	#97,24(a1)
	beq.s	MoDp1b
	add.w	#1,24(a1)
MoDp1b:
	sub.b	#1,26(a1)
	bne.s	MoDp2b
	move.b	#100,26(a1)
	move.w	#95,24(a1)
	moveq	#26,d0
	bsr.l	FI
MoDp2b:
	rts

;- 36 -
Move_Mina:
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	move.w	#90,4(a6)
	tst.b	24(a1)
	bne.s	MoMi9
	move.w	#91,4(a6)
MoMi9:
	tst.b	Timer2
	bne.s	MoMi8
	eor.b	#$ff,24(a1)
MoMi8:
	move.w	#BLT_NORMAL,6(a6)
	add.w	#22,2(a6)
	lea	8(a6),a6
	st	d7
	rts

;37
Move_Box:
	tst.b	Timer1
	bne.s	MoBx1
	tst.b	27(a1)
	beq.s	MoBx2
	add.w	#1,28(a1)
	cmp.w	#85,28(a1)
	bne.s	MoBx1
	sf	27(a1)
	bra.s	MoBx1
MoBx2:
	sub.w	#1,28(a1)
	cmp.w	#80,28(a1)
	bne.s	MoBx1
	st	27(a1)
MoBx1:
	tst.b	24(a1)
	bne.s	MoBx6
	move.b	$bfd600,25(a1)
	tst.b	Timer3
	bne.s	MoBxxx
	move.b	$bfd600,26(a1)
MoBxxx:
	move.b	#13,24(a1)
MoBx6:
	sub.b	#1,24(a1)

	move.w	10(a1),d3
	move.w	12(a1),d4
	addq.w	#1,d3
	addq.w	#1,d4
	tst.b	25(a1)
	bpl.s	MoBx7
	subq.w	#2,d3
MoBx7:
	tst.b	26(a1)
	bpl.s	MoBx8
	subq.w	#2,d4
MoBx8:
	move.w	d3,d1
	move.w	d4,d2
	addq.w	#8,d3
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoBxE
	move.w	10(a1),(a6)
	move.w	12(a1),2(a6)
	eor.b	#%10000000,25(a1)
	eor.b	#%10000000,26(a1)
	bra.s	MoBxQ
MoBxE:
	move.w	d1,(a6)
	move.w	d2,2(a6)
	move.w	d1,10(a1)
	move.w	d2,12(a1)
MoBxQ:
	move.w	28(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	31(a1)
	beq.s	MoBxW
	move.w	#BLT_WHITE,6(a6)
	sf	31(a1)
MoBxW:
	lea	8(a6),a6
	st	d7
	rts

;38
Move_JBall:
	move.w	10(a1),(a6)
	tst.b	29(a1)
	beq.s	MoJb4
	add.w	#4,12(a1)
	move.w	12(a1),2(a6)
	add.w	#17,2(a6)
	move.w	10(a1),d3
	move.w	12(a1),d4
	add.w	#8,d3
	add.w	#17,d4
	add.w	#15,d4
	bsr.l	JakaKostka
	bne.L	MoJb0
	sf	29(a1)
	bra.L	MoJb0
MoJb4:
	lea	JumpBall,a4
	move.w	26(a1),d0
	move.w	12(a1),d1
	add.w	#17,d1
	sub.w	0(a4,d0.w),d1
	move.w	d1,2(a6)
	addq.w	#2,d0
	cmp.w	#74,d0
	bcs.s	MoJb1
	move.w	#0,26(a1)

	move.w	10(a1),d3
	move.w	12(a1),d4
	add.w	#8,d3
	add.w	#32,d4
	bsr.l	JakaKostka
	beq.s	MoJb0
	st	29(a1)
	bra.s	MoJb0
MoJb1:
	move.w	d0,26(a1)
	move.w	10(a1),d0
	addq.w	#1,d0
	tst.b	28(a1)
	beq.s	MoJb2
	subq.w	#2,d0
MoJb2:

	move.w	d0,d3
	addq.w	#8,d3
	move.w	2(a6),d4
	addq.w	#8,d4
	bsr.l	JakaKostka
	bne.s	MoJb9
	eor.b	#$ff,28(a1)
MoJb9:
	move.w	d0,10(a1)
	move.w	d0,(a6)
MoJb0:
	move.w	24(a1),4(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	31(a1)
	beq.s	MoJb8
	sf	31(a1)
	move.w	#BLT_WHITE,6(a6)
MoJb8:
	lea	8(a6),a6
	st	d7
	rts

;39
Move_Rura:
	move.w	12(a1),d1
	move.w	24(a1),d0
	lea	JumpBall,a4
	sub.w	0(a4,d0.w),d1
	lea	RuraBob,a4
	move.w	0(a4,d0.w),4(a6)
	;tst.b	Timer1
	;bne.s	MoRu1
	addq.w	#2,d0
	cmp.w	#74,d0
	bcs.s	MoRu1
	move.w	#0,d0
MoRu1:
	move.w	d0,24(a1)
	move.w	10(a1),(a6)
	add.w	#24,d1
	move.w	d1,2(a6)
	move.w	#BLT_NORMAL,6(a6)
	tst.b	26(a1)
	beq.s	MoRu2
	move.w	#BLT_WHITE,6(a6)
	sf	26(a1)
MoRu2:
	lea	8(a6),a6
	st	d7
	rts

RuraBob:
	dc.w	89,89,88,88,87,87,86,86,86,86
	dc.w	86,86,86,86,86,86,86,86,86,86
	dc.w	86,86,86,86,86,86,86,86,86,86
	dc.w	86,86,86,86,86,87,88
	
;*******************************************************************
;			Procedury Instalacji
;*******************************************************************

	;d0.B - Numer objektu
	;d1.B - CaveX
	;d2.B - CaveY
	;a1.L - Adres w tablicy CAVE
	;a2.L - Adres w tablicy OBJECT
	;a3.L - Struktura

	;d3,a4 - NC

;d0-ObjNum
FI:
	movem.l	a1/a2,-(sp)
	lea	ObjectTab,a3
MoWy2:
	tst.b	(a3)
	beq.s	MoWy4			;wolne
	bmi.s	MoWy0
	lea	ObjectSize(a3),a3
	bra.s	MoWy2
MoWy4:
	move.w	20(a1),d1
	move.w	22(a1),d2
	lea	InstObject,a4
	bsr.L	AddObject2
MoWy0:
	movem.l	(sp)+,a1/a2
	rts

Inst_Empty:
	sf	1(a3)
	sf	18(a3)
	rts

Inst_Diamond:
	sf	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	move.w	#8,24(a3)
	move.w	#2*56,26(a3)
	rts

;	- 5 -
Inst_ChmuraGet:
	move.b	#5,(a3)
	sf	1(a3)
	add.w	#16,12(a3)
	sf	18(a3)
	move.w	#28,24(a3)
	rts

Inst_Mina1:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#44,24(a3)
	sf	26(a3)
	sf	27(a3)
	move.w	12(a3),28(a3)
	sub.w	#6,28(a3)
	move.w	#0,30(a3)
	rts

;- 7 -
Inst_Mina2:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#46,24(a3)
	st	26(a3)
	sf	27(a3)
	move.w	12(a3),28(a3)
	sub.w	#6,28(a3)
	move.w	#0,30(a3)
	rts

;-8-
Inst_Wyrzutnia:
	st	1(a3)
	move.w	#32,14(a3)
	move.w	#16,16(a3)
	sf	18(a3)
	sf	19(a3)
	move.w	10(a3),24(a3)
	move.w	12(a3),26(a3)
	sf	28(a3)
	move.b	#6,29(a3)
	sf	30(a3)
	rts

;-9-
Inst_Rakieta:
	st	1(a3)
	add.w	#2,10(a3)
	move.w	#16,14(a3)
	move.w	#8,16(a3)
	st	18(a3)
	sf	19(a3)
	move.b	Timer2,24(a3)
	st	25(a3)
	move.w	#38,26(a3)
	rts

;-10-
Inst_Chmura16:
	sf	1(a3)
	move.b	#10,(a3)
	add.w	#4,12(a3)
	sf	18(a3)
	move.w	#48,24(a3)
	rts

;-11 do 22-
Inst_Przedmiot:
	sf	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	move.w	#0,24(a3)
	rts

;- 23 -
Inst_Chmura32:
	sf	1(a3)
	move.b	#23,(a3)
	sf	18(a3)
	move.w	#104,24(a3)
	rts

;- 24 -
Inst_Plyta:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#98,24(a3)
	move.b	#4,26(a3)
	sf	27(a3)
	rts

; 25-28 24(a3)-numer boba ustawic!
Inst_Ball1:
	add.w	#8,10(a3)
	add.w	#3,12(a3)
	st	1(a3)
	move.w	#8,14(a3)
	move.w	#8,16(a3)
	st	18(a3)
	sf	19(a3)
InBl2:
	move.w	#75,24(a3)
	tst.b	Timer2
	beq.s	InBl1
	move.w	#76,24(a3)
InBl1:
	rts

Inst_Ball2:
	add.w	#16,10(a3)
	add.w	#3,12(a3)
	st	1(a3)
	move.w	#8,14(a3)
	move.w	#8,16(a3)
	st	18(a3)
	sf	19(a3)
	bra.s	InBl2

Inst_Ball3:
	add.w	#6,12(a3)
	add.w	#8,10(a3)
	st	1(a3)
	move.w	#8,14(a3)
	move.w	#8,16(a3)
	st	18(a3)
	sf	19(a3)
	bra.s	InBl2

Inst_Ball4:
	add.w	#6,12(a3)
	st	1(a3)
	move.w	#8,14(a3)
	move.w	#8,16(a3)
	st	18(a3)
	sf	19(a3)
	bra.L	InBl2

;29
Inst_OutBall:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#73,24(a3)
	move.b	#1,26(a3)
	sf	27(a3)
	move.b	#16,28(a3)
	sf	29(a3)
	rts

;30
Inst_Fly:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#69,24(a3)
	move.b	#10,26(a3)
	sf	27(a3)
	rts

;32
Inst_Kolec1:
	sf	1(a3)
	st	18(a3)
	move.w	#8,14(a3)
	move.w	#16,16(a3)
	rts

;33
Inst_Kolec2:
	sf	1(a3)
	st	18(a3)
	move.w	#8,14(a3)
	move.w	#16,16(a3)
	rts

;34
Inst_DzialoP:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#94,24(a3)
	move.b	#1,26(a3)
	sf	27(a3)
	move.b	#10,28(a3)
	rts

;35
Inst_DzialoL:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#97,24(a3)
	move.b	#1,26(a3)
	sf	27(a3)
	move.b	#10,28(a3)
	rts

;- 36 -
Inst_Mina:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#10,16(a3)
	st	18(a3)
	sf	24(a3)
	sf	19(a3)
	rts

;37
Inst_Box:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.b	#0,24(a3)	;zmiana x,y
	sf	25(a3)		;plus x
	sf	26(a3)		;plus y
	st	27(a3)		;0-plus bob / 1-minus bob
	move.w	#80,28(a3)	;num boba
	sf	31(a3)
	move.b	#6,30(a3)
	rts

;38
Inst_JBall:
	st	1(a3)
	move.w	#16,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#0,26(a3)
	move.w	#20,24(a3)
	btst	#0,RND
	beq.s	InJb1
	move.w	#21,24(a3)
InJb1:
	sf	28(a3)
	btst	#1,RND
	beq.s	InJb2
	st	28(a3)
InJb2:
	sf	29(a3)
	move.b	#6,30(a3)
	sf	31(a3)
	rts

;39
Inst_Rura:
	st	1(a3)
	move.w	#10,14(a3)
	move.w	#16,16(a3)
	st	18(a3)
	sf	19(a3)
	move.w	#0,24(a3)
	sf	26(a3)
	move.b	#10,27(a3)
	rts

;*******************************************************************
;			Procedury usuniecia
;*******************************************************************

	;d7.B = TRUE-przez sprite / FALSE-przez naboj
	;a3.L - Struktura

	;a0,a6 - NC

Rem_Diamond:
	move.l	#1,d0
	bsr.l	Loop_AddScore
	move.l	2(a3),a1
	sf	(a1)			;usuniecie w OBJECT
	bra.L	Inst_ChmuraGet

Rem_Mina1:
	tst.b	d7
	bne.l	SubPower
	sf	(a3)
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#4,10(a3)
	sub.w	#2,12(a3)
	bra.L	Inst_Chmura16

Rem_Wyrzutnia:
	st	30(a3)
	sub.b	#1,29(a3)
	bne.s	ReWy1
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#12,12(a3)
	bra.L	Inst_Chmura32
ReWy1:
	rts

;- 9 -
Rem_Rakieta:
	tst.b	d7
	bne.l	SubPower
	sf	(a3)
	add.w	#4,10(a3)
	sub.w	#4,12(a3)
	bra.L	Inst_Chmura16

;-11 do 22 -
Rem_Przedmiot:
	tst.b	KeyWez
	beq.s	RePr1
	tst.w	24(a3)
	bne.s	RePr1
	sf	KeyWez

	move.b	(a3),WezBobNum
	st	WezBobNumS
	clr.w	d7
	move.b	ActWin,d7
	lea	Kieszen,a1
	move.b	0(a1,d7.w),(a3)
	move.l	2(a3),a4
	move.b	0(a1,d7.w),(a4)
	beq.L	Inst_ChmuraGet
	move.w	#52*2,24(a3)
RePr1:
	rts

;- 24 -
Rem_Plyta:
	tst.b	d7
	bne.l	SubPower
	st	27(a3)
	sub.b	#1,26(a3)
	bne.s	RePl1
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#4,12(a3)
	bra.l	Inst_Chmura16
RePl1:
	rts

Rem_Ball:
	tst.b	d7
	beq.s	ReBal
	bsr.l	SubPower
ReBal:
	sub.w	#8,12(a3)
	sub.w	#4,10(a3)
	bra.l	Inst_Chmura16

;-29-
Rem_OutBall:
	tst.b	d7
	bne.l	SubPower
	st	29(a3)
	sub.b	#1,28(a3)
	bne.s	ReOBl
	sub.w	#8,12(a3)
	move.l	2(a3),a1
	sf	(a1)
	bra.l	Inst_Chmura16
ReObl:
	rts

;30
Rem_Fly:
	tst.b	d7
	bne.l	SubPower
	sub.b	#1,26(a3)
	beq.s	ReFl0
	st	27(a3)
	rts
ReFl0:
	move.l	2(a3),a1
	sf	(a1)
	bra.l	Inst_Chmura16

Rem_Kolec1:
	bra.l	SubPower

Rem_Kolec2:
	bra.l	SubPower

Rem_DzialoP:
	tst.b	d7
	bne.l	SubPower
	sub.b	#1,28(a3)
	beq.s	ReDzP
	st	27(a3)
	rts
ReDzP:
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#6,12(a3)
	bra.l	Inst_Chmura16

Rem_DzialoL:
	tst.b	d7
	bne.l	SubPower
	sub.b	#1,28(a3)
	beq.s	ReDzL
	st	27(a3)
	rts
ReDzL:
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#6,12(a3)
	add.w	#16,10(a3)
	bra.l	Inst_Chmura16

Rem_Mina:
	tst.b	d7
	beq.s	ReMina
	bsr.l	SubPower
ReMina:
	move.l	2(a3),a1
	sf	(a1)
	add.w	#18,12(a3)
	bra.l	Inst_Chmura16

;37
Rem_Box:
	tst.b	d7
	beq.s	ReBox
	bra.l	SubPower
ReBox:
	sub.b	#1,30(a3)
	beq.s	ReBoxx
	st	31(a3)
	rts
ReBoxx:
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#4,12(a3)
	bra.l	Inst_Chmura16

;38
Rem_JBall:
	tst.b	d7
	bne.l	SubPower
	sub.b	#1,30(a3)
	bne.s	ReJb1
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#4,12(a3)
	bra.l	Inst_Chmura16
ReJb1:
	st	31(a3)
	rts

;39
Rem_Rura:
	tst.b	d7
	bne.l	SubPower
	sub.b	#1,27(a3)
	bne.s	ReRu1
	move.l	2(a3),a1
	sf	(a1)
	sub.w	#4,12(a3)
	bra.l	Inst_Chmura16
ReRu1:
	st	26(a3)
	rts

;*******************************************************************

ObjectSize	=	32

;	0.B - Typ (=0 - brak, -1=koniec listy)
;	1.B - czy niszczone przez naboje
;	2.L - adres w tablicy OBJECT
;	6.L - adres w tablicy CAVE
;	10.W - GlobalX
;	12.W - GlobalY
;	14.W - Width Bob
;	16.W - Height Bob
;	18.B - Czy badac kolizje ze spritem
;	19.B - 0-brak kolizji/ +sprite -naboj
;	20.W - BoxXCave
;	22.W - BoxYCave
;	24

;Diamond:
;	24.W - Licznik obrazu boba
;	26.W - Jump counter

;ChmuraGet:
;	24.W - Licznik obrazu boba

;Mina:
;	24.W - Numer Boba
;	26.B - Kierunek (True-right / False-left)
;	27.B - True+ False-
;	28.W - Stale Y
;	30.W - AddY

;Wyrzutnia:
;	28.B - licznik do wyslania rakiety (do 0)
;	29.B - licznik oberwania (do 0)
;	30.B - czy mrugnac

;Rakieta:
;	24.B - true-right / false-left
;	25.B - true-down / false-kierunek
;	26.W - numer boba

;Chmura16
;	24.W - licznik obrazu

ObjectTab:	blk.b	MaxIlObject*ObjectSize+2,0

;--- Zerowanie listy objektow. ---

ResetObject:
	lea	ObjectTab,a0
	move.w	#MaxIlObject-1,d0
ReOb1:
	sf	(a0)
	lea	ObjectSize(a0),a0
	dbf	d0,ReOb1
	st	(a0)

	lea	MoveObject,a0
	lea	0(a0),a1
ReOb2:
	move.l	(a0),d0
	beq.s	ReOb3
	add.l	a1,d0
	move.l	d0,(a0)+
	bra.s	ReOb2
ReOb3:
	rts

MoveObject:
	dc.l	-1
	dc.l	Move_CloseDoor-MoveObject
	dc.l	Move_OpenDoor-MoveObject
	dc.l	Move_Diamond1-MoveObject
	dc.l	Move_Diamond2-MoveObject
	dc.l	Move_ChmuraGet-MoveObject
	dc.l	Move_Mina1-MoveObject
	dc.l	Move_Mina2-MoveObject
	dc.l	Move_Wyrzutnia-MoveObject
	dc.l	Move_Rakieta-MoveObject
	dc.l	Move_Chmura16-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Chmura32-MoveObject
	dc.l	Move_Plyta-MoveObject
	dc.l	Move_Ball1-MoveObject
	dc.l	Move_Ball2-MoveObject
	dc.l	Move_Ball3-MoveObject
	dc.l	Move_Ball4-MoveObject
	dc.l	Move_OutBall-MoveObject
	dc.l	Move_Fly-MoveObject
	dc.l	Move_Przedmiot-MoveObject
	dc.l	Move_Kolec1-MoveObject
	dc.l	Move_Kolec2-MoveObject
	dc.l	Move_DzialoP-MoveObject
	dc.l	Move_DzialoL-MoveObject
	dc.l	Move_Mina-MoveObject
	dc.l	Move_Box-MoveObject
	dc.l	Move_JBall-MoveObject
	dc.l	Move_Rura-MoveObject

InstObject:
	dc.l	-1
	dc.l	Inst_Empty-MoveObject
	dc.l	Inst_Empty-MoveObject
	dc.l	Inst_Diamond-MoveObject
	dc.l	Inst_Diamond-MoveObject
	dc.l	-1
	dc.l	Inst_Mina1-MoveObject
	dc.l	Inst_Mina2-MoveObject
	dc.l	Inst_Wyrzutnia-MoveObject
	dc.l	Inst_Rakieta-MoveObject
	dc.l	-1
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	-1
	dc.l	Inst_Plyta-MoveObject
	dc.l	Inst_Ball1-MoveObject
	dc.l	Inst_Ball2-MoveObject
	dc.l	Inst_Ball3-MoveObject
	dc.l	Inst_Ball4-MoveObject
	dc.l	Inst_OutBall-MoveObject
	dc.l	Inst_Fly-MoveObject
	dc.l	Inst_Przedmiot-MoveObject
	dc.l	Inst_Kolec1-MoveObject
	dc.l	Inst_Kolec2-MoveObject
	dc.l	Inst_DzialoP-MoveObject
	dc.l	Inst_DzialoL-MoveObject
	dc.l	Inst_Mina-MoveObject
	dc.l	Inst_Box-MoveObject
	dc.l	Inst_JBall-MoveObject
	dc.l	Inst_Rura-MoveObject

RemoveObject:
	dc.l	-1
	dc.l	-1
	dc.l	-1
	dc.l	Rem_Diamond-MoveObject
	dc.l	Rem_Diamond-MoveObject
	dc.l	-1
	dc.l	Rem_Mina1-MoveObject
	dc.l	Rem_Mina1-MoveObject
	dc.l	Rem_Wyrzutnia-MoveObject
	dc.l	Rem_Rakieta-MoveObject
	dc.l	-1
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	-1
	dc.l	Rem_Plyta-MoveObject
	dc.l	Rem_Ball-MoveObject
	dc.l	Rem_Ball-MoveObject
	dc.l	Rem_Ball-MoveObject
	dc.l	Rem_Ball-MoveObject
	dc.l	Rem_OutBall-MoveObject
	dc.l	Rem_Fly-MoveObject
	dc.l	Rem_Przedmiot-MoveObject
	dc.l	Rem_Kolec1-MoveObject
	dc.l	Rem_Kolec2-MoveObject
	dc.l	Rem_DzialoP-MoveObject
	dc.l	Rem_DzialoL-MoveObject
	dc.l	Rem_Mina-MoveObject
	dc.l	Rem_Box-MoveObject
	dc.l	Rem_JBall-MoveObject
	dc.l	Rem_Rura-MoveObject

	dc.l	0

InstallSamples:
	lea	AudioInt,a0
	move.l	a0,$70
	rts

SamplesOff:
	bsr.L	Stop0
	bsr.L	Stop1
	bsr.L	Stop2
	bsr.L	Stop3
	rts

;a0.l - sample data
;d0.w - size (words)
;d1.w - periods
;d2.b - volume
;d3.b - True=Loop

Play0:
	ext.w	d2
	bsr.L	Stop0
	move.l	a0,$dff0a0
	move.w	d0,$dff0a4
	move.w	d1,$dff0a6
	move.w	d2,$dff0a8
	sf	AudioReg0
	move.w	#%1000000000000001,$dff096
	tst.b	d3
	bne.s	Play00
	move.w	#%1000000010000000,$dff09a
Play00:
	rts

Play1:
	ext.w	d2
	bsr.L	Stop1
	move.l	a0,$dff0b0
	move.w	d0,$dff0b4
	move.w	d1,$dff0b6
	move.w	d2,$dff0b8
	sf	AudioReg1
	move.w	#%1000000000000010,$dff096
	tst.b	d3
	bne.s	Play10
	move.w	#%1000000100000000,$dff09a
Play10:
	rts

Play2:
	ext.w	d2
	bsr.L	Stop2
	move.l	a0,$dff0c0
	move.w	d0,$dff0c4
	move.w	d1,$dff0c6
	move.w	d2,$dff0c8
	sf	AudioReg2
	move.w	#%1000000000000100,$dff096
	tst.b	d3
	bne.s	Play20
	move.w	#%1000001000000000,$dff09a
Play20:
	rts

Play3:
	ext.w	d2
	bsr.L	Stop3
	move.l	a0,$dff0d0
	move.w	d0,$dff0d4
	move.w	d1,$dff0d6
	move.w	d2,$dff0d8
	sf	AudioReg3
	move.w	#%1000000000001000,$dff096
	tst.b	d3
	bne.s	Play30
	move.w	#%1000010000000000,$dff09a
Play30:
	rts

Stop0:
	move.w	#0,$dff0a8
	move.w	#%0000000000000001,$dff096
	move.w	#%0000000010000000,$dff09a
	move.w	#%0000000010000000,$dff09c
	rts

Stop1:
	move.w	#0,$dff0b8
	move.w	#%0000000000000010,$dff096
	move.w	#%0000000100000000,$dff09a
	move.w	#%0000000100000000,$dff09c
	rts

Stop2:
	move.w	#0,$dff0c8
	move.w	#%0000000000000100,$dff096
	move.w	#%0000001000000000,$dff09a
	move.w	#%0000001000000000,$dff09c
	rts

Stop3:
	move.w	#0,$dff0d8
	move.w	#%0000000000001000,$dff096
	move.w	#%0000010000000000,$dff09a
	move.w	#%0000010000000000,$dff09c
	rts

AudioInt:
	move.w	d0,-(sp)
	move.w	$dff01e,d0
	and.w	$dff01c,d0

	btst	#7,d0
	beq.s	AuIn0a
	tst.b	AudioReg0
	beq.s	AuIn0b
	bsr.L	Stop0
AuIn0b:
	st	AudioReg0
AuIn0a:

	btst	#8,d0
	beq.s	AuIn1a
	tst.b	AudioReg1
	beq.s	AuIn1b
	bsr.L	Stop1
AuIn1b:
	st	AudioReg1
AuIn1a:

	btst	#9,d0
	beq.s	AuIn2a
	tst.b	AudioReg2
	beq.s	AuIn2b
	bsr.L	Stop2
AuIn2b:
	st	AudioReg2
AuIn2a:

	btst	#10,d0
	beq.s	AuIn3a
	tst.b	AudioReg3
	beq.s	AuIn3b
	bsr.L	Stop3
AuIn3b:
	st	AudioReg3
AuIn3a:
	move.w	d0,$dff09c
	move.w	(sp)+,d0
	rte

AudioReg0:	dc.b	0
AudioReg1:	dc.b	0
AudioReg2:	dc.b	0
AudioReg3:	dc.b	0

;--- Pierwsze rysowanie dolnych okien. ---

InitBox:
	bsr.L	DrawBron
	rts

;--- Czyszczenie okienka. ---

;d1.W - Num okienka
ClrBox:
	lea	Win0Ptr,a0
	lsl.w	#2,d1
	move.l	0(a0,d1.w),a0	;adres okna
	btst	#6,DMACONR(a6)
DrIo1E:
	btst	#6,DMACONR(a6)
	bne.s	DrIo1E
	move.w	#256,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
	move.l	#-1,BLTAFWM(a6)
	move.l	a0,BLTDPT(a6)
	move.w	#36,BLTDMOD(a6)
	move.w	#16*64*4+1,BLTSIZE(a6)
	rts

;--- Rysowanie przedmiotow. ---

;d0.W - Num Boba
;d1.W - Num okienka (0-3)

DrawInBox:
	lea	Kieszen,a0
	move.b	d0,0(a0,d1.w)
	sub.b	#44,0(a0,d1.w)

	lea	Win0Ptr,a0
	lsl.w	#2,d1
	move.l	0(a0,d1.w),a0	;adres okna
	lea	BobArray,a1
	lsl.w	#4,d0
	move.l	6(a1,d0.w),a1	;dane boba

	btst	#6,DMACONR(a6)
DrIo1A:
	btst	#6,DMACONR(a6)
	bne.s	DrIo1A

	move.w	#$09f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
	move.l	#-1,BLTAFWM(a6)
	move.l	a1,BLTAPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#150,BLTDMOD(a6)
	move.w	#16*64+1,BLTSIZE(a6)

	lea	38(a0),a0
	btst	#6,DMACONR(a6)
DrIo1B:
	btst	#6,DMACONR(a6)
	bne.s	DrIo1B
	move.l	a0,BLTDPT(a6)
	move.w	#16*64+1,BLTSIZE(a6)

	lea	38(a0),a0
	btst	#6,DMACONR(a6)
DrIo1C:
	btst	#6,DMACONR(a6)
	bne.s	DrIo1C
	move.l	a0,BLTDPT(a6)
	move.w	#16*64+1,BLTSIZE(a6)

	lea	38(a0),a0
	btst	#6,DMACONR(a6)
DrIo1D:
	btst	#6,DMACONR(a6)
	bne.s	DrIo1D
	move.l	a0,BLTDPT(a6)
	move.w	#16*64+1,BLTSIZE(a6)
	rts

Kieszen:	dc.b	0,0,0,0

;--- Rysowanie broni w okienku na dole. ---

DrawBron:
	move.w	NumBroni,d1
	lea	BobArray,a0
	lsl.w	#4,d1
	move.l	Win4Ptr,a1
	move.l	6(a0,d1.w),a0	;dane boba

	btst	#6,DMACONR(a6)
DrIb2A:
	btst	#6,DMACONR(a6)
	bne.s	DrIb2A

	move.w	#$19f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
	move.l	#-1,BLTAFWM(a6)
	move.l	a0,BLTAPT(a6)
	move.l	a1,BLTDPT(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#150,BLTDMOD(a6)
	move.w	#10*64+1,BLTSIZE(a6)

	lea	38(a1),a1
	btst	#6,DMACONR(a6)
DrIb2B:
	btst	#6,DMACONR(a6)
	bne.s	DrIb2B
	move.l	a1,BLTDPT(a6)
	move.w	#10*64+1,BLTSIZE(a6)

	lea	38(a1),a1
	btst	#6,DMACONR(a6)
DrIb2C:
	btst	#6,DMACONR(a6)
	bne.s	DrIb2C
	move.l	a1,BLTDPT(a6)
	move.w	#10*64+1,BLTSIZE(a6)

	lea	38(a1),a1
	btst	#6,DMACONR(a6)
DrIb2D:
	btst	#6,DMACONR(a6)
	bne.s	DrIb2D
	move.l	a1,BLTDPT(a6)
	move.w	#10*64+1,BLTSIZE(a6)
	rts

;--- Obsluga strzalu. ---

Loop_Strzal:
	tst.b	JoyFire
	bne.s	LoSt1
	sf	StrzalOff
	bra.s	LoSt2
LoSt1:
	tst.b	StrzalOff
	bne.s	LoSt2
	tst.b	StrzalTimer
	bne.s	LoSt2

	lea	NabTab,a1
	move.w	#MaxIlNab-1,d0
LoSt01:
	tst.w	4(a1)
	bpl.s	LoSt01B
	tst.b	6(a1)
	beq.s	LoSt02
LoSt01B:
	lea	NABTABS(a1),a1
	dbf	d0,LoSt01
	bra.s	LoSt2
LoSt02:
	move.w	GlobalX,(a1)
	move.w	GlobalY,2(a1)

	move.w	NumBroni,4(a1)

	sub.w	#16,(a1)
	move.b	Kierunek,6(a1)
	beq.s	LoSt00
	add.w	#15+28,(a1)
	sub.w	#1,4(a1)
LoSt00:
	add.w	#2,2(a1)

	move.b	#8,StrzalTimer
	st	StrzalOff
LoSt2:
	tst.b	StrzalTimer
	beq.s	LoSt3
	sub.b	#1,StrzalTimer
LoSt3:

	move.w	#MaxIlNab-1,d0
	lea	NabTab,a1
LoSt10:
	tst.w	4(a1)
	bmi.L	StrzalChmurka

	move.w	(a1),d1
	move.w	2(a1),d2
	move.w	d1,(a0)
	move.w	d2,2(a0)

	move.w	4(a1),4(a0)
	cmp.w	#6,4(a1)
	bcs.s	LoSt010			;animacja broni
	tst.b	ScrNum
	beq.s	LoSt010
	bchg	#0,5(a0)
LoSt010:

	move.w	#BLT_NORMAL,6(a0)

	move.w	(a0),8(a1)		;wlasciwe X
	move.w	2(a0),10(a1)		;wlasciwe Y

	lea	8(a0),a0

	tst.b	6(a1)
	bne.s	LoSt12
	sub.w	#8,(a1)
	bra.s	LoSt13
LoSt12:
	add.w	#8,(a1)
LoSt13:
	move.w	d1,d3
	move.w	d2,d4

	sub.w	LiniaX,d1
	bmi.s	LoSt14
	sub.w	LiniaY,d2
	bmi.s	LoSt14
	cmp.w	#320+64,d1
	bgt.s	LoSt14
	cmp.w	#192+64,d2
	bgt.s	LoSt14

	addq.w	#7,d3
	addq.w	#5,d4
	bsr.s	JakaKostka
	bne.s	LoSt11

LoSt14:
	move.w	#-1,4(a1)
	move.b	#6,6(a1)
LoSt11:
	lea	NABTABS(a1),a1
	dbf	d0,LoSt10
	rts

StrzalChmurka:
	tst.b	6(a1)
	beq.s	LoSt11
	move.l	(a1),(a0)
	moveq	#28,d1
	sub.b	6(a1),d1
	move.w	d1,4(a0)
	move.w	#BLT_NORMAL,6(a0)
	lea	8(a0),a0
	tst.b	ScrNum
	beq.s	LoSt11
	sub.b	#1,6(a1)
	bra.s	LoSt11

StrzalOff:	dc.b	0
StrzalTimer:	dc.b	0
NumBroni:	dc.w	1

;NabStruct:
;	0.w - X_Cave
;	2.w - Y_Cave
;	4.w - BobNum (-1 - brak strzalu, moze byc chmurka)
;	6.w - Kierunek (False-brak chmurki / licznik chmurki)
;	8.w - X_Cave_Scr
;	10.W - Y_Cave_Scr

NABTABS	=	12

NabTab:		blk.b	MaxIlNab*NABTABS

;--- Czy jest mur. ---

;d3.W - X_Cave
;d4.W - Y_Cave

;TUTAJ

JakaKostka:
	lsr.w	#5,d3
	lsr.w	#5,d4
	lsl.w	#2,d4
	lea	BoxYAdr,a5
	move.l	0(a5,d4.w),a4
	ext.l	d3
	add.l	d3,a4
	clr.w	d5
	move.b	(a4),d5			;kod kostki
	bmi.s	JaKo_Mur
	move.l	BoxInfo1Ptr,a4
	cmp.b	#50,d5
	bcs.s	JaKo1
	move.l	BoxInfo2Ptr,a4
JaKo1:
	cmp.b	#$80,0(a4,d5.w)
	beq.s	JaKo2
	cmp.b	#1,0(a4,d5.w)		;kod WARUNEK
JaKo2:
	rts

JaKo_Mur:
	clr.b	d5
	rts

;--- Zerowanie strzelania. ---

ResetStrzal:
	lea	NabTab,a0
	move.w	#MaxIlNab-1,d0
ReSt1:
	move.w	#-1,4(a0)
	sf	6(a0)
	lea	NABTABS(a0),a0
	dbf	d0,ReSt1
	rts

;--- Zerowanie listy bobow do rysowania. ---

ResetBobDraw:
	lea	BobDrawTab,a0
	lea	BobDrawTabBack,a1
	move.w	#MaxIlBob,d0
ReBd1:
	move.w	#-1,4(a0)
	move.w	#-1,4(a1)
	lea	8(a0),a0
	lea	8(a1),a1
	dbf	d0,ReBd1
	rts

;In:	d0.L-Value
Loop_AddScore:
	add.l	d0,Score
	cmp.l	#9999,Score
	bls.s	LoAdSc
	move.l	#9999,Score
LoAdSc:
	rts

Loop_Score:
	move.l	OldScore,d0
	cmp.l	Score,d0
	beq.s	LoSo1
	add.l	#1,OldScore

	add.b	#1,ScoreTab+3
	cmp.b	#10,ScoreTab+3
	bne.s	LoSo1
	sf	ScoreTab+3

	add.b	#1,ScoreTab+2
	cmp.b	#10,ScoreTab+2
	bne.s	LoSo1
	sf	ScoreTab+2

	add.b	#1,ScoreTab+1
	cmp.b	#10,ScoreTab+1
	bne.s	LoSo1
	sf	ScoreTab+1

	add.b	#1,ScoreTab
LoSo1:
	add.w	#1,ScoreCnt
	cmp.w	#4,ScoreCnt
	bcs.s	LoSo2
	clr.w	ScoreCnt
LoSo2:
	move.w	ScoreCnt,d0
	lea	ScoreTab,a0
	clr.w	d1
	move.b	0(a0,d0.w),d1
	add.b	#48,d1
	move.l	ScorePtr,a0
	lea	0(a0,d0.w),a0
	;a0.L-ScrPtr d1.W-ASCII
	lea	DownFontTab,a1
	move.b	0(a1,d1.w),d1
	lsl.w	#3,d1
	lea	DownFont,a1

	move.b	0(a1,d1.w),152*0(a0)
	move.b	1(a1,d1.w),152*1(a0)
	move.b	2(a1,d1.w),152*2(a0)
	move.b	3(a1,d1.w),152*3(a0)
	move.b	4(a1,d1.w),152*4(a0)
	move.b	5(a1,d1.w),152*5(a0)
	move.b	6(a1,d1.w),152*6(a0)
	move.b	7(a1,d1.w),152*7(a0)

	clr.w	d0
	move.b	Lives,d0
	cmp.b	OldLives,d0
	beq.s	LoSo3
	move.b	d0,OldLives
	add.b	#48,d0
	lea	DownFontTab,a0
	move.b	0(a0,d0.w),d0
	lsl.w	#3,d0
	lea	DownFont,a0
	move.l	LivesPtr,a1

	move.b	0(a0,d0.w),152*0(a1)
	move.b	1(a0,d0.w),152*1(a1)
	move.b	2(a0,d0.w),152*2(a1)
	move.b	3(a0,d0.w),152*3(a1)
	move.b	4(a0,d0.w),152*4(a1)
	move.b	5(a0,d0.w),152*5(a1)
	move.b	6(a0,d0.w),152*6(a1)
	move.b	7(a0,d0.w),152*7(a1)

LoSo3:
	rts

SetScore:
	clr.l	ScoreTab
	clr.w	ScoreTab+4
	clr.w	ScoreCnt
	move.l	#0,Score
	clr.l	OldScore
	clr.b	OldLives
	rts

OldLives:	dc.b	0
	EVEN
ScoreTab:	dc.b	0,0,0,0,0,0
ScoreCnt:	dc.w	0
Score:		dc.l	0
OldScore:	dc.l	0
ScorePtr:	dc.l	0
LivesPtr:	dc.l	0

Loop_DownSprite:
	clr.l	d0
	move.b	ActWin,d0
	lsl.w	#4,d0
	add.w	#79,d0
	move.w	d0,d1
	add.w	#7,d1

	clr.w	d7
	move.b	DSCnt,d7
	tst.b	DSDelay
	bne.s	LoDs1
	add.b	#1,d7
	cmp.b	#8,d7
	bcs.s	LoDs2
	sf	d7
LoDs2:
	move.b	#2,DSDelay
LoDs1:
	sub.b	#1,DSDelay
	move.b	d7,DSCnt

	lsl.w	#2,d7
	lea	DownSprtTab,a0
	move.l	00(a0,d7.w),a1
	move.l	08(a0,d7.w),a2
	move.l	16(a0,d7.w),a3
	move.l	24(a0,d7.w),a4

	move.b	#8,(a1)
	move.b	d0,1(a1)
	move.b	#8+5,2(a1)
	move.b	#%110,3(a1)

	move.b	#8+15,(a2)
	move.b	d1,1(a2)
	move.b	#8+15+5,2(a2)
	move.b	#%111,3(a2)

	move.b	#8,(a3)
	move.b	d1,1(a3)
	move.b	#8+5,2(a3)
	move.b	#%111,3(a3)

	move.b	#8+15,(a4)
	move.b	d0,1(a4)
	move.b	#8+15+5,2(a4)
	move.b	#%110,3(a4)

	move.l	a1,d1
	move.l	a2,d2
	move.l	a3,d3
	move.l	a4,d4

	move.l	CLPtr,a0
	lea	CLDownSprite-CopperList(a0),a0

	move.w	d1,6(a0)
	swap	d1
	move.w	d1,2(a0)

	move.w	d2,6+8(a0)
	swap	d2
	move.w	d2,2+8(a0)

	move.w	d3,6+16(a0)
	swap	d3
	move.w	d3,2+16(a0)

	move.w	d4,6+24(a0)
	swap	d4
	move.w	d4,2+24(a0)

	rts

DSCnt:		dc.b	0
DSDelay:	dc.b	0

AddPower:
	cmp.w	#80,Power
	beq.s	AdPo0
	add.w	#1,Power
AdPo0:
	rts

SubPower:
	tst.w	Power
	beq.s	SuPo0
	sub.w	#1,Power
SuPo0:
	rts

Loop_Lives:
	move.w	Power,d0
	beq.s	LoLi3
	move.w	Power8,d1
	lsr.w	#3,d0
	cmp.w	d1,d0
	beq.s	LoLi1
	bhi.s	LoLi2
	;-- zmalala. --
	sub.w	#1,Power8
	cmp.w	#10,d1
	beq.s	LoLi1
LoLi4:
	move.l	BarPtr,a0
	lea	0(a0,d1.w),a0
	sf	(a0)
	sf	152(a0)
	bra.s	LoLi1
LoLi3:
	clr.w	d1
	bra.s	LoLi4
LoLi2:
	;-- wzroslo. --
	add.w	#1,Power8
	move.l	BarPtr,a0
	lea	0(a0,d1.w),a0
	or.b	#%01111100,(a0)
	or.b	#%01111100,152(a0)
LoLi1:
	rts

SetLives:
	move.b	#4,Lives
	sf	ActWin
	sf	DSCnt
	sf	DSDelay
ResetLives:
	sub.b	#1,Lives

	move.w	#80,Power
	move.w	#80/8,Power8

	rts

Power:		dc.w	0
Power8:		dc.w	0
BarPtr:		dc.l	0
Lives:		dc.b	0
ActWin:		dc.b	0
	EVEN

TxtPos:
	dc.l	Txt11-TxtPos
	dc.l	Txt11-TxtPos
	dc.l	Txt13-TxtPos
	dc.l	Txt14-TxtPos
	dc.l	Txt11-TxtPos
	dc.l	Txt11-TxtPos
	dc.l	Txt13-TxtPos
	dc.l	Txt14-TxtPos
	dc.l	Txt19-TxtPos
	dc.l	Txt20-TxtPos
	dc.l	Txt21-TxtPos
	dc.l	Txt22-TxtPos
	dc.l	0,0,0,0,0,0,0,0
	dc.l	Txt31-TxtPos

	;...........1234567890123456789012345678901234567
Txt:	dc.b	32,'    napisa: Sawomir Juraowicz'
Txt11:	dc.b	05,'Klucz'
Txt13:	dc.b	15,'Odnawia energi'
Txt14:	dc.b	16,'Zwiksza energi'
Txt19:	dc.b	06,'Lustro'
Txt20:	dc.b	07,'Papirus'
Txt21:	dc.b	09,'Piercie'
Txt22:	dc.b	12,'Zota moneta'
Txt31:	dc.b	08,'Pojemnik'
	EVEN

;Esc - quit game / quit pisz
;Entr - zatwierdzenie tekstu
;P - pisanie

Keyboard:
	sf	KeyWez

	bsr.L	KeyPressed
	beq.L	KeYb1

	clr.l	d0
	bsr.L	ReadKey

	tst.b	DTTryb
	bne.L	KeYb2

	;-- bez pisania. --

	cmp.b	#$75,d0
	bne.s	KeYb3
	st	DTQuitGame
	bra.L	KeYb1
KeYb3:
	cmp.b	#$cd,d0
	bne.s	KeYb4
	st	DTTryb
	st	DTClr
	sf	DTSize
	lea	Komentarz,a0
	move.l	a0,DTTxtPtr
	bra.L	KeYb1
KeYb4:
	cmp.b	#$5f,d0
	bne.s	KeYb5
	move.b	#0,ActWin
	bra.l	KeYb1
KeYb5:
	cmp.b	#$5d,d0
	bne.s	KeYb6
	move.b	#1,ActWin
	bra.l	KeYb1
KeYb6:
	cmp.b	#$5b,d0
	bne.s	KeYb7
	move.b	#2,ActWin
	bra.l	KeYb1
KeYb7:
	cmp.b	#$59,d0
	bne.s	KeYb8
	move.b	#3,ActWin
	bra.l	KeYb1
KeYb8:
	cmp.b	#$7f,d0
	bne.s	KeYb8_1
	add.w	#2,NumBroni
	cmp.w	#8,NumBroni
	bcs.s	KeYb8_2
	move.w	#1,NumBroni
KeYb8_2:
	bsr.l	DrawBron
	bra.l	KeYb1
KeYb8_1:
	cmp.b	#$dd,d0
	bne.s	KeYb9
	st	KeyWez
	bra.l	KeYb1
KeYb9:
	bra.L	KeYb1

KeyWez:		dc.b	0
WezBobNum:	dc.b	0
WezBobNumS:	dc.b	0
	EVEN

	;-- pisanie. --

KeYb2:
	tst.b	DTClr
	bne.L	KeYb1

	cmp.b	#$77,d0		;Enter
	bne.s	KeYb100
KeYb101:
	sf	DTTryb
	st	DTClr
	sf	DTSize
	bra.s	KeYb1
KeYb100:
	cmp.b	#$75,d0		;Esc
	beq.s	KeYb101

	cmp.b	#$7d,d0		;BkSpc
	bne.s	KeYb102
	tst.b	DTSize
	beq.s	KeYb1
	bsr.L	CursOff
	sub.b	#1,DTSize
	sub.b	#1,DTOldSize
	sub.l	#1,DTTxtPtr
	sub.l	#1,DTCursPtr
	bra.s	KeYb1
KeYb102:
	lea	RawToASCII,a0
	tst.b	DTAmigaKey
	beq.s	KeYb102b
	lea	RawToASCIIPl,a0
KeYb102b:
	move.b	0(a0,d0.w),d0
	beq.s	KeYb1		;NoASCII

	move.l	DTTxtPtr,a0
	move.b	d0,(a0)
	add.b	#1,DTSize

	;-- quit. --

KeYb1:
	rts

;In:	a0.L-DTStruct  .b-size,txt
Loop_SetDT:
	move.b	(a0),DTSize
	lea	1(a0),a0
	move.l	a0,DTTxtPtr
	st	DTClr
	rts

DTCursPtr:	dc.l	0
DTTxtPtr:	dc.l	0
DTSize:		dc.b	0
DTOldSize:	dc.b	0
DTClr:		dc.b	0
DTTryb:		dc.b	0
DTQuitGame:	dc.b	0
Komentarz:	blk.b	40,0
DTAmigaKey:	dc.b	0
	EVEN

Loop_DownFont:
	bsr.L	Keyboard

	tst.b	DTClr
	beq.s	LoDf10

LoDf11b:
	tst.b	DTOldSize
	bne.s	LoDf11
	sf	DTClr
	bra.L	LoDf0
LoDf11:
	;sf	DFCursStat		;wymuszenie kursora
	;sf	DFCursDelay
	sub.b	#1,DTOldSize
	bsr.L	CursOff
	sub.l	#1,DTCursPtr
	bra.s	LoDf0
LoDf10:
	move.b	DTSize,d0
	cmp.b	DTOldSize,d0
	beq.s	LoDf0
	;sf	DFCursStat		;wymuszenie kursora
	;sf	DFCursDelay
	add.b	#1,DTOldSize

	lea	DownFontTab,a2
	move.l	DTTxtPtr,a0
	clr.l	d0
	move.b	(a0)+,d0
	move.b	0(a2,d0.w),d0
	move.l	a0,DTTxtPtr
	lsl.w	#3,d0
	move.l	DTCursPtr,a1
	lea	DownFont,a0

	move.b	0(a0,d0.w),40*0(a1)
	move.b	1(a0,d0.w),40*1(a1)
	move.b	2(a0,d0.w),40*2(a1)
	move.b	3(a0,d0.w),40*3(a1)
	move.b	4(a0,d0.w),40*4(a1)
	move.b	5(a0,d0.w),40*5(a1)
	move.b	6(a0,d0.w),40*6(a1)
	move.b	7(a0,d0.w),40*7(a1)

	add.l	#1,DTCursPtr
LoDf0:
	tst.b	DFCursDelay
	bne.s	LoDf1
	move.b	#CursDelay,DFCursDelay
	eor.b	#$ff,DFCursStat
	bne.s	LoDf2
	bsr.s	CursOff
	bra.s	LoDf1
LoDf2:
	bsr.s	CursOn
LoDf1:
	sub.b	#1,DFCursDelay
	rts

DFCursStat:	dc.b	0
DFCursDelay:	dc.b	0

;In:	a0.L-adres
CursOff:
	move.l	DTCursPtr,a0
	sf	40*0(a0)
	sf	40*1(a0)
	sf	40*2(a0)
	sf	40*3(a0)
	sf	40*4(a0)
	sf	40*5(a0)
	sf	40*6(a0)
	sf	40*7(a0)
	rts

;In:	a0.L-adres
CursOn:
	move.l	DTCursPtr,a0
	st	40*0(a0)
	st	40*1(a0)
	st	40*2(a0)
	st	40*3(a0)
	st	40*4(a0)
	st	40*5(a0)
	st	40*6(a0)
	st	40*7(a0)
	rts

SetDownScreen:
	move.l	CLPtr,a0
	lea	CLDTScrAdr-CopperList(a0),a0
	move.l	ScrMemDPtr,d0
	move.l	d0,d1
	add.l	#40*8,d1

	move.l	d1,a1
	moveq	#40*8/4-1,d2
SdSc1:
	move.l	#-1,(a1)+
	dbf	d2,SdSc1

	move.l	d0,a1
	moveq	#40*8/4-1,d2
SdSc2:
	clr.l	(a1)+
	dbf	d2,SdSc2

	move.w	d1,6(a0)
	swap	d1
	move.w	d1,2(a0)

	move.w	d0,6+8(a0)
	move.w	d0,6+16(a0)
	swap	d0
	move.w	d0,2+8(a0)
	move.w	d0,2+16(a0)

	move.l	ScrMemDPtr,a0
	lea	3(a0),a0
	move.l	a0,DownTxtPtr
	move.l	a0,DTCursPtr

	sf	DFCursStat
	sf	DFCursDelay
	sf	DTClr
	sf	DTSize
	sf	DTOldSize
	sf	DTTryb

	;-- dolna grafika. --

	move.l	CLPtr,a0
	lea	CLDownLine-CopperList(a0),a0
	move.l	DownLinePtr,d0
	moveq	#3,d1
SdSc3:
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#40-2,d0
	lea	8(a0),a0
	dbf	d1,SdSc3

	move.l	DownLinePtr,d0
	add.l	#152*11+2,d0
	move.l	d0,Win0Ptr
	addq.l	#4,d0
	move.l	d0,Win1Ptr
	addq.l	#4,d0
	move.l	d0,Win2Ptr
	addq.l	#4,d0
	move.l	d0,Win3Ptr
	add.l	#152*3+20,d0
	move.l	d0,Win4Ptr

	move.l	DownLinePtr,d0
	add.l	#152*10+21,d0
	move.l	d0,BarPtr

	move.l	DownLinePtr,d0
	add.l	#152*23+23,d0
	move.l	d0,ScorePtr

	move.l	DownLinePtr,d0
	add.l	#152*23+19,d0
	move.l	d0,LivesPtr
	rts

;--- Instalacja bobow. ---

InstallBob:
	move.l	BobDataPtr,d0
	lea	BobArray,a0
InBb1:
	tst.w	(a0)
	beq.s	InBb2

	add.l	d0,6(a0)
	add.l	d0,10(a0)

	lea	16(a0),a0
	bra.s	InBb1
InBb2:
	rts

;--- Pierwsze ustawienie adresow. ---

ScrMathFirst:
	move.l	ScrMemPtr,d0
	add.l	OffsetAll,d0
	add.l	Offset,d0
	move.l	d0,Screen0		;Screen 0
	move.l	d0,Fizyczny
	add.l	#ScrSize,d0
	move.l	d0,Screen1		;Screen 1
	move.l	d0,Logiczny
	add.l	#ScrSize,d0
	move.l	d0,Screen2		;Screen do naprawiania
	move.l	d0,Return
	lea	BobMemBank0,a0
	move.l	a0,RetBobMem0Ptr
	lea	BobMemBank1,a0
	move.l	a0,RetBobMem1Ptr
	sf	RetBobNum
	sf	Mem0Cnt
	sf	Mem1Cnt
	rts

;--- Obliczenia dotyczace ekranow. ---

Loop_ScreenMath:
	move.l	ScrMemPtr,d0
	add.l	OffsetAll,d0
	add.l	Offset,d0
	move.l	d0,Screen0
	add.l	#ScrSize,d0
	move.l	d0,Screen1
	add.l	#ScrSize,d0
	move.l	d0,Screen2

	;odnalezienie typu ekranu
	;0. - wolny/logiczny
	;1. - fizyczny
	;2. - return

	move.l	Screen0,d0
	bsr.L	CheckScreen
	move.b	d0,Scr0Stat

	move.l	Screen1,d0
	bsr.L	CheckScreen
	move.b	d0,Scr1Stat

	move.l	Screen2,d0
	bsr.L	CheckScreen
	move.b	d0,Scr2Stat

;1.return pozostawic, jesli brak to ustawic na nie fizycznym

	move.l	Screen0,d0
	cmp.b	#2,Scr0Stat
	beq.s	LoSm1
	move.l	Screen1,d0
	cmp.b	#2,Scr1Stat
	beq.s	LoSm1
	move.l	Screen2,d0
	cmp.b	#2,Scr2Stat
	beq.s	LoSm1

	move.l	Screen0,d0
	cmp.b	#0,Scr0Stat
	bne.s	LoSm2
	move.b	#2,Scr0Stat
	bra.s	LoSm1
LoSm2:
	move.l	Screen1,d0
	cmp.b	#0,Scr1Stat
	bne.s	LoSm3
	move.b	#2,Scr1Stat
	bra.s	LoSm1
LoSm3:
	move.l	Screen2,d0
	move.b	#2,Scr2Stat
LoSm1:
	move.l	d0,Return

	move.l	Fizyczny,Logiczny		;formalnosc - boby i tak odtwarzane po swojemu

	;odszukanie przyszlego fizycznego

	move.l	Screen0,d0
	cmp.b	#0,Scr0Stat
	beq.s	LoSm10
	move.l	Screen1,d0
	cmp.b	#0,Scr1Stat
	beq.s	LoSm10
	move.l	Screen2,d0
LoSm10:
	move.l	d0,Fizyczny
	rts

;podanie typu ekranu

CheckScreen:
	move.l	d0,d1
	move.l	d0,d2
	sub.l	#BoxNL*4,d1
	add.l	#BoxNL*4,d2

	move.l	Fizyczny,d3
	cmp.l	d3,d1
	bhi.s	ChSc1
	cmp.l	d3,d2
	bcs.s	ChSc1
	moveq	#1,d0			;fizyczny
	rts
ChSc1:
	move.l	Return,d3
	cmp.l	d3,d1
	bhi.s	ChSc2
	cmp.l	d3,d2
	bcs.s	ChSc2
	moveq	#2,d0			;return
	rts
ChSc2:
	sf	d0			;empty / logiczny
	rts

;--- Zmiana ekranu. ---

ShowScreen:
	move.l	Fizyczny,d0
	add.l	#BoxNL+BoxBPR,d0	;opuscic po kostce
	;add.l	#BoxNL,d0		;!!!
	move.l	d0,ShowScrPtr		;wpis adresu scr. do pokazania

	st	UstawScrAdr
ShSc1:
	tst.b	UstawScrAdr		;oczekiwanie na VBL
	bne.s	ShSc1

	;--- delay ---

	;bra.s	ShSc0
	tst.b	JoyFire
	beq.s	ShSc0
	bra.s	ShSc0			;BLOKADA
	move.l	#30,d0
	jsr	Wait
	btst	#6,$bfe001
	beq.L	Halt
ShSc0:
	rts

;--- Rysowanie wszystkich bobow. ---
;na fizycznym jeszcze nie pokazanym

Loop_BobsDraw:
	move.w	#-1,4(a0)		;koniec listy BACK
	move.l	Fizyczny,BobScrPtr

	lea	BobDrawTabBack,a3	;lista bobow do rysowania
	lea	BobDrawTab,a2

	lea	Mem0Cnt,a4
	lea	Box0XY,a1
	move.l	RetBobMem0Ptr,a5
	tst.b	RetBobNum
	beq.s	LoBd0
	lea	Mem1Cnt,a4
	lea	Box1XY,a1
	move.l	RetBobMem1Ptr,a5
LoBd0:
	sf	(a4)

	move.b	CaveX,(a1)
	move.b	CaveY,1(a1)

	move.l	#BoxNL+4,d2
	moveq	#16,d4

	tst.b	CntUp
	beq.s	LoBd10
	clr.w	d0
	move.b	CntUp,d0
	lsl.b	#1,d0
	lea	AddOfsUp,a0
	add.w	0(a0,d0.w),d2
LoBd10:
	tst.b	CntDown
	beq.s	LoBd11
	clr.w	d0
	move.b	CntDown,d0
	lsl.b	#1,d0
	lea	AddOfsDown,a0
	add.w	0(a0,d0.w),d2
LoBd11:
	tst.b	CntRight
	beq.s	LoBd12
	clr.w	d0
	move.b	CntRight,d0
	lsl.b	#2,d0
	lea	AddOfsRight,a0
	add.w	0(a0,d0.w),d2
	move.w	2(a0,d0.w),d4
LoBd12:
	tst.b	CntLeft
	beq.s	LoBd13
	clr.w	d0
	move.b	CntLeft,d0
	lsl.b	#2,d0
	lea	AddOfsLeft,a0
	add.w	0(a0,d0.w),d2
	move.w	2(a0,d0.w),d4
LoBd13:

	ext.l	d2
	add.l	d2,BobScrPtr

	lea	BobArray,a1
LoBd_Loop:
	move.w	(a3)+,d0	;X_Cave
	sub.w	#32+16,d0
	move.w	(a3)+,d1	;Y_Cave
	sub.w	#32,d1
	sub.w	LiniaX,d0
	sub.w	LiniaY,d1
	move.w	(a3)+,d3	;NumBob
	bmi.s	LoBd_Loop2	;ostatni w liscie

	move.w	(a3)+,BltTryb
	lsl.w	#4,d3		;NumBob*8
	lea	0(a1,d3.w),a0	;BobStruct

	;a1.L-BobArrayConst
	;a3.L-BobList
	;a4.L-Licznik ilosci bobow
	;d4-wyrownanie X
	;d2-spec
	;a5-spec

	;a0.L-BobStruct
	;d0.W-X_Ekr
	;d1.W-Y_Ekr

	jsr	PasteBob
	add.b	#1,(a4)
	add.l	d2,4(a5)
	lea	BobMemSize(a5),a5
	bra.s	LoBd_Loop

LoBd_Loop2:
	move.w	(a2)+,d0	;X_Cave
	sub.w	#32+16,d0
	move.w	(a2)+,d1	;Y_Cave
	sub.w	#32,d1
	sub.w	LiniaX,d0
	sub.w	LiniaY,d1
	move.w	(a2)+,d3	;NumBob
	bmi.s	LoBd_Quit	;ostatni w liscie

	move.w	(a2)+,BltTryb
	lsl.w	#4,d3		;NumBob*8
	lea	0(a1,d3.w),a0	;BobStruct

	jsr	PasteBob
	add.b	#1,(a4)
	add.l	d2,4(a5)
	lea	BobMemSize(a5),a5
	bra.s	LoBd_Loop2

LoBd_Quit:
	rts

AddOfsLeft:
	dc.w	0,0
	dc.w	4,14,4,12,4,10,4,8,4,6,4,4,4,2,4,0
	dc.w	2,14,2,12,2,10,2,8,2,6,2,4,2,2,2,0

AddOfsRight:
	dc.w	0,0
	dc.w	-2,2,-2,4,-2,6,-2,8,-2,10,-2,12,-2,14,-2,16
	dc.w	0,2,0,4,0,6,0,8,0,10,0,12,0,14,0,16

AddOfsUp:
	dc.w	0
	dc.w	ScrNL*30,ScrNL*28,ScrNL*26,ScrNL*24
	dc.w	ScrNL*22,ScrNL*20,ScrNL*18,ScrNL*16
	dc.w	ScrNL*14,ScrNL*12,ScrNL*10,ScrNL*08
	dc.w	ScrNL*06,ScrNL*04,ScrNL*02,ScrNL*00

AddOfsDown:
	dc.w	0
	dc.w	-ScrNL*30,-ScrNL*28,-ScrNL*26,-ScrNL*24
	dc.w	-ScrNL*22,-ScrNL*20,-ScrNL*18,-ScrNL*16
	dc.w	-ScrNL*14,-ScrNL*12,-ScrNL*10,-ScrNL*08
	dc.w	-ScrNL*06,-ScrNL*04,-ScrNL*02,-ScrNL*00

;--- Usuniecie wszystkich bobow. ---
;jeszcze przed scrolowaniem

Loop_BobsClear:
	lea	Mem0Cnt,a0
	lea	Box0XY,a2
	move.l	RetBobMem0Ptr,a1
	eor.b	#$ff,RetBobNum
	beq.s	LoBc1
	lea	Mem1Cnt,a0
	lea	Box1XY,a2
	move.l	RetBobMem1Ptr,a1
LoBc1:
	tst.b	(a0)
	beq.L	LoBcQuit

	clr.w	d7
	move.b	(a0),d7
	subq.b	#1,d7

	move.l	Return,d0
	move.b	(a2),d1
	move.b	1(a2),d2

	cmp.b	CaveX,d1
	beq.s	LoBc50
	bhi.s	LoBc51
	subq.l	#4,d0
	bra.s	LoBc50
LoBc51:
	addq.l	#4,d0
LoBc50:

	cmp.b	CaveY,d2
	beq.s	LoBc60
	bhi.s	LoBc61
	sub.l	#BoxNL,d0
	bra.s	LoBc60
LoBc61:
	add.l	#BoxNL,d0
LoBc60:

	btst	#6,DMACONR(a6)
LoBc010:
	btst	#6,DMACONR(a6)
	bne.L	LoBc010

	move.w	#$ffff,BLTAFWM(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	#$09f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)

LoBc_Loop:
	tst.w	(a1)
	beq.s	LoBcSkip

	move.l	d0,d2
	add.l	4(a1),d2		;poc. ret bob
	move.w	(a1),d3			;szer byte
	move.w	2(a1),d4		;wys*64
	lsl.w	#2,d4			;*4 bpl
	move.w	#ScrBPR,d5		;szer 4 bpl
	sub.w	d3,d5			;modulo
	lsr.w	#1,d3			;szer word
	or.w	d3,d4			;blt size

	btst	#6,DMACONR(a6)
LoBc10:
	btst	#6,DMACONR(a6)
	bne.L	LoBc10

	move.l	d2,BLTAPT(a6)
	move.l	8(a1),BLTDPT(a6)
	move.w	d5,BLTAMOD(a6)
	move.w	d5,BLTDMOD(a6)
	move.w	d4,BLTSIZE(a6)

LoBcSkip:
	lea	BobMemSize(a1),a1
	dbf	d7,LoBc_Loop
LoBcQuit:
	rts

;--- Rysowanie Boba na ekranie. ---
;jesli ScrollLeft, to ScrAdr o jedna kostke w prawo
;jesli ScrillUp, to ScrAdr o jedna linie kostek w dol
;a5-RetBob

;0.W - dx byte
;2.W - dy*64
;4.L - scr offset
;8.L - scr dest

;In:	d0.w-X d1.w-Y a0.l-bob struct
PasteBob:
	movem.l	d2/d4/a1-a5,-(sp)

	add.w	d4,d0

	clr.w	(a5)			;bob moze nie byc narysowany

	move.w	2(a0),d2
	move.w	4(a0),d3
	mulu.w	d2,d3
	move.l	d3,BobSkipPlane

	move.l	6(a0),a1		;Data Ptr
	move.l	10(a0),a2		;Mask Ptr

	cmp.w	#ScreenWidth-64,d0
	bge.L	PB_Quit			;caly na prawo
	cmp.w	#ScreenHeight-64,d1
	bge.L	PB_Quit			;caly u dolu

	;ile pixli wychodzi z lewej

	move.w	d0,d6
	add.w	(a0),d6			;X+DX
	bmi.L	PB_Quit			;<0
	beq.L	PB_Quit			;=0

	;ile linii wychodzi u gory

	move.w	d1,d2
	add.w	4(a0),d2		;Y+DY
	bmi.L	PB_Quit			;<0
	beq.L	PB_Quit			;=0

	;ile linii uciac u gory - d3

	clr.l	BobAddY
	clr.w	d3
	tst.w	d1
	bpl.s	PsBo1
	move.w	d1,d3
	neg.w	d3			;-Y

	;nowe adresy poczatkowe

	move.w	d3,d4
	mulu.w	2(a0),d4		;* BPR
	ext.l	d4
	move.l	d4,BobAddY
	adda.l	d4,a2			;nowy adres maski
PsBo1:

	;ile linii uciac u dolu - d4

	clr.w	d4
	subq.w	#1,d2
	cmp.w	#ScreenHeight-64,d2	;? Y+DY-1
	bls.s	PsBo2
	move.w	d2,d4
	sub.w	#ScreenHeight-64,d4
	addq.w	#1,d4
PsBo2:

	;nowa wysokosc - d2

	move.w	4(a0),d2
	sub.w	d3,d2
	sub.w	d4,d2

	;offset ekranu wg. Y - a3

	lea	0,a3
	tst.w	d1
	bmi.s	PsBo3			;<0
	lsl.w	#2,d1			;Y*4
	lea	ScrYAdd,a4
	move.l	0(a4,d1.w),a3
PsBo3:

	move.w	#$ffff,d3		;FWM
	clr.w	d7			;LWM
	move.w	2(a0),d4		;szerokosc w bajtach
	move.w	d0,d5			;zapamietanie X

	;ewentualne ciecia z lewej

	sf	BobByloCutL
	tst.w	d0
	bpl.s	PsBo4			;z lewej nic nie ciac
	st	BobByloCutL
	neg.w	d0			;-X
	subq.w	#1,d0			;X-1
	move.b	d0,d1
	and.b	#%1111,d1		;0-15
	lea	-2(a3),a3		;ScrOfs-2
	lsr.w	#3,d0			;X/8
	bclr	#0,d0			;tylko co slowo
	ext.l	d0
	adda.l	d0,a1			;opuszczenie N bajtow danych
	adda.l	d0,a2			;opuszczenie N bajow maski
	sub.w	d0,d4			;zmniejszenie szerokosci

	clr.w	d3			;fwm
	move.w	#15,d0
	sub.b	d1,d0			;przesuniecie bitow

	tst.b	d0
	beq.s	PsBo5			;rot=0

	moveq	#1,d3			;fwm=%0..01
	cmp.b	#1,d0
	beq.s	PsBo5			;rot=1

	lsl.w	d0,d3
	subq.w	#1,d3

	bra.s	PsBo5
PsBo4:
	move.w	d0,d1
	lsr.w	#3,d1			;X/8
	bclr	#0,d1			;tylko co slowo
	ext.l	d1
	adda.l	d1,a3			;pozycja X z dokladnoscia do slowa
	and.w	#%1111,d0		;przesuniecie bitow 0-15
PsBo5:

	addq.w	#2,d4			;dodatkowe slowo na przesuniecie bitow
	move.w	2(a0),d1		;orginalna szerokosc
	sub.w	d4,d1			;modulo danych

	;a0.l-bob struct
	;a1.l-data
	;a2.l-mask
	;a3.l-scr offset
	;d0.b-rotacja
	;d1.b-modulo danych, maski
	;d2.w-wysokosc
	;d3.w-fwm
	;d4.w-szerokosc w bajtach
	;d5.w-X
	;d6.w-X+DX
	;d7.w-lwm (=0)

	;szerokosc +2 na rotacje bitow
	;modulo ekranu jak wyjdzie
	;modulo danych, maski -2

	;ewentualne ciecia z prawej

	cmp.w	#ScreenWidth-64,d6
	bls.s	PsBo6			;nie wychodzi z prawej

	subq.w	#2,d4			;szerokosc bez dodatkowego slowa
	addq.w	#2,d1			;modulo

	move.w	d4,d6			;szer w bajtach
	lsr.w	#1,d6			;szer w slowach
	move.w	d5,d7			;X
	lsr.w	#4,d7			;/16 - od ktorego slowa zaczynamy
	add.w	d6,d7			;na ktorym slowie koniec
	sub.w	#[ScreenWidth-64]/16,d7
	lsl.w	#1,d7			;na bajty
	sub.w	d7,d4
	add.w	d7,d1

	and.l	#%1111,d5		;0-15
	moveq	#1,d7
	lsl.w	d5,d7
	neg.w	d7
	bra.s	PsBo6b

PsBo6:
	tst.w	d5
	bmi.s	PsBo6b
	move.w	d4,d6
	lsr.w	#1,d6			;szer w word
	lsr.w	#4,d5			;x/16 - start word
	add.w	d6,d5			;na ktorym slowie koniec
	cmp.w	#[ScreenWidth-64]/16,d5
	bls.s	PsBo6b
	subq.w	#2,d4			;szerokosc bez dodatkowego slowa
	addq.w	#2,d1			;modulo
	move.w	#-1,d7
PsBo6b:
	move.l	a3,4(a5)
	adda.l	BobScrPtr,a3		;adres na ekranie
	move.l	a3,8(a5)

	move.w	#ScrBPR*4,d5
	sub.w	d4,d5			;modulo scr.

	lsl.w	#8,d0
	lsl.w	#4,d0			;rotacja od bitu 12

	move.w	d0,d6			;CON0
	or.w	#%111100000000,d6
	or.w	BltTryb,d6

	lsl.w	#6,d2			;*64 dla blittera
	move.w	d4,(a5)
	move.w	d2,2(a5)
	lsr.w	#1,d4			;szer. /2 - w slowach
	or.w	d4,d2			;szer+wys

	tst.b	BobByloCutL
	beq.s	NoCutL
	sub.w	#2,(a5)
	add.l	#2,4(a5)
	add.l	#2,8(a5)
NoCutL:

	;--- Plane 0 ---

	movea.l	a1,a4
	adda.l	BobAddY,a4

	btst	#6,DMACONR(a6)
PsBo000:
	btst	#6,DMACONR(a6)
	bne.L	PsBo000

	move.w	d3,BLTAFWM(a6)
	move.w	d7,BLTALWM(a6)
	move.w	d1,BLTAMOD(a6)
	move.w	d1,BLTBMOD(a6)
	move.w	d5,BLTCMOD(a6)
	move.w	d5,BLTDMOD(a6)
	move.w	d6,BLTCON0(a6)
	move.w	d0,BLTCON1(a6)

	move.l	a2,BLTAPT(a6)		;maska
	move.l	a4,BLTBPT(a6)		;dane
	move.l	a3,BLTCPT(a6)		;scr
	move.l	a3,BLTDPT(a6)		;scr
	move.w	d2,BLTSIZE(a6)

	;--- Plane 1 ---

	adda.l	BobSkipPlane,a1
	lea	ScrBPR(a3),a3
	movea.l	a1,a4
	adda.l	BobAddY,a4

	btst	#6,DMACONR(a6)
PsBo01:
	btst	#6,DMACONR(a6)
	bne.L	PsBo01

	move.l	a2,BLTAPT(a6)		;maska
	move.l	a4,BLTBPT(a6)		;dane
	move.l	a3,BLTCPT(a6)		;scr
	move.l	a3,BLTDPT(a6)		;scr
	move.w	d2,BLTSIZE(a6)

	;--- Plane 2 ---

	adda.l	BobSkipPlane,a1
	lea	ScrBPR(a3),a3
	movea.l	a1,a4
	adda.l	BobAddY,a4

	btst	#6,DMACONR(a6)
PsBo02:
	btst	#6,DMACONR(a6)
	bne.L	PsBo02

	move.l	a2,BLTAPT(a6)		;maska
	move.l	a4,BLTBPT(a6)		;dane
	move.l	a3,BLTCPT(a6)		;scr
	move.l	a3,BLTDPT(a6)		;scr
	move.w	d2,BLTSIZE(a6)

	;--- Plane 3 ---

	adda.l	BobSkipPlane,a1
	lea	ScrBPR(a3),a3
	movea.l	a1,a4
	adda.l	BobAddY,a4

	btst	#6,DMACONR(a6)
PsBo03:
	btst	#6,DMACONR(a6)
	bne.L	PsBo03

	move.l	a2,BLTAPT(a6)		;maska
	move.l	a4,BLTBPT(a6)		;dane
	move.l	a3,BLTCPT(a6)		;scr
	move.l	a3,BLTDPT(a6)		;scr
	move.w	d2,BLTSIZE(a6)

PB_Quit:
	movem.l	(sp)+,d2/d4/a1-a5
	rts

BltTryb:	dc.w	0

;--- Sterowanie brakiem powtarzania skoku... ---

Loop_JoyOff:
	tst.b	Skok
	bne.s	LoJo1
	tst.b	Lot
	beq.s	LoJo2
LoJo1:
	st	UpOff
	rts
LoJo2:
	tst.b	JoyUp
	beq.s	LoJo3
	tst.b	JoyRight
	bne.s	LoJo1
	tst.b	JoyLeft
	bne.s	LoJo1
LoJo3:
	sf	UpOff
	rts

;--- Sterowanie postacia. ---

Loop_Sprite:
	move.w	GlobalX,d4
	move.w	GlobalY,d5

	move.w	d4,d0
	move.w	d5,d1
	bsr.L	CheckPosFirst

	tst.b	Lot
	bne.L	Loop_Lot
	tst.b	Skok
	bne.L	Loop_Skok

	tst.b	UpOff
	bne.s	NoJump
	tst.b	JoyUp
	beq.s	NoJump
	tst.b	JoyRight
	bne.L	JumpRight
	tst.b	JoyLeft
	bne.L	JumpLeft
NoJump:

	tst.b	Drabina
	bne.L	Loop_Drabina

	;--- sprawdz spadanie ---

LotReturn:
	move.w	d4,d0
	move.w	d5,d1
	addq.w	#2,d1
	bsr.L	CheckPos
	beq.L	Loop_Lot

	tst.b	JoyUp
	bne.L	DrabinaUp
	tst.b	JoyDown
	bne.L	DrabinaDown

DrabReturn:
	tst.b	JoyRight
	beq.s	LoSp1
	st	Kierunek
	move.w	d4,d0
	move.w	d5,d1
	addq.w	#2,d0
	bsr.L	CheckPos
	beq.s	LoSp4
	move.b	#0,Position
	rts
LoSp4:
	add.w	#2,GlobalX
	eor.b	#$ff,Anim
	bne.s	LoSp5
	add.b	#1,Position
LoSp5:
	cmp.b	#2,Position
	bcs.s	LoSp2
	cmp.b	#15,Position
	bls.s	LoSp3
LoSp2:
	move.b	#2,Position
LoSp3:
	rts

LoSp1:
	tst.b	JoyLeft
	beq.s	LoSp10
	sf	Kierunek
	move.w	d4,d0
	move.w	d5,d1
	subq.w	#2,d0
	bsr.L	CheckPos
	beq.s	LoSp11
	move.b	#16,Position
	rts
LoSp11:
	sub.w	#2,GlobalX
	eor.b	#$ff,Anim
	bne.s	LoSp12
	add.b	#1,Position
LoSp12:
	cmp.b	#2+16,Position
	bcs.s	LoSp14
	cmp.b	#15+16,Position
	bls.s	LoSp13
LoSp14:
	move.b	#2+16,Position
LoSp13:
	rts

LoSp10:
	move.b	#0,Position

Loop_Quit:
	tst.b	Kierunek
	bne.s	LoQui
	add.b	#16,Position
LoQui:
	rts

Loop_Lot:
	st	Lot
	sf	Skok
	sf	Drabina

	move.w	d4,d0
	move.w	d5,d1
	addq.w	#4,d1
	bsr.L	CheckPos
	beq.s	LoLo1
	move.w	GlobalY,d1
	and.b	#31,d1
	beq.s	LoLo30
	add.w	#32,GlobalY
	and.w	#%1111111111100000,GlobalY
LoLo30:
	sf	Lot
	sf	Position
	move.w	GlobalX,d4
	move.w	GlobalY,d5
	bra.L	DrabReturn
LoLo1:
	move.b	d4,d0
	and.b	#31,d0
	tst.b	JoyUp
	beq.s	LoLo11			;warunkowa zmiana na drabine
	cmp.b	#4,d0
	bne.s	LoLo11
	cmp.b	#129,SpriteAryF+4
	beq.L	DrabinaLot
LoLo11:
	move.b	#7,Position
	add.w	#4,GlobalY
	addq.w	#4,d5
LoLo11b:
	move.w	d4,d0
	move.w	d5,d1

	tst.b	JoyRight
	beq.s	LoLo2
	st	Kierunek
	addq.w	#2,d0
	bsr.L	CheckPos
	bne.L	Loop_Quit
	add.w	#2,GlobalX
	bra.L	Loop_Quit

LoLo2:
	tst.b	JoyLeft
	beq.L	Loop_Quit
	sf	Kierunek
	subq.w	#2,d0
	bsr.L	CheckPos
	bne.L	Loop_Quit
	sub.w	#2,GlobalX
	bra.L	Loop_Quit

JumpRight:
	st	Kierunek
	bra.s	SkokFirst

JumpLeft:
	sf	Kierunek

SkokFirst:
	sf	Lot
	sf	Drabina
	st	Skok
	sf	JumpCnt
	sf	JumpBreak
	move.w	GlobalY,JumpYMem

Loop_Skok:
	tst.b	JumpCnt
	beq.L	LoSk4

	move.w	GlobalX,d0
	move.w	GlobalY,d1
	and.b	#30,d0
	and.b	#31,d1

	;jesli animacja z powietrza na kostce

	bne.s	LoSk5
	tst.b	JumpBreak
	bne.s	LoSk7b
	cmp.b	#42,JumpCnt
	bcc.s	LoSk5
LoSk7b:
	cmp.b	#128,SpriteAryF+7
	bne.s	LoSk6
LoSk7:
	move.w	GlobalX,d4
	move.w	GlobalY,d5
	sf	Skok
	bra.L	DrabReturn
LoSk6:
	cmp.b	#10,d0
	bls.s	LoSk5
	cmp.b	#128,SpriteAryF+8
	beq.s	LoSk7
LoSk5:

	tst.b	JoyUp
	beq.s	LoSk20			;warunkowa zmiana na drabine
	cmp.b	#4,d0
	bne.s	LoSk20
	cmp.b	#129,SpriteAryF+4
	beq.L	DrabinaLot

LoSk20:
	cmp.b	#42,JumpCnt
	bls.s	LoSk4
	tst.b	d1
	beq.s	LoSk21
LoSk22:
	move.w	GlobalX,d4
	move.w	GlobalY,d5
	bra.L	Loop_Lot
LoSk21:
	cmp.b	#128,SpriteAryF+7
	beq.s	LoSk4
	cmp.b	#10,d0
	bls.s	LoSk22
	cmp.b	#128,SpriteAryF+8
	bne.s	LoSk22

LoSk4:
	move.w	GlobalX,d4
	move.w	GlobalY,d5

	clr.w	d2
	move.b	JumpCnt,d2
	lsl.w	#2,d2
	lea	SpriteJump,a4
	move.w	JumpYMem,d1
	sub.w	0(a4,d2.w),d1
	move.b	3(a4,d2.w),Position

	tst.b	JumpBreak
	beq.s	LoSk50
	move.b	#7,Position		;stala pozycja
	add.w	#2,GlobalY
	add.b	#1,JBCnt
	cmp.b	#4,JBCnt
	bcs.s	LoSk52
	add.w	#2,GlobalY
LoSk52:
	cmp.b	#24,JumpCnt
	bcc.s	LoSk51
	move.b	#24,JumpCnt
	bra.s	LoSk51
LoSk50:
	move.w	d1,GlobalY
LoSk51:

	move.w	GlobalX,d0
	move.w	GlobalY,d1
	bsr.L	CheckPos
	beq.s	LoSk1b
	move.w	d5,GlobalY
	st	JumpBreak
	sf	JBCnt
LoSk1b:

	;bra.s	LoSk41			;brak sterowania w skoku

	tst.b	JoyRight
	beq.s	LoSk40
	st	Kierunek
LoSk40:
	tst.b	JoyLeft
	beq.s	LoSk41
	sf	Kierunek
LoSk41:

	tst.b	Kierunek
	beq.s	LoSk1
	add.w	#2,GlobalX
	bra.s	LoSk2
LoSk1:
	add.b	#16,Position
	sub.w	#2,GlobalX
LoSk2:

	move.w	GlobalX,d0
	move.w	GlobalY,d1
	bsr.L	CheckPos
	beq.s	LoSk3b
	move.w	d4,GlobalX
	;move.w	d5,GlobalY		;przejscie do spadania przy
	;sf	Skok			;nimoznosci pojscia
	;bra.L	Loop_Lot		;w bok
LoSk3b:

	add.b	#1,JumpCnt
	cmp.b	#48,JumpCnt
	bne.s	LoSk3
	sf	Skok
LoSk3:
	rts

DrabinaLot:
	and.w	#%1111111111111000,GlobalY
	or.w	#4,GlobalY
	move.w	GlobalX,d4
	move.w	GlobalY,d5
	move.w	#-4,DrabAdd
	sf	Lot
	sf	Skok
	st	Drabina
	move.b	#1,DrabCnt
	move.b	#32,Position
	bra.L	Loop_Drabina

DrabinaUp:
	move.b	d4,d0
	and.b	#31,d0
	cmp.b	#16,d0
	bhi.s	DrUp1
	cmp.b	#129,SpriteAryF+4
	bne.L	DrabReturn
DrUp2:
	move.w	#-4,DrabAdd
	sub.w	#4,GlobalY
	and.w	#%1111111111100000,GlobalX
	or.w	#4,GlobalX
	sf	Lot
	sf	Skok
	st	Drabina
	move.b	#DrabinaWaitL,DrabCnt
	move.b	#33,Position
	rts
DrUp1:
	cmp.b	#20,d0
	bcs.L	DrabReturn
	cmp.b	#129,SpriteAryF+5
	bne.L	DrabReturn
	add.w	#32,GlobalX
	bra.s	DrUp2

DrabinaDown:
	move.b	d4,d0
	and.b	#31,d0
	cmp.b	#16,d0
	bhi.s	DrDo1
	cmp.b	#129,SpriteAryF+7
	bne.L	DrabReturn
DrDo2:
	move.w	#4,DrabAdd
	add.w	#4,GlobalY
	and.w	#%1111111111100000,GlobalX
	or.w	#4,GlobalX
	sf	Lot
	sf	Skok
	st	Drabina
	move.b	#DrabinaWaitL,DrabCnt
	move.b	#34,Position
	rts
DrDo1:
	cmp.b	#20,d0
	bcs.L	DrabReturn
	cmp.b	#129,SpriteAryF+8
	bne.L	DrabReturn
	add.w	#32,GlobalX
	bra.s	DrDo2

Loop_Drabina:
	tst.b	JoyRight
	beq.s	LoDr20
	st	Kierunek
LoDr20:
	tst.b	JoyLeft
	beq.s	LoDr21
	sf	Kierunek
LoDr21:

	cmp.b	#32,Position
	beq.s	LoDr10
	tst.b	JoyFire
	beq.s	LoDr10
LoDr11:
	move.b	#1,Position
	tst.b	Kierunek
	bne.s	LoDr12
	move.b	#17,Position
LoDr12:
	rts

LoDr10:
	tst.b	DrabCnt
	beq.s	LoDr3
	sub.b	#1,DrabCnt
	bne.L	LoDr1
LoDr3:
	move.w	d5,d1
	and.b	#31,d1
	tst.b	d1
	bne.s	LoDr5
	cmp.b	#129,SpriteAryF+7
	beq.s	LoDr5
	sf	Drabina
	move.b	#0,Position
	bra.L	Loop_Quit
LoDr5:
	cmp.b	#32,Position
	beq.s	LoDr2

	tst.b	JoyUp
	beq.s	LoDr4
	move.w	#-4,DrabAdd
	cmp.b	#129,SpriteAryF+4
	bne.s	LoDr1
	bra.s	LoDr2
LoDr4:
	tst.b	JoyDown
	beq.s	LoDr1
	move.w	#4,DrabAdd
LoDr2:
	add.w	DrabAdd,d5
	move.w	d5,GlobalY
	move.w	d5,d1
	and.w	#31,d1
	lsr.w	#1,d1
	bclr	#0,d1
	lea	DrabPos,a0
	move.b	0(a0,d1.w),Position
	move.b	1(a0,d1.w),DrabCnt
LoDr1:
	rts

CheckPosFirst:
	lea	SpriteAryF,a0
	bra.s	ChPos

;TUTAJ*

;In:	d0.W-GlobalX d1.W-GlobalY a0.L-SpriteArray
;Out:	d7.B- True=jest mur
CheckPos:
	lea	SpriteAry,a0
ChPos:
	move.w	d0,d2
	move.w	d1,d3
	and.w	#31,d2
	and.w	#31,d3

	lsr.w	#5,d0		;x kostki
	ext.l	d0
	lsr.w	#3,d1		;offset y kostki
	and.w	#%1111111111111100,d1
	lea	BoxYAdr,a1
	move.l	0(a1,d1.w),a1	;adres kostki y
	adda.l	d0,a1		;adres kostki

	movea.l	a0,a2
	move.b	-1-CaveWidth(a1),(a2)+
	move.b	-CaveWidth(a1),(a2)+
	move.b	1-CaveWidth(a1),(a2)+
	move.b	-1(a1),(a2)+
	move.b	(a1),(a2)+
	move.b	1(a1),(a2)+
	move.b	-1+CaveWidth(a1),(a2)+
	move.b	CaveWidth(a1),(a2)+
	move.b	1+CaveWidth(a1),(a2)+

	movea.l	a0,a2
	moveq	#8,d0
	move.l	BoxInfo1Ptr,a1
	move.l	BoxInfo2Ptr,a3
ChPo1:
	move.b	(a2),d1
	bmi.s	ChPo02
	ext.w	d1
	cmp.b	#50,d1
	bcs.s	ChPo2
	move.b	0(a3,d1.w),(a2)+
	bra.s	ChPo3
ChPo02:
	move.b	#128,(a2)+
	bra.s	ChPo3
ChPo2:
	move.b	0(a1,d1.w),(a2)+		;CHANGE
ChPo3:
	dbf	d0,ChPo1

	sf	d7
	cmp.b	#128,4(a0)
	bne.s	ChPo4
	st	d7
	bra.s	ChPo0
ChPo4:
	tst.b	d3
	beq.s	ChPo5
	cmp.b	#128,7(a0)
	bne.s	ChPo5
	st	d7
	bra.s	ChPo0
ChPo5:
	cmp.b	#4,d3
	bcc.s	ChPo6
	cmp.b	#128,1(a0)
	bne.s	ChPo6
	st	d7
	bra.s	ChPo0
ChPo6:
	cmp.b	#10,d2
	bls.s	ChPo0
	cmp.b	#128,5(a0)
	bne.s	ChPo7
	st	d7
	bra.s	ChPo0
ChPo7:
	tst.b	d3
	beq.s	ChPo8
	cmp.b	#128,8(a0)
	bne.s	ChPo8
	st	d7
	bra.s	ChPo0
ChPo8:
	cmp.b	#4,d3
	bcc.s	ChPo0
	cmp.b	#128,2(a0)
	bne.s	ChPo0
	st	d7
ChPo0:
	tst.b	d7
	rts

;--- Wymuszenie scrolowania ekranu. ---

Loop_Range:
	move.w	GlobalX,d0
	move.w	GlobalY,d1
	sub.w	LiniaX,d0
	sub.w	LiniaY,d1
	add.w	#92,d0
	add.w	#13,d1
	move.w	d0,HardX
	move.w	d1,HardY

	clr.l	MustUp

	cmp.w	#320,HardX
	bcs.s	LoRa1
	st	MustRight
LoRa1:
	cmp.w	#220,HardX
	bhi.s	LoRa2
	st	MustLeft
LoRa2:
	cmp.w	#77+16,HardY
	bhi.s	LoRa3
	st	MustUp
LoRa3:
	cmp.w	#173-16,HardY
	bcs.s	LoRa4
	st	MustDown
LoRa4:
	rts

;--- Gracz. ---

;In:	d0.W-X d1.W-Y d2.B-Pozycja
Loop_SetSprite:
	move.w	HardX,d0
	move.w	HardY,d1
	move.b	Position,d2

	lea	SpriteOffset,a0
	and.w	#$ff,d2
	lsl.w	#1,d2
	lea	SpriteInfo,a1
	move.w	0(a1,d2.w),d3	;height
	add.w	d1,d3		;v_stop
	lsl.w	#3,d2
	move.l	0(a0,d2.w),a2	;sprite 0
	move.l	4(a0,d2.w),a3	;sprite 1
	move.l	8(a0,d2.w),a4	;sprite 2
	move.l	12(a0,d2.w),a5	;sprite 3
	move.l	CLPtr,a1
	lea	CLSprite-CopperList(a1),a1

	move.l	a2,d2
	move.w	d2,0*8+6(a1)
	swap	d2
	move.w	d2,0*8+2(a1)

	move.l	a3,d2
	move.w	d2,1*8+6(a1)
	swap	d2
	move.w	d2,1*8+2(a1)

	move.l	a4,d2
	move.w	d2,2*8+6(a1)
	swap	d2
	move.w	d2,2*8+2(a1)

	move.l	a5,d2
	move.w	d2,3*8+6(a1)
	swap	d2
	move.w	d2,3*8+2(a1)

	move.b	d1,(a2)		;v_start
	move.b	d1,(a3)
	move.b	d1,(a4)
	move.b	d1,(a5)

	move.b	d3,2(a2)	;v_stop
	move.b	d3,2(a3)
	move.b	d3,2(a4)
	move.b	d3,2(a5)

	move.w	d0,d4
	add.w	#16,d4

	move.b	d0,3(a2)
	move.b	d0,3(a3)
	move.b	d4,3(a4)
	move.b	d4,3(a5)
	and.b	#%1,3(a2)
	and.b	#%1,3(a3)
	and.b	#%1,3(a4)
	and.b	#%1,3(a5)
	bset	#7,3(a3)	;link 0-1
	bset	#7,3(a5)	;link 2-3

	btst	#8,d1
	beq.s	LoSs1
	bset	#2,3(a2)
	bset	#2,3(a3)
	bset	#2,3(a4)
	bset	#2,3(a5)
LoSs1:

	btst	#8,d3
	beq.s	LoSs2
	bset	#1,3(a2)
	bset	#1,3(a3)
	bset	#1,3(a4)
	bset	#1,3(a5)
LoSs2:
	lsr.w	#1,d0
	lsr.w	#1,d4
	move.b	d0,1(a2)
	move.b	d0,1(a3)
	move.b	d4,1(a4)
	move.b	d4,1(a5)
	rts

;--- Tworzenie spritow. ---

InstallSprite:
	move.w	#GlobSprtStartX,GlobalX
	move.w	#GlobSprtStartY,GlobalY

	lea	SpriteOffset,a0
	move.l	SpritePtr,d0
	move.w	#IlSprt*4-1,d1
InSp1:
	add.l	d0,(a0)+
	dbf	d1,InSp1

	move.l	EmptySprtPtr,d0
	move.l	d0,d2
	swap	d2
	move.l	CLPtr,a0
	lea	CLSprite-CopperList(a0),a0
	moveq	#7,d1
InSp2:
	move.w	d2,2(a0)
	move.w	d0,6(a0)
	lea	8(a0),a0
	dbf	d1,InSp2

	move.l	CLPtr,a0
	lea	CLSprtColors-CopperList(a0),a0
	lea	SpriteColors,a1
	moveq	#15,d0
InSp3:
	move.w	(a1)+,2(a0)
	lea	4(a0),a0
	dbf	d0,InSp3

	move.l	DSPtr,a0
	lea	DownSprtTab,a1
	move.w	#7,d0
InSp4:
	move.l	a0,(a1)+
	move.l	a0,4*8-4(a1)
	lea	28(a0),a0
	dbf	d0,InSp4
	rts

DownSprtTab:	blk.l	16,0

;--- Obliczenia. ---

Loop_Math:
	clr.w	d0
	move.b	CaveY,d0
	lsl.w	#5,d0

	tst.b	CntDown
	beq.s	LoMa1
	move.w	#16,d1
	sub.b	CntDown,d1
	lsl.w	#1,d1
	sub.w	d1,d0
LoMa1:
	tst.b	CntUp
	beq.s	LoMa2
	move.w	#16,d2
	sub.b	CntUp,d2
	lsl.w	#1,d2
	add.w	d2,d0
LoMa2:
	move.w	d0,LiniaY

	clr.w	d0
	move.b	CaveX,d0
	lsl.w	#5,d0

	tst.b	CntRight
	beq.s	LoMa3
	move.w	#16,d1
	sub.b	CntRight,d1
	lsl.w	#1,d1
	sub.w	d1,d0
LoMa3:
	tst.b	CntLeft
	beq.s	LoMa4
	move.w	#16,d2
	sub.b	CntLeft,d2
	lsl.w	#1,d2
	add.w	d2,d0
LoMa4:
	move.w	d0,LiniaX
	rts

;--- Petla animacji teczy. ---

Loop_RainbowWithWait:
	tst.b	StatSOFT
	beq.s	Loop_RainbowWithWait

Loop_Rainbow2:
	clr.l	d1
	move.w	LiniaY,d1
	lsr.w	#4,d1

	move.w	LiniaY,d2
	lsr.w	#1,d2
	and.w	#%110,d2

	moveq	#7,d0
	sub.b	d2,d0

	;tst.b	d0
	;beq.s	LoRa0
	;nop
	;addq.l	#2,d1
	;LoRa0:

;--- Ustawienie kolorow teczy. --

;In:	d0.B - Plus d1.L - offset
SetColorsRain:
	move.l	CLPtr,a0
	lea	CLRain-CopperList+6(a0),a0
	lea	Rainbow+4,a1
	lsl.l	#1,d1
	lea	0(a1,d1.w),a1

	cmp.b	#7,d0
	bne.s	SeCr1
	move.w	-2(a1),(a0)
	lea	8(a0),a0
SeCr1:
	move.w	#24,d2
SeCr2:
	tst.b	d2
	bne.s	SeCr3
	cmp.b	#7,d0
	beq.s	SeCr4
SeCr3:
	move.w	(a1),(a0)
	move.w	2(a1),8(a0)
	move.w	(a1),16(a0)
	lea	24(a0),a0
	lea	2(a1),a1
	dbf	d2,SeCr2
SeCr4:

;--- Ustawienie oczekiwania na wiazke dla teczy. ---

;In:	d0.B - Plus (0-7)
SetWaitRain:
	sf	d1
	move.l	CLPtr,a0
	lea	CLRain-CopperList(a0),a0
	cmp.b	#7,d0
	bne.s	SwRa1
	moveq	#2,d1
SwRa1:
	moveq	#50,d2

	moveq	#74,d3
SwRa2:
	cmp.b	#241,d2
	bhi.s	SwRa3

	move.b	d2,(a0)
	move.b	#7,1(a0)
	move.w	#$fffe,2(a0)
	lea	8(a0),a0

	tst.b	d1
	bne.s	SwRa5
	add.b	d0,d2
	moveq	#6,d0
	bra.s	SwRa7
SwRa5:
	cmp.b	#1,d1
	beq.s	SwRa6
	cmp.b	#2,d1
	bne.s	SwRa7
SwRa6:
	addq.b	#1,d2
SwRa7:

	addq.b	#1,d1
	cmp.b	#3,d1
	bne.s	SwRa8
	sf	d1
SwRa8:
	dbf	d3,SwRa2
SwRa3:
	rts

;--- Petla przejscia kolorow. ---

Loop_Fade:
	eor.b	#$ff,FadeSkip
	beq.s	LoFa0
	move.l	FadePtr,a0
	move.l	ClPtr,a1
	lea	ColorsAdr-CopperList+2(a1),a1
	move.w	#15,d0
LoFa2:
	move.w	(a1),d1
	move.w	(a0)+,d4
	cmp.w	d1,d4
	beq.s	LoFa3

	move.w	d1,d2
	move.w	d2,d3
	move.w	d4,d5
	move.w	d5,d6
	and.w	#$f00,d1
	and.w	#$f00,d4
	and.w	#$0f0,d2
	and.w	#$0f0,d5
	and.w	#$00f,d3
	and.w	#$00f,d6

	cmp.w	d1,d4
	beq.s	LoFa4
	bhi.s	LoFa4b
	sub.w	#$100,d1
	bra.s	LoFa4
LoFa4b:
	add.w	#$100,d1
LoFa4:

	cmp.w	d2,d5
	beq.s	LoFa5
	bhi.s	LoFa5b
	sub.w	#$010,d2
	bra.s	LoFa5
LoFa5b:
	add.w	#$010,d2
LoFa5:

	cmp.w	d3,d6
	beq.s	LoFa6
	bhi.s	LoFa6b
	subq.w	#$001,d3
	bra.s	LoFa6
LoFa6b:
	addq.w	#$001,d3
LoFa6:
	or.w	d2,d1
	or.w	d3,d1
	move.w	d1,(a1)
LoFa3:
	lea	4(a1),a1
	dbf	d0,LoFa2
LoFa0:
	rts

;--- Petla przewijania ekranu. ---

Loop_Scroll:
	sf	ChgScrPtr

	tst.b	CntUp
	bne.L	LoSc1
	tst.b	CntDown
	bne.L	LoSc2
	tst.b	MustUp
	bne.s	LoSc1Check
	tst.b	MustDown
	bne.s	LoSc2Check
	bra.L	LoSc0

LoSc1Check:
	cmp.b	#0,CaveY
	beq.L	LoSc0
LoSc1:
	tst.b	Drabina			;- drabina -
	beq.s	LoSc1b			;- drabina -
	eor.b	#$ff,DrabFrameSkip	;- drabina -
	tst.b	DrabFrameSkip		;- drabina -
	bne.L	LoSc0			;- drabina -
LoSc1b:
	add.b	#1,CntUp
	bsr.L	ScrollUp
	cmp.b	#16,CntUp
	bne.s	LoSc1_1
	sf	CntUp
LoSc1_1:
	tst.b	Drabina			;- drabina -
	bne.L	LoSc0			;- drabina -
	tst.b	CntUp
	beq.L	LoSc0
	add.b	#1,CntUp
	bsr.L	ScrollUp
	cmp.b	#16,CntUp
	bne.s	LoSc0
	sf	CntUp
	bra.s	LoSc0

LoSc2Check:
	cmp.b	#CaveHeight-BoxShowY,CaveY
	beq.s	LoSc0
LoSc2:
	tst.b	Drabina			;- drabina -
	beq.s	LoSc2b			;- drabina -
	eor.b	#$ff,DrabFrameSkip	;- drabina -
	tst.b	DrabFrameSkip		;- drabina -
	bne.L	LoSc0			;- drabina -
LoSc2b:
	add.b	#1,CntDown
	bsr.L	ScrollDown
	cmp.b	#16,CntDown
	bne.s	LoSc2_1
	sf	CntDown
LoSc2_1:
	tst.b	Drabina			;- drabina -
	bne.s	LoSc0			;- drabina -
	tst.b	CntDown
	beq.s	LoSc0
	add.b	#1,CntDown
	bsr.L	ScrollDown
	cmp.b	#16,CntDown
	bne.s	LoSc0
	sf	CntDown
	bra.s	LoSc0

LoSc0:
	tst.b	CntLeft
	bne.s	LoSc3
	tst.b	CntRight
	bne.s	LoSc4
	tst.b	MustLeft
	bne.s	LoSc3Check
	tst.b	MustRight
	bne.s	LoSc4Check
	bra.s	LoSc00

LoSc3Check:
	cmp.b	#0,CaveX
	beq.s	LoSc00
LoSc3:
	add.b	#1,CntLeft
	bsr.L	ScrollLeft
	cmp.b	#16,CntLeft
	bne.s	LoSc00
	sf	CntLeft
	bra.s	LoSc00

LoSc4Check:
	cmp.b	#CaveWidth-BoxShowX,CaveX
	beq.s	LoSc00
LoSc4:
	add.b	#1,CntRight
	bsr.L	ScrollRight
	cmp.b	#16,CntRight
	bne.s	LoSc00
	sf	CntRight

LoSc00:
	rts

;--- Zmiana banku kostek. ---

Loop_CheckBank:
	move.l	BoxDataPtr,a0
	move.l	BoxColorsPtr,a2
	lea	BoxInfo,a3

	move.b	CaveX,d0
	move.b	CaveY,d1

	cmp.b	#73,d0
	beq.s	ChBa73
	cmp.b	#74,d0
	beq.L	ChBa74
	cmp.b	#147,d0
	beq.L	ChBa147
	cmp.b	#148,d0
	beq.L	ChBa148

	cmp.b	#47,d1
	beq.L	ChBa47
	cmp.b	#48,d1
	beq.L	ChBa48
	cmp.b	#96,d1
	beq.L	ChBa96
	cmp.b	#97,d1
	beq.L	ChBa97
	rts

ChBa0:
	move.l	a0,CopySource
	move.l	a1,CopyDestin
	move.l	#6400,CopySize		;50*512 /4
	move.l	a2,FadePtr
	move.l	a3,(a4)
	rts

ChBa73:
	cmp.b	#96,d1
	bhi.s	ChBa73c
	cmp.b	#47,d1
	bhi.s	ChBa73b
ChBa73a:
	adda.l	#1*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#1*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.s	ChBa0
ChBa73b:
	adda.l	#1*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#3*32,a2
	adda.l	#1*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.s	ChBa0
ChBa73c:
	adda.l	#6*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#6*32,a2
	adda.l	#6*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0

ChBa74:
	cmp.b	#96,d1
	bhi.s	ChBa74c
	cmp.b	#47,d1
	bhi.s	ChBa74b
ChBa74a:
	adda.l	#2*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#1*32,a2
	adda.l	#2*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa74b:
	adda.l	#2*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#4*32,a2
	adda.l	#2*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa74c:
	adda.l	#6*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#7*32,a2
	adda.l	#6*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0

ChBa147:
	cmp.b	#96,d1
	bhi.s	ChBa147c
	cmp.b	#47,d1
	bhi.s	ChBa147b
ChBa147a:
	adda.l	#0*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#1*32,a2
	adda.l	#0*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa147b:
	adda.l	#3*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#4*32,a2
	adda.l	#3*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa147c:
	adda.l	#3*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#7*32,a2
	adda.l	#3*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0

ChBa148:
	cmp.b	#96,d1
	bhi.s	ChBa148c
	cmp.b	#47,d1
	bhi.s	ChBa148b
ChBa148a:
	adda.l	#4*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#2*32,a2
	adda.l	#4*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa148b:
	adda.l	#5*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#5*32,a2
	adda.l	#5*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa148c:
	adda.l	#5*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#8*32,a2
	adda.l	#5*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0

ChBa47:
	cmp.b	#147,d0
	bhi.s	ChBa47c
	cmp.b	#73,d0
	bhi.s	ChBa47b
ChBa47a:
	adda.l	#0*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#0*32,a2
	adda.l	#0*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa47b:
	adda.l	#0*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#1*32,a2
	adda.l	#0*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa47c:
	adda.l	#4*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#2*32,a2
	adda.l	#4*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0

ChBa48:
	cmp.b	#147,d0
	bhi.s	ChBa48c
	cmp.b	#73,d0
	bhi.s	ChBa48b
ChBa48a:
	adda.l	#3*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#3*32,a2
	adda.l	#3*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa48b:
	adda.l	#3*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#4*32,a2
	adda.l	#3*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0
ChBa48c:
	adda.l	#4*50*512,a0
	move.l	BoxBank1Ptr,a1
	adda.l	#5*32,a2
	adda.l	#4*50-00,a3
	lea	BoxInfo1Ptr,a4
	bra.L	ChBa0

ChBa96:
	cmp.b	#147,d0
	bhi.s	ChBa96c
	cmp.b	#73,d0
	bhi.s	ChBa96b
ChBa96a:
	adda.l	#1*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#3*32,a2
	adda.l	#1*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa96b:
	adda.l	#2*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#4*32,a2
	adda.l	#2*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa96c:
	adda.l	#2*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#5*32,a2
	adda.l	#2*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0

ChBa97:
	cmp.b	#147,d0
	bhi.s	ChBa97c
	cmp.b	#73,d0
	bhi.s	ChBa97b
ChBa97a:
	adda.l	#6*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#6*32,a2
	adda.l	#6*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa97b:
	adda.l	#6*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#7*32,a2
	adda.l	#6*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0
ChBa97c:
	adda.l	#6*50*512,a0
	move.l	BoxBank2Ptr,a1
	adda.l	#8*32,a2
	adda.l	#6*50-50,a3
	lea	BoxInfo2Ptr,a4
	bra.L	ChBa0

;--- Inicjacja kostek. ---

InstallBox:
	move.l	BoxDataPtr,a0
	adda.l	#StartBoxBank1,a0
	move.l	BoxBank1Ptr,a1
	move.l	#50*512,d0
	bsr.s	Copy

	move.l	BoxDataPtr,a0
	adda.l	#StartBoxBank2,a0
	move.l	BoxBank2Ptr,a1
	move.l	#50*512,d0
	bsr.s	Copy

	lea	BoxInfo,a0
	adda.l	#StartBoxInfo1,a0
	move.l	a0,BoxInfo1Ptr

	lea	BoxInfo,a0
	adda.l	#StartBoxInfo2-50,a0
	move.l	a0,BoxInfo2Ptr

	move.l	CavePtr,d0
	move.w	#CaveHeight-1,d1
	lea	BoxYAdr,a0
InBo1:
	move.l	d0,(a0)+
	add.l	#CaveWidth,d0
	dbf	d1,InBo1
	rts

;--- Kopiowanie. ---

;In:	a0.L-Src a1.L-Dst d0.L-Size
Copy:
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	Copy
	rts

;--- Petla kopiowania. ---

Loop_CopyLong:
	move.l	CopySize,d0
	beq.s	CoLo1
	move.l	CopySource,a0
	move.l	CopyDestin,a1
	sub.l	#CopyReply,d0
	move.w	#CopyReply-1,d1
CoLo2:
	move.l	(a0)+,(a1)+
	dbf	d1,CoLo2
	move.l	a0,CopySource
	move.l	a1,CopyDestin
	move.l	d0,CopySize
CoLo1:
	rts

;--- Przewijanie w lewo. ---

ScrollLeft:
	clr.w	d1
	move.b	CntLeft,d1
	beq.L	ScLe1
	cmp.b	OldCntLeft,d1
	beq.L	ScLe1
	move.b	d1,OldCntLeft
	cmp.b	#1,d1
	bne.s	ScLe2

	sub.b	#1,CaveX

	move.b	CaveX,ScrlRLCaveX
	move.b	CaveY,ScrlRLCaveY

	move.l	OffsetAll,d2
	subq.l	#BoxBPR,d2
	move.l	d2,OffsetAll
	add.l	ScrMemPtr,d2
	add.l	Offset,d2
	move.l	d2,ScrlScrAdrLR

	move.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	add.l	#ScrSize*ScrsNum,d2
	move.l	d2,ScrlMaxAdrLR

	move.l	BoxOffset,d2
	sub.l	#1,d2
	move.l	d2,BoxOffset
	add.l	CavePtr,d2
	move.l	d2,ScrlBoxAdrLR
ScLe2:
	move.l	ScrlScrAdrLR,a0
	move.l	ScrlBoxAdrLR,a2

	move.b	ScrlRLCaveX,d3
	move.b	ScrlRLCaveY,d4
	lea	ScrlRLAddY,a1
	add.b	0(a1,d1.w),d4

	lsl.w	#3,d1
	lea	ScrlAddLR,a1
	add.l	0(a1,d1.w),a2
	add.l	4(a1,d1.w),a0

	move.b	CaveX,d5
	move.b	CaveY,d6
	add.b	#BoxShowX-1,d5
	add.b	#BoxShowY-1,d6

	moveq	#1,d1
ScLe4:
	cmp.b	CaveX,d3
	bcs.s	ScLe0
	cmp.b	CaveY,d4
	bcs.s	ScLe0
	cmp.b	d5,d3
	bhi.s	ScLe0
	cmp.b	d6,d4
	bhi.s	ScLe0

	clr.l	d0
	move.b	(a2),d0
	move.l	a0,-(sp)
	bsr.L	PasteBoxCheckLR
	move.l	(sp)+,a0
ScLe0:
	adda.l	#BoxNL,a0
	lea	CaveWidth(a2),a2
	addq.b	#1,d4
	dbf	d1,ScLe4
ScLe1:
	rts

;--- Przewijanie w prawo. ---

ScrollRight:
	clr.w	d1
	move.b	CntRight,d1
	beq.L	ScLe1B
	cmp.b	OldCntRight,d1
	beq.L	ScLe1B
	move.b	d1,OldCntRight
	cmp.b	#1,d1
	bne.L	ScLe2B

	add.b	#1,CaveX

	move.b	CaveX,ScrlRLCaveX
	move.b	CaveY,ScrlRLCaveY
	add.b	#BoxShowX-1,ScrlRLCaveX

	move.l	OffsetAll,d2
	addq.l	#BoxBPR,d2
	move.l	d2,OffsetAll
	add.l	ScrMemPtr,d2
	add.l	Offset,d2
	add.l	#[BoxShowX-1]*BoxBPR,d2
	move.l	d2,ScrlScrAdrLR

	move.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	add.l	#ScrSize*ScrsNum,d2
	move.l	d2,ScrlMaxAdrLR

	move.l	BoxOffset,d2
	add.l	#1,d2
	move.l	d2,BoxOffset
	add.l	CavePtr,d2
	add.l	#BoxShowX-1,d2
	move.l	d2,ScrlBoxAdrLR
ScLe2B:
	move.l	ScrlScrAdrLR,a0
	move.l	ScrlBoxAdrLR,a2

	move.b	ScrlRLCaveX,d3
	move.b	ScrlRLCaveY,d4
	lea	ScrlRLAddY,a1
	add.b	0(a1,d1.w),d4

	lsl.w	#3,d1
	lea	ScrlAddLR,a1
	add.l	0(a1,d1.w),a2
	add.l	4(a1,d1.w),a0

	move.b	CaveX,d5
	move.b	CaveY,d6
	add.b	#BoxShowX-1,d5
	add.b	#BoxShowY-1,d6

	moveq	#1,d1
ScLe4B:
	cmp.b	CaveX,d3
	bcs.s	ScLe0B
	cmp.b	CaveY,d4
	bcs.s	ScLe0B
	cmp.b	d5,d3
	bhi.s	ScLe0B
	cmp.b	d6,d4
	bhi.s	ScLe0B

	clr.l	d0
	move.b	(a2),d0
	move.l	a0,-(sp)
	bsr.L	PasteBoxCheckLR
	move.l	(sp)+,a0
ScLe0B:
	adda.l	#BoxNL,a0
	lea	CaveWidth(a2),a2
	addq.b	#1,d4
	dbf	d1,ScLe4B
ScLe1B:
	rts

;--- Przewijanie w gore. ---

ScrollUp:
	clr.w	d1
	move.b	CntUp,d1
	beq.L	ScUp1
	cmp.b	OldCntUp,d1
	beq.L	ScUp1
	move.b	d1,OldCntUp
	cmp.b	#1,d1
	bne.L	ScUp2

	sub.b	#1,CaveY

	move.b	CaveX,ScrlUDCaveX
	move.b	CaveY,ScrlUDCaveY

	move.l	Offset,d2
	sub.l	#BoxNL,d2
	bpl.s	ScUp3
	add.l	#ScrSize,d2
	st	ChgScrPtr
ScUp3:
	move.l	d2,Offset
	add.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	move.l	d2,ScrlScrAdrUD

	move.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	add.l	#ScrSize*ScrsNum,d2
	move.l	d2,ScrlMaxAdrUD

	move.l	BoxOffset,d2
	sub.l	#CaveWidth,d2
	move.l	d2,BoxOffset
	add.l	CavePtr,d2
	move.l	d2,ScrlBoxAdrUD
ScUp2:
	move.l	ScrlScrAdrUD,a0
	move.l	ScrlBoxAdrUD,a2

	move.b	ScrlUDCaveX,d3
	move.b	ScrlUDCaveY,d4
	lea	ScrlUDAddX,a1
	add.b	0(a1,d1.w),d3

	lsl.w	#3,d1
	lea	ScrlAddUD,a1
	add.l	0(a1,d1.w),a2
	add.l	4(a1,d1.w),a0

	move.b	CaveX,d5
	move.b	CaveY,d6
	add.b	#BoxShowX-1,d5
	add.b	#BoxShowY-1,d6

	moveq	#2,d1
ScUp4:
	clr.l	d0
	move.b	(a2)+,d0

	cmp.b	CaveX,d3
	bcs.s	ScUp0
	cmp.b	CaveY,d4
	bcs.s	ScUp0
	cmp.b	d5,d3
	bhi.s	ScUp0
	cmp.b	d6,d4
	bhi.s	ScUp0

	move.l	a0,-(sp)
	bsr.L	PasteBoxCheckUD
	move.l	(sp)+,a0
ScUp0:
	lea	BoxBPR(a0),a0
	addq.b	#1,d3
	dbf	d1,ScUp4
ScUp1:
	rts

;--- Przewijanie w dol. ---

ScrollDown:
	clr.w	d1
	move.b	CntDown,d1
	beq.L	ScUp1B
	cmp.b	OldCntDown,d1
	beq.L	ScUp1B
	move.b	d1,OldCntDown
	cmp.b	#1,d1
	bne.L	ScUp2B

	add.b	#1,CaveY

	move.b	CaveX,ScrlUDCaveX
	move.b	CaveY,ScrlUDCaveY
	add.b	#BoxShowY-1,ScrlUDCaveY

	move.l	Offset,d2
	add.l	#BoxNL,d2
	cmp.l	#ScrSize,d2
	bcs.s	ScUp3B
	sub.l	#ScrSize,d2
	st	ChgScrPtr
ScUp3B:
	move.l	d2,Offset
	add.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	add.l	#ScrSize-BoxNL,d2		;adres na dole
	move.l	d2,ScrlScrAdrUD

	move.l	ScrMemPtr,d2
	add.l	OffsetAll,d2
	add.l	#ScrSize*ScrsNum,d2
	move.l	d2,ScrlMaxAdrUD

	move.l	BoxOffset,d2
	add.l	#CaveWidth,d2
	move.l	d2,BoxOffset
	add.l	CavePtr,d2
	add.l	#[BoxShowY-1]*CaveWidth,d2	;adres na dole
	move.l	d2,ScrlBoxAdrUD
ScUp2B:
	move.l	ScrlScrAdrUD,a0
	move.l	ScrlBoxAdrUD,a2

	move.b	ScrlUDCaveX,d3
	move.b	ScrlUDCaveY,d4
	lea	ScrlUDAddX,a1
	add.b	0(a1,d1.w),d3

	lsl.w	#3,d1
	lea	ScrlAddUD,a1
	add.l	0(a1,d1.w),a2
	add.l	4(a1,d1.w),a0

	move.b	CaveX,d5
	move.b	CaveY,d6
	add.b	#BoxShowX-1,d5
	add.b	#BoxShowY-1,d6

	moveq	#2,d1
ScUp4B:
	clr.l	d0
	move.b	(a2)+,d0

	cmp.b	CaveX,d3
	bcs.s	ScUp0B
	cmp.b	CaveY,d4
	bcs.s	ScUp0B
	cmp.b	d5,d3
	bhi.s	ScUp0B
	cmp.b	d6,d4
	bhi.s	ScUp0B

	move.l	a0,-(sp)
	bsr.L	PasteBoxCheckUD
	move.l	(sp)+,a0
ScUp0B:
	lea	BoxBPR(a0),a0
	addq.b	#1,d3
	dbf	d1,ScUp4B
ScUp1B:
	rts

;--- Pierwsze rysowanie. ---

PasteFirst:
	move.l	BoxColorsPtr,a0			;pierwsze kolory
	move.l	a0,FadePtr

	bsr.L	BlitterOn

	move.l	ScrMemPtr,a0
	add.l	OffsetAll,a0

	moveq	#ScrsNum-1,d1			;licznik ekranow
PaFi1:
	move.l	CavePtr,a2
	add.l	BoxOffset,a2			;adres pierwszej kostki

	moveq	#BoxShowY-1,d2			;licznik Y
PaFi2:
	moveq	#BoxShowX-1,d3			;licznik X
PaFi3:
	clr.l	d0
	move.b	(a2)+,d0
	bsr.s	PasteBox
	lea	BoxBPR(a0),a0
	dbf	d3,PaFi3

	adda.l	#CaveWidth-BoxShowX,a2
	adda.l	#BoxNL-[BoxShowX*BoxBPR],a0

	dbf	d2,PaFi2
	dbf	d1,PaFi1

	bsr.L	WaitBlit
	rts

;--- Rysowanie kostki lewo lub prawo. ---

PasteBoxCheckLR:
	cmpa.l	ScrlMaxAdrLR,a0
	bcs.s	PbCu1B
	suba.l	#ScrSize*ScrsNum,a0
PbCu1B:
	bra.L	PasteBox

;--- Rysowanie kostki gora lub dol. ---

PasteBoxCheckUD:
	cmpa.l	ScrlMaxAdrUD,a0
	bcs.s	PbCu1
	suba.l	#ScrSize*ScrsNum,a0
PbCu1:

;TUTAJ

;--- Rysowanie kostki. ---

;In:	a0.L-Adres d0.L-Numer
PasteBox:
	bclr	#7,d0
	;move.l	#29,d0			;- sama tecza -
	move.l	BoxBank1Ptr,a1
	cmp.b	#50,d0
	bcs.s	PaBo0
	sub.b	#50,d0
	move.l	BoxBank2Ptr,a1
PaBo0:
	lsl.l	#8,d0
	lsl.l	#1,d0
	adda.l	d0,a1

	;bra.s	Procesor

	btst	#6,DMACONR(a6)
PaBo1:
	btst	#6,DMACONR(a6)
	bne.s	PaBo1
	move.l	a1,BLTAPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	#-1,BLTAFWM(a6)
	move.w	#$09f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#ScrBPR-BoxBPR,BLTDMOD(a6)
	move.w	#[64*BoxHeight*Depth]+[BoxBPR/2],BLTSIZE(a6)
	rts

;--- Kopiowanie procesorem zamiast blitterem. ---

Procesor:
	movem.l	d0/a0/a1,-(sp)
	move.w	#127,d0
PrCsr:
	move.l	(a1)+,(a0)
	lea	ScrBPR(a0),a0
	dbf	d0,PrCsr
	movem.l	(sp)+,d0/a0/a1
	rts

;--- Ustawienie kolorow. ---

;In:	a0.L-Kolory d0.B-Ilosc
SetPalette:
	move.l	CLPtr,a1
	lea	ColorsAdr-CopperList(a1),a1
SePa:
	move.w	(a0)+,2(a1)
	lea	4(a1),a1
	subq.b	#1,d0
	bne.s	SePa
	rts

;--- Wlaczenie blittera. ---

BlitterOn:
	move.w	#SETCLR+BLTEN+DMAEN+BLTPR,DMACON(a6)
	rts

;--- Wlaczenie DMA obrazu. ---

ViewOn:
	move.l	CLPtr,a0
	move.l	a0,COP1PTR(a6)
	bsr.L	WaitVBL
	move.w	#SETCLR+COPEN+BPLEN+DMAEN+SPREN,DMACON(a6)
	rts

;--- Ustawienie ekranu. ---

SetScreen:
	clr.l	Offset

	move.l	#CaveStartX,d0
	lsl.l	#2,d0
	move.l	d0,OffsetAll

	clr.l	CntUp
	clr.l	OldCntUp
	sf	ScrNum

	bsr.s	SetScrAdr
	rts

;--- Wpis adresow biplanow. ---

SetScrAdr:
	clr.w	d1

	move.l	ShowScrPtr,d0

	lea	AddScrAdrUD,a1

	tst.b	CntUp
	beq.s	SsAd2
	clr.w	d2
	move.b	CntUp,d2
	lsl.w	#2,d2
	add.l	0(a1,d2.w),d0
SsAd2:

	tst.b	CntDown
	beq.s	SsAd3
	clr.w	d2
	move.b	CntDown,d2
	lsl.w	#2,d2
	sub.l	0(a1,d2.w),d0
SsAd3:

	tst.b	CntLeft
	beq.s	SsAd4
	clr.w	d2
	move.b	CntLeft,d2
	lsl.w	#3,d2
	lea	AddScrAdrLeft,a1
	add.l	0(a1,d2.w),d0
	move.l	4(a1,d2.w),d1
SsAd4:

	tst.b	CntRight
	beq.s	SsAd5
	clr.w	d2
	move.b	CntRight,d2
	lsl.w	#3,d2
	lea	AddScrAdrRight,a1
	sub.l	0(a1,d2.w),d0
	move.l	4(a1,d2.w),d1
SsAd5:

	move.l	CLPtr,a0
	lea	CLScrAdr-CopperList(a0),a0

	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#ScrBPR,d0

	move.w	d0,14(a0)
	swap	d0
	move.w	d0,10(a0)
	swap	d0
	add.l	#ScrBPR,d0

	move.w	d0,22(a0)
	swap	d0
	move.w	d0,18(a0)
	swap	d0
	add.l	#ScrBPR,d0

	move.w	d0,30(a0)
	swap	d0
	move.w	d0,26(a0)

	move.w	d1,34(a0)
	rts

;--- Zerowanie gry. ---

ResetGame:
	move.b	#CaveStartX,CaveX
	move.b	#CaveStartY,CaveY

	move.l	#CaveStartY,d0
	mulu.w	#CaveWidth,d0
	add.l	#CaveStartX,d0
	move.l	d0,BoxOffset

	clr.l	CopySize
	clr.l	MustUp
	clr.l	FadePtr
	clr.l	Kieszen

	sf	FadeSkip
	sf	Position
	st	Kierunek
	st	Sterowanie
	sf	Skok
	sf	Lot
	sf	Drabina
	sf	DrabFrameSkip
	sf	Anim
	sf	DTQuitGame
	sf	DTAmigaKey
	sf	KeyWez
	sf	WezBobNumS

	lea	ScrYAdd,a0
	move.w	#ScreenHeight-1,d0
	clr.l	d1
ReGa1:
	move.l	d1,(a0)+
	add.l	#ScrBPR*4,d1
	dbf	d0,ReGa1
	rts

;--- Czy byl nacisniety klawisz. ---

KeyPressed:
	sf	d0
	tst.b	KeyStatus
	beq.s	KePr9
	st	d0
	bra.L	KePr1d
KePr9:
	btst	#3,KEYICR
	beq.s	KePr1
	move.b	KEYSDR,d1
	bsr.s	KePr0

	cmp.b	#$0f,d1			;kod -Reset-
	beq.s	KePr1
	cmp.b	#$0c,d1			;bledny kod - ponowna proba przeslania
	beq.s	KePr9
KePr2:
	cmp.b	#$0a,d1			;przepelniony sprzetowy bufor
	beq.s	KePr1
KePr3:
	cmp.b	#$06,d1			;niepomyslny test wlasny klawiatury
	beq.s	KePr1
	cmp.b	#$04,d1			;nacisniety klawisz przy pierwszym zalaczeniu
	bne.s	KePr4
KePr5:
	btst	#3,KEYICR		;opuszczenie wszystkich kodow z bufora
	beq.s	KePr5
	move.b	KEYSDR,d1
	bsr.s	KePr0
	cmp.b	#$02,d1
	bne.s	KePr5
	bra.s	KePr1
KePr4:
	btst	#0,d1			;(7)
	beq.s	KePr1			;klawisz puszczony (bne)

	cmp.b	#$35,d1	;Alt on
	bne.s	KePr4b
KePr4c:
	st	DTAmigaKey
	bra.s	KePr1
KePr4b:
	cmp.b	#$37,d1	;Alt on
	beq.s	KePr4c

	move.b	d1,RawKeyCode
	st	d0
	st	KeyStatus
KePr1:
	cmp.b	#$36,d1	;Alt off
	bne.s	KePr1b
KePr1c:
	sf	DTAmigaKey
	bra.s	KePr1d
KePr1b:
	cmp.b	#$34,d1	;Alt off
	beq.s	KePr1c
KePr1d:
	tst.b	d0
	rts

;--- Potwierdzenie odebrania kodu. ---

KePr0:
	bset	#6,KEYCRA
	bclr	#6,KEYCRA
	rts

;--- Odczyt klawisza. ---

ReadKey:
	move.b	RawKeyCode,d0
	sf	KeyStatus
	rts

;--- Czyszczenie bufora klawiatury. ---

ClrKeyBuf:
	sf	KeyStatus
	bsr.L	KeyPressed
	bne.s	ClrKeyBuf
	rts

;--- Procedura VBL. ---

VBL_Proc:
	eor.b	#$ff,ScrNum			;CHANGE
	tst.b	UstawScrAdr
	beq.s	VBL1
	bsr.L	SetScrAdr
	sf	UstawScrAdr
VBL1:
	rts

;--- Czekanie 1/50 sek. ---

Wait:
	bsr.s	WaitVBL
	subq.l	#1,d0
	bne.s	Wait
	rts

;--- Czekanie na VBL. ---

WaitVBL:
	sf	ByloVBL
WaVbl:
	tst.b	ByloVBL
	beq.s	WaVbl
	rts

;--- Przerwanie pionowe. ---

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	VBL_Quit

	tst.b	WykonujVBL
	beq.s	VBL_Quit

	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.s	VBL_Proc
	st	ByloVBL
	sf	StatSOFT
	movem.l	(sp)+,d0-d7/a0-a6

VBL_Quit:
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;--- Procedure przerwania programowego. ---

SOFT:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#2,d0
	beq.s	SoFt1
	st	StatSOFT
SoFt1:
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;--- Uruchomienie procedury VBL. ---

StartVBL:
	sf	UstawScrAdr
	st	WykonujVBL
	rts


;--- Ustawienie i uruchomienie przerwania programowego. ---

SetStartSOFT:
	lea	SOFT,a0
	move.l	a0,$64
	move.w	#SETCLR+%100+$4000,INTENA(a6)
	sf	StatSOFT
	rts

;--- Ustawienie przerwania pionowego. ---

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;--- Zerowanie rejestrow. ---

ResetRegisters:
	bset	#1,$bfe001			;LED Off
	move.w	#%11111111,ADKCON(a6)		;modulacja Off
	rts

;--- Stan joystick-a. ---

Joystick:
	btst	#7,$bfe001
	seq	JoyFire

	move.w	JOY1DAT(a6),d0

	btst	#1,d0
	sne	JoyRight
	btst	#9,d0
	sne	JoyLeft

	sf	JoyUp
	sf	JoyDown

	btst	#0,d0
	bne.s	JoYs1
	btst	#1,d0
	beq.s	JoYs2
	st	JoyDown
	bra.s	JoYs2
JoYs1:
	btst	#1,d0
	bne.s	JoYs2
	st	JoyDown
JoYs2:

	btst	#8,d0
	bne.s	JoYs3
	btst	#9,d0
	beq.s	JoYs4
	st	JoyUp
	bra.s	JoYs4
JoYs3:
	btst	#9,d0
	bne.s	JoYs4
	st	JoyUp
JoYs4:

	tst.l	JoyUp
	sne	JoyInUse
	rts

;--- Czekanie na blitter. ---

WaitBlit:
	btst	#6,DMACONR(a6)
WaBlt:
	btst	#6,DMACONR(a6)
	bne.s	WaBlt
	rts

;--- Czekanie na lewy klawisz myszy. ---

WaitMK:
	btst	#6,$bfe001
	bne.s	WaitMK
	rts

ExecBase	=	4
ExcOldOpenLib	=	-408
ExcCloseLib	=	-414
GfxOwnBlit	=	-456
GfxDisownBlit	=	-462
GfxWaitBlit	=	-228

;--- Zapamietanie systemu. ---

Own_System:
	lea	GfxLibName,a1
	move.l	ExecBase.w,a6
	jsr	ExcOldOpenLib(a6)
	move.l	d0,GfxBase
	beq.s	Abort

	exg	d0,a6
	jsr	GfxOwnBlit(a6)
	jsr	GfxWaitBlit(a6)

	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096

	lea	MemBuf,a0
	lea	0,a1
	lea	Hard_Reset,a2
	moveq	#63,d0

OwSy1:
	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,OwSy1

Abort:
	tst.b	d0
	rts

;--- Zwrot systemu. ---

Disown_System:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096

	lea	MemBuf,a0
	lea	0,a1
	moveq	#63,d0

DiSy1:
	move.l	(a0)+,(a1)+
	dbf	d0,DiSy1

	move.l	GfxBase,a6
	move.l	$26(a6),$dff080

	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a

	jsr	GfxDisownBlit(a6)

	exg	a6,a1
	move.l	ExecBase.w,a6
	jsr	ExcCloseLib(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;--- Zimny start. ---

Hard_Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	Go_Reset,a0
	move.l	a0,$80
	trap	#0

Go_Reset:
	clr.l	ExecBase.w
	lea	2,a0
	reset
	jmp	(a0)

;--- Dane. ---

GfxLibName:	dc.b	'graphics.library',0,0
GfxBase:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemBuf:		blk.l	$40,0

;--- Stale. ---

CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180

SETCLR		=	$8000

DSKEN		=	%10000		;dysk
SPREN		=	%100000		;sprite
BLTEN		=	%1000000	;blitter
COPEN		=	%10000000	;copper
BPLEN		=	%100000000	;bit-plane
DMAEN		=	%1000000000
BLTPR		=	%10000000000	;priorytet

ERSY		=	%10
LACE		=	%100
LPEN		=	%1000
GAUD		=	%100000000
COLOR		=	%1000000000
DBLPF		=	%10000000000
HOMOD		=	%100000000000
BPU0		=	%1000000000000
BPU1		=	%10000000000000
BPU2		=	%100000000000000
HIRES		=	%1000000000000000

COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf

KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01

;*******************************************************************

			;--- Fast Data ---

CLPtr:		dc.l	CopperList
ScrMemPtr:	dc.l	ScrMem
CavePtr:	dc.l	Cave			;**SET FAST**
ObjectPtr:	dc.l	Object			;**SET FAST**
BobDataPtr:	dc.l	BobData			;**SET CHIP**
ScrMemDPtr:	dc.l	ScrMemDown
DownTxtPtr:	dc.l	0
DownLinePtr:	dc.l	DownLine		;**SET CHIP**
DSPtr:		dc.l	DownStars		;**SET CHIP**

;--- sprite ---

SpritePtr:	dc.l	SpriteData		;**SET CHIP**
EmptySprtPtr:	dc.l	EmptySprite

;--- kostki ---

BoxDataPtr:	dc.l	BoxBanks		;**SET FAST**
BoxBank1Ptr:	dc.l	BoxBank1
BoxBank2Ptr:	dc.l	BoxBank2
BoxInfo1Ptr:	dc.l	0
BoxInfo2Ptr:	dc.l	0

;--- Kolory ---

BoxColorsPtr:	dc.l	BoxColors		;**SET FAST**

;--- Inne ---

ScrlAddLR:
	dc.l	0,0
	dc.l	0*CaveWidth,[0*BoxNL]+[ScrSize*0],2*CaveWidth,[2*BoxNL]+[ScrSize*0]
	dc.l	4*CaveWidth,[4*BoxNL]+[ScrSize*0],6*CaveWidth,[6*BoxNL]+[ScrSize*0]
	dc.l	0*CaveWidth,[0*BoxNL]+[ScrSize*1],2*CaveWidth,[2*BoxNL]+[ScrSize*1]
	dc.l	4*CaveWidth,[4*BoxNL]+[ScrSize*1],6*CaveWidth,[6*BoxNL]+[ScrSize*1]
	dc.l	0*CaveWidth,[0*BoxNL]+[ScrSize*2],2*CaveWidth,[2*BoxNL]+[ScrSize*2]
	dc.l	4*CaveWidth,[4*BoxNL]+[ScrSize*2],6*CaveWidth,[6*BoxNL]+[ScrSize*2]
	dc.l	0*CaveWidth,[0*BoxNL]+[ScrSize*3],2*CaveWidth,[2*BoxNL]+[ScrSize*3]
	dc.l	4*CaveWidth,[4*BoxNL]+[ScrSize*3],6*CaveWidth,[6*BoxNL]+[ScrSize*3]

ScrlAddUD:
	dc.l	0,0
	dc.l	0,[0*BoxBPR]+[0*ScrSize],3,[3*BoxBPR]+[0*ScrSize]
	dc.l	6,[6*BoxBPR]+[0*ScrSize],9,[9*BoxBPR]+[0*ScrSize]
	dc.l	0,[0*BoxBPR]+[1*ScrSize],3,[3*BoxBPR]+[1*ScrSize]
	dc.l	6,[6*BoxBPR]+[1*ScrSize],9,[9*BoxBPR]+[1*ScrSize]
	dc.l	0,[0*BoxBPR]+[2*ScrSize],3,[3*BoxBPR]+[2*ScrSize]
	dc.l	6,[6*BoxBPR]+[2*ScrSize],9,[9*BoxBPR]+[2*ScrSize]
	dc.l	0,[0*BoxBPR]+[3*ScrSize],3,[3*BoxBPR]+[3*ScrSize]
	dc.l	6,[6*BoxBPR]+[3*ScrSize],9,[9*BoxBPR]+[3*ScrSize]

AddScrAdrLeft:
	dc.l	0,0
	dc.l	4,$22,4,$44,4,$66,4,$88,4,$aa,4,$cc,4,$ee
	dc.l	2,$00,2,$22,2,$44,2,$66,2,$88,2,$aa,2,$cc,2,$ee
	dc.l	0,$00

AddScrAdrRight:
	dc.l	0,0
	dc.l	2,$ee,2,$cc,2,$aa,2,$88,2,$66,2,$44,2,$22,2,$00
	dc.l	0,$ee,0,$cc,0,$aa,0,$88,0,$66,0,$44,0,$22,0,$00

AddScrAdrUD:
	dc.l	0
	dc.l	30*ScrNL,28*ScrNL,26*ScrNL,24*ScrNL,22*ScrNL
	dc.l	20*ScrNL,18*ScrNL,16*ScrNL,14*ScrNL,12*ScrNL
	dc.l	10*ScrNL,08*ScrNL,06*ScrNL,04*ScrNL,02*ScrNL
	dc.l	00*ScrNL

ScrlUDAddX:
	dc.b	0
	dc.b	0,3,6,9,0,3,6,9
	dc.b	0,3,6,9,0,3,6,9

ScrlRLAddY:
	dc.b	0
	dc.b	0,2,4,6,0,2,4,6
	dc.b	0,2,4,6,0,2,4,6

ScrlRLCaveX:	dc.b	0
ScrlRLCaveY:	dc.b	0
ScrlUDCaveX:	dc.b	0
ScrlUDCaveY:	dc.b	0
	EVEN

DrabPos:
	dc.b	32,DrabinaWaitS
	dc.b	34,DrabinaWaitL
	dc.b	32,DrabinaWaitS
	dc.b	33,DrabinaWaitL
	dc.b	32,DrabinaWaitS
	dc.b	34,DrabinaWaitL
	dc.b	32,DrabinaWaitS
	dc.b	33,DrabinaWaitL

;*******************************************************************

			;--- Fast Work ---

Win0Ptr:	dc.l	0
Win1Ptr:	dc.l	0
Win2Ptr:	dc.l	0
Win3Ptr:	dc.l	0
Win4Ptr:	dc.l	0

Box0XY:		dc.w	0
Box1XY:		dc.w	0

Fizyczny:	dc.l	0
Logiczny:	dc.l	0
Return:		dc.l	0

Screen0:	dc.l	0
Screen1:	dc.l	0
Screen2:	dc.l	0

RetBobMem0Ptr:	dc.l	0		;lista bobow banku 0
RetBobMem1Ptr:	dc.l	0		;lista bobow banku 1
BobAddY:	dc.l	0
BobSkipPlane:	dc.l	0

Scr0Stat:	dc.b	0
Scr1Stat:	dc.b	0
Scr2Stat:	dc.b	0
ChgScrPtr:	dc.b	0
RetBobNum:	dc.b	0		;z/do ktorego banku odtwarzac / wpisywac
Mem0Cnt:	dc.b	0		;ile bobow w banku 0
Mem1Cnt:	dc.b	0		;ile bobow w banku 1
BobByloCutL:	dc.b	0		;czy bylo ciecie z lewej
	EVEN

;--- sprite ---

HardX:		dc.w	0
HardY:		dc.w	0
GlobalX:	dc.w	0
GlobalY:	dc.w	0
JumpYMem:	dc.w	0
DrabAdd:	dc.w	0

DrabCnt:	dc.b	0
Position:	dc.b	0
Kierunek:	dc.b	0
Skok:		dc.b	0
Lot:		dc.b	0
Drabina:	dc.b	0
DrabFrameSkip:	dc.b	0
Sterowanie:	dc.b	0
Anim:		dc.b	0
JumpBreak:	dc.b	0
JBCnt:		dc.b	0
JumpCnt:	dc.b	0
UpOff:		dc.b	0
	EVEN

SpriteAry:	blk.b	12,0
SpriteAryF:	blk.b	12,0
	EVEN

Stos:		dc.l	0

OffsetAll:	dc.l	0
Offset:		dc.l	0
BoxOffset:	dc.l	0
FadePtr:	dc.l	0

;--- Boby ---

BobScrPtr:	dc.l	0
ShowScrPtr:	dc.l	0

LiniaY:		dc.w 	0
LiniaX:		dc.w 	0

ScrlBoxAdrUD:	dc.l	0
ScrlScrAdrUD:	dc.l	0
ScrlMaxAdrUD:	dc.l	0
ScrlBoxAdrLR:	dc.l	0
ScrlScrAdrLR:	dc.l	0
ScrlMaxAdrLR:	dc.l	0

;*** procedura kopiowania ***

CopySource:	dc.l	0
CopyDestin:	dc.l	0
CopySize:	dc.l	0

;*** pozostale zmienne ***

FadeSkip:	dc.b	0
WykonujVBL:	dc.b	0
ByloVBL:	dc.b	0
UstawScrAdr:	dc.b	0
ScrNum:		dc.b	0

CaveX:		dc.b	0
CaveY:		dc.b	0

RawKeyCode:	dc.b	0
KeyStatus:	dc.b	0
StatSOFT:	dc.b	0
	EVEN
CntUp:		dc.b	0
CntDown:	dc.b	0
CntRight:	dc.b	0
CntLeft:	dc.b	0

OldCntUp:	dc.b	0
OldCntDown:	dc.b	0
OldCntRight:	dc.b	0
OldCntLeft:	dc.b	0

MustUp:		dc.b	0
MustDown:	dc.b	0
MustRight:	dc.b	0
MustLeft:	dc.b	0

JoyUp:		dc.b	0
JoyDown:	dc.b	0
JoyRight:	dc.b	0
JoyLeft:	dc.b	0
JoyFire:	dc.b	0
JoyInUse:	dc.b	0
	EVEN

BoxYAdr:	blk.l	CaveHeight,0
ScrYAdd:	blk.l	ScreenHeight,0

BobMemBank0:	blk.b	MaxIlBob*BobMemSize
BobMemBank1:	blk.b	MaxIlBob*BobMemSize

BobDrawTab:	blk.b	[MaxIlBob+1]*8
BobDrawTabBack:	blk.b	[MaxIlBob+1]*8

;*******************************************************************

			;--- Chip Data ---

CopperList:
	dc.w	BPLCON0,COLOR

CLSprite:
	dc.w	$120,0
	dc.w	$122,0
	dc.w	$124,0
	dc.w	$126,0
	dc.w	$128,0
	dc.w	$12a,0
	dc.w	$12c,0
	dc.w	$12e,0
CLDownSprite:
	dc.w	$130,0
	dc.w	$132,0
	dc.w	$134,0
	dc.w	$136,0
	dc.w	$138,0
	dc.w	$13a,0
	dc.w	$13c,0
	dc.w	$13e,0

	dc.w	$2003,COPWAIT

ColorsAdr:	;*$180*
	dc.w	$182,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
CLSprtColors:
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	DDFSTRT,DDFVAR*8
	dc.w	DDFSTOP,[DDFVAR*8]+[[ScreenDMA/2]-8]

	dc.w	DIWSTRT,$1691
	dc.w	DIWSTOP,$7fc1

	dc.w	BPLCON2,%111111

	dc.w	BPL1MOD,ScrNL-[ScreenDMA/8]
	dc.w	BPL2MOD,ScrNL-[ScreenDMA/8]

CLScrAdr:
	dc.w	$e0,00,$e2,00
	dc.w	$e4,00,$e6,00
	dc.w	$e8,00,$ea,00
	dc.w	$ec,00,$ee,00

	dc.w	BPLCON1,0

	dc.w	$3203,COPWAIT
	dc.w	BPLCON0,COLOR+BPU2

CLRain:
	blk.l	75*2,$01820000

	dc.w	$f203,COPWAIT
	dc.w	BPLCON0,COLOR

	dc.w	INTREQ,%100+$8000

	;-- Down Line Text. ---

CLDTScrAdr:
	dc.w	$e0,00,$e2,00
	dc.w	$e4,00,$e6,00
	dc.w	$e8,00,$ea,00

	dc.w	DDFSTRT,[DDFVAR+1]*7
	dc.w	DDFSTOP,[DDFVAR+1]*7+152

	dc.w	BPL1MOD,0
	dc.w	BPL2MOD,0
	dc.w	BPLCON1,%1
	dc.w	BPLCON2,%1000000

	dc.w	$182,$000,$186,$000	;*$180*

	dc.w	$f403,COPWAIT
	dc.w	BPLCON0,COLOR+BPU0+BPU1+DBLPF

	dc.w	$192,$666,$182,$410,$f503,COPWAIT	
	dc.w	$192,$888,$182,$720,$f603,COPWAIT
	dc.w	$192,$bbb,$182,$930,$f703,COPWAIT
	dc.w	$192,$fff,$182,$c50,$f903,COPWAIT
	dc.w	$192,$bbb,$182,$930,$fa03,COPWAIT
	dc.w	$192,$888,$182,$720,$fb03,COPWAIT
	dc.w	$192,$666,$182,$410,$fc03,COPWAIT

	dc.w	BPLCON0,COLOR

CLDownLine:
	dc.w	$e0,00,$e2,00
	dc.w	$e4,00,$e6,00
	dc.w	$e8,00,$ea,00
	dc.w	$ec,00,$ee,00

	dc.w	DDFSTRT,[DDFVAR+1]*8
	dc.w	DDFSTOP,[DDFVAR+1]*8+144

	dc.w	BPL1MOD,38*3
	dc.w	BPL2MOD,38*3
	dc.w	BPLCON1,0
	dc.w	BPLCON2,127

	dc.w	$182,$000,$182,$000,$184,$321,$186,$543	;*$180*
	dc.w	$188,$765,$18a,$987,$18c,$ba9,$18e,$410
	dc.w	$190,$720,$192,$930,$194,$c50,$196,$f80
	dc.w	$198,$333,$19a,$666,$19c,$aaa,$19e,$eee

	dc.w	$1b2,$666,$1b4,$999,$1b6,$fff
	dc.w	$1ba,$666,$1bc,$999,$1be,$fff

	dc.w	$ff03,COPWAIT
	dc.w	BPLCON0,COLOR+BPU2

	dc.w	ENDHALF,COPWAIT

	dc.w	$0903,COPWAIT,$182,$f00
	dc.w	$0a03,COPWAIT,$182,$800

	dc.w	$1603,COPWAIT,$182,$bbb
	dc.w	$1703,COPWAIT,$182,$ddd
	dc.w	$1803,COPWAIT,$182,$fff
	dc.w	$1903,COPWAIT,$182,$fff
	dc.w	$1a03,COPWAIT,$182,$ddd
	dc.w	$1b03,COPWAIT,$182,$bbb
	dc.w	$1c03,COPWAIT,$182,$999
	dc.w	$1d03,COPWAIT,$182,$777

	dc.w	$2903,COPWAIT
	dc.w	BPLCON0,COLOR

	;-- End CL. --

	dc.w	ENDCOPLST,COPWAIT

EmptySprite:
	dc.w	$fe00,$ff00
	dc.w	$0000,$0000
	dc.w	$0000,$0000

;*******************************************************************

			;--- Chip Work ---

BoxBank1:	blk.b	512*50,0
BoxBank2:	blk.b	512*50,0

ScrMemDown:
	blk.b	40*8,0
	blk.b	40*8,0

ScrMem:
	blk.b	ScrSize*ScrsNum+AddScrMem,0

;BobStruct = 16
;	.w - szer pxl (= 0 -ostatni bob)
;	.w - szer byte
;	.w - wys
;	.l - data ptr
;	.l - mask ptr
;	.w - nieuzyty

;BobDrawStruct = 8
;	.w - X_Cave
;	.w - Y_Cave
;	.w - numer boba (=-1 - nie rysowac-koniec listy)
;	.w - tryb rysowania dla blittera

		;*** CHIP INCL ***

BobData:	incbin	"RAM:BobData.BIN"
SpriteData:	incbin	"RAM:SpriteData.BIN"
DownLine:	incbin	"RAM:DownLine.BIN"
DownStars:	incbin	"RAM:DownStars.BIN"
SpriteColors:	incbin	"RAM:SpriteColors.BIN"
Rainbow:	incbin	"RAM:Rainbow.BIN"
SpriteOffset:	incbin	"RAM:SpriteOffset.BIN"
SpriteInfo:	incbin	"RAM:SpriteInfo.BIN"
SpriteJump:	incbin	"RAM:SpriteJump.BIN"
BobArray:	incbin	"RAM:BobArray.BIN"
DownFont:	incbin	"RAM:DownFont.BIN"
DownFontTab:	incbin	"RAM:DownFontTab.BIN"
RawToASCII:	incbin	"RAM:RawToASCII.BIN"
RawToASCIIPl:	incbin	"RAM:RawToASCIIPl.BIN"
Jump1:
		dc.w	0
		incbin	"RAM:Jump1.BIN"
Jump2:
		dc.w	0
		incbin	"RAM:Jump2.BIN"
JumpBall:	incbin	"RAM:BallJump.BIN"
BoxInfo:
		incbin	"RAM:BoxInfo0.BIN"
		incbin	"RAM:BoxInfo1.BIN"
;Samples:	incbin	"RAM:Samples.BIN"
;SmplTab:	incbin	"RAM:SmplTab.BIN"

		;*** FAST INCL ***

Cave:		incbin	"RAM:CaveData.BIN"
Object:		incbin	"RAM:Object.BIN"
BoxColors:	incbin	"RAM:BoxColors.BIN"
BoxBanks:
		incbin	"RAM:BoxBank0.BIN"
		incbin	"RAM:BoxBank1.BIN"
Stop:
