/*
 *
 * Common types and defines
 *
 */

#ifndef _TYPES_H
#define _TYPES_H

#ifndef macintosh
#include <sys/types.h>
#endif

#include <limits.h>

// define a dboolean
typedef int dboolean;

//define a signed byte
typedef signed char sbyte;

//define unsigned types;
typedef unsigned char ubyte;

#if defined(_WIN32) || defined(macintosh)
typedef unsigned short ushort;
typedef unsigned int uint;
#endif


#include <SDL_types.h>


typedef Uint16 u_int16_t;
typedef Uint32 u_int32_t;
typedef Uint64 u_int64_t;


#ifdef _MSC_VER
# include <stdlib.h> // this is where min and max are defined
#endif
#ifndef min
#define min(a,b) (((a)>(b))?(b):(a))
#endif
#ifndef max
#define max(a,b) (((a)<(b))?(b):(a))
#endif

#ifndef PATH_MAX
#define PATH_MAX 4096
#endif

#ifndef bool
//define a boolean
typedef ubyte bool;
#endif

#ifndef NULL
#define NULL 0
#endif

// the following stuff has nothing to do with types but needed everywhere,
// and since this file is included everywhere, it's here.
#define WORDS_BIGENDIAN
#define WORDS_NEED_ALIGNMENT

#ifdef __GNUC__
# define __pack__ __attribute__((packed))
#elif defined(_MSC_VER)
# pragma pack(push, packing)
# pragma pack(1)
# define __pack__
#elif defined(macintosh)
# pragma options align=packed
# define __pack__
#else
# error d1x will not work without packed structures
#endif

#ifdef _MSC_VER
# define inline __inline
#endif

#ifndef PACKAGE_STRING
# define PACKAGE_STRING "d1x"
#endif

#endif //_TYPES_H

