ExecBase	=	4

AllocMem	=	-198
FreeMem		=	-210
OldOpenLibrary	=	-408
CloseLibrary	=	-414
FindTask	=	-294
AddPort		=	-354
RemPort		=	-360
OpenDevice	=	-444
CloseDevice	=	-450
DoIO		=	-456

Open		=	-30
Close		=	-36
Read		=	-42
Write		=	-48
Output		=	-60
Seek		=	-66

MODE_OLD	=	1005
MODE_NEW	=	1006

MEM_PUBLIC	=	0
MEM_CHIP	=	2
MEM_FAST	=	4

Command		=	28
Length		=	36
Data		=	40
Offset		=	44

SecPerCyl	=	22
TrkStart	=	0
TrkStop		=	79

EFFICIENCY	=	4
SPEEDUP		=	0

ppAllocCrInfo	=	-$60
ppCrunchBuf	=	-$6c
ppFreeCrInfo	=	-$66
ppWriteHeader	=	-$72

Start:
	lea	Params(pc),a6
Sk1:	move.b	(a0)+,(a6)+
	bne.s	Sk1
	clr.b	-2(a6)

	lea	DosName(pc),a1
	move.l	ExecBase.w,a6
	jsr	OldOpenLibrary(a6)
	lea	DosBase(pc),a6
	move.l	d0,(a6)
	beq.L	Err1

	move.l	DosBase(pc),a6
	jsr	OutPut(a6)
	lea	OHandle(pc),a6
	move.l	d0,(a6)
	beq.L	Err2

	move.l	#512*SecPerCyl*2,d0
	moveq	#MEM_CHIP,d1
	move.l	ExecBase.w,a6
	jsr	AllocMem(a6)
	lea	TDBuf(pc),a6
	move.l	d0,(a6)
	beq.s	Err2

	lea	PPName(pc),a1
	move.l	ExecBase.w,a6
	jsr	OldOpenLibrary(a6)
	lea	PPBase(pc),a6
	move.l	d0,(a6)
	beq.s	Err3

	lea	Txt0(pc),a0
	bsr.L	Print

	bsr.L	StartTD

	move.b	Params(pc),d0
	cmp.b	#'R',d0
	beq.s	ProgR
	cmp.b	#'r',d0
	beq.s	ProgR
	cmp.b	#'W',d0
	beq.L	ProgW
	cmp.b	#'w',d0
	beq.L	ProgW

	lea	Txt1(pc),a0
	bsr.L	Print

Quit:
	bsr.L	StopTD

Err4:	move.l	PPBase(pc),a1
	move.l	ExecBase.w,a6
	jsr	CloseLibrary(a6)

Err3:	move.l	TDBuf(pc),a1
	move.l	#512*SecPerCyl*2,d0
	move.l	ExecBase.w,a6
	jsr	FreeMem(a6)

Err2:	move.l	DosBase(pc),a1
	move.l	ExecBase.w,a6
	jsr	CloseLibrary(a6)

Err1:	rts

********************************************************************

ProgR:
	lea	Params+2(pc),a0
	exg	a0,d1
	move.l	#MODE_NEW,d2
	move.l	DosBase(pc),a6
	jsr	Open(a6)
	lea	FHandle(pc),a6
	move.l	d0,(a6)
	beq.L	ErrOpenFile

	lea	Blok(pc),a6
	move.l	#SecPerCyl*TrkStart,(a6)
	lea	TDOffset(pc),a6
	move.l	#SecPerCyl*TrkStart*512,(a6)
	lea	Track(pc),a6
	move.l	#TrkStart,(a6)

LoopR:
	bsr.L	ReadTrack
	bne.L	ErrRT

	move.l	TDBuf(pc),a0
	movea.l	a0,a1
	adda.l	#512*SecPerCyl,a1
	move.w	#[512*SecPerCyl/4]-1,d0
LR1:	move.l	(a0)+,(a1)+
	dbf	d0,LR1

	bsr.L	Pack
	lea	CrSize(pc),a6
	move.l	d0,(a6)
	tst.b	d7
	beq.L	QuitR
	tst.l	d0
	beq.L	LoopRNoPack
	bmi.L	LoopRNoPack
	cmp.l	#512*SecPerCyl,d0
	bcc.s	LoopRNoPack

	moveq	#0,d2
	moveq	#1,d3
	bsr.L	SeekFile
	lea	M1Seek(pc),a6
	move.l	d0,(a6)

	bsr.L	WriteLong
	bne.L	ErrRF

	move.l	FHandle(pc),d0
	move.l	#EFFICIENCY,d1
	moveq	#0,d2
	moveq	#0,d3
	move.l	PPBase(pc),a6
	jsr	ppWriteHeader(a6)

	move.l	TDBuf(pc),a0
	move.l	CrSize(pc),d0
	bsr.L	WriteFile
	bne.L	ErrRF

	move.l	CrInfo(pc),a0
	move.l	PPBase(pc),a6
	jsr	ppFreeCrInfo(a6)

	moveq	#0,d2
	moveq	#1,d3
	bsr.L	SeekFile
	lea	M2Seek(pc),a6
	move.l	d0,(a6)

	move.l	M1Seek(pc),d2
	moveq	#-1,d3
	bsr.L	SeekFile

	move.l	M2Seek(pc),d0
	sub.l	M1Seek(pc),d0
	subq.l	#4,d0
	bset	#31,d0
	bsr.L	WriteLong

	move.l	M2Seek(pc),d2
	moveq	#-1,d3
	bsr.L	SeekFile

	bra.s	LoopRNext

LoopRNoPack:
	move.l	CrInfo(pc),a0
	move.l	PPBase(pc),a6
	jsr	ppFreeCrInfo(a6)

	move.l	#512*SecPerCyl,d0
	bsr.L	WriteLong
	bne.s	ErrRF

	move.l	TDBuf(pc),a0
	move.l	#512*SecPerCyl,d0
	adda.l	d0,a0
	bsr.L	WriteFile
	bne.s	ErrRF

LoopRNext:
	bsr.L	NextTrack
	bne.L	LoopR

	lea	Txt8(pc),a0
	bsr.L	Print
	moveq	#0,d2
	moveq	#1,d3
	bsr.L	SeekFile
	bsr.L	D0ToAscii
	lea	DecBuf(pc),a0
	bsr.L	Print
	bsr.L	PrintRet

QuitR:	move.l	FHandle(pc),d1
	move.l	DosBase(pc),a6
	jsr	Close(a6)

	bra.L	Quit

ErrRT:
	lea	Txt5(pc),a0
	bsr.L	Print
	bra.s	QuitR

ErrRF:
	lea	Txt4(pc),a0
	bsr.L	Print
	bra.s	QuitR

********************************************************************

ProgW:
	lea	Params+2(pc),a0
	exg	a0,d1
	move.l	#MODE_OLD,d2
	move.l	DosBase(pc),a6
	jsr	Open(a6)
	lea	FHandle(pc),a6
	move.l	d0,(a6)
	beq.L	ErrOpenFile

	lea	Blok(pc),a6
	move.l	#SecPerCyl*TrkStart,(a6)
	lea	TDOffset(pc),a6
	move.l	#SecPerCyl*TrkStart*512,(a6)
	lea	Track(pc),a6
	move.l	#TrkStart,(a6)

LoopW:
	bsr.L	ReadFAndDePack
	bne.s	ErrWF
	bsr.L	WriteTrack
	bne.s	ErrWT
	bsr.L	NextTrack
	bne.L	LoopW

QuitW:	move.l	FHandle(pc),d1
	move.l	DosBase(pc),a6
	jsr	Close(a6)

	bra.L	Quit

ErrWT:
	lea	Txt6(pc),a0
	bsr.L	Print
	bra.s	QuitW

ErrWF:
	lea	Txt3(pc),a0
	bsr.L	Print
	bra.s	QuitW

********************************************************************

Pack:
	moveq	#EFFICIENCY,d0
	moveq	#SPEEDUP,d1
	suba.l	a0,a0
	move.l	TDBuf(pc),a1
	move.l	PPBase(pc),a6
	jsr	ppAllocCrInfo(a6)
	lea	CrInfo(pc),a0
	move.l	d0,(a0)
	beq.s	ErrPack

	move.l	CrInfo(pc),a0
	move.l	TDBuf(pc),a1
	move.l	#512*SecPerCyl,d0
	move.l	PPBase(pc),a6
	jsr	ppCrunchBuf(a6)

	st	d7
	rts

ErrPack:
	lea	Txt7(pc),a0
	bsr.L	Print
	sf	d7
	rts


********************************************************************

ReadFAndDePack:
	bsr.s	ReadLong
	bne.s	ErrDP
	btst	#31,d0
	bne.s	RDeCrunch
	move.l	TDBuf(pc),a0
	bsr.L	ReadFile
	bne.s	ErrDP
	moveq	#0,d0
ErrDP:	rts
RDeCrunch:
	bclr	#31,d0
	move.l	d0,-(sp)
	move.l	TDBuf(pc),a0
	adda.l	#512*SecPerCyl,a0
	bsr.s	ReadFile
	bne.s	ErrDP2
	move.l	(sp)+,d0
	move.l	TDBuf(pc),a0
	movea.l	a0,a1
	adda.l	#512*SecPerCyl,a0
	bsr.L	DeCrunch
	moveq	#0,d0
	rts
ErrDP2:	move.l	(sp)+,d0
	rts

********************************************************************

ReadLong:
	lea	Long(pc),a0
	move.l	FHandle(pc),d1
	exg	a0,d2
	moveq	#4,d3
	move.l	DosBase(pc),a6
	jsr	Read(a6)
	move.l	Long(pc),d1
	exg	d0,d1
	cmp.l	#4,d1
	rts

********************************************************************

WriteLong:
	lea	Long(pc),a0
	move.l	d0,(a0)
	move.l	FHandle(pc),d1
	exg	a0,d2
	moveq	#4,d3
	move.l	DosBase(pc),a6
	jsr	Write(a6)
	cmp.l	#4,d0
	rts

********************************************************************

SeekFile:
	move.l	FHandle(pc),d1
	move.l	DosBase(pc),a6
	jmp	Seek(a6)

********************************************************************

;In:
;	a0.l	- Bufor
;	d0.l	- Length
ReadFile:
	move.l	FHandle(pc),d1
	exg	a0,d2
	exg	d0,d3
	move.l	DosBase(pc),a6
	move.l	d3,-(sp)
	jsr	Read(a6)
	cmp.l	(sp)+,d0
	rts

********************************************************************

;In:
;	a0.l	- Bufor
;	d0.l	- Length
WriteFile:
	move.l	FHandle(pc),d1
	exg	a0,d2
	exg	d0,d3
	move.l	DosBase(pc),a6
	move.l	d3,-(sp)
	jsr	Write(a6)
	cmp.l	(sp)+,d0
	rts

********************************************************************

NextTrack:
	lea	TDOffset(pc),a6
	add.l	#SecPerCyl*512,(a6)
	lea	Blok(pc),a6
	add.l	#SecPerCyl,(a6)
	lea	Track(pc),a6
	move.l	(a6),d0
	addq.l	#1,d0
	move.l	d0,(a6)
	cmp.l	#TrkStop+1,d0
	rts

********************************************************************

ReadTrack:
	lea	DiskIO(pc),a1
	move.w	#2,Command(a1)
	move.l	TDBuf(pc),Data(a1)
	move.l	#SecPerCyl*512,Length(a1)
	move.l	TDOffset(pc),Offset(a1)
	bra.s	GoTD

********************************************************************

WriteTrack:
	lea	DiskIO(pc),a1
	move.w	#3,Command(a1)
	move.l	TDBuf(pc),Data(a1)
	move.l	#SecPerCyl*512,Length(a1)
	move.l	TDOffset(pc),Offset(a1)
	bra.s	GoTD

********************************************************************

ErrOpenFile:
	lea	Txt2(pc),a0
	bsr.s	Print
	lea	Params+2(pc),a0
	bsr.s	Print
	bsr.s	PrintRet
	bra.L	Quit

********************************************************************

;In:
;	a0.l	- Text
Print:
	move.l	OHandle(pc),d1
	move.l	a0,d2
	moveq	#0,d3
Pr1:	addq.l	#1,d3
	tst.b	(a0)+
	bne.s	Pr1
	subq.l	#1,d3
	move.l	DosBase(pc),a6
	jmp	Write(a6)

********************************************************************

PrintRet:
	lea	Txt00(pc),a0
	bra.s	Print

********************************************************************

;In:
;	d0.l	- Length
Alloc:
	lea	BufLen(pc),a6
	move.l	d0,(a6)
	moveq	#MEM_PUBLIC,d1
	move.l	ExecBase.w,a6
	jsr	AllocMem(a6)
	lea	BufPtr(pc),a6
	move.l	d0,(a6)
	rts

********************************************************************

Free:
	move.l	BufPtr(pc),a1
	move.l	BufLen(pc),d0
	move.l	ExecBase.w,a6
	jmp	FreeMem(a6)

********************************************************************

GoTD:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	ExecBase.w,a6
	jsr	DoIO(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	moveq	#0,d7
	move.b	31(a1),d7
	rts

********************************************************************

StartTD:
	move.l	ExecBase.w,a6
	sub.l	a1,a1
	jsr	FindTask(a6)
	lea	DiskRep(pc),a5
	move.l	d0,16(a5)
	lea	DiskRep(pc),a1
	jsr	AddPort(a6)
	lea	DiskIO(pc),a1
	lea	DiskRep(pc),a5
	move.l	a5,14(a1)
	moveq	#0,d0
	moveq	#0,d1
	lea	TrackName(pc),a0
	jsr	OpenDevice(a6)
	rts

********************************************************************

StopTD:
	lea	DiskIO(pc),a1
	move.w	#9,Command(a1)
	clr.l	Length(a1)
	bsr.s	GoTD
	move.l	ExecBase.w,a6
	lea	DiskIO(pc),a1
	jsr	CloseDevice(a6)
	lea	DiskRep(pc),a1
	jsr	RemPort(a6)
	rts

********************************************************************

	;a0.l - spakowane dane
	;a1.l - miejsce rozpakowania
	;d0.l - dlugosc spakowanych danych

DeCrunch:
		move.l	a1,a3
		lea	4(a0),a5
		add.l	d0,a0
PP_Decrunch:	moveq	#3,d6
		moveq	#7,d7
		moveq	#1,d5
		move.l	a3,a2
		move.l	-(a0),d1
		tst.b	d1
		beq.s	NoEmptyBits
ReadBit00:	lsr.l	#1,d5
		bne.s	ReadBitEnd00
GetNextLong00:	move.l	-(a0),d5
		roxr.l	#1,d5
ReadBitEnd00:	subq.b	#1,d1
		lsr.l	d1,d5
NoEmptyBits:	lsr.l	#8,d1
		add.l	d1,a3
LoopCheckCrnch:	lsr.l	#1,d5
		bne.s	ReadBitEnd01
GetNextLong01:	move.l	-(a0),d5
		roxr.l	#1,d5
ReadBitEnd01:	bcs.s	CrunchedBytes
NormalBytes:	moveq	#0,d2
Read2BitsRow:	moveq	#1,d0
ReadD1_00:	moveq	#0,d1
ReadBits_00:	lsr.l	#1,d5
		bne.s	RotX_00
GetNext_00:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_00:	addx.l	d1,d1
		dbf	d0,ReadBits_00
		add.w	d1,d2
		cmp.w	d6,d1
		beq.s	Read2BitsRow
ReadNormalByte:	moveq	#7,d0
ReadD1_01:	moveq	#0,d1
ReadBits_01:	lsr.l	#1,d5
		bne.s	RotX_01
GetNext_01:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_01:	addx.l	d1,d1
		dbf	d0,ReadBits_01
		move.b	d1,-(a3)
		dbf	d2,ReadNormalByte
		cmp.l	a3,a2
		bcs.s	CrunchedBytes
		rts
CrunchedBytes:	moveq	#1,d0
ReadD1_03:	moveq	#0,d1
ReadBits_03:	lsr.l	#1,d5
		bne.s	RotX_03
GetNext_03:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_03:	addx.l	d1,d1
		dbf	d0,ReadBits_03
		moveq	#0,d0
		move.b	0(a5,d1.w),d0
		move.w	d1,d2
		cmp.w	d6,d2
		bne.s	ReadOffset
ReadBit02:	lsr.l	#1,d5
		bne.s	ReadBitEnd02
GetNextLong02:	move.l	-(a0),d5
		roxr.l	#1,d5
ReadBitEnd02:	bcs.s	LongBlockOffs
		moveq	#7,d0
LongBlockOffs:	subq.w	#1,d0
ReadD1_05:	moveq	#0,d1
ReadBits_05:	lsr.l	#1,d5
		bne.s	RotX_05
GetNext_05:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_05:	addx.l	d1,d1
		dbf	d0,ReadBits_05
		move.w	d1,d3
Read3BitsRow:	moveq	#2,d0
ReadD1_04:	moveq	#0,d1
ReadBits_04:	lsr.l	#1,d5
		bne.s	RotX_04
GetNext_04:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_04:	addx.l	d1,d1
		dbf	d0,ReadBits_04
		add.w	d1,d2
		cmp.w	d7,d1
		beq.s	Read3BitsRow
		bra.s	DecrunchBlock
ReadOffset:	subq.w	#1,d0
ReadD1_06:	moveq	#0,d1
ReadBits_06:	lsr.l	#1,d5
		bne.s	RotX_06
GetNext_06:	move.l	-(a0),d5
		roxr.l	#1,d5
RotX_06:	addx.l	d1,d1
		dbf	d0,ReadBits_06
		move.w	d1,d3
DecrunchBlock:	lea	1(a3,d3.w),a1
		addq.w	#1,d2
DecrunchBlockL:	move.b	-(a1),-(a3)
		move.b	(a1),$dff180
		dbf	d2,DecrunchBlockL
EndOfLoop:	cmp.l	a3,a2
		bcs.w	LoopCheckCrnch
		rts

********************************************************************

D0ToAscii:
	lea	DecTab(pc),a0
	lea	DecBuf(pc),a1
	moveq	#9,d1
To1:	move.b	#'0',(a1)
To3:	cmp.l	(a0),d0
	bcs.s	To2
	add.b	#1,(a1)
	sub.l	(a0),d0
	bra.s	To3
To2:
	lea	4(a0),a0
	lea	1(a1),a1
	dbf	d1,To1
	clr.b	(a1)
	rts

********************************************************************

TDOffset:	dc.l	0
Blok:		dc.l	0
Track:		dc.l	0

DosBase:	dc.l	0
PPBase:		dc.l	0
OHandle:	dc.l	0
FHandle:	dc.l	0
BufPtr:		dc.l	0
BufLen:		dc.l	0
TDBuf:		dc.l	0
Long:		dc.l	0
CrInfo:		dc.l	0
CrSize:		dc.l	0
M1Seek:		dc.l	0
M2Seek:		dc.l	0

DosName:	dc.b	'dos.library',0
	EVEN
TrackName:	dc.b	'trackdisk.device',0
	EVEN
PPName:		dc.b	'powerpacker.library',0
	EVEN
DecTab:
	dc.l	1000000000
	dc.l	100000000
	dc.l	10000000
	dc.l	1000000
	dc.l	100000
	dc.l	10000
	dc.l	1000
	dc.l	100
	dc.l	10
	dc.l	1

DiskIO:		blk.l	20,0
DiskRep:	blk.l	8,0
Params:		blk.b	256

DecBuf:		blk.b	12,0

Txt00:		dc.b	10,10,0
Txt0:		dc.b	10,9,'    MiniDiskPacker V1.0',10
		dc.b	9,'napisal: Slawomir Juralowicz',10,10,0
Txt1:		dc.b	'  MDP R FileName - rozpakowanie dysku.',10
		dc.b	'  MDP W FileName - spakowanie dysku.',10,10,0
Txt2:		dc.b	'  Nie moge otworzyc pliku: ',0
Txt3:		dc.b	'  Blad odczytu pliku.',10,10,0
Txt4:		dc.b	'  Blad zapisu pliku.',10,10,0
Txt5:		dc.b	'  Blad odczytu sektora.',10,10,0
Txt6:		dc.b	'  Blad zapisu sektora.',10,10,0
Txt7:		dc.b	'  Blad - brak pamieci.',10,10,0
Txt8:		dc.b	'  Dlugosc pliku: ',0
		EVEN
