Start:
	sf	d7
	bra.s	Start2
	dc.l	Start2
Start2:
	move.b	d7,SysStat
	bne.s	Begin
	bsr.L	StartSystem
	lea	Begin,a6
	move.l	a6,$80
	trap	#0
	bsr.L	StopSystem
Quit:	rts
Begin:	move.l	a7,MemStack
	lea	Stack+STACKSIZE,a7
	lea	CUSTOM,a6
	bsr.s	Program
Halt:	move.l	MemStack,a7
	tst.b	SysStat
	bne.s	Quit
	rte

;*******************************************************************

Program:
	bsr.s	SetVBL
	bsr.s	StartVBL
	bsr.L	LMK
	rts

;*******************************************************************

WaitVBL:
	sf	ByloVBL
WVBL:	tst.b	ByloVBL
	beq.s	WVBL
	rts

;*******************************************************************

ProcVBL:
	rts

;*******************************************************************

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	QuitV
	tst.b	WykonujVBL
	beq.s	QuitV
	eor.b	#$ff,SkipVBL
	bne.s	QuitV
	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.L	ProcVBL
	st	ByloVBL
	movem.l	(sp)+,d0-d7/a0-a6
QuitV:	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

StartVBL:
	sf	ByloVBL
	sf	SkipVBL
	st	WykonujVBL
	rts

;*******************************************************************

StopVBL:
	sf	WykonujVBL
	rts

;*******************************************************************

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;*******************************************************************

LMK:
	btst	#6,$bfe001
	bne.s	LMK
	rts

;*******************************************************************

WaitBlt:
	btst	#6,$dff002
WaBl1:	btst	#6,$dff002
	bne.s	WaBl1
	rts

;*******************************************************************

StartSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	GfxLibName,a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxLibBase
	exg	d0,a6
	jsr	OwnBlitter(a6)
	bsr.s	WaitBlt
	move.l	ExecBase,a6
	jsr	Forbid(a6)
	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	lea	Reset,a2
	moveq	#63,d0
StSy1:	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,StSy1
	bsr.s	InstEI
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

StopSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	moveq	#63,d0
StSs1:	move.l	(a0)+,(a1)+
	dbf	d0,StSs1
	move.l	GfxLibBase,a6
	move.l	$26(a6),$dff080
	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a
	move.l	ExecBase,a6
	jsr	Permit(a6)
	move.l	GfxLibBase,a6
	jsr	DisownBlitter(a6)
	exg	a6,a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

InstEI:
	lea	EmptyInt,a0
	move.l	a0,$64
	move.l	a0,$68
	move.l	a0,$6c
	move.l	a0,$70
	move.l	a0,$74
	move.l	a0,$78
	move.l	a0,$7c
	rts

;*******************************************************************

EmptyInt:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	ResetP,a0
	move.l	a0,$80
	trap	#0
ResetP:	clr.l	ExecBase
	lea	2,a0
	reset
	jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

STACKSIZE	=	1024
ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462
Forbid		=	-132
Permit		=	-138
CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
TBLO		=	$bfd600
TBHI		=	$bfd700
CRB		=	$bfdf00
ICR		=	$bfdd00
SPR0POS		=	$140
SPR0CTL		=	$142
SPR0DATA	=	$144
SPR0DATB	=	$146
SPR1POS		=	$148
SPR1CTL		=	$14a
SPR1DATA	=	$14c
SPR1DATB	=	$14e
SPR2POS		=	$150
SPR2CTL		=	$152
SPR2DATA	=	$154
SPR2DATB	=	$156
SPR3POS		=	$158
SPR3CTL		=	$15a
SPR3DATA	=	$15c
SPR3DATB	=	$15e
SPR4POS		=	$160
SPR4CTL		=	$162
SPR4DATA	=	$164
SPR4DATB	=	$166
SPR5POS		=	$168
SPR5CTL		=	$16a
SPR5DATA	=	$16c
SPR5DATB	=	$16e
SPR6POS		=	$170
SPR6CTL		=	$172
SPR6DATA	=	$174
SPR6DATB	=	$176
SPR7POS		=	$178
SPR7CTL		=	$17a
SPR7DATA	=	$17c
SPR7DATB	=	$17e

	;dc.w	SPR0CTL,0,SPR1CTL,0,SPR2CTL,0,SPR3CTL,0
	;dc.w	SPR4CTL,0,SPR5CTL,0,SPR6CTL,0,SPR7CTL,0

;*******************************************************************
;			FAST DATA
;*******************************************************************

	;--- System. ---

GfxLibName:	dc.b	'graphics.library',0
	EVEN

;*******************************************************************
;			POINTERS
;*******************************************************************

;*******************************************************************
;			FAST WORK
;*******************************************************************

	;--- System. ---

GfxLibBase:	dc.l	0
MemStack:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemVectors:	blk.l	64
Stack:		blk.b	STACKSIZE
	EVEN

ByloVBL:	dc.b	0
WykonujVBL:	dc.b	0
SysStat:	dc.b	0
SkipVBL:	dc.b	0
	EVEN

;*******************************************************************
;			CHIP DATA
;*******************************************************************

;*******************************************************************
;			CHIP WORK
;*******************************************************************

Stop:
