-- LUA module version
LUANQversion = "0.5 MySQL"
databaseversion = "1"
databasecheck = 0

-- NOTE
-- When you call con:execute to query a SQL statment, if it feedbacks informations ( i.e. a SELECT )
-- alweys remember to call cur:close() when you have done using those informations
-- i.e.
--	 cur = con:execute( BLA BLA BLA )
--      row = cur:fetch ({}, "a")
--	 while row do
--		COMMANDS
--	 	row = cur:fetch (row, "a")
--	 end
--      cur:close()
-- If the SQL statment doesn't feedback informations ( i.e. an INSERT ), then you don't need to colse the res
-- i.e.
-- 	 res = con:execute( BLA BLA BLA )

-- Database managment system to use
dbname = "noquarter"
dbuser = "etserver"
dbpassword = "3ha9IL5z"

-- The next vars are used only with MySQL and PostgreSQL extensions
dbhostname = "localhost"
dbport = "3306"

require "luasql.mysql"
env = assert (luasql.mysql())
con = assert (env:connect (dbname, dbuser, dbpassword, dbhostname, dbport))
cur = {}
res = {}
row = {}

-- The table "slot" will store a table "client" for each slot on the server
slot = {}

-- The table "client" is created each time someone connect and will store the current client informations
-- The current fields are:
-- client["id"] = stores the player id from the database


-- We are connected to the database	

function et_InitGame( levelTime, randomSeed, restart )

	et.RegisterModname( "LUANQ version " .. LUANQversion .. " " .. et.FindSelf() )

	-- Check the database version
	cur = assert (con:execute("SELECT version FROM version ORDER BY version DESC LIMIT 1"))
	row = cur:fetch ({}, "a")
	
	if row.version == databaseversion then
		databasecheck = 1
		et.G_LogPrint("^1Database "..dbname.." is up to date\n")
	else
		et.G_LogPrint("^1Database "..dbname.." is not up to date: SQL support disabled!\n")
		-- We don't need to keep the connection with the database open
		con:close()
		env:close()
	end

	cur:close()
end

function et_ShutdownGame( restart ) 
	con:close()
	env:close()
end

-- Table player
--id INT NOT NULL AUTO_INCREMENT
--pkey VARCHAR(32) NOT NULL
--regname VARCHAR(36)
--netname VARCHAR(36)
--isBot BOOLEAN
--clan VARCHAR(20)
--level INT
--password VARCHAR(20)
--banreason VARCHAR(1024)
--bannedby VARCHAR(36)
--banexpire DATETIME
--mutedreason VARCHAR(1024)
--mutedby VARCHAR(36)
--muteexpire DATETIME
--warnings SMALLINT
--suspect TINYINT
--regdate DATETIME
--updatedate DATETIME
--createdate DATETIME

-- Table session
-- id INT NOT NULL AUTO_INCREMENT
-- pkey INT NOT NULL
-- slot SMALLINT DEFAULT NULL
-- map VARCHAR(36) DEFAULT NULL
-- ip VARCHAR(25) DEFAULT NULL
-- valid BOOLEAN DEFAULT NULL
-- start DATETIME DEFAULT NULL
-- end DATETIME DEFAULT NULL
-- sstime DATETIME DEFAULT NULL
-- axtime DATETIME DEFAULT NULL
-- altime DATETIME DEFAULT NULL
-- sptime DATETIME DEFAULT NULL


function et_ClientConnect( clientNum, firstTime, isBot )
	
	if databasecheck == 1 then
		client = {}
		-- Get the start connection time
		cur = assert (con:execute("SELECT NOW()"))
		row = cur:fetch ()
		cur:close()
		if row then
			client["sstart"] = row
		else
			-- This is something that should never happens : need some other handling
			client["sstart"] = nil
		end

		--Get player GUId
		local guid = string.upper( et.Info_ValueForKey( et.trap_GetUserinfo( clientNum ), "cl_guid" ))
		
		if firstTime == 1 then
			--It's the first time the players connects ( = it's not a reconnection )
			--Search the GUId in the database ( GUId is UNIQUE, so we just have 1 result, stop searching when we have it )
			cur = assert (con:execute("SELECT id, netname, banreason, bannedby, banexpire, mutedreason, mutedby, muteexpire FROM player WHERE pkey='"..guid.."' LIMIT 1"))
			row = cur:fetch ({}, "a")
			cur:close()
			if row then
				-- This player is already present in the database
				-- Check if he is banned
				if row.bannedby then
					if row.banreason then
						if row.banexpire then
							return "You was banned by "..row.bannedby.." until "..row.banexpire..". Reason: "..row.banreason
						else
							return "You was permanently banned by "..row.bannedby..". Reason: "..row.banreason
						end
					else
						if row.banexpire then
							return "You was banned by "..row.bannedby.." until "..row.banexpire
						else
							return "You was permanently banned by "..row.bannedby
						end
					end
				end

				-- Start to collect session information for this player id
				client["id"] = row.id
				client["netname"] = row.netname
				client["team"] = nil
				client["axtime"] = 0
				client["altime"] = 0
				client["sptime"] = 0
				client["lctime"] = 0

				slot[clientNum] = client
				
				return nil
			else
				-- This player is a new one: get some infos and create a new database entry
				res = assert (con:execute("INSERT INTO player (pkey, isBot, level, warnings, suspect, regdate, updatedate, createdate) VALUES ('"..guid.."', '"..isBot.."', '0', '0', '0', NOW(), NOW(), NOW())"))
				
				cur = assert (con:execute("SELECT id, netname FROM player WHERE pkey='"..guid.."' LIMIT 1"))
				row = cur:fetch ({}, "a")
				cur:close()
				if row then
					client["id"] = row.id
					client["netname"] = row.netname
					client["team"] = nil
					client["axtime"] = 0
					client["altime"] = 0
					client["sptime"] = 0
					client["lctime"] = 0

					slot[clientNum] = client

					return nil
				end
			end
		end
		
		-- Get the player id from the "player" table and  start to collect session information for this player id
		cur = assert (con:execute("SELECT id, netname FROM player WHERE pkey='"..guid.."' LIMIT 1"))
		row = cur:fetch ({}, "a")
		cur:close()
		if row then
			client["id"] = row.id
			client["netname"] = row.netname
			client["team"] = nil
			client["axtime"] = 0
			client["altime"] = 0
			client["sptime"] = 0
			client["lctime"] = 0

			slot[clientNum] = client

			return nil
		end
	end

       return nil
end

-- This function is called:
--	- after the connection is over, so when you first join the game world
--	- when you change team
--	- when you are spectator and switch from "free look mode" to "follow player mode"
function et_ClientBegin( clientNum )

	if databasecheck == 1 then
		
		local currentteam = et.gentity_get(clientNum,"sess.sessionTeam")

		if slot[clientNum].netname == nil then
			-- Get the player name
			slot[clientNum].netname = et.gentity_get( clientNum ,"pers.netname")
			res = assert (con:execute("UPDATE player SET netname='"..slot[clientNum].netname.."' WHERE id='"..slot[clientNum].id.."'"))
		end

		-- This is the first clientbegin after the connection time
		if slot[clientNum].team == nil then

			cur = assert (con:execute("SELECT NOW()"))
			row = cur:fetch ()
			cur:close()
			if row then
				slot[clientNum].lctime = row
			end			

			slot[clientNum].team = currentteam
			return

			--et.trap_SendConsoleCommand( et.EXEC_APPEND, "qsay ^1Welcome "..slot[clientNum].netname.."! Your id is "..slot[clientNum].id.." and your session started "..slot[clientNum].sstart.."\n" )
		end
		
		-- Check if the player changed the team
		if currentteam ~= slot[clientNum].team then
			if slot[clientNum].team == 1 then
				cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].axtime.."')"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].axtime = row
				end
				
				cur = assert (con:execute("SELECT NOW()"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].lctime = row
				end	
				
				slot[clientNum].team = currentteam
			elseif slot[clientNum].team == 2 then
				cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].altime.."')"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].altime = row
				end
				
				cur = assert (con:execute("SELECT NOW()"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].lctime = row
				end	
				
				slot[clientNum].team = currentteam
			else
				cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].sptime.."')"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].sptime = row
				end
				
				cur = assert (con:execute("SELECT NOW()"))
				row = cur:fetch ()
				cur:close()
				if row then
					slot[clientNum].lctime = row
				end	
				
				slot[clientNum].team = currentteam
			end
		end
	end
end

function et_ClientDisconnect( clientNum )

	if databasecheck == 1 then
		local ip = et.Info_ValueForKey( et.trap_GetUserinfo( clientNum ), "ip" )
		if ip == "localhost" then
			-- He is a bot, mark his ip as "localhost"
			ip = "127.0.0.1"
		else
			s,e,ip = string.find(ip,"(%d+%.%d+%.%d+%.%d+)")
		end

		local map = tostring(et.trap_Cvar_Get("mapname"))

		if slot[clientNum].team == 1 then
			cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].axtime.."')"))
			row = cur:fetch ()
			cur:close()
			if row then
				slot[clientNum].axtime = row
			end	
		elseif slot[clientNum].team == 2 then
			cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].altime.."')"))
			row = cur:fetch ()
			cur:close()
			if row then
				slot[clientNum].altime = row
			end
		else
			cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[clientNum].lctime.."'), '"..slot[clientNum].sptime.."')"))
			row = cur:fetch ()
			cur:close()
			if row then
				slot[clientNum].sptime = row
			end		
		end

		-- Write to session
		if slot[clientNum].team == nil then
			-- In this case the player never entred the game world, he disconnected during connection time
			res = assert (con:execute("INSERT INTO session (pkey, slot, map, ip, valid, start, end, sstime) VALUES ('"..slot[clientNum].id.."', '"..clientNum.."', '"..map.."', '"..ip.."', '0', '"..slot[clientNum].sstart.."', NOW(), TIMEDIFF( NOW(), '"..slot[clientNum].sstart.."' ))"))
		else
			res = assert (con:execute("INSERT INTO session (pkey, slot, map, ip, valid, start, end, sstime, axtime, altime, sptime) VALUES ('"..slot[clientNum].id.."', '"..clientNum.."', '"..map.."', '"..ip.."', '1', '"..slot[clientNum].sstart.."', NOW(), TIMEDIFF( NOW(), '"..slot[clientNum].sstart.."' ), '"..slot[clientNum].axtime.."', '"..slot[clientNum].altime.."', '"..slot[clientNum].sptime.."')"))
		end

		slot[clientNum] = nil
	end
end

function et_ShutdownGame( restart )

	if databasecheck == 1 then
		-- This is when the map end: we have to close all opened sessions
		-- Cycle between all possible clients
		for i=0, tonumber(et.trap_Cvar_Get("sv_maxclients"))-1, 1 do
			if slot[i] ~= nil then
				local ip = et.Info_ValueForKey( et.trap_GetUserinfo( i ), "ip" )
				if ip == "localhost" then
					-- He is a bot, mark his ip as "localhost"
					ip = "127.0.0.1"
				else
					s,e,ip = string.find(ip,"(%d+%.%d+%.%d+%.%d+)")
				end

				local map = tostring(et.trap_Cvar_Get("mapname"))

				if slot[i].team == 1 then
					cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[i].lctime.."'), '"..slot[i].axtime.."')"))
					row = cur:fetch ()
					cur:close()
					if row then
						slot[i].axtime = row
					end	
				elseif slot[i].team == 2 then
					cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[i].lctime.."'), '"..slot[i].altime.."')"))
					row = cur:fetch ()
					cur:close()
					if row then
						slot[i].altime = row
					end
				else
					cur = assert (con:execute("SELECT ADDTIME( TIMEDIFF(NOW(), '"..slot[i].lctime.."'), '"..slot[i].sptime.."')"))
					row = cur:fetch ()
					cur:close()
					if row then
						slot[i].sptime = row
					end		
				end

				-- Write to session
				if slot[i].team == nil then
					-- In this case the player never entred the game world, he disconnected during connection time
					-- This should never happens, but who knows... it cost nothing :)
					res = assert (con:execute("INSERT INTO session (pkey, slot, map, ip, valid, start, end, sstime) VALUES ('"..slot[i].id.."', '"..i.."', '"..map.."', '"..ip.."', '0', '"..slot[i].sstart.."', NOW(), TIMEDIFF( NOW(), '"..slot[i].sstart.."' ))"))
				else
					res = assert (con:execute("INSERT INTO session (pkey, slot, map, ip, valid, start, end, sstime, axtime, altime, sptime) VALUES ('"..slot[i].id.."', '"..i.."', '"..map.."', '"..ip.."', '1', '"..slot[i].sstart.."', NOW(), TIMEDIFF( NOW(), '"..slot[i].sstart.."' ), '"..slot[i].axtime.."', '"..slot[i].altime.."', '"..slot[i].sptime.."')"))
				end

				slot[i] = nil
			end
		end
	end
end