-- NOQ-lua - NO Quarter game manager (p) No Quarter Mod Team 2009
-------------------------------------------------------------------------------
-- TASKS/TODO:
-- create database
-- player tracking
-- custom commands
-- dynamic team balance control

-------------------------------------------------------------------------------
-- setup vars
-------------------------------------------------------------------------------
dbname = "noquarter.dat"
dbtype = "sqlite3"

color = "^5" 
-------------------------------------------------------------------------------
-- load driver
require "luasql.sqlite3" -- make this dynamic for given dbtype

-------------------------------------------------------------------------------
-- script vars
-------------------------------------------------------------------------------
noqVersion = 1 -- users of script never touch this
debug = 1 -- debug 0/1
debugRunFrame = 0

-- db variables
env = NULL
con = NULL

openDB()

-------------------------------------------------------------------------------
-- Lua functions
-------------------------------------------------------------------------------

function et_InitGame( levelTime, randomSeed, restart )
	-- debug et_InitGame
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "InitGame - levelTime: " .. levelTime .. " randomSeed: " .. randomSeed .. " restart: " .. restart )
	end
	et.RegisterModname( "NOQ.lua " .. et.FindSelf() )
end


function et_ShutdownGame(restart )
	-- debug et_InitGame
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ShutdownGame - restart: " .. restart )
	end
	-- if !restart ... need to check
	closeDB()
end


function et_RunFrame( levelTime )
	-- debug et_InitGame
	if debugRunFrame == 1 then
		if math.mod( levelTime, 1000 ) == 0 then
 			et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "RunFrame - levelTime: " .. levelTime )       
 		end
	end
end


function et_ClientCommand( clientNum, command )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ClientCommand - clientNum: " .. clientNum .. " command: " .. command )
	end
end


function et_ClientUserinfoChanged( clientNum)
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ClientUserinfoChanged - clientNum: " .. clientNum )
	end
end


function et_ClientConnect( clientNum, firstTime, isBot, reason)
	-- debug et_ClientConnect
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ClientConnect - firstTime: " .. firstTime .. " bot: " .. isBot )
	end
	-- split for real
	if firstTime == 1 then
	  FirstConnect(clientNum, firstTime, isBot, reason)
	end
	-- every connect (also first time - map restarts)
	CommonConnect(clientNum )

end


function et_ClientBegin( clientNum )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ClientBegin - clientNum: " .. clientNum )
	end
end


function et_ClientSpawn(clientNum, revived, teamChange, restoreHealth)
	if debug == 1 then
	  et.trap_SendServerCommand( -1 , "cpm \"" .. color .. "ClientSpawn client: " .. clientNum .. " revived: " .. revived .. " teamChange: " .. teamChange .. " restoreHealth: " .. restoreHealth)
	end
end


function et_ClientDisconnect( clientNum )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ClientDisconnect - clientNum: " .. clientNum )
	end
end


function et_ConsoleCommand( command )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "ConsoleCommand - command: " .. command )
	end
end


-- Different to ETPub!
function et_Obituary( victim, killer, meansOfDeath )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "Obituary - victim: " .. victim .. " killer: " .. killer .. " meansOfDeath: " .. meansOfDeath )
	end
	
end


function et_UpgradeSkill(clientNum, skill )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "UpgradeSkill - clientNum: " .. clientNum .. "skill: " .. skill )
	end
end


function et_Print( text )
	if debugPrint == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "Print - text: " .. text)
	end
end


function et_SetPlayerSkill(clientNum, skill )
	if debug == 1 then
	  et.trap_SendServerCommand( -1 ,"cpm \"" .. color .. "SetPlayerSkill - clientNum: " .. clientNum .. " skill: " .. skill )
	end
end

-------------------------------------------------------------------------------
-- database functions
-------------------------------------------------------------------------------

function openDB()
  env = assert (luasql.sqlite3())
  con = assert (env:connect(dbname))
end


function createDB()

  -- version (... for updates later on db)
  -- this table contains only one row with current NOQ version
  res = assert (con:execute[[
    CREATE TABLE IF NOT EXISTS version (
      version INTEGER,
  )
  ]])

  -- player
  res = assert (con:execute[[
    CREATE TABLE IF NOT EXISTS player (
      id  INTEGER PRIMARY KEY,
      name varchar(32)
  )
  ]])
  
  -- session
  res = assert (con:execute[[
    CREATE TABLE IF NOT EXISTS session (
      id  INTEGER PRIMARY KEY,
      playerid INTEGER
  )
  ]])  
  et.G_Printf("Database created.")
end -- createDB()


function closeDB()
  con:close()
  env:close()
end

-- player
function inserPlayer(_guid, _name,)
	list = {
	  { name="Jose das Couves", 
	    email="jose@couves.com", },

	}
	for i, p in pairs (list) do
	  res = assert (con:execute(string.format([[
	    INSERT INTO people
	    VALUES ('%s', '%s')]], p.name, p.email)
	  ))
  end
end	

function updatePlayer(_key)
end

function readPlayer()
  -- retrieve a cursor
  cur = assert (con:execute"SELECT name, email from people")
  -- print all rows
  row = cur:fetch ({}, "a")	-- the rows will be indexed by field names
  while row do
    et.G_Printf("Name: %s, E-mail: %s\n", row.name, row.email)
    row = cur:fetch (row, "a")	-- reusing the table of results
  end
  cur:close()
end

-- session
function writeSession()
end


-------------------------------------------------------------------------------
-- custom commands functions

-- tbd ...

-------------------------------------------------------------------------------
-- helper functions

et.G_Printf = function(...)
		et.G_Print(string.format(unpack(arg)))
end

-- split et_ClientConnect for real
function FirstConnect(clientNum, firstTime, isBot, reason)
  -- TODO
  -- Scan player table for given key (GUID)
  -- if not in table create entry
end

-- split et_ClientConnect for real
function CommonConnect( clientNum )

	local GUID = et.Info_ValueForKey( et.trap_GetUserinfo( clientNum ), "cl_guid" )
	if GUID then
	-- TODO
		-- slottable[clientNum] = GUID
  	else
		et.G_Print("Player failed " .. clientNum .. "\n" )
	end
end
