
#ifdef CDA

#include "../client/header/client.h"
#include "twfsound_cd.h"

static qboolean cdValid = false;
static qboolean cdPlaying = false;
static qboolean cdWasPlaying = false;
static qboolean cdInitialized = false;
static qboolean cdEnabled = false;
static byte cdPlayTrack;
static byte cdMaxTrack;
static int cdEmulatedStart;
static int cdEmulatedLength;

struct TWFCDData *twfdata=0;

cvar_t *cd_nocd;

static void CD_f();

int CDAudio_GetAudioDiskInfo()
{

	int err;
	cdValid = false;

	err = TWFCD_ReadTOC(twfdata);
	if (err == TWFCD_FAIL)
	{
		Com_Printf("CD Audio: Drive not ready\n");
		return 0;
	}

	cdMaxTrack = (twfdata->TWFCD_Table).cda_LastTrack;
	if ((twfdata->TWFCD_Table.cda_FirstAudio) == TWFCD_NOAUDIO)
	{
		Com_Printf("CD Audio: No music tracks\n");
		return 0;
	}
	
	cdValid = true;
	return 1;
}

void CDAudio_Play(int track, qboolean looping)
{
	int err;
	struct TagItem tags[]=
	{
		{TWFCD_Track_Start, 0},
		{TWFCD_Track_End, 0},
		{TWFCD_Track_Count, 0},
		{TWFCD_Track_PlayMode, SCSI_CMD_PLAYAUDIO12},
		{0, 0}
	};

	if (!cdEnabled)
		return;

	if ((track < 1) || (track > cdMaxTrack))
	{
		CDAudio_Stop();
		return;
	}

	if (!cdValid)
	{
		CDAudio_GetAudioDiskInfo();
		if (!cdValid)
		{
			return;
		}
	}

	if (!((twfdata->TWFCD_Table.cda_TrackData[track]).cdt_Audio))
	{
		Com_Printf("CDAudio_Play: Track %i is not audio\n", track);
		return;
	}

	if (cdPlaying)
	{
		if (cdPlayTrack == track)
		{
			return;
		}
		CDAudio_Stop();
	}

	tags[0].ti_Data=track;
	tags[1].ti_Data=track;
	tags[2].ti_Data=1;
	tags[3].ti_Data=SCSI_CMD_PLAYAUDIO12;
	err = TWFCD_PlayTracks(twfdata, tags);
	
	if (err != TWFCD_OK)
	{
		tags[3].ti_Data = SCSI_CMD_PLAYAUDIO_TRACKINDEX;
		err = TWFCD_PlayTracks(twfdata, tags);
		
		if (err != TWFCD_OK)
		{
			tags[3].ti_Data=SCSI_CMD_PLAYAUDIO10;
			err = TWFCD_PlayTracks(twfdata, tags);
		}
	}

	if (err != TWFCD_OK)
	{
		Com_Printf("CDAudio_Play: CD PLAY failed\n");
		return;
	}
	
	cdEmulatedLength = (((twfdata->TWFCD_Table.cda_TrackData[track]).cdt_Length)/75)*1000;
	cdEmulatedStart = Sys_Milliseconds();

	cdPlayTrack = track;
	cdPlaying = true;
}

void CDAudio_RandomPlay(void)
{
	// not implemented
}

void CDAudio_Eject(void)
{
	// not implemented
}

void CDAudio_Stop(void)
{
	if (!cdEnabled)
	{
		return;
	}

	if (!cdPlaying)
	{
		return;
	}

	TWFCD_MotorControl(twfdata, TWFCD_MOTOR_STOP);
	
	cdWasPlaying = false;
	cdPlaying = false;
}


void CDAudio_Resume(void)
{
	int err;
	
	if (!cdEnabled)
	{
		return;
	}
		
	if (!cdWasPlaying)
	{
		return;
	}
	
	if (!cdValid)
	{
		return;
	}
	
	err = TWFCD_PausePlay(twfdata);
	cdPlaying = true;

	if (err == TWFCD_FAIL)
	{
		cdPlaying = false;
	}
}

void CDAudio_Pause(void)
{
	int err;

	if (!cdEnabled)
	{
		return;
	}

	if (!cdPlaying)
	{
		return;
	}

	err = TWFCD_PausePlay(twfdata);

	cdWasPlaying = cdPlaying;
	cdPlaying = false;
}


void CDAudio_Update(void)
{
	if (cd_nocd && cd_nocd->modified)
	{
		cd_nocd->modified = 0;

		if (cd_nocd->value)
		{
			CDAudio_Pause();
		}
		else
		{
			CDAudio_Resume();
		}
	}
	
	if (Sys_Milliseconds() > (cdEmulatedStart + cdEmulatedLength))
	{
		cdPlaying = false;
		CDAudio_Play(cdPlayTrack, true);
	}
}

#ifdef __AROS__
#include <dos/bptr.h>
#else
#include <dos/filehandler.h>
#endif

LONG CopyStringBSTRToC (BSTR src, STRPTR dst, ULONG dst_size)
{
#ifdef __AROS__
    STRPTR ptr = AROS_BSTR_ADDR(src);
    ULONG ln = AROS_BSTR_strlen(src);
#else
    UBYTE *ptr = BADDR(src);
    ULONG ln = *ptr++;
#endif
    if (ln > (dst_size - 1))
	{
		ln = dst_size - 1;
	}
	
    memcpy(dst, ptr, ln);
    dst[ln] = 0;
    return ln;
}

int CDAudio_HardwareInit()
{
	char devicename[255];
	char dosname[255];
	struct DosList *dlist;

	dlist = LockDosList(LDF_DEVICES | LDF_READ);
	
	while ((dlist = NextDosEntry(dlist, LDF_DEVICES|LDF_READ)) && !cdValid)
	{
		struct FileSysStartupMsg *startup;
		
		startup = BADDR(dlist->dol_misc.dol_handler.dol_Startup);
		
		if ((ULONG) startup > 0x400 &&
		    (startup->fssm_Unit & 0xff000000) == 0 &&
		     startup->fssm_Device && startup->fssm_Environ)
		{		
			if (CopyStringBSTRToC(startup->fssm_Device, devicename, sizeof(devicename)))
			{
				if (CopyStringBSTRToC(dlist->dol_Name, dosname, sizeof(dosname)))
				{
					//Com_Printf("dosname %s devicename %s unit %d\n", dosname, devicename, unit);
					twfdata = TWFCD_Setup(devicename, startup->fssm_Unit);
					CDAudio_GetAudioDiskInfo();
				}
			}
		}
	}	
	
	UnLockDosList(LDF_DEVICES | LDF_READ);
	
	return cdValid;
}

int CDAudio_Init(void)
{
	cvar_t *cv;
	
	if (cdInitialized)
	{
		return 0;
	}

	cv = Cvar_Get("nocdaudio", "0", CVAR_NOSET);

	if (cv->value)
	{
		return -1;
	}		
		
	cd_nocd = Cvar_Get("cd_nocd", "0", CVAR_ARCHIVE);
	
	if (!CDAudio_HardwareInit())
	{
		Com_Printf("CDAudio_Init: Unable to open default CD-ROM drive.\n");
		return -1;
	}

	cdEnabled = true;
	
	CDAudio_GetAudioDiskInfo();
	
	Cmd_AddCommand("cd", CD_f);
	Com_Printf("CD Audio Initialized.\n");	
	
	return(0);
}

void CDAudio_Shutdown(void)
{
	if (!cdInitialized)
	{
		return;
	}
	
	CDAudio_Stop();
	TWFCD_Shutdown(twfdata);
	Cmd_RemoveCommand("cd");
	
	cdInitialized = false;
}

static void
CD_f()
{
	char *command;

	if (!cdInitialized)
	{
		return;
	}	
	
	if (Cmd_Argc() < 2)
	{
		return;
	}

	command = Cmd_Argv(1);

	if (!Q_strcasecmp(command, "on"))
	{
		cdEnabled = true;
		return;		
	}

	if (!Q_strcasecmp(command, "off"))
	{
		CDAudio_Stop();

		cdEnabled = false;
		return;
	}

	if (!Q_strcasecmp(command, "play"))
	{
		CDAudio_Play((byte)(int)strtol(Cmd_Argv(2), (char **)NULL, 10), false);
		return;
	}

	if (!Q_strcasecmp(command, "loop"))
	{
		CDAudio_Play((byte)(int)strtol(Cmd_Argv(2), (char **)NULL, 10), true);
		return;
	}

	if (!Q_strcasecmp(command, "stop"))
	{
		CDAudio_Stop();
		return;
	}

	if (!Q_strcasecmp(command, "pause"))
	{
		CDAudio_Pause();
		return;
	}

	if (!Q_strcasecmp(command, "resume"))
	{
		CDAudio_Resume();
		return;
	}

	if (!Q_strcasecmp(command, "eject"))
	{
		CDAudio_Eject();
		return;
	}

	if (!Q_strcasecmp(command, "info"))
	{
		if (!cdValid)
		{
			return;
		}

		Com_Printf("%d tracks\n", cdMaxTrack);

		if (cdPlaying)
		{
			Com_Printf("Currently %s track %d\n",
					0 ? "looping" : "playing",
					cdPlayTrack);
		}
		else
		if (cdWasPlaying)
		{
			Com_Printf("Paused %s track %d\n",
					0 ? "looping" : "playing",
					cdPlayTrack);
		}
		
		// implement this looping...

		return;
	}
}

#endif
