/*
** File:	snd_amiga.c
** Date:	25-Dec-2001
** Purpose: SndDll glue code for loading external sound systems
** Author:  Hans-Joerg Frieden
**
*/

#if defined __AROS__// || defined __MORPHOS__
#include <dll.h>
#define dlsym dllGetProcAddress
#define dlclose dllFreeLibrary
#define dlopen(x,y) dllLoadLibrary(x,x)
#define RTLD_LAZY 0
#define dlerror() ""
#elif defined __MORPHOS__
#include <proto/dynload.h>
#else
#include <dlfcn.h>
#endif
#include <sys/stat.h>
//#include <unistd.h>
#include <errno.h>


#include "../client/header/client.h"
#include "../client/sound/header/local.h"
#include "../client/sound/header/snddll.h"
#include "../common/header/common.h"

void *		sound_library;
//qboolean	soundlib_active;
sndexport_t se;
cvar_t *	s_lib = 0;

extern void Com_Printf (char *fmt, ...);
extern void Sys_Error (char *fmt, ...);

/*void SND_CheckChanges(void)
{
	if (s_lib && s_lib->modified == true)
	{
		extern void CL_Snd_Restart_f(void);
		//CL_Snd_Restart_f();
		Cbuf_AddText("snd_restart\n");
		Cbuf_Execute();
		s_lib->modified = false;
	}
}*/

void SND_FreeSoundlib(void)
{
#ifdef __MORPHOS__
	void (*morphos_so_deinit)(void);
#endif

//	Com_Printf("SND_FreeSoundlib\n");

	if (sound_library)
	{
#ifdef __MORPHOS__
		morphos_so_deinit = dlsym(sound_library, "morphos_so_deinit");
		if (morphos_so_deinit)
		{
			morphos_so_deinit();
		}
#endif
		dlclose(sound_library);
	}
		
	memset(&se, 0, sizeof(se));
	sound_started = SS_NOT;
}

qboolean SND_LoadSoundlib(char *name)
{
#ifdef __MORPHOS__
	int (*morphos_so_init)(void);
	void (*morphos_so_deinit)(void);
#endif
	sndimport_t	 si;
	GetSndAPI_t	 GetSndAPI;
	char fn[MAX_OSPATH];
	char *path;
	struct stat st;	

//	Com_Printf("SND_LoadSoundlib\n");	
	
	if (sound_started)
	{
		se.Shutdown();
		SND_FreeSoundlib();
	}

	path = Cvar_Get("basedir", ".", CVAR_NOSET)->string;

#if defined __AROS__ || defined __MORPHOS__
	if (Q_stricmp(path, ".") == 0)
		snprintf(fn, MAX_OSPATH, "%s", name);
	else
#endif
	snprintf(fn, MAX_OSPATH, "%s/%s", path, name);

	if (stat(fn, &st) == -1)
	{
		Com_Printf("LoadLibrary(\"%s\") failed: %s\n", name, strerror(errno));
		return false;
	}	

	if ((sound_library = dlopen(fn, RTLD_LAZY)) == 0)
	{
		Com_Printf("LoadLibrary(\"%s\") failed\n", name);
		return false;
	}
	
	Com_Printf("LoadLibrary(\"%s\")\n", fn);
	
	si.Cmd_AddCommand = Cmd_AddCommand;
	si.Cmd_RemoveCommand = Cmd_RemoveCommand;
	si.Cmd_Argc = Cmd_Argc;
	si.Cmd_Argv = Cmd_Argv;
	si.Cmd_ExecuteText = Cbuf_ExecuteText;
	si.Com_Printf = Com_Printf;
	si.Sys_Error = Sys_Error;
	si.FS_LoadFile = FS_LoadFile;
	si.FS_FreeFile = FS_FreeFile;
	si.FS_Gamedir = FS_Gamedir;
	si.Cvar_Get = Cvar_Get;
	si.Cvar_Set = Cvar_Set;
	si.Cvar_SetValue = Cvar_SetValue;

#ifdef __MORPHOS__
	morphos_so_init = dlsym(sound_library, "morphos_so_init");
	morphos_so_deinit = dlsym(sound_library, "morphos_so_deinit");

	if (!(morphos_so_init && morphos_so_init()))
	{
		dlclose(sound_library);
		sound_library = NULL;
		Com_Error(ERR_FATAL, "LibNIX SO init failed");
	}
#endif

	if ((GetSndAPI = (void *) dlsym(sound_library, "GetSndAPI")) == 0)
		Com_Error(ERR_FATAL, "dlsym failed on %s", name );

	se = GetSndAPI( si );

	if (se.api_version != SND_API_VERSION)
	{
		SND_FreeSoundlib();
		Com_Error(ERR_FATAL, "%s has incompatible snd_api_version", name);
	}

	if (se.Init(&dma) == -1 )
	{
		se.Shutdown();
		SND_FreeSoundlib ();
		
		return false;
	}

	Com_Printf("------------------------------------\n\n");
	//sound_started = se.library_type;
	sound_started = SS_DMA;
	
	return true;
}

qboolean SNDDMA_Init(void)
{
	char name[100];

//	Com_Printf("SNDDMA_Init\n");	
	
	if (!s_lib)
	{
		s_lib = Cvar_Get("s_lib", "ahi", CVAR_ARCHIVE);
		s_lib->modified = false;
	}
		
	Com_sprintf(name, sizeof(name), "snd_%s.so", s_lib->string);

	return SND_LoadSoundlib(name);
}

int SNDDMA_GetDMAPos(void)
{
	return se.GetDMAPos();
}

void SNDDMA_Shutdown(void)
{
//	Com_Printf("SNDDMA_Shutdown\n");
	
	se.Shutdown();
	SND_FreeSoundlib();
}

void SNDDMA_BeginPainting (void)
{
	se.BeginPainting();
}

void SNDDMA_Submit(void)
{
	se.Submit();
}
