require "muidefs"
require "muifuncs"
require "muiasl"
require "lfs"

ExportList	= strarray.new("box","cgm","eepic","eepicemu","emf","epic","eps","ge","gif","ibmgl","dxf",
						   "jpeg","latex","map","mf","mmp","mp","pcx","pdf","pdftex","pdftex_t","pic",
						   "pictex","png","ppm","ps","pstex","pstex_t","pstricks","ptk","shape","sld",
						   "svg","textyl","tiff","tk","xbm","xpm")
UnitList	= strarray.new("cm","in")
DimList		= strarray.new("None","0.1","0.25","0.5","1","5","10")
PaperList 	= strarray.new("A5","A4","A3","A2","A1","Letter")
OrientList	= strarray.new("Portrait","Landscape")
				   
EXPORT_ID 	= 50
INFILE_ID	= 70
GENCL_ID  	= 80

function Get_File_Path(file)
-- returns separately File and Path from file string
  local l = string.len(file)
  local pos = string.find(string.reverse(file),'/')
  if pos==nil then
	pos = string.find(string.reverse(file),':')
  end
  if pos==nil then
    return "",file
  else
    return string.sub(file,1,l-pos+1),string.sub(file,-pos+1) 
  end
end

function basename(file)
	local l = string.len(file)
	local pos = string.find(file,'%.')
	if pos==nil then
		return file
	else
		return string.sub(file,1,pos-1)
	end
end

function AddCmd(command, opt, val)
	if (val == "") then
		return command
	else
		return (command .. " " .. opt .. " " .. val)
	end
end

function CheckMark(label, state)
  local obj = mui.make(mui.MUIO_Checkmark, label)
  obj:setcheckmark(state)
  return obj
end

function GenerateCommandLine()
	-- Initialise command string
	local command = "fig2dev/fig2dev";

	-- Add export format
	command = AddCmd(command,"-L",strarray.get(ExportList,mui.getint(Format, mui.MUIA_List_Active)+1))
	
	-- Add General options
	if (mui.getint(GridMinor,mui.MUIA_Cycle_Active) > 0) then
		opt = strarray.get(DimList,mui.getint(GridMinor,mui.MUIA_Cycle_Active)+1)
		if (mui.getint(GridMajor,mui.MUIA_Cycle_Active) > 0) then
			opt = opt .. ":" .. strarray.get(DimList,mui.getint(GridMajor,mui.MUIA_Cycle_Active)+1)
		end
		opt = opt .. strarray.get(UnitList,mui.getint(GridUnit,mui.MUIA_Cycle_Active)+1)
		command = AddCmd(command,"-G",opt)
	end
	
	if (mui.getstr(MaxDim,mui.MUIA_String_Contents) == "") then
		command = AddCmd(command,"-m",mui.getint(Magnif,mui.MUIA_Numeric_Value)/100)
	else
		opt = mui.getstr(MaxDim,mui.MUIA_String_Contents)
		opt = opt .. strarray.get(UnitList,mui.getint(MaxDimUnit,mui.MUIA_Cycle_Active)+1)
		command = AddCmd(command,"-Z", opt )
	end
	
	
	-- command = AddCmd(command, "-s", mui.getint(DefFontSize,mui.MUIA_Numeric_Value))
	
	-- Add Specific Options
	
	-- Add Input file name
	command = AddCmd(command,"",mui.getstr(InputFile, mui.MUIA_String_Contents))
	
	return command
end

function Slider(min, max, value)
  return mui.SliderObject(
    mui.MUIA_Numeric_Min, min,
    mui.MUIA_Numeric_Max, max,
    mui.MUIA_Numeric_Value, value)
end

function main()

	scr = "Workbench"
	
	-- get input argument
	if (arg ~= nil) then
		i = 1;
		while (arg[i] ~= nil) do
			if (arg[i] == "-o") then
				i = i+1
				if (arg[i] ~= nil) then 
					OutputDir = arg[i] 
					i = i+1
				end
			
			elseif (arg[i] == "-screen") then
				i = i+1;
				if (arg[i] ~= nil) then 
					scr = arg[i] 
					i = i+1
				end
				
			else
				InFile = arg[i]
				i = i+1;
			end
		end
	end
	
	Format 		= mui.ListObject()

	Paper 		= mui.CycleObject(	mui.MUIA_Cycle_Entries, PaperList,
									mui.MUIA_Cycle_Active, 1)

	Orientation	= mui.CycleObject(	mui.MUIA_Cycle_Entries, OrientList,
									mui.MUIA_Cycle_Active, 0)
							
	InputFile	= mui.StringObject( mui.MUIA_Frame, mui.MUIV_Frame_String,
									mui.MUIA_Weight, 400,
									mui.MUIA_String_Contents, "",
									mui.MUIA_String_MaxLen, 256)
									
	GridUnit	= mui.CycleObject(	mui.MUIA_Cycle_Entries, UnitList,
									mui.MUIA_Cycle_Active, 0)
									
	GridMajor	= mui.CycleObject(	mui.MUIA_Cycle_Entries, DimList,
									mui.MUIA_Cycle_Active, 0)
	
	GridMinor	= mui.CycleObject(	mui.MUIA_Cycle_Entries, DimList,
									mui.MUIA_Cycle_Active, 0)

	Grayscale	= CheckMark("", false)
	
	Magnif		= Slider(10,1000,100)
	
	DefFontSize = Slider(1,72,12)
	
	MaxDim		= mui.StringObject( mui.MUIA_Frame, mui.MUIV_Frame_String,
									mui.MUIA_String_Contents, "",
									mui.MUIA_String_MaxLen, 10,
									mui.MUIA_String_Format, mui.MUIV_String_Format_Right)
									
	MaxDimUnit	= mui.CycleObject(	mui.MUIA_Cycle_Entries, UnitList,
									mui.MUIA_Cycle_Active, 0) 
									
	CommandLine	= mui.StringObject( mui.MUIA_Frame, mui.MUIV_Frame_String,
									mui.MUIA_Weight, 400,
									mui.MUIA_String_Contents, "",
									mui.MUIA_String_MaxLen, 256)
	
	Qual = Slider(0,10,8)									
							
	EXPORT 	= mui.SimpleButton("_Export")
	CANCEL 	= mui.SimpleButton("_Cancel")
	INFILE  = mui.SimpleButton("Select")
	GENCL	= mui.SimpleButton("Generate")

	
	window = mui.WindowObject(
		mui.MUIA_Window_Title, "Fig2Dev GUI",
		mui.MUIA_Window_PublicScreen, scr,
		mui.MUIA_Window_ID   , mui.makeid("F2DG"),
		mui.MUIA_Window_Width , mui.MUIV_Window_Width_Screen(40),
		mui.MUIA_Window_Height, mui.MUIV_Window_Height_Screen(60),
		mui.WindowContents, mui.VGroup(
			mui.MUIA_Group_SameWidth, true,
			
			mui.Child, mui.HGroup(
				mui.MUIA_Frame, mui.MUIV_Frame_Group,
				mui.MUIA_FrameTitle, "Input File",
				mui.Child, InputFile,
				mui.Child, mui.RectangleObject(),
				mui.Child, INFILE
			),
			
			mui.Child, mui.VSpace(2),
			
			mui.Child, mui.HGroup(
				mui.Child, mui.VGroup(
					mui.MUIA_Group_SameWidth, true,
					mui.MUIA_Frame, mui.MUIV_Frame_Group,
					mui.MUIA_FrameTitle, "Export Format",
					mui.Child, mui.ListviewObject(
						mui.MUIA_Listview_List,Format
					)
				),
						
				mui.Child, mui.VGroup(
					mui.Child, mui.VGroup(
						mui.MUIA_Group_SameWidth, true,
						mui.MUIA_Frame, mui.MUIV_Frame_Group,
						mui.MUIA_FrameTitle, "General options",
						
						mui.Child, mui.VGroup(
							mui.MUIA_Frame, mui.MUIV_Frame_Group,
							mui.MUIA_FrameTitle, "Magnification",
							mui.Child, mui.HGroup(
								mui.Child, Magnif, 
								mui.Child, mui.Label("%")
							),
							mui.Child, mui.HGroup(
								mui.Child, mui.Label("Max. Dim"),
								mui.Child, MaxDim,
								mui.Child, MaxDimUnit
							)
						),
						
						mui.Child, mui.ColGroup(3,
							mui.MUIA_Frame, mui.MUIV_Frame_Group,
							mui.MUIA_FrameTitle, "Grid",
							mui.Child, mui.Label("Minor"), mui.Child, mui.Label("Major"), mui.Child, mui.Label("Unit"),
							mui.Child, GridMinor, mui.Child, GridMajor, mui.Child, GridUnit
						),
						
						mui.Child, mui.HGroup(
							mui.MUIA_Frame, mui.MUIV_Frame_Group,
							mui.MUIA_FrameTitle, "Default Font Size",
							mui.Child, DefFontSize
						)
					),

					mui.Child, mui.VGroup(
						mui.MUIA_Group_SameWidth, true,
						mui.MUIA_Frame, mui.MUIV_Frame_Group,
						mui.MUIA_FrameTitle, "Specific options",
						mui.Child, mui.ColGroup( 2,
							mui.MUIA_Frame, mui.MUIV_Frame_Group,
							mui.MUIA_FrameTitle, "Paper Format",
							mui.Child, Paper,
							mui.Child, Orientation
						)
					),
					
					mui.Child, mui.RectangleObject()
				)
			),
			
			mui.Child, mui.VSpace(2),
			
			mui.Child, mui.HGroup(
				mui.MUIA_Frame, mui.MUIV_Frame_Group,
				mui.MUIA_FrameTitle, "Manual options",
				mui.Child, GENCL,
				mui.Child, CommandLine
			),

			mui.Child, mui.VSpace(2),
			
			mui.Child, mui.HGroup(
				mui.MUIA_Group_SameWidth, true,
				mui.MUIA_Frame, mui.MUIV_Frame_Group,
				mui.Child, mui.RectangleObject(mui.MUIA_Weight, 20),
				mui.Child, EXPORT,
				mui.Child, mui.RectangleObject(),
				mui.Child, CANCEL,
				mui.Child, mui.RectangleObject(mui.MUIA_Weight, 20)
			)
		)
	)
	
	app = mui.ApplicationObject(
		mui.MUIA_Application_Title      , "Fig2Dev GUI",
		mui.MUIA_Application_Version    , "$VER: Fig2Dev GUI v1.0 (July 2010)",
		mui.MUIA_Application_Author     , "Yannick Erb",
		mui.MUIA_Application_Description, "Fig2Dev Graphical User Interface",
		mui.MUIA_Application_Base       , "Fig2DevGUI",
		mui.SubWindow, window
	)

	assert(app:check(), "Failed to create Application.")

	collectgarbage("collect")
	
	-- set up button actions
	window:doint(mui.MUIM_Notify, mui.MUIA_Window_CloseRequest, true,
    app, 2, mui.MUIM_Application_ReturnID, mui.MUIV_Application_ReturnID_Quit)

	CANCEL:doint(mui.MUIM_Notify, mui.MUIA_Pressed, false,
    app, 2, mui.MUIM_Application_ReturnID, mui.MUIV_Application_ReturnID_Quit)

	EXPORT:doint(mui.MUIM_Notify, mui.MUIA_Pressed, false,
    app, 2, mui.MUIM_Application_ReturnID, EXPORT_ID)
	
	INFILE:doint(mui.MUIM_Notify, mui.MUIA_Pressed, false,
    app, 2, mui.MUIM_Application_ReturnID, INFILE_ID)

	GENCL:doint(mui.MUIM_Notify, mui.MUIA_Pressed, false,
    app, 2, mui.MUIM_Application_ReturnID, GENCL_ID)
	
	-- Open Window
	window:set(mui.MUIA_Window_Open, true)
	
	-- fill in list with export format entries
	Format:doint(mui.MUIM_List_Insert,ExportList,-1,mui.MUIV_List_Insert_Bottom)
	mui.set(Format,mui.MUIA_List_Active,32)
	
	if InFile then mui.set(InputFile, mui.MUIA_String_Contents,  InFile) end
	
	running = true

	-- Main loop
	while running do
		id, signals = app:input()
		if id == mui.MUIV_Application_ReturnID_Quit then
			-- Exit GUI
			running = false
			
		elseif id == INFILE_ID then
			ipath, ifile = Get_File_Path(mui.getstr(InputFile, mui.MUIA_String_Contents))
			if ipath=="" then ipath = lfs.currentdir() end
			tmp = mui.filerequest(	mui.ASLFR_PubScreenName, scr,
									mui.ASLFR_InitialFile,     ifile,
									mui.ASLFR_InitialDrawer,   ipath)             
			if tmp ~= nil then
				mui.set(InputFile, mui.MUIA_String_Contents,  tmp)
			end	
			
		elseif id == GENCL_ID then
			mui.set(CommandLine, mui.MUIA_String_Contents,  GenerateCommandLine())
		
		elseif id == EXPORT_ID then
			-- Read or generate command Line
			command = mui.getstr(CommandLine, mui.MUIA_String_Contents)
			if (command == "") then
				command = GenerateCommandLine()
			end
			
			-- Get export filename
			ipath, ifile = Get_File_Path(mui.getstr(InputFile, mui.MUIA_String_Contents))
			exportfile = (basename(ifile) .. "." .. strarray.get(ExportList,mui.getint(Format, mui.MUIA_List_Active)+1))
			if (OutputDir~=nil) then
				ipath = OutputDir
			else
				ipath = lfs.currentdir ()
			end
			exportfile = mui.filerequest(	mui.ASLFR_PubScreenName, scr,
											mui.ASLFR_TitleText,       "Export as...",
											mui.ASLFR_InitialDrawer,   ipath,
											mui.ASLFR_InitialFile,     exportfile)

			-- Add Export file name
			command = AddCmd(command,">",exportfile)
			
			-- Start external application
			os.execute(command)
			running = false

		end  
      
		if running then mui.wait(signals) end
	end  
end

--main()
_, err = pcall(main)
if err then print("Error: " .. err) end
if app then app:dispose() end
ExportList:dispose()
PaperList:dispose()
OrientList:dispose()

