#include <stdio.h>
#include "ptrie.h"
#include "stack.h"

static char *program;

static char *pin_list[20];
static int num_pin;

static void
#ifdef __STDC__
stack_free_func(char *data)
#else /* !__STDC__ */
stack_free_func(data)
char *data;
#endif /* !__STDC__ */
{
    if (data != NULL)
      free(data);
}

static void
#ifdef __STDC__
ptrie_free_func(stack data)
#else /* !__STDC__ */
ptrie_free_func(data)
stack data;
#endif /* !__STDC__ */
{
    if (data != NULL)
      stack_free(data, stack_free_func);
}

static int
#ifdef __STDC__
add_line(char *line, ptrie tree)
#else /* !__STDC__ */
add_line(line, tree)
char *line;
ptrie tree;
#endif /* !__STDC__ */
{
    char *pinyin, *ptr;
    unsigned char danci[3];
    stack nstack;
    int dcount;

    ptr = line;
    /*
     * Go to the end of the Pinyin.
     */
    while(*ptr && *ptr != ' ')
      ptr++;

    /*
     * Make a copy of the Pinyin.
     */
    pinyin = (char *)malloc(sizeof(char) * (int)(ptr - line + 1));
    (void)strncpy(pinyin, line, (int)(ptr - line));

    /*
     * Move to the first danci.
     */
    while(*ptr && !(*ptr & 0x80))
      ptr++;

    /*
     * Do this while more danci remain in the line.
     */
    dcount = 0;
    while(*ptr != '\0') {
        danci[0] = *ptr++;
        danci[1] = *ptr++;
        danci[2] = '\0';
        dcount++;
        nstack = (stack)ptrie_find(tree, (unsigned char *)danci);
        if (nstack == NULL) {
            nstack = stack_create(20);
            /*
             * A stack overflow on a newly created stack should
             * not be possible if the stack size is greater than 0.
             * But, may as well be careful.
             */
            if (stack_push(nstack, (void *)pinyin) < 0) {
                fprintf(stderr, "%s: 0 stack overflow (%s %d)\n", program,
                        pinyin, dcount);
                stack_free(nstack, stack_free_func);
                return(-1);
            }
            /*
             * Insert the danci/pinyin stack pair into the search
             * trie.
             */
            ptrie_insert(tree, (unsigned char *)danci, (void *)nstack);
        } else {
            /*
             * Make sure we don't overflow the stack when pushing
             * a new Pinyin on it.
             */
            if (stack_push(nstack, (void *)pinyin) < 0) {
                fprintf(stderr, "%s: 1 stack overflow (%s %d)\n", program,
                        pinyin, dcount);
                return(-1);
            }
        }

        /*
         * Move to next danci.
         */
        while(*ptr && !(*ptr & 0x80))
          ptr++;
    }
    return(0);
}

static ptrie
#ifdef __STDC__
load_danci(FILE *dfile)
#else /* !__STDC__ */
load_danci(dfile)
FILE *dfile;
#endif /* !__STDC__ */
{
    char buf[BUFSIZ];
    ptrie tree;

    /*
     * Create the search trie for the danci.
     */
    tree = ptrie_create();

    fgets(buf, BUFSIZ, dfile);
    while(!feof(dfile)) {
        if (add_line((char *)buf, tree) < 0) {
            ptrie_free(tree, ptrie_free_func);
            return(NULL);
        }
        fgets(buf, BUFSIZ, dfile);
    }
    return(tree);
}

static void
#ifdef __STDC__
stack_gather(char *pinyin)
#else /* !__STDC__ */
stack_gather(pinyin)
char *pinyin;
#endif /* !__STDC__ */
{
    pin_list[num_pin++] = pinyin;
}

int
#ifdef __STDC__
main(int argc, char **argv)
#else /* !__STDC__ */
main(argc, argv)
int argc;
char **argv;
#endif /* !__STDC__ */
{
    FILE *danci_file = stdin;
    int i, j, k, exit_on_err = 0;
    ptrie tree;
    unsigned char danci[3];
    stack st;

    program = argv[0];

    argc--;
    *argv++;
    if (argc) {
        danci_file = fopen(argv[0], "r");
        if (danci_file == NULL) {
            fprintf(stderr, "%s: problem opening danci file \"%s\"\n",
                    program, argv[0]);
            exit(-1);
        }
    }

    tree = load_danci(danci_file);
    if (tree == NULL) {
        if (danci_file != stdin)
          fprintf(stderr, "%s: problem loading danci file \"%s\"\n",
                  program, argv[0]);
        else
          fprintf(stderr, "%s: problem loading danci file from (stdin)\n",
                  program);
        exit_on_err = 1;
    }
    if (danci_file != stdin)
      fclose(danci_file);

    if (exit_on_err != 0)
      exit(-1);

    danci[2] = '\0';
    for (i = 161; i < 248; i++) {
        danci[0] = i;
        for (j = 161; j < 255; j++) {
            danci[1] = j;
            st = (stack)ptrie_find(tree, (unsigned char *)danci);
            if (st != NULL) {
                num_pin = 0;
                stack_dump(st, stack_gather);
                printf("%s ", (char *)danci);
                /*
                 * Print the stack results in reverse order
                 * because the Pinyin were pushed on the stack
                 * from lowest to highest alphabetically, and
                 * the stack_dump routine goes from the top of
                 * the stack to the bottom.
                 */
                num_pin--;
                for (k = num_pin; k > 0; k--)
                  printf("%s,", pin_list[k]);
                printf("%s\n", pin_list[0]);
            }
        }
    }
    ptrie_free(tree, ptrie_free_func);
}
