/*
  This is the file error.h of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/

/* this file will be included in ttf.h */


#ifndef __TTF_ERROR_H
#define __TTF_ERROR_H

#include <stdlib.h> /* for size_t */


typedef enum {
  ttf_err_invalid_filename = 0,
  ttf_err_read = 1,
  ttf_err_out_of_memory = 2,
  ttf_err_invalid_table = 3,
  ttf_err_invalid_format = 4,
  ttf_err_not_implemented = 5,
  ttf_err_invalid_version = 6,
  ttf_err_need_head_table = 7,
  ttf_err_need_maxp_table = 8,
  ttf_err_invalid_prep = 9,
  ttf_err_invalid_index = 10,
  ttf_err_openfile = 11
} ttf_err_type;

extern char *ttf_err_message[];
extern int ttf_debug;

void ttf_error(ttf_err_type, ...);

#ifdef DEBUG
void *ttf_malloc(size_t, char *);
void *ttf_realloc(void *, size_t, char *);
void ttf_free(void *, char *);
#else
void *ttf_malloc(size_t);
void *ttf_realloc(void *, size_t);
void ttf_free(void *);
#endif

#endif /* __TTF_ERROR_H */


/* end of error.h */
