/*
  This is the file render.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include <string.h>
#include "ttf.h"
#include "loadtabl.h"
#include "ttf2bmp.h"


#if 0
static void PSMoveto(int x, int y, char *buf);
static void PSLineto(int x, int y, char *buf);
static void PSCurveto(OUTLINE *ol, char *buf, int x, int y, int s, int t);
#endif


/*
  render a solid font.
*/


/*@@*/

/* prototype declaration in font.h */

BITMAP *ttf_renderChar(f, cc, point, x_resolution, y_resolution)
  TTF *f;
  BYTE *cc;
  double point; /* we assume that pointsize = em */
  int x_resolution, y_resolution; /* in dpi (dots per inch) */
{
  int index, i;
  OUTLINE *ol;
  USHORT EM, totpoint, x_ppem, y_ppem;
  double x_scaling, y_scaling;
  BITMAP *bm;
  
  EM = f->head->unitsPerEm;
  x_ppem = round(point * x_resolution / 72); /* pixel per em; 1 inch = 72pt */
  y_ppem = round(point * y_resolution / 72);
  x_scaling = (double)x_ppem / EM;
  y_scaling = (double)y_ppem / EM;

  /* 
    get the start address of outline data. The ttf_select_CMAP() function
    should be called first to setup character-to-index table.
  */
  index = ttf_getFontOffset(f, cc);
  if (index == -1)
  {
    bm = BITMAP_Init(point, x_resolution, y_resolution,
                     BITMAP_ONE_BIT, x_ppem, y_ppem);
    memset(BITMAP_map(bm), 0, BITMAP_len(bm));
    return bm;
  }
  /* load outline data to f->glyf */
  load_glyf(f, f->fp, index, 0);
  /* if we have a data error or the index has no data */
  if (f->glyf->valid == 0)
  {
    /* fill bitmap with blanks */
    bm = BITMAP_Init(point, x_resolution, y_resolution,
                     BITMAP_ONE_BIT, x_ppem, y_ppem);
    memset(BITMAP_map(bm), 0, BITMAP_len(bm));
    return bm;
  }
  ol = f->glyf;
  totpoint =
   ol->endPtsOfContours
        [ol->endCtrOfGlyphs[ol->numberOfCompGlyphs - 1] - 1] + 1;

  /*
    we must round up here; additionally we increase the bitmap size by 1
    to avoid overflow due to rounding effects.
  */
  bm = BITMAP_Init(point, x_resolution, y_resolution, BITMAP_ONE_BIT,
                   (ol->xMax - ol->xMin + 1) * x_scaling + 2,
                   (ol->yMax - ol->yMin + 1) * y_scaling + 2);

  /* rescale the outline data (and preparing for fixp arithmetic) */
  for (i = 0; i < totpoint; i++)
  {
    ol->xCoordinates[i] = 
      (ol->xCoordinates[i] - ol->xMin) * x_ppem / (EM / 4) - 2;
    ol->yCoordinates[i] = 
      (ol->yCoordinates[i] - ol->yMin) * y_ppem / (EM / 4) - 2;
  }
  /* 
    call a block of stolen code :-) to convert outline data
    into bitmap data. This block deserves rewriting.
  */
  convert(f, bm);

  /* this avoids missing empty glyphs */
  if (bm->xpoint <= 2 || bm->ysize <= 2)
  {
    bm = BITMAP_Init(point, x_resolution, y_resolution,
                     BITMAP_ONE_BIT, x_ppem, y_ppem);
    memset(BITMAP_map(bm), 0, BITMAP_len(bm));
  }

  return bm;
}


/*@*/

#if 0
static void PSMoveto(x, y, buf)
  int x, y;
  char *buf;
{
  sprintf(buf, "%d %d moveto\n", x, y) ;
}


static void PSLineto(x, y, buf)
  int x, y;
  char *buf;
{
  sprintf(buf, "%d %d lineto\n", x, y) ;
}


/* prototype declaration in font.h */

void ttf_renderCharPS(f, cc, buf, len)
  TTF *f;
  BYTE *cc;
  char *buf;
  int len;
{
  int i, j, k;
  int index;
  OUTLINE *ol;
  LONG *xcoor, *ycoor;
  USHORT *epts_ctr;
  SHORT *ectr_glyph;
  SHORT num_glyph;
  BYTE *flags;
  int fst, start_offpt, end_offpt = 0;

  /* 
    get the start address of outline data. The ttf_select_CMAP() function
    should be called first to setup character-to-index table.
  */
  index = ttf_getFontOffset(f, cc);

  /* load outline data to f->glyf */
  load_glyf(f, f->fp, index, 0);
  /* 
    if we have a data error or the index has no data or the index points to
    a composite font.
  */
  if (f->glyf->valid == 0)
  {
    /* return empty buffer */
    *buf = 0;
    return;
  }

  ol = f->glyf;
  xcoor = ol->xCoordinates;
  ycoor = ol->yCoordinates;
  eptr_ctr = ol->endPtsOfContours;
  ectr_glyph = ol->endCtrOfGlyphs;
  num_glyph = ol->numberOfCompGlyphs;
  flags = ol->flags;

  for (i = 0, j = 0, k = 0; k < num_glyph; k++)
  {
    for (; i < ectr_glyph[k]; i++)
    {
      fst = j; 
      PSMoveto(xcoor[j], ycoor[j], buf); 
      buf += strlen(buf);
      start_offpt = 0; /* start at least 1 */

      /* data pts for all contours stored in one array.
         Each round j init at last j + 1 */

      /* start_offpt means start of off points.
         0 means no off points in record.
         N means the position of the off point.
         end_offpt means the ending off point.
         (lastx, lasty) is the last ON point from which Curve and Line
         shall start.
      */

      /* start with j = 0. into loop, j = 1.
         if pt[1] off, if start_offpt == 0, toggle start_offpt
         next j = 2. if on, now start_off != 0, run Curveto.
         if pt[1] on, start_off == 0, will run Lineto.
      */
      for (j++; j <= epts_ctr[i]; j++)
      {
        if (!(flags[j] & 1))
        { /*Off curve*/
          if (!start_offpt)
            start_offpt = end_offpt = j;
          else
            end_offpt++;
        }
        else
        {
          /*On Curve*/
          if (start_offpt)
          {
            /* start_offpt stuck at j, end_offpt++.
               end_offpt - start_offpt gives no of off
               pts. start_offpt gives start of sequence.
               why need xcoor[j] ycoor[j]?
            */ 
            PSCurveto(ol, buf, xcoor[j], ycoor[j], start_offpt, end_offpt); 
            buf += strlen(buf);
            start_offpt = 0; 

            /* also use start_offpt as indicator to
               save one variable!! */
            /* after curveto, reset condition. */
          } 
          else 
          {
            PSLineto(xcoor[j], ycoor[j], buf);
            buf += strlen(buf);
          }
          /* uses lastx, lasty */
          /* Lineto(xcoor[j], ycoor[j], buf); */
        } 
      } 
      /* looks like closepath  
         fst = first, i.e. go back to first */ 
      if (start_offpt) 
      {
        PSCurveto(ol, buf, xcoor[fst], ycoor[fst], start_offpt, end_offpt); 
        buf += strlen(buf);
      }
      else 
      {
        PSLineto(xcoor[fst], ycoor[fst], buf); 
        buf += strlen(buf);
      }
    }
  }
}


static void PSCurveto(ol, buf, x, y, s, t)
  OUTLINE *ol;
  char *buf;
  int x, y, s, t;
{ 
  int N, i;
  double sx[3], sy[3], cx[4], cy[4];

  N = t - s + 2;
  for (i = 0; i < N - 1; i++)
  {
    sx[0] = (i == 0 ? xcoor[s - 1] : (xcoor[i + s] + xcoor[i + s - 1]) / 2);
    sy[0] = (i == 0 ? ycoor[s - 1] : (ycoor[i + s] + ycoor[i + s - 1]) / 2);
    sx[1] = xcoor[s + i];
    sy[1] = ycoor[s + i];
    sx[2] = (i == (N - 2) ? x : (xcoor[s + i] + xcoor[s + i + 1]) / 2);
    sy[2] = (i == (N - 2) ? y : (ycoor[s + i] + ycoor[s + i + 1]) / 2);
    cx[3] = sx[2];
    cy[3] = sy[2];
    cx[1] = (2 * sx[1] + sx[0]) / 3;
    cy[1] = (2 * sy[1] + sy[0]) / 3;
    cx[2] = (sx[2] + 2 * sx[1]) / 3;
    cy[2] = (sy[2] + 2 * sy[1]) / 3;
    sprintf(buf,"%g %g %g %g %g %g curveto\n",
            cx[1], cy[1], cx[2], cy[2], cx[3], cy[3]);
  }
}
#endif


/* end of render.c */
