/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.NodeField;
import nts.noad.ScriptableNoad;
import nts.noad.StItalNodeEgg;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.HShiftNode;
import nts.node.Node;

public class VCenterNoad
extends ScriptableNoad {
    protected final NodeField nucleus;

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc());
        this.nucleus.addOn(log, cntx, '.');
    }

    protected String getDesc() {
        return "vcenter";
    }

    public boolean isJustChar() {
        return this.nucleus.isJustChar();
    }

    public Egg convert(Converter conv) {
        Node node = this.nucleus.getNode();
        Dimen middle = conv.getDimPar(16);
        if (node.isBox()) {
            Box box = node.getBox();
            BoxSizes sizes = box.getSizes();
            Dimen shift = this.delta(sizes.getHeight(), sizes.getDepth(), middle);
            node = box.pretendSizesCopy(sizes.shiftedUp(shift));
        } else {
            Dimen shift = this.delta(node.getHeight(), node.getDepth(), middle);
            node = HShiftNode.shiftingUp(node, shift);
        }
        return new StItalNodeEgg(node, 0);
    }

    private Dimen delta(Dimen height, Dimen depth, Dimen middle) {
        return depth.minus(height).halved().plus(middle);
    }

    public VCenterNoad(NodeField nucleus) {
        this.nucleus = nucleus;
    }
}

