/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import nts.base.Dimen;
import nts.base.Glue;

public class NetDimen
implements Serializable {
    public static final NetDimen NULL;
    private Dimen natural;
    private Dimen shrink;
    private Dimen[] stretch = new Dimen[4];

    public Dimen getNatural() {
        return this.natural;
    }

    public Dimen getShrink() {
        return this.shrink;
    }

    public Dimen getStretch(byte ord) {
        return this.stretch[ord];
    }

    public void setNatural(Dimen dim) {
        this.natural = dim;
    }

    public void setShrink(Dimen dim) {
        this.shrink = dim;
    }

    public void setStretch(Dimen dim, byte ord) {
        this.stretch[ord] = dim;
    }

    public byte getMaxStrOrder() {
        byte ord = 3;
        while (ord > 0 && this.stretch[ord].isZero()) {
            ord = (byte)(ord - 1);
        }
        return ord;
    }

    public final void add(Dimen d) {
        this.natural = this.natural.plus(d);
    }

    public final void addShrink(Dimen d) {
        this.shrink = this.shrink.plus(d);
    }

    public final void addStretch(byte ord, Dimen d) {
        this.stretch[ord] = this.stretch[ord].plus(d);
    }

    public void add(Glue g) {
        this.add(g.getDimen());
        this.addShrink(g.getShrink());
        this.addStretch(g.getStrOrder(), g.getStretch());
    }

    public void add(NetDimen nd) {
        this.add(nd.natural);
        this.addShrink(nd.shrink);
        byte o = 0;
        while (o < this.stretch.length) {
            this.addStretch(o, nd.stretch[o]);
            o = (byte)(o + 1);
        }
    }

    public final void sub(Dimen d) {
        this.natural = this.natural.minus(d);
    }

    public final void subShrink(Dimen d) {
        this.shrink = this.shrink.minus(d);
    }

    public final void subStretch(byte ord, Dimen d) {
        this.stretch[ord] = this.stretch[ord].minus(d);
    }

    public void sub(Glue g) {
        this.sub(g.getDimen());
        this.subShrink(g.getShrink());
        this.subStretch(g.getStrOrder(), g.getStretch());
    }

    public void sub(NetDimen nd) {
        this.sub(nd.natural);
        this.subShrink(nd.shrink);
        byte o = 0;
        while (o < this.stretch.length) {
            this.subStretch(o, nd.stretch[o]);
            o = (byte)(o + 1);
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String unit) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.natural.toString());
        if (unit != null) {
            buf.append(unit);
        }
        byte o = 0;
        while (o < this.stretch.length) {
            if (!this.stretch[o].isZero()) {
                Glue.append(buf.append(" plus "), this.stretch[o], o, unit);
            }
            o = (byte)(o + 1);
        }
        if (!this.shrink.isZero()) {
            Glue.append(buf.append(" minus "), this.shrink, (byte)0, unit);
        }
        return buf.toString();
    }

    public NetDimen() {
        this(Dimen.ZERO);
    }

    public NetDimen(Dimen d) {
        this.natural = d;
        this.shrink = Dimen.ZERO;
        int i = 0;
        while (i < this.stretch.length) {
            this.stretch[i++] = Dimen.ZERO;
        }
    }

    public NetDimen(Glue g) {
        this.natural = g.getDimen();
        this.shrink = g.getShrink();
        int i = 0;
        while (i < this.stretch.length) {
            this.stretch[i++] = Dimen.ZERO;
        }
        this.stretch[g.getStrOrder()] = g.getStretch();
    }

    public NetDimen(NetDimen nd) {
        this.natural = nd.natural;
        this.shrink = nd.shrink;
        int i = 0;
        while (i < this.stretch.length) {
            this.stretch[i] = nd.stretch[i];
            ++i;
        }
    }
}

