/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import java.io.PrintWriter;
import nts.tfm.PLDumper;

class PrintWriterPLDumper
implements PLDumper {
    static final char[] RI = new char[]{'R', 'I'};
    static final char[] MBL = new char[]{'M', 'B', 'L'};
    static final char[] RCE = new char[]{'R', 'C', 'E'};
    private PrintWriter output;
    private int level = 0;
    private boolean newLine = true;
    private boolean octChars = false;

    private PrintWriterPLDumper out(char c) {
        this.output.print(c);
        this.newLine = false;
        return this;
    }

    private PrintWriterPLDumper out(String s) {
        this.output.print(s);
        this.newLine = false;
        return this;
    }

    private PrintWriterPLDumper outLn() {
        this.output.println();
        this.newLine = true;
        int i = this.level;
        while (i-- > 0) {
            this.output.print("   ");
        }
        return this;
    }

    public PLDumper open(String p) {
        if (!this.newLine) {
            this.outLn();
        }
        ++this.level;
        return this.out('(').out(p);
    }

    public PLDumper close() {
        --this.level;
        return this.out(')').outLn();
    }

    public PLDumper addDec(int i) {
        return this.out(" D " + i);
    }

    public PLDumper addOct(int i) {
        return this.out(" O " + Integer.toOctalString(i));
    }

    public PLDumper addReal(Object o) {
        return this.out(" R " + o);
    }

    public PLDumper addFace(int face) {
        int f = face;
        int ri = f % RI.length;
        int mbl = (f /= RI.length) % MBL.length;
        int rce = (f /= MBL.length) % RCE.length;
        return (f /= RCE.length) != 0 ? this.addOct(face) : this.out(" F ").out(MBL[mbl]).out(RI[ri]).out(RCE[rce]);
    }

    public PLDumper addStr(String s) {
        return this.out(' ').out(s);
    }

    public PLDumper addBool(boolean b) {
        return this.out(b ? " TRUE" : " FALSE");
    }

    public PLDumper addChar(short c) {
        return !this.octChars && (48 <= c && c <= 57 || 65 <= c && c <= 90 || 97 <= c && c <= 122) ? this.out(" C ").out((char)c) : this.addOct(c);
    }

    public void forceNumChars() {
        this.octChars = true;
    }

    public void closeOutput() {
        while (this.level-- > 0) {
            this.close();
        }
        this.output.close();
    }

    public PrintWriterPLDumper(PrintWriter o) {
        this.output = o;
    }
}

