function num = struct2latex(data,xname,downsample,filtertype,filename,postfix,options)
%------------------------------------------------
%2010/09/14 version 1.0
%num = struct2latex(data,xname,downsample,filename,postfix,options)
%Function to export a matlabstruct to a tex-file for using NumericPlots. 
%xname, downsample, filename, postfix and options are optional parameters.
%struct2latex is based on the function export2latex.
%------------------------------------------------
%output:
%num        ...number of y-data exported
%input:
%data       ...datastruct
%xname      ...name of the x-Axis
%downsample ...downsampling factor (optional, default = 1)
%filtertype ...using filtering data {'none','MinMax','Hull'}(optional, default = 'none')
%filename   ...name of the tex-file (optional, default io)
%postfix    ...postfix for fieldnames in the tex-file (optional, default '')
%options    ...options for export2latex (optional)
%

% author: Alexander Michel
% date: 2010/08/09
% changed by Alexander Michel: 
%    2010/09/14 mapping of column-vectors 
%    2010/09/14 postfix option added
%    2012/08/03 filters added
%
% Copyright 2010 Thomas Knig, Alexander Michel
%
% This file is part of NumericPlots.
%
% NumericPlots is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% any later version.
% 
% NumericPlots is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with NumericPlots.  If not, see <http://www.gnu.org/licenses/>.


%choose x-Axis
fnames = fieldnames(data);
if(nargin<2)    
    [xnamenum,selected] = listdlg('PromptString','Choose x-Axis:','SelectionMode','single','ListString',fnames(1:end));
    if (selected==0)
        error('No x-Axis chosen!');
    end
    xname = fnames{xnamenum};
end

%downsample
if(nargin<3)
    downsample = 1;
end
idx = 1:downsample:length(data.(xname));

%downsample
if(nargin<4)
    filtertype = 'none';
end


%postfix
if(nargin<6)
    postfix = '';
end

if(length(idx)>5000)
    buttonname = questdlg('Warning! Number of points exceeds 5000! It is recommended to increase the downsampling factor!','Increase the downsampling factor?','Yes','No','Yes');
    switch buttonname
        case 'Yes'
            dlgoptions.Resize='on';
            dlgoptions.WindowStyle='normal';
            dlgoptions.Interpreter='tex';
            defans{1} = num2str(ceil(length(data.(xname))/5000));
            answer = inputdlg('Downsampling factor','Input Downsampling factor',1,defans,dlgoptions);
            downsample = str2num(answer{1});
            idx = 1:downsample:length(data.(xname));
        case 'No'
            warning('number of points exceeds 5000');
    end
end


% get x-data
xbuffer = data.(xname);
[nor noc] = size(xbuffer);
if(nor>1)
     if(noc>1)
         error('struct2latex supports only vectors');
     else
         xbuffer = xbuffer';
     end
end

% get y-data
jj = 1;
for ii = 1:length(fnames)
    if(strcmp(xname,fnames{ii})~=1 && strcmp('dSPACESettings',fnames{ii})~=1)        
        ybuffer = data.(fnames{ii});
        [nor noc] = size(ybuffer);
        if(nor>1)
             if(noc>1)
                 error('struct2latex supports only vectors');
             else
                 ybuffer = ybuffer';
             end
        end
        switch(filtertype)
            case{'none'}
                ydata = ybuffer(idx);
                xdata = xbuffer(idx);
            case{'MinMax'}
                [xdata ydata] = LatexFilterMinMax(xbuffer,ybuffer,floor(length(idx)/2));
            case{'Hull'}
                [xdata ydata] = LatexFilterHull(xbuffer,ybuffer,floor(length(idx)/2));
            otherwise
                ydata = ybuffer(idx);
                xdata = xbuffer(idx);
        end
        texdata(jj).x = xdata;
        texdata(jj).y = ydata;
        texdata(jj).ident = [fnames{ii} postfix];
        jj = jj+1;
    end
end

if(nargin<4)
    [texname texpname] = uiputfile('*.tex','Save Tex-File as ...','data');
    filename = [texpname texname(1:end-4)];
end
if(ischar(filename))
    if(exist('options','var'))
        export2latex(texdata,filename,options);
    else
        export2latex(texdata,filename);
    end
else
    error('no savefile chosen or illegal name');
end

num = jj-1;