if(OS_MACOS)
  target_sources(hiro PRIVATE hiro.mm)
else()
  target_sources(hiro PRIVATE hiro.cpp)
endif()

target_sources(hiro PRIVATE hiro.hpp components.hpp)

target_sources(
  hiro
  PRIVATE
    core/alignment.cpp
    core/alignment.hpp
    core/application.cpp
    core/application.hpp
    core/attribute.cpp
    core/attribute.hpp
    core/browser-window.cpp
    core/browser-window.hpp
    core/color.cpp
    core/color.hpp
    core/core.cpp
    core/core.hpp
    core/desktop.cpp
    core/desktop.hpp
    core/font.cpp
    core/font.hpp
    core/geometry.cpp
    core/geometry.hpp
    core/gradient.cpp
    core/gradient.hpp
    core/group.cpp
    core/group.hpp
    core/hotkey.cpp
    core/hotkey.hpp
    core/keyboard.cpp
    core/keyboard.hpp
    core/lock.hpp
    core/menu-bar.cpp
    core/menu-bar.hpp
    core/message-window.cpp
    core/message-window.hpp
    core/monitor.cpp
    core/monitor.hpp
    core/mouse-cursor.cpp
    core/mouse-cursor.hpp
    core/mouse.cpp
    core/mouse.hpp
    core/object.cpp
    core/object.hpp
    core/popup-menu.cpp
    core/popup-menu.hpp
    core/position.cpp
    core/position.hpp
    core/shared.hpp
    core/sizable.cpp
    core/sizable.hpp
    core/size.cpp
    core/size.hpp
    core/status-bar.cpp
    core/status-bar.hpp
    core/system-color.hpp
    core/text-cursor.cpp
    core/text-cursor.hpp
    core/timer.cpp
    core/timer.hpp
    core/window.cpp
    core/window.hpp
)

target_sources(
  hiro
  PRIVATE
    core/action/action.cpp
    core/action/action.hpp
    core/action/menu-check-item.cpp
    core/action/menu-check-item.hpp
    core/action/menu-item.cpp
    core/action/menu-item.hpp
    core/action/menu-radio-item.cpp
    core/action/menu-radio-item.hpp
    core/action/menu-separator.cpp
    core/action/menu-separator.hpp
    core/action/menu.cpp
    core/action/menu.hpp
)

target_sources(
  hiro
  PRIVATE
    core/widget/button.cpp
    core/widget/button.hpp
    core/widget/canvas.cpp
    core/widget/canvas.hpp
    core/widget/check-button.cpp
    core/widget/check-button.hpp
    core/widget/check-label.cpp
    core/widget/check-label.hpp
    core/widget/combo-button-item.cpp
    core/widget/combo-button-item.hpp
    core/widget/combo-button.cpp
    core/widget/combo-button.hpp
    core/widget/combo-edit-item.cpp
    core/widget/combo-edit-item.hpp
    core/widget/combo-edit.cpp
    core/widget/combo-edit.hpp
    core/widget/console.cpp
    core/widget/console.hpp
    core/widget/frame.cpp
    core/widget/frame.hpp
    core/widget/hex-edit.cpp
    core/widget/hex-edit.hpp
    core/widget/horizontal-scroll-bar.cpp
    core/widget/horizontal-scroll-bar.hpp
    core/widget/horizontal-slider.cpp
    core/widget/horizontal-slider.hpp
    core/widget/icon-view-item.cpp
    core/widget/icon-view-item.hpp
    core/widget/icon-view.cpp
    core/widget/icon-view.hpp
    core/widget/label.cpp
    core/widget/label.hpp
    core/widget/line-edit.cpp
    core/widget/line-edit.hpp
    core/widget/progress-bar.cpp
    core/widget/progress-bar.hpp
    core/widget/radio-button.cpp
    core/widget/radio-button.hpp
    core/widget/radio-label.cpp
    core/widget/radio-label.hpp
    core/widget/source-edit.cpp
    core/widget/source-edit.hpp
    core/widget/tab-frame-item.cpp
    core/widget/tab-frame-item.hpp
    core/widget/tab-frame.cpp
    core/widget/tab-frame.hpp
    core/widget/table-view-cell.cpp
    core/widget/table-view-cell.hpp
    core/widget/table-view-column.cpp
    core/widget/table-view-column.hpp
    core/widget/table-view-item.cpp
    core/widget/table-view-item.hpp
    core/widget/table-view.cpp
    core/widget/table-view.hpp
    core/widget/text-edit.cpp
    core/widget/text-edit.hpp
    core/widget/tree-view-item.cpp
    core/widget/tree-view-item.hpp
    core/widget/tree-view.cpp
    core/widget/tree-view.hpp
    core/widget/vertical-scroll-bar.cpp
    core/widget/vertical-scroll-bar.hpp
    core/widget/vertical-slider.cpp
    core/widget/vertical-slider.hpp
    core/widget/viewport.cpp
    core/widget/viewport.hpp
    core/widget/widget.cpp
    core/widget/widget.hpp
)

target_sources(
  hiro
  PRIVATE
    extension/about-dialog.cpp
    extension/about-dialog.hpp
    extension/browser-dialog.cpp
    extension/browser-dialog.hpp
    extension/extension.cpp
    extension/extension.hpp
    extension/fixed-layout.cpp
    extension/fixed-layout.hpp
    extension/horizontal-layout.cpp
    extension/horizontal-layout.hpp
    extension/horizontal-resize-grip.cpp
    extension/horizontal-resize-grip.hpp
    extension/list-view.cpp
    extension/list-view.hpp
    extension/message-dialog.cpp
    extension/message-dialog.hpp
    extension/name-dialog.cpp
    extension/name-dialog.hpp
    extension/shared.hpp
    extension/table-layout.cpp
    extension/table-layout.hpp
    extension/vertical-layout.cpp
    extension/vertical-layout.hpp
    extension/vertical-resize-grip.cpp
    extension/vertical-resize-grip.hpp
)

if(OS_MACOS)
  target_sources(
    hiro
    PRIVATE
      cocoa/application.cpp
      cocoa/application.hpp
      cocoa/browser-window.cpp
      cocoa/browser-window.hpp
      cocoa/desktop.cpp
      cocoa/desktop.hpp
      cocoa/font.cpp
      cocoa/font.hpp
      cocoa/group.cpp
      cocoa/group.hpp
      cocoa/header.hpp
      cocoa/keyboard.cpp
      cocoa/keyboard.hpp
      cocoa/menu-bar.cpp
      cocoa/menu-bar.hpp
      cocoa/message-window.cpp
      cocoa/message-window.hpp
      cocoa/monitor.cpp
      cocoa/monitor.hpp
      cocoa/mouse.cpp
      cocoa/mouse.hpp
      cocoa/object.cpp
      cocoa/object.hpp
      cocoa/platform.cpp
      cocoa/platform.hpp
      cocoa/popup-menu.cpp
      cocoa/popup-menu.hpp
      cocoa/sizable.cpp
      cocoa/sizable.hpp
      cocoa/status-bar.cpp
      cocoa/status-bar.hpp
      cocoa/timer.cpp
      cocoa/timer.hpp
      cocoa/utility.cpp
      cocoa/window.cpp
      cocoa/window.hpp
  )

  target_sources(
    hiro
    PRIVATE
      cocoa/action/action.cpp
      cocoa/action/action.hpp
      cocoa/action/menu-check-item.cpp
      cocoa/action/menu-check-item.hpp
      cocoa/action/menu-item.cpp
      cocoa/action/menu-item.hpp
      cocoa/action/menu-protocol.hpp
      cocoa/action/menu-radio-item.cpp
      cocoa/action/menu-radio-item.hpp
      cocoa/action/menu-separator.cpp
      cocoa/action/menu-separator.hpp
      cocoa/action/menu.cpp
      cocoa/action/menu.hpp
  )

  target_sources(
    hiro
    PRIVATE
      cocoa/widget/button.cpp
      cocoa/widget/button.hpp
      cocoa/widget/canvas.cpp
      cocoa/widget/canvas.hpp
      cocoa/widget/check-button.cpp
      cocoa/widget/check-button.hpp
      cocoa/widget/check-label.cpp
      cocoa/widget/check-label.hpp
      cocoa/widget/combo-button-item.cpp
      cocoa/widget/combo-button-item.hpp
      cocoa/widget/combo-button.cpp
      cocoa/widget/combo-button.hpp
      cocoa/widget/console.cpp
      cocoa/widget/console.hpp
      cocoa/widget/frame.cpp
      cocoa/widget/frame.hpp
      cocoa/widget/hex-edit.cpp
      cocoa/widget/hex-edit.hpp
      cocoa/widget/horizontal-scroll-bar.cpp
      cocoa/widget/horizontal-scroll-bar.hpp
      cocoa/widget/horizontal-slider.cpp
      cocoa/widget/horizontal-slider.hpp
      cocoa/widget/label.cpp
      cocoa/widget/label.hpp
      cocoa/widget/line-edit.cpp
      cocoa/widget/line-edit.hpp
      cocoa/widget/progress-bar.cpp
      cocoa/widget/progress-bar.hpp
      cocoa/widget/radio-button.cpp
      cocoa/widget/radio-button.hpp
      cocoa/widget/radio-label.cpp
      cocoa/widget/radio-label.hpp
      cocoa/widget/tab-frame-item.cpp
      cocoa/widget/tab-frame-item.hpp
      cocoa/widget/tab-frame.cpp
      cocoa/widget/tab-frame.hpp
      cocoa/widget/table-view-cell.cpp
      cocoa/widget/table-view-cell.hpp
      cocoa/widget/table-view-column.cpp
      cocoa/widget/table-view-column.hpp
      cocoa/widget/table-view-item.cpp
      cocoa/widget/table-view-item.hpp
      cocoa/widget/table-view.cpp
      cocoa/widget/table-view.hpp
      cocoa/widget/text-edit.cpp
      cocoa/widget/text-edit.hpp
      cocoa/widget/tree-view-item.cpp
      cocoa/widget/tree-view-item.hpp
      cocoa/widget/tree-view.cpp
      cocoa/widget/tree-view.hpp
      cocoa/widget/vertical-scroll-bar.cpp
      cocoa/widget/vertical-scroll-bar.hpp
      cocoa/widget/vertical-slider.cpp
      cocoa/widget/vertical-slider.hpp
      cocoa/widget/viewport.cpp
      cocoa/widget/viewport.hpp
      cocoa/widget/widget.cpp
      cocoa/widget/widget.hpp
  )
elseif(OS_WINDOWS)
  target_sources(
    hiro
    PRIVATE
      windows/application.cpp
      windows/application.hpp
      windows/browser-window.cpp
      windows/browser-window.hpp
      windows/desktop.cpp
      windows/desktop.hpp
      windows/font.cpp
      windows/font.hpp
      windows/group.cpp
      windows/group.hpp
      windows/header.hpp
      windows/hiro.Manifest
      windows/hiro.rc
      windows/keyboard.cpp
      windows/keyboard.hpp
      windows/menu-bar.cpp
      windows/menu-bar.hpp
      windows/message-window.cpp
      windows/message-window.hpp
      windows/monitor.cpp
      windows/monitor.hpp
      windows/mouse.cpp
      windows/mouse.hpp
      windows/object.cpp
      windows/object.hpp
      windows/platform.cpp
      windows/platform.hpp
      windows/popup-menu.cpp
      windows/popup-menu.hpp
      windows/settings.cpp
      windows/settings.hpp
      windows/sizable.cpp
      windows/sizable.hpp
      windows/status-bar.cpp
      windows/status-bar.hpp
      windows/timer.cpp
      windows/timer.hpp
      windows/tool-tip.cpp
      windows/tool-tip.hpp
      windows/utility.cpp
      windows/window.cpp
      windows/window.hpp
  )

  target_sources(
    hiro
    PRIVATE
      windows/action/action.cpp
      windows/action/action.hpp
      windows/action/menu-check-item.cpp
      windows/action/menu-check-item.hpp
      windows/action/menu-item.cpp
      windows/action/menu-item.hpp
      windows/action/menu-radio-item.cpp
      windows/action/menu-radio-item.hpp
      windows/action/menu-separator.cpp
      windows/action/menu-separator.hpp
      windows/action/menu.cpp
      windows/action/menu.hpp
  )

  target_sources(
    hiro
    PRIVATE
      windows/widget/button.cpp
      windows/widget/button.hpp
      windows/widget/canvas.cpp
      windows/widget/canvas.hpp
      windows/widget/check-button.cpp
      windows/widget/check-button.hpp
      windows/widget/check-label.cpp
      windows/widget/check-label.hpp
      windows/widget/combo-button-item.cpp
      windows/widget/combo-button-item.hpp
      windows/widget/combo-button.cpp
      windows/widget/combo-button.hpp
      windows/widget/frame.cpp
      windows/widget/frame.hpp
      windows/widget/hex-edit.cpp
      windows/widget/hex-edit.hpp
      windows/widget/horizontal-scroll-bar.cpp
      windows/widget/horizontal-scroll-bar.hpp
      windows/widget/horizontal-slider.cpp
      windows/widget/horizontal-slider.hpp
      windows/widget/label.cpp
      windows/widget/label.hpp
      windows/widget/line-edit.cpp
      windows/widget/line-edit.hpp
      windows/widget/progress-bar.cpp
      windows/widget/progress-bar.hpp
      windows/widget/radio-button.cpp
      windows/widget/radio-button.hpp
      windows/widget/radio-label.cpp
      windows/widget/radio-label.hpp
      windows/widget/tab-frame-item.cpp
      windows/widget/tab-frame-item.hpp
      windows/widget/tab-frame.cpp
      windows/widget/tab-frame.hpp
      windows/widget/table-view-cell.cpp
      windows/widget/table-view-cell.hpp
      windows/widget/table-view-column.cpp
      windows/widget/table-view-column.hpp
      windows/widget/table-view-item.cpp
      windows/widget/table-view-item.hpp
      windows/widget/table-view.cpp
      windows/widget/table-view.hpp
      windows/widget/text-edit.cpp
      windows/widget/text-edit.hpp
      windows/widget/tree-view-item.cpp
      windows/widget/tree-view-item.hpp
      windows/widget/tree-view.cpp
      windows/widget/tree-view.hpp
      windows/widget/vertical-scroll-bar.cpp
      windows/widget/vertical-scroll-bar.hpp
      windows/widget/vertical-slider.cpp
      windows/widget/vertical-slider.hpp
      windows/widget/viewport.cpp
      windows/widget/viewport.hpp
      windows/widget/widget.cpp
      windows/widget/widget.hpp
  )
endif()

target_sources(hiro PRIVATE cmake/sources.cmake cmake/os-windows.cmake cmake/os-linux.cmake)
