package NetworkTestConfigs;

#
# Some tests are over-specified to make sure test exactly and only what we
# claim we test.  Some tests are under-specified so that if we want to check
# if they work when we vary other aspects of networking, we can.
#

#
# FIXME:
# * NETWORK_INTERFACE isn't set in the configurations which are supposed to
#   be testing it.
# * The shared port and CCB configurations should have NETWORK_INTERFACE set
#   to '*', but the corresponding tests fail to shut down when they do,
#   probably because of permission problems.  (CONDOR_HOST rather than self.)
#
# BUGS:
# * The private address has no addrs entry which matches the primary.  (#5182)
# * The TCP_FORWARDING_HOST does not appear in addrs.  (#5145)
#

#
# IPv4-only, IPv6-only, and mixed mode.
#

our $ipV4Only = '
	ENABLE_IPV4 = TRUE
	ENABLE_IPV6 = FALSE

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

our $ipV6Only = '
	ENABLE_IPV4 = FALSE
	ENABLE_IPV6 = TRUE

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

our $mixedMode = '
	ENABLE_IPV4 = TRUE
	ENABLE_IPV6 = TRUE

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

#
# NETWORK_INTERFACE and BIND_ALL_INTERFACES.
#
our $niOnly = '
	# NETWORK_INTERFACE = FIXME
	BIND_ALL_INTERFACES = FALSE

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

our $niGiven = '
	# NETWORK_INTERFACE = FIXME
	BIND_ALL_INTERFACES = TRUE

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

#
# Shared port.
#
our $sp = '
	USE_SHARED_PORT = TRUE

	COLLECTOR_ADDRESS =
	# NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

#
# CCB.
#
our $ccb = '
	CCB_ADDRESS = $(COLLECTOR_HOST)

	USE_SHARED_PORT = FALSE
	# NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

#
# Shared port + CCB.
#
our $ccbAndSp = '
	USE_SHARED_PORT = TRUE
	CCB_ADDRESS = $(COLLECTOR_HOST)

	# NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

#
# PRIVATE_NETWORK_INTERFACE, PRIVATE_NETWORK_NAME.
#
our $pni = '
	PRIVATE_NETWORK_INTERFACE = 127.0.0.1

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_NAME =
	TCP_FORWARDING_HOST =
';

our $pniAndName = '
	PRIVATE_NETWORK_INTERFACE = 127.0.0.1
	PRIVATE_NETWORK_NAME = privateNetworkName

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	TCP_FORWARDING_HOST =
';

#
# TCP_FORWARDING_HOST.
#
our $tcpForwardingHost = '
	TCP_FORWARDING_HOST = 10.0.0.1

	USE_SHARED_PORT = FALSE
	COLLECTOR_ADDRESS =
	NETWORK_INTERFACE = *
	BIND_ALL_INTERFACES = TRUE
	PRIVATE_NETWORK_INTERFACE =
	PRIVATE_NETWORK_NAME =
';

1;
