# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Tests the Place system."""

from debusine.test.django import TestCase
from debusine.web.views.places import Place
from debusine.web.views.tests.utils import ViewTestMixin


class TestPlace(ViewTestMixin, TestCase):
    """Tests for the :py:class:`Place` class."""

    def test_as_nav(self) -> None:
        place = Place(title="test title", url="/test-url")
        tree = self.assertHTMLValid(place.as_nav())
        a = self.assertHasElement(tree, "//a")
        self.assertTextContentEqual(a, "test title")
        self.assertEqual(a.get("href"), "/test-url")

    def test_as_nav_icon(self) -> None:
        place = Place(
            title="test title",
            url="/test-url",
            icon="icon",
            icon_title="icon-title",
        )
        tree = self.assertHTMLValid(place.as_nav())
        a = self.assertHasElement(tree, "//a")
        self.assertTextContentEqual(a, "test title")
        self.assertEqual(a.get("href"), "/test-url")

        span = self.assertHasElement(a, "span")
        self.assertTextContentEqual(span, "")
        self.assertEqual(span.get("class"), "bi bi-icon")

    def test_as_head_title(self) -> None:
        place = Place(title="test title")
        tree = self.assertHTMLValid(place.as_head_title())
        title = self.assertHasElement(tree, "//title")
        self.assertTextContentEqual(title, "Debusine - test title")

    def test_as_page_title(self) -> None:
        place = Place(title="test title")
        tree = self.assertHTMLValid(place.as_page_title())
        title = self.assertHasElement(tree, "//h1")
        self.assertTextContentEqual(title, "test title")

    def test_as_page_title_icon(self) -> None:
        place = Place(title="test title", icon="icon")
        tree = self.assertHTMLValid(place.as_page_title())
        h1 = self.assertHasElement(tree, "//h1")
        self.assertTextContentEqual(h1, "test title")

        span = self.assertHasElement(h1, "span")
        self.assertTextContentEqual(span, "")
        self.assertEqual(span.get("class"), "bi bi-icon")
        self.assertIsNone(span.get("title"))

    def test_as_page_title_icon_title(self) -> None:
        place = Place(title="test title", icon="icon", icon_title="icon-title")
        tree = self.assertHTMLValid(place.as_page_title())
        h1 = self.assertHasElement(tree, "//h1")
        self.assertTextContentEqual(h1, "test title")

        span = self.assertHasElement(h1, "span")
        self.assertTextContentEqual(span, "")
        self.assertEqual(span.get("class"), "bi bi-icon")
        self.assertEqual(span.get("title"), "icon-title")
