/* SPDX-License-Identifier: LGPL-2.1-or-later */

#include "sort-util.h"
#if 0 /// UNNEEDED by elogind
#include "alloc-util.h"

/* hey glibc, APIs with callbacks without a user pointer are so useless */
void *xbsearch_r(const void *key, const void *base, size_t nmemb, size_t size,
                 comparison_userdata_fn_t compar, void *arg) {
        size_t l, u, idx;
        const void *p;
        int comparison;

        assert(!size_multiply_overflow(nmemb, size));

        l = 0;
        u = nmemb;
        while (l < u) {
                idx = (l + u) / 2;
                p = (const uint8_t*) base + idx * size;
                comparison = compar(key, p, arg);
                if (comparison < 0)
                        u = idx;
                else if (comparison > 0)
                        l = idx + 1;
                else
                        return (void *)p;
        }
        return NULL;
}
#endif // 0

int cmp_int(const int *a, const int *b) {
        return CMP(*a, *b);
}

int cmp_uint16(const uint16_t *a, const uint16_t *b) {
        return CMP(*a, *b);
}
