// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import "time"

const (
	MilestoneStateOpen   = "open"
	MilestoneStateClosed = "closed"
)

type Milestone struct {
	Common
	Title       string     `json:"title"`
	Description string     `json:"description"`
	Deadline    *time.Time `json:"deadline"`
	Created     time.Time  `json:"created"`
	Updated     *time.Time `json:"updated"`
	Closed      *time.Time `json:"closed"`
	State       string     `json:"state"` // open, closed
}

func (o Milestone) Equal(other Milestone) bool {
	return o.Common.Equal(other.Common) &&
		o.Title == other.Title &&
		o.Description == other.Description &&
		nilOrEqualTimeToDate(o.Deadline, other.Deadline) &&
		o.State == other.State
}

func (o *Milestone) Clone() Interface {
	clone := &Milestone{}
	*clone = *o
	return clone
}
