//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/confluent/armconfluent"
	"net/http"
	"net/url"
	"regexp"
)

// ValidationsServer is a fake server for instances of the armconfluent.ValidationsClient type.
type ValidationsServer struct {
	// ValidateOrganization is the fake for method ValidationsClient.ValidateOrganization
	// HTTP status codes to indicate success: http.StatusOK
	ValidateOrganization func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.OrganizationResource, options *armconfluent.ValidationsClientValidateOrganizationOptions) (resp azfake.Responder[armconfluent.ValidationsClientValidateOrganizationResponse], errResp azfake.ErrorResponder)

	// ValidateOrganizationV2 is the fake for method ValidationsClient.ValidateOrganizationV2
	// HTTP status codes to indicate success: http.StatusOK
	ValidateOrganizationV2 func(ctx context.Context, resourceGroupName string, organizationName string, body armconfluent.OrganizationResource, options *armconfluent.ValidationsClientValidateOrganizationV2Options) (resp azfake.Responder[armconfluent.ValidationsClientValidateOrganizationV2Response], errResp azfake.ErrorResponder)
}

// NewValidationsServerTransport creates a new instance of ValidationsServerTransport with the provided implementation.
// The returned ValidationsServerTransport instance is connected to an instance of armconfluent.ValidationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewValidationsServerTransport(srv *ValidationsServer) *ValidationsServerTransport {
	return &ValidationsServerTransport{srv: srv}
}

// ValidationsServerTransport connects instances of armconfluent.ValidationsClient to instances of ValidationsServer.
// Don't use this type directly, use NewValidationsServerTransport instead.
type ValidationsServerTransport struct {
	srv *ValidationsServer
}

// Do implements the policy.Transporter interface for ValidationsServerTransport.
func (v *ValidationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ValidationsClient.ValidateOrganization":
		resp, err = v.dispatchValidateOrganization(req)
	case "ValidationsClient.ValidateOrganizationV2":
		resp, err = v.dispatchValidateOrganizationV2(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *ValidationsServerTransport) dispatchValidateOrganization(req *http.Request) (*http.Response, error) {
	if v.srv.ValidateOrganization == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateOrganization not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/validations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgvalidate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.OrganizationResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.ValidateOrganization(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OrganizationResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ValidationsServerTransport) dispatchValidateOrganizationV2(req *http.Request) (*http.Response, error) {
	if v.srv.ValidateOrganizationV2 == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateOrganizationV2 not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Confluent/validations/(?P<organizationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/orgvalidateV2`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconfluent.OrganizationResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	organizationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("organizationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.ValidateOrganizationV2(req.Context(), resourceGroupNameParam, organizationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidationResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
