//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armorbital

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AuthorizedGroundstation.
func (a AuthorizedGroundstation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateType(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "groundStation", a.GroundStation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizedGroundstation.
func (a *AuthorizedGroundstation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateDateType(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "groundStation":
			err = unpopulate(val, "GroundStation", &a.GroundStation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableContacts.
func (a AvailableContacts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groundStationName", a.GroundStationName)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "spacecraft", a.Spacecraft)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableContacts.
func (a *AvailableContacts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groundStationName":
			err = unpopulate(val, "GroundStationName", &a.GroundStationName)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "spacecraft":
			err = unpopulate(val, "Spacecraft", &a.Spacecraft)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableContactsListResult.
func (a AvailableContactsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableContactsListResult.
func (a *AvailableContactsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableContactsProperties.
func (a AvailableContactsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endAzimuthDegrees", a.EndAzimuthDegrees)
	populate(objectMap, "endElevationDegrees", a.EndElevationDegrees)
	populate(objectMap, "maximumElevationDegrees", a.MaximumElevationDegrees)
	populateDateTimeRFC3339(objectMap, "rxEndTime", a.RxEndTime)
	populateDateTimeRFC3339(objectMap, "rxStartTime", a.RxStartTime)
	populate(objectMap, "startAzimuthDegrees", a.StartAzimuthDegrees)
	populate(objectMap, "startElevationDegrees", a.StartElevationDegrees)
	populateDateTimeRFC3339(objectMap, "txEndTime", a.TxEndTime)
	populateDateTimeRFC3339(objectMap, "txStartTime", a.TxStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableContactsProperties.
func (a *AvailableContactsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &a.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &a.EndElevationDegrees)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &a.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateDateTimeRFC3339(val, "RxEndTime", &a.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateDateTimeRFC3339(val, "RxStartTime", &a.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &a.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &a.StartElevationDegrees)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateDateTimeRFC3339(val, "TxEndTime", &a.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateDateTimeRFC3339(val, "TxStartTime", &a.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableContactsSpacecraft.
func (a AvailableContactsSpacecraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableContactsSpacecraft.
func (a *AvailableContactsSpacecraft) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableGroundStation.
func (a AvailableGroundStation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableGroundStation.
func (a *AvailableGroundStation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableGroundStationListResult.
func (a AvailableGroundStationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableGroundStationListResult.
func (a *AvailableGroundStationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableGroundStationProperties.
func (a AvailableGroundStationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "altitudeMeters", a.AltitudeMeters)
	populate(objectMap, "city", a.City)
	populate(objectMap, "latitudeDegrees", a.LatitudeDegrees)
	populate(objectMap, "longitudeDegrees", a.LongitudeDegrees)
	populate(objectMap, "providerName", a.ProviderName)
	populate(objectMap, "releaseMode", a.ReleaseMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableGroundStationProperties.
func (a *AvailableGroundStationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "altitudeMeters":
			err = unpopulate(val, "AltitudeMeters", &a.AltitudeMeters)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "latitudeDegrees":
			err = unpopulate(val, "LatitudeDegrees", &a.LatitudeDegrees)
			delete(rawMsg, key)
		case "longitudeDegrees":
			err = unpopulate(val, "LongitudeDegrees", &a.LongitudeDegrees)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &a.ProviderName)
			delete(rawMsg, key)
		case "releaseMode":
			err = unpopulate(val, "ReleaseMode", &a.ReleaseMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableGroundStationPropertiesAutoGenerated.
func (a AvailableGroundStationPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "altitudeMeters", a.AltitudeMeters)
	populate(objectMap, "city", a.City)
	populate(objectMap, "latitudeDegrees", a.LatitudeDegrees)
	populate(objectMap, "longitudeDegrees", a.LongitudeDegrees)
	populate(objectMap, "providerName", a.ProviderName)
	populate(objectMap, "releaseMode", a.ReleaseMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableGroundStationPropertiesAutoGenerated.
func (a *AvailableGroundStationPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "altitudeMeters":
			err = unpopulate(val, "AltitudeMeters", &a.AltitudeMeters)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "latitudeDegrees":
			err = unpopulate(val, "LatitudeDegrees", &a.LatitudeDegrees)
			delete(rawMsg, key)
		case "longitudeDegrees":
			err = unpopulate(val, "LongitudeDegrees", &a.LongitudeDegrees)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &a.ProviderName)
			delete(rawMsg, key)
		case "releaseMode":
			err = unpopulate(val, "ReleaseMode", &a.ReleaseMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Contact.
func (c *Contact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactInstanceProperties.
func (c ContactInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endAzimuthDegrees", c.EndAzimuthDegrees)
	populate(objectMap, "endElevationDegrees", c.EndElevationDegrees)
	populate(objectMap, "maximumElevationDegrees", c.MaximumElevationDegrees)
	populateDateTimeRFC3339(objectMap, "rxEndTime", c.RxEndTime)
	populateDateTimeRFC3339(objectMap, "rxStartTime", c.RxStartTime)
	populate(objectMap, "startAzimuthDegrees", c.StartAzimuthDegrees)
	populate(objectMap, "startElevationDegrees", c.StartElevationDegrees)
	populateDateTimeRFC3339(objectMap, "txEndTime", c.TxEndTime)
	populateDateTimeRFC3339(objectMap, "txStartTime", c.TxStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactInstanceProperties.
func (c *ContactInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &c.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &c.EndElevationDegrees)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &c.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateDateTimeRFC3339(val, "RxEndTime", &c.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateDateTimeRFC3339(val, "RxStartTime", &c.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &c.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &c.StartElevationDegrees)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateDateTimeRFC3339(val, "TxEndTime", &c.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateDateTimeRFC3339(val, "TxStartTime", &c.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactListResult.
func (c ContactListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactListResult.
func (c *ContactListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactParameters.
func (c ContactParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactProfile", c.ContactProfile)
	populateDateTimeRFC3339(objectMap, "endTime", c.EndTime)
	populate(objectMap, "groundStationName", c.GroundStationName)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactParameters.
func (c *ContactParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactProfile":
			err = unpopulate(val, "ContactProfile", &c.ContactProfile)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &c.EndTime)
			delete(rawMsg, key)
		case "groundStationName":
			err = unpopulate(val, "GroundStationName", &c.GroundStationName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactParametersContactProfile.
func (c ContactParametersContactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactParametersContactProfile.
func (c *ContactParametersContactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfile.
func (c ContactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfile.
func (c *ContactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileLink.
func (c ContactProfileLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channels", c.Channels)
	populate(objectMap, "direction", c.Direction)
	populate(objectMap, "eirpdBW", c.EirpdBW)
	populate(objectMap, "gainOverTemperature", c.GainOverTemperature)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "polarization", c.Polarization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfileLink.
func (c *ContactProfileLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channels":
			err = unpopulate(val, "Channels", &c.Channels)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &c.Direction)
			delete(rawMsg, key)
		case "eirpdBW":
			err = unpopulate(val, "EirpdBW", &c.EirpdBW)
			delete(rawMsg, key)
		case "gainOverTemperature":
			err = unpopulate(val, "GainOverTemperature", &c.GainOverTemperature)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "polarization":
			err = unpopulate(val, "Polarization", &c.Polarization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileLinkChannel.
func (c ContactProfileLinkChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandwidthMHz", c.BandwidthMHz)
	populate(objectMap, "centerFrequencyMHz", c.CenterFrequencyMHz)
	populate(objectMap, "decodingConfiguration", c.DecodingConfiguration)
	populate(objectMap, "demodulationConfiguration", c.DemodulationConfiguration)
	populate(objectMap, "encodingConfiguration", c.EncodingConfiguration)
	populate(objectMap, "endPoint", c.EndPoint)
	populate(objectMap, "modulationConfiguration", c.ModulationConfiguration)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfileLinkChannel.
func (c *ContactProfileLinkChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandwidthMHz":
			err = unpopulate(val, "BandwidthMHz", &c.BandwidthMHz)
			delete(rawMsg, key)
		case "centerFrequencyMHz":
			err = unpopulate(val, "CenterFrequencyMHz", &c.CenterFrequencyMHz)
			delete(rawMsg, key)
		case "decodingConfiguration":
			err = unpopulate(val, "DecodingConfiguration", &c.DecodingConfiguration)
			delete(rawMsg, key)
		case "demodulationConfiguration":
			err = unpopulate(val, "DemodulationConfiguration", &c.DemodulationConfiguration)
			delete(rawMsg, key)
		case "encodingConfiguration":
			err = unpopulate(val, "EncodingConfiguration", &c.EncodingConfiguration)
			delete(rawMsg, key)
		case "endPoint":
			err = unpopulate(val, "EndPoint", &c.EndPoint)
			delete(rawMsg, key)
		case "modulationConfiguration":
			err = unpopulate(val, "ModulationConfiguration", &c.ModulationConfiguration)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileListResult.
func (c ContactProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfileListResult.
func (c *ContactProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileProperties.
func (c ContactProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoTrackingConfiguration", c.AutoTrackingConfiguration)
	populate(objectMap, "eventHubUri", c.EventHubURI)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "minimumElevationDegrees", c.MinimumElevationDegrees)
	populate(objectMap, "minimumViableContactDuration", c.MinimumViableContactDuration)
	populate(objectMap, "networkConfiguration", c.NetworkConfiguration)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "thirdPartyConfigurations", c.ThirdPartyConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfileProperties.
func (c *ContactProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoTrackingConfiguration":
			err = unpopulate(val, "AutoTrackingConfiguration", &c.AutoTrackingConfiguration)
			delete(rawMsg, key)
		case "eventHubUri":
			err = unpopulate(val, "EventHubURI", &c.EventHubURI)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &c.Links)
			delete(rawMsg, key)
		case "minimumElevationDegrees":
			err = unpopulate(val, "MinimumElevationDegrees", &c.MinimumElevationDegrees)
			delete(rawMsg, key)
		case "minimumViableContactDuration":
			err = unpopulate(val, "MinimumViableContactDuration", &c.MinimumViableContactDuration)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &c.NetworkConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "thirdPartyConfigurations":
			err = unpopulate(val, "ThirdPartyConfigurations", &c.ThirdPartyConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfileThirdPartyConfiguration.
func (c ContactProfileThirdPartyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "missionConfiguration", c.MissionConfiguration)
	populate(objectMap, "providerName", c.ProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfileThirdPartyConfiguration.
func (c *ContactProfileThirdPartyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "missionConfiguration":
			err = unpopulate(val, "MissionConfiguration", &c.MissionConfiguration)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &c.ProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfilesProperties.
func (c ContactProfilesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoTrackingConfiguration", c.AutoTrackingConfiguration)
	populate(objectMap, "eventHubUri", c.EventHubURI)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "minimumElevationDegrees", c.MinimumElevationDegrees)
	populate(objectMap, "minimumViableContactDuration", c.MinimumViableContactDuration)
	populate(objectMap, "networkConfiguration", c.NetworkConfiguration)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "thirdPartyConfigurations", c.ThirdPartyConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfilesProperties.
func (c *ContactProfilesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoTrackingConfiguration":
			err = unpopulate(val, "AutoTrackingConfiguration", &c.AutoTrackingConfiguration)
			delete(rawMsg, key)
		case "eventHubUri":
			err = unpopulate(val, "EventHubURI", &c.EventHubURI)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &c.Links)
			delete(rawMsg, key)
		case "minimumElevationDegrees":
			err = unpopulate(val, "MinimumElevationDegrees", &c.MinimumElevationDegrees)
			delete(rawMsg, key)
		case "minimumViableContactDuration":
			err = unpopulate(val, "MinimumViableContactDuration", &c.MinimumViableContactDuration)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &c.NetworkConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "thirdPartyConfigurations":
			err = unpopulate(val, "ThirdPartyConfigurations", &c.ThirdPartyConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactProfilesPropertiesNetworkConfiguration.
func (c ContactProfilesPropertiesNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetId", c.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactProfilesPropertiesNetworkConfiguration.
func (c *ContactProfilesPropertiesNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetId":
			err = unpopulate(val, "SubnetID", &c.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactsProperties.
func (c ContactsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "antennaConfiguration", c.AntennaConfiguration)
	populate(objectMap, "contactProfile", c.ContactProfile)
	populate(objectMap, "endAzimuthDegrees", c.EndAzimuthDegrees)
	populate(objectMap, "endElevationDegrees", c.EndElevationDegrees)
	populate(objectMap, "errorMessage", c.ErrorMessage)
	populate(objectMap, "groundStationName", c.GroundStationName)
	populate(objectMap, "maximumElevationDegrees", c.MaximumElevationDegrees)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "reservationEndTime", c.ReservationEndTime)
	populateDateTimeRFC3339(objectMap, "reservationStartTime", c.ReservationStartTime)
	populateDateTimeRFC3339(objectMap, "rxEndTime", c.RxEndTime)
	populateDateTimeRFC3339(objectMap, "rxStartTime", c.RxStartTime)
	populate(objectMap, "startAzimuthDegrees", c.StartAzimuthDegrees)
	populate(objectMap, "startElevationDegrees", c.StartElevationDegrees)
	populate(objectMap, "status", c.Status)
	populateDateTimeRFC3339(objectMap, "txEndTime", c.TxEndTime)
	populateDateTimeRFC3339(objectMap, "txStartTime", c.TxStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactsProperties.
func (c *ContactsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "antennaConfiguration":
			err = unpopulate(val, "AntennaConfiguration", &c.AntennaConfiguration)
			delete(rawMsg, key)
		case "contactProfile":
			err = unpopulate(val, "ContactProfile", &c.ContactProfile)
			delete(rawMsg, key)
		case "endAzimuthDegrees":
			err = unpopulate(val, "EndAzimuthDegrees", &c.EndAzimuthDegrees)
			delete(rawMsg, key)
		case "endElevationDegrees":
			err = unpopulate(val, "EndElevationDegrees", &c.EndElevationDegrees)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &c.ErrorMessage)
			delete(rawMsg, key)
		case "groundStationName":
			err = unpopulate(val, "GroundStationName", &c.GroundStationName)
			delete(rawMsg, key)
		case "maximumElevationDegrees":
			err = unpopulate(val, "MaximumElevationDegrees", &c.MaximumElevationDegrees)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "reservationEndTime":
			err = unpopulateDateTimeRFC3339(val, "ReservationEndTime", &c.ReservationEndTime)
			delete(rawMsg, key)
		case "reservationStartTime":
			err = unpopulateDateTimeRFC3339(val, "ReservationStartTime", &c.ReservationStartTime)
			delete(rawMsg, key)
		case "rxEndTime":
			err = unpopulateDateTimeRFC3339(val, "RxEndTime", &c.RxEndTime)
			delete(rawMsg, key)
		case "rxStartTime":
			err = unpopulateDateTimeRFC3339(val, "RxStartTime", &c.RxStartTime)
			delete(rawMsg, key)
		case "startAzimuthDegrees":
			err = unpopulate(val, "StartAzimuthDegrees", &c.StartAzimuthDegrees)
			delete(rawMsg, key)
		case "startElevationDegrees":
			err = unpopulate(val, "StartElevationDegrees", &c.StartElevationDegrees)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "txEndTime":
			err = unpopulateDateTimeRFC3339(val, "TxEndTime", &c.TxEndTime)
			delete(rawMsg, key)
		case "txStartTime":
			err = unpopulateDateTimeRFC3339(val, "TxStartTime", &c.TxStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactsPropertiesAntennaConfiguration.
func (c ContactsPropertiesAntennaConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationIp", c.DestinationIP)
	populate(objectMap, "sourceIps", c.SourceIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactsPropertiesAntennaConfiguration.
func (c *ContactsPropertiesAntennaConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationIp":
			err = unpopulate(val, "DestinationIP", &c.DestinationIP)
			delete(rawMsg, key)
		case "sourceIps":
			err = unpopulate(val, "SourceIPs", &c.SourceIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactsPropertiesContactProfile.
func (c ContactsPropertiesContactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactsPropertiesContactProfile.
func (c *ContactsPropertiesContactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndPoint.
func (e EndPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endPointName", e.EndPointName)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "port", e.Port)
	populate(objectMap, "protocol", e.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndPoint.
func (e *EndPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endPointName":
			err = unpopulate(val, "EndPointName", &e.EndPointName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &e.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "percentComplete", o.PercentComplete)
	populateAny(objectMap, "properties", o.Properties)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultErrorProperties.
func (o OperationResultErrorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "message", o.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultErrorProperties.
func (o *OperationResultErrorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIDListResult.
func (r ResourceIDListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIDListResult.
func (r *ResourceIDListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIDListResultValueItem.
func (r ResourceIDListResultValueItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIDListResultValueItem.
func (r *ResourceIDListResultValueItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Spacecraft.
func (s Spacecraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Spacecraft.
func (s *Spacecraft) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpacecraftLink.
func (s SpacecraftLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizations", s.Authorizations)
	populate(objectMap, "bandwidthMHz", s.BandwidthMHz)
	populate(objectMap, "centerFrequencyMHz", s.CenterFrequencyMHz)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "polarization", s.Polarization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpacecraftLink.
func (s *SpacecraftLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizations":
			err = unpopulate(val, "Authorizations", &s.Authorizations)
			delete(rawMsg, key)
		case "bandwidthMHz":
			err = unpopulate(val, "BandwidthMHz", &s.BandwidthMHz)
			delete(rawMsg, key)
		case "centerFrequencyMHz":
			err = unpopulate(val, "CenterFrequencyMHz", &s.CenterFrequencyMHz)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &s.Direction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "polarization":
			err = unpopulate(val, "Polarization", &s.Polarization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpacecraftListResult.
func (s SpacecraftListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpacecraftListResult.
func (s *SpacecraftListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpacecraftsProperties.
func (s SpacecraftsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "links", s.Links)
	populate(objectMap, "noradId", s.NoradID)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "titleLine", s.TitleLine)
	populate(objectMap, "tleLine1", s.TleLine1)
	populate(objectMap, "tleLine2", s.TleLine2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpacecraftsProperties.
func (s *SpacecraftsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "links":
			err = unpopulate(val, "Links", &s.Links)
			delete(rawMsg, key)
		case "noradId":
			err = unpopulate(val, "NoradID", &s.NoradID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "titleLine":
			err = unpopulate(val, "TitleLine", &s.TitleLine)
			delete(rawMsg, key)
		case "tleLine1":
			err = unpopulate(val, "TleLine1", &s.TleLine1)
			delete(rawMsg, key)
		case "tleLine2":
			err = unpopulate(val, "TleLine2", &s.TleLine2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
