//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ItemLevelRecoveryConnectionsServer is a fake server for instances of the armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClient type.
type ItemLevelRecoveryConnectionsServer struct {
	// Provision is the fake for method ItemLevelRecoveryConnectionsClient.Provision
	// HTTP status codes to indicate success: http.StatusAccepted
	Provision func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, containerName string, protectedItemName string, recoveryPointID string, parameters armrecoveryservicesbackup.ILRRequestResource, options *armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClientProvisionOptions) (resp azfake.Responder[armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClientProvisionResponse], errResp azfake.ErrorResponder)

	// Revoke is the fake for method ItemLevelRecoveryConnectionsClient.Revoke
	// HTTP status codes to indicate success: http.StatusAccepted
	Revoke func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, containerName string, protectedItemName string, recoveryPointID string, options *armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClientRevokeOptions) (resp azfake.Responder[armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClientRevokeResponse], errResp azfake.ErrorResponder)
}

// NewItemLevelRecoveryConnectionsServerTransport creates a new instance of ItemLevelRecoveryConnectionsServerTransport with the provided implementation.
// The returned ItemLevelRecoveryConnectionsServerTransport instance is connected to an instance of armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewItemLevelRecoveryConnectionsServerTransport(srv *ItemLevelRecoveryConnectionsServer) *ItemLevelRecoveryConnectionsServerTransport {
	return &ItemLevelRecoveryConnectionsServerTransport{srv: srv}
}

// ItemLevelRecoveryConnectionsServerTransport connects instances of armrecoveryservicesbackup.ItemLevelRecoveryConnectionsClient to instances of ItemLevelRecoveryConnectionsServer.
// Don't use this type directly, use NewItemLevelRecoveryConnectionsServerTransport instead.
type ItemLevelRecoveryConnectionsServerTransport struct {
	srv *ItemLevelRecoveryConnectionsServer
}

// Do implements the policy.Transporter interface for ItemLevelRecoveryConnectionsServerTransport.
func (i *ItemLevelRecoveryConnectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ItemLevelRecoveryConnectionsClient.Provision":
		resp, err = i.dispatchProvision(req)
	case "ItemLevelRecoveryConnectionsClient.Revoke":
		resp, err = i.dispatchRevoke(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *ItemLevelRecoveryConnectionsServerTransport) dispatchProvision(req *http.Request) (*http.Response, error) {
	if i.srv.Provision == nil {
		return nil, &nonRetriableError{errors.New("fake for method Provision not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectionContainers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectedItems/(?P<protectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoveryPoints/(?P<recoveryPointId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/provisionInstantItemRecovery`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.ILRRequestResource](req)
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	protectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectedItemName")])
	if err != nil {
		return nil, err
	}
	recoveryPointIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("recoveryPointId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Provision(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, containerNameParam, protectedItemNameParam, recoveryPointIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ItemLevelRecoveryConnectionsServerTransport) dispatchRevoke(req *http.Request) (*http.Response, error) {
	if i.srv.Revoke == nil {
		return nil, &nonRetriableError{errors.New("fake for method Revoke not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectionContainers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/protectedItems/(?P<protectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoveryPoints/(?P<recoveryPointId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revokeInstantItemRecovery`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	protectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectedItemName")])
	if err != nil {
		return nil, err
	}
	recoveryPointIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("recoveryPointId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Revoke(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, containerNameParam, protectedItemNameParam, recoveryPointIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
