//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// IngestionSettingsServer is a fake server for instances of the armsecurity.IngestionSettingsClient type.
type IngestionSettingsServer struct {
	// Create is the fake for method IngestionSettingsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, ingestionSettingName string, ingestionSetting armsecurity.IngestionSetting, options *armsecurity.IngestionSettingsClientCreateOptions) (resp azfake.Responder[armsecurity.IngestionSettingsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method IngestionSettingsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, ingestionSettingName string, options *armsecurity.IngestionSettingsClientDeleteOptions) (resp azfake.Responder[armsecurity.IngestionSettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IngestionSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, ingestionSettingName string, options *armsecurity.IngestionSettingsClientGetOptions) (resp azfake.Responder[armsecurity.IngestionSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method IngestionSettingsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.IngestionSettingsClientListOptions) (resp azfake.PagerResponder[armsecurity.IngestionSettingsClientListResponse])

	// ListConnectionStrings is the fake for method IngestionSettingsClient.ListConnectionStrings
	// HTTP status codes to indicate success: http.StatusOK
	ListConnectionStrings func(ctx context.Context, ingestionSettingName string, options *armsecurity.IngestionSettingsClientListConnectionStringsOptions) (resp azfake.Responder[armsecurity.IngestionSettingsClientListConnectionStringsResponse], errResp azfake.ErrorResponder)

	// ListTokens is the fake for method IngestionSettingsClient.ListTokens
	// HTTP status codes to indicate success: http.StatusOK
	ListTokens func(ctx context.Context, ingestionSettingName string, options *armsecurity.IngestionSettingsClientListTokensOptions) (resp azfake.Responder[armsecurity.IngestionSettingsClientListTokensResponse], errResp azfake.ErrorResponder)
}

// NewIngestionSettingsServerTransport creates a new instance of IngestionSettingsServerTransport with the provided implementation.
// The returned IngestionSettingsServerTransport instance is connected to an instance of armsecurity.IngestionSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIngestionSettingsServerTransport(srv *IngestionSettingsServer) *IngestionSettingsServerTransport {
	return &IngestionSettingsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurity.IngestionSettingsClientListResponse]](),
	}
}

// IngestionSettingsServerTransport connects instances of armsecurity.IngestionSettingsClient to instances of IngestionSettingsServer.
// Don't use this type directly, use NewIngestionSettingsServerTransport instead.
type IngestionSettingsServerTransport struct {
	srv          *IngestionSettingsServer
	newListPager *tracker[azfake.PagerResponder[armsecurity.IngestionSettingsClientListResponse]]
}

// Do implements the policy.Transporter interface for IngestionSettingsServerTransport.
func (i *IngestionSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IngestionSettingsClient.Create":
		resp, err = i.dispatchCreate(req)
	case "IngestionSettingsClient.Delete":
		resp, err = i.dispatchDelete(req)
	case "IngestionSettingsClient.Get":
		resp, err = i.dispatchGet(req)
	case "IngestionSettingsClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	case "IngestionSettingsClient.ListConnectionStrings":
		resp, err = i.dispatchListConnectionStrings(req)
	case "IngestionSettingsClient.ListTokens":
		resp, err = i.dispatchListTokens(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if i.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings/(?P<ingestionSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.IngestionSetting](req)
	if err != nil {
		return nil, err
	}
	ingestionSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ingestionSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Create(req.Context(), ingestionSettingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IngestionSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if i.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings/(?P<ingestionSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ingestionSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ingestionSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Delete(req.Context(), ingestionSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings/(?P<ingestionSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ingestionSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ingestionSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), ingestionSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IngestionSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := i.srv.NewListPager(nil)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.IngestionSettingsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchListConnectionStrings(req *http.Request) (*http.Response, error) {
	if i.srv.ListConnectionStrings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListConnectionStrings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings/(?P<ingestionSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listConnectionStrings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ingestionSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ingestionSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListConnectionStrings(req.Context(), ingestionSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectionStrings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IngestionSettingsServerTransport) dispatchListTokens(req *http.Request) (*http.Response, error) {
	if i.srv.ListTokens == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListTokens not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/ingestionSettings/(?P<ingestionSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listTokens`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ingestionSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ingestionSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListTokens(req.Context(), ingestionSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IngestionSettingToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
