//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// FailoverGroupsServer is a fake server for instances of the armsql.FailoverGroupsClient type.
type FailoverGroupsServer struct {
	// BeginCreateOrUpdate is the fake for method FailoverGroupsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters armsql.FailoverGroup, options *armsql.FailoverGroupsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method FailoverGroupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, options *armsql.FailoverGroupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method FailoverGroupsClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFailover func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, options *armsql.FailoverGroupsClientBeginFailoverOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientFailoverResponse], errResp azfake.ErrorResponder)

	// BeginForceFailoverAllowDataLoss is the fake for method FailoverGroupsClient.BeginForceFailoverAllowDataLoss
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginForceFailoverAllowDataLoss func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, options *armsql.FailoverGroupsClientBeginForceFailoverAllowDataLossOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientForceFailoverAllowDataLossResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FailoverGroupsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, options *armsql.FailoverGroupsClientGetOptions) (resp azfake.Responder[armsql.FailoverGroupsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method FailoverGroupsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, options *armsql.FailoverGroupsClientListByServerOptions) (resp azfake.PagerResponder[armsql.FailoverGroupsClientListByServerResponse])

	// BeginTryPlannedBeforeForcedFailover is the fake for method FailoverGroupsClient.BeginTryPlannedBeforeForcedFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTryPlannedBeforeForcedFailover func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, options *armsql.FailoverGroupsClientBeginTryPlannedBeforeForcedFailoverOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientTryPlannedBeforeForcedFailoverResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method FailoverGroupsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters armsql.FailoverGroupUpdate, options *armsql.FailoverGroupsClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.FailoverGroupsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewFailoverGroupsServerTransport creates a new instance of FailoverGroupsServerTransport with the provided implementation.
// The returned FailoverGroupsServerTransport instance is connected to an instance of armsql.FailoverGroupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFailoverGroupsServerTransport(srv *FailoverGroupsServer) *FailoverGroupsServerTransport {
	return &FailoverGroupsServerTransport{
		srv:                                 srv,
		beginCreateOrUpdate:                 newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientCreateOrUpdateResponse]](),
		beginDelete:                         newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientDeleteResponse]](),
		beginFailover:                       newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientFailoverResponse]](),
		beginForceFailoverAllowDataLoss:     newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientForceFailoverAllowDataLossResponse]](),
		newListByServerPager:                newTracker[azfake.PagerResponder[armsql.FailoverGroupsClientListByServerResponse]](),
		beginTryPlannedBeforeForcedFailover: newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientTryPlannedBeforeForcedFailoverResponse]](),
		beginUpdate:                         newTracker[azfake.PollerResponder[armsql.FailoverGroupsClientUpdateResponse]](),
	}
}

// FailoverGroupsServerTransport connects instances of armsql.FailoverGroupsClient to instances of FailoverGroupsServer.
// Don't use this type directly, use NewFailoverGroupsServerTransport instead.
type FailoverGroupsServerTransport struct {
	srv                                 *FailoverGroupsServer
	beginCreateOrUpdate                 *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientCreateOrUpdateResponse]]
	beginDelete                         *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientDeleteResponse]]
	beginFailover                       *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientFailoverResponse]]
	beginForceFailoverAllowDataLoss     *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientForceFailoverAllowDataLossResponse]]
	newListByServerPager                *tracker[azfake.PagerResponder[armsql.FailoverGroupsClientListByServerResponse]]
	beginTryPlannedBeforeForcedFailover *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientTryPlannedBeforeForcedFailoverResponse]]
	beginUpdate                         *tracker[azfake.PollerResponder[armsql.FailoverGroupsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for FailoverGroupsServerTransport.
func (f *FailoverGroupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FailoverGroupsClient.BeginCreateOrUpdate":
		resp, err = f.dispatchBeginCreateOrUpdate(req)
	case "FailoverGroupsClient.BeginDelete":
		resp, err = f.dispatchBeginDelete(req)
	case "FailoverGroupsClient.BeginFailover":
		resp, err = f.dispatchBeginFailover(req)
	case "FailoverGroupsClient.BeginForceFailoverAllowDataLoss":
		resp, err = f.dispatchBeginForceFailoverAllowDataLoss(req)
	case "FailoverGroupsClient.Get":
		resp, err = f.dispatchGet(req)
	case "FailoverGroupsClient.NewListByServerPager":
		resp, err = f.dispatchNewListByServerPager(req)
	case "FailoverGroupsClient.BeginTryPlannedBeforeForcedFailover":
		resp, err = f.dispatchBeginTryPlannedBeforeForcedFailover(req)
	case "FailoverGroupsClient.BeginUpdate":
		resp, err = f.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := f.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.FailoverGroup](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		f.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		f.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		f.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if f.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := f.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginDelete(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		f.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		f.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		f.beginDelete.remove(req)
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if f.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := f.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginFailover(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		f.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		f.beginFailover.remove(req)
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginForceFailoverAllowDataLoss(req *http.Request) (*http.Response, error) {
	if f.srv.BeginForceFailoverAllowDataLoss == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginForceFailoverAllowDataLoss not implemented")}
	}
	beginForceFailoverAllowDataLoss := f.beginForceFailoverAllowDataLoss.get(req)
	if beginForceFailoverAllowDataLoss == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/forceFailoverAllowDataLoss`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginForceFailoverAllowDataLoss(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginForceFailoverAllowDataLoss = &respr
		f.beginForceFailoverAllowDataLoss.add(req, beginForceFailoverAllowDataLoss)
	}

	resp, err := server.PollerResponderNext(beginForceFailoverAllowDataLoss, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginForceFailoverAllowDataLoss.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginForceFailoverAllowDataLoss) {
		f.beginForceFailoverAllowDataLoss.remove(req)
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FailoverGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := f.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, nil)
		newListByServerPager = &resp
		f.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armsql.FailoverGroupsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		f.newListByServerPager.remove(req)
	}
	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginTryPlannedBeforeForcedFailover(req *http.Request) (*http.Response, error) {
	if f.srv.BeginTryPlannedBeforeForcedFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTryPlannedBeforeForcedFailover not implemented")}
	}
	beginTryPlannedBeforeForcedFailover := f.beginTryPlannedBeforeForcedFailover.get(req)
	if beginTryPlannedBeforeForcedFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tryPlannedBeforeForcedFailover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginTryPlannedBeforeForcedFailover(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTryPlannedBeforeForcedFailover = &respr
		f.beginTryPlannedBeforeForcedFailover.add(req, beginTryPlannedBeforeForcedFailover)
	}

	resp, err := server.PollerResponderNext(beginTryPlannedBeforeForcedFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginTryPlannedBeforeForcedFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTryPlannedBeforeForcedFailover) {
		f.beginTryPlannedBeforeForcedFailover.remove(req)
	}

	return resp, nil
}

func (f *FailoverGroupsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := f.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.FailoverGroupUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serverNameParam, failoverGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		f.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		f.beginUpdate.remove(req)
	}

	return resp, nil
}
